/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.action;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.indexstatemanagement.step.forcemerge.AttemptCallForceMergeStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.forcemerge.AttemptSetReadOnlyStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.forcemerge.WaitForForceMergeStep;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/action/ForceMergeAction;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "maxNumSegments", "", "index", "<init>", "(II)V", "getMaxNumSegments", "()I", "attemptSetReadOnlyStep", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/AttemptSetReadOnlyStep;", "attemptCallForceMergeStep", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/AttemptCallForceMergeStep;", "waitForForceMergeStep", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep;", "stepNameToStep", "Ljava/util/LinkedHashMap;", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "Lkotlin/collections/LinkedHashMap;", "getStepToExecute", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "getSteps", "", "populateAction", "", "builder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nForceMergeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForceMergeAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/action/ForceMergeAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class ForceMergeAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxNumSegments;
    @NotNull
    private final AttemptSetReadOnlyStep attemptSetReadOnlyStep;
    @NotNull
    private final AttemptCallForceMergeStep attemptCallForceMergeStep;
    @NotNull
    private final WaitForForceMergeStep waitForForceMergeStep;
    @NotNull
    private final LinkedHashMap<String, Step> stepNameToStep;
    @NotNull
    public static final String name = "force_merge";
    @NotNull
    public static final String MAX_NUM_SEGMENTS_FIELD = "max_num_segments";

    public ForceMergeAction(int maxNumSegments, int index2) {
        super(name, index2);
        this.maxNumSegments = maxNumSegments;
        if (!(this.maxNumSegments > 0)) {
            boolean bl = false;
            String string = "Force merge {max_num_segments} must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.attemptSetReadOnlyStep = new AttemptSetReadOnlyStep(this);
        this.attemptCallForceMergeStep = new AttemptCallForceMergeStep(this);
        this.waitForForceMergeStep = new WaitForForceMergeStep(this);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"attempt_set_read_only", (Object)((Object)this.attemptSetReadOnlyStep)), TuplesKt.to((Object)"attempt_call_force_merge", (Object)((Object)this.attemptCallForceMergeStep)), TuplesKt.to((Object)"wait_for_force_merge", (Object)((Object)this.waitForForceMergeStep))};
        this.stepNameToStep = MapsKt.linkedMapOf((Pair[])pairArray);
    }

    public final int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @NotNull
    public Step getStepToExecute(@NotNull StepContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ManagedIndexMetaData managedIndexMetaData = context.getMetadata();
        StepMetaData stepMetaData = managedIndexMetaData.getStepMetaData();
        if (stepMetaData == null) {
            return this.attemptSetReadOnlyStep;
        }
        StepMetaData stepMetaData2 = stepMetaData;
        String currentStep = stepMetaData2.getName();
        if (!this.stepNameToStep.containsKey(currentStep)) {
            return this.attemptSetReadOnlyStep;
        }
        Step.StepStatus currentStepStatus = stepMetaData2.getStepStatus();
        if (currentStepStatus == Step.StepStatus.COMPLETED) {
            Step step;
            String string = currentStep;
            if (Intrinsics.areEqual((Object)string, (Object)"attempt_set_read_only")) {
                step = this.attemptCallForceMergeStep;
            } else if (Intrinsics.areEqual((Object)string, (Object)"attempt_call_force_merge")) {
                step = this.waitForForceMergeStep;
            } else {
                Step step2 = this.stepNameToStep.get(currentStep);
                Intrinsics.checkNotNull((Object)step2);
                step = step2;
            }
            return step;
        }
        Step step = this.stepNameToStep.get(currentStep);
        Intrinsics.checkNotNull((Object)step);
        return step;
    }

    @NotNull
    public List<Step> getSteps() {
        Collection<Step> collection = this.stepNameToStep.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public void populateAction(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject(this.getType());
        builder.field(MAX_NUM_SEGMENTS_FIELD, this.maxNumSegments);
        builder.endObject();
    }

    public void populateAction(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.maxNumSegments);
        out.writeInt(this.getActionIndex());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/action/ForceMergeAction$Companion;", "", "<init>", "()V", "name", "", "MAX_NUM_SEGMENTS_FIELD", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

