/**
 * ./src/lib/utils.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { ChildProcess, SpawnOptions, SpawnSyncOptions, SpawnSyncReturns } from 'child_process';
import { IExec } from '../interfaces/index.js';
interface ShellExecResult {
    code: number;
    stderr: string;
    stdout: string;
}
interface ExecSyncOptions {
    echo?: boolean;
    ignore?: boolean;
    stdio?: 'ignore' | 'inherit' | 'pipe';
}
/**
 * spawnSync (WRAPPER INTELLIGENTE)
 * Supporta:
 * 1. (command, args, options)
 * 2. (command, options) -> args diventa []
 * Pulisce automaticamente l'ambiente.
 */
export declare function spawnSync(command: string, arg2?: SpawnSyncOptions | string[], arg3?: SpawnSyncOptions): SpawnSyncReturns<Buffer | string>;
/**
 * spawn (WRAPPER INTELLIGENTE)
 * Supporta:
 * 1. (command, args, options)
 * 2. (command, options) -> args diventa []
 * Pulisce automaticamente l'ambiente.
 */
export declare function spawn(command: string, arg2?: readonly string[] | SpawnOptions, arg3?: SpawnOptions): ChildProcess;
/**
 * shx
 * Sostituto drop-in per shelljs che usa API native e ambiente pulito.
 */
export declare const shx: {
    chmod(mode: number | string, file: string): void;
    cp(arg1: string, arg2: string, arg3?: string): void;
    exec(command: string, options?: {
        silent?: boolean;
    }): ShellExecResult;
    ln(flag: string, target: string, link: string): void;
    ls(arg1?: string | string[], arg2?: string | string[]): string[];
    mkdir(arg1: string, arg2?: string): void;
    mv(src: string, dest: string): void;
    rm(arg1: string, arg2?: string): void;
    sed(flag: string, regex: RegExp | string, replacement: string, file: string): void;
    test(flag: string, pathToCheck: string): boolean;
    touch(file: string): void;
    which(cmd: string): null | string;
};
/**
 * execSync
 */
export declare function execSync(command: string, options?: ExecSyncOptions): null | string;
/**
 * exec (Async)
 */
export declare function exec(command: string, { capture, echo, ignore }?: {
    capture?: boolean | undefined;
    echo?: boolean | undefined;
    ignore?: boolean | undefined;
}): Promise<IExec>;
export {};
