/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.json;

public class JSONFilter {
    public static char[] escape(char c) {
        if (c < ' ' || c == '\"' || c == '\\' || Character.isHighSurrogate(c) || Character.isLowSurrogate(c)) {
            char c2 = JSONFilter.getPopularChar(c);
            if (c2 > '\u0000') {
                return new char[]{'\\', c2};
            }
            StringBuilder stringBuilder = new StringBuilder(6);
            stringBuilder.append("\\u");
            stringBuilder.append(String.format("%04X", c));
            return stringBuilder.toString().toCharArray();
        }
        char[] cArray = new char[]{c};
        return cArray;
    }

    public static String escape(String string) {
        return JSONFilter.escape(string, 0, string.length()).toString();
    }

    public static CharSequence escape(CharSequence charSequence) {
        return JSONFilter.escape(charSequence, 0, charSequence.length());
    }

    public static CharSequence escape(CharSequence charSequence, int n, int n2) {
        StringBuilder stringBuilder = null;
        int n3 = n;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c >= ' ' && c != '\"' && c != '\\' && !Character.isHighSurrogate(c) && !Character.isLowSurrogate(c)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n2 + 20);
            }
            if (n3 < i) {
                stringBuilder.append(charSequence.subSequence(n3, i));
            }
            n3 = i + 1;
            char c2 = JSONFilter.getPopularChar(c);
            if (c2 > '\u0000') {
                stringBuilder.append('\\').append(c2);
                continue;
            }
            stringBuilder.append("\\u");
            stringBuilder.append(String.format("%04X", c));
        }
        if (stringBuilder == null) {
            if (n == 0 && n2 == charSequence.length()) {
                return charSequence;
            }
            return charSequence.subSequence(n, n2 - n);
        }
        if (n3 < n2) {
            stringBuilder.append(charSequence.subSequence(n3, n2));
        }
        return stringBuilder.toString();
    }

    private JSONFilter() {
    }

    private static char getPopularChar(char c) {
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                return c;
            }
            case '\b': {
                return 'b';
            }
            case '\f': {
                return 'f';
            }
            case '\n': {
                return 'n';
            }
            case '\r': {
                return 'r';
            }
            case '\t': {
                return 't';
            }
        }
        return '\u0000';
    }
}

