/*
 * Copyright (C) 1999-2025. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.28.0 2025-05-31
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef KEY_CODE_TERMINAL_MODEL_CONSTANT_HEADER
#define KEY_CODE_TERMINAL_MODEL_CONSTANT_HEADER

//
// Library interface
//

#include "constant.h"

//
//?? TODO:
//
// Check out:
// http://www.comptechdoc.org/os/linux/howlinuxworks/linux_hlkeycodes.html
//
// or google:
// gnu linux keyboard terminal keycodes mapping table
//
// GNU/Linux kernel source:
// http://www.topology.org/linux/charpath.html
//

/** The escape key code terminal model. */
static int ESCAPE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 1 };
static int* ESCAPE_KEY_CODE_TERMINAL_MODEL = ESCAPE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* ESCAPE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The one key code terminal model. */
static int ONE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 2 };
static int* ONE_KEY_CODE_TERMINAL_MODEL = ONE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* ONE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The two key code terminal model. */
static int TWO_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 3 };
static int* TWO_KEY_CODE_TERMINAL_MODEL = TWO_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* TWO_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The three key code terminal model. */
static int THREE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 4 };
static int* THREE_KEY_CODE_TERMINAL_MODEL = THREE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* THREE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The four key code terminal model. */
static int FOUR_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 5 };
static int* FOUR_KEY_CODE_TERMINAL_MODEL = FOUR_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* FOUR_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The five key code terminal model. */
static int FIVE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 6 };
static int* FIVE_KEY_CODE_TERMINAL_MODEL = FIVE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* FIVE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The six key code terminal model. */
static int SIX_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 7 };
static int* SIX_KEY_CODE_TERMINAL_MODEL = SIX_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* SIX_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The seven key code terminal model. */
static int SEVEN_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 8 };
static int* SEVEN_KEY_CODE_TERMINAL_MODEL = SEVEN_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* SEVEN_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The eight key code terminal model. */
static int EIGHT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 9 };
static int* EIGHT_KEY_CODE_TERMINAL_MODEL = EIGHT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* EIGHT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The nine key code terminal model. */
static int NINE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 10 };
static int* NINE_KEY_CODE_TERMINAL_MODEL = NINE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NINE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The zero key code terminal model. */
static int ZERO_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 11 };
static int* ZERO_KEY_CODE_TERMINAL_MODEL = ZERO_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* ZERO_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The minus key code terminal model. */
static int MINUS_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 12 };
static int* MINUS_KEY_CODE_TERMINAL_MODEL = MINUS_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* MINUS_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The equals key code terminal model. */
static int EQUALS_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 13 };
static int* EQUALS_KEY_CODE_TERMINAL_MODEL = EQUALS_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* EQUALS_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The backspace key code terminal model. */
static int BACKSPACE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 14 };
static int* BACKSPACE_KEY_CODE_TERMINAL_MODEL = BACKSPACE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* BACKSPACE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The tabulator key code terminal model. */
static int TABULATOR_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 15 };
static int* TABULATOR_KEY_CODE_TERMINAL_MODEL = TABULATOR_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* TABULATOR_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The q key code terminal model. */
static int Q_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 16 };
static int* Q_KEY_CODE_TERMINAL_MODEL = Q_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* Q_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The w key code terminal model. */
static int W_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 17 };
static int* W_KEY_CODE_TERMINAL_MODEL = W_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* W_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The e key code terminal model. */
static int E_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 18 };
static int* E_KEY_CODE_TERMINAL_MODEL = E_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* E_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The r key code terminal model. */
static int R_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 19 };
static int* R_KEY_CODE_TERMINAL_MODEL = R_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* R_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The t key code terminal model. */
static int T_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 20 };
static int* T_KEY_CODE_TERMINAL_MODEL = T_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* T_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The y key code terminal model. */
static int Y_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 21 };
static int* Y_KEY_CODE_TERMINAL_MODEL = Y_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* Y_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The u key code terminal model. */
static int U_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 22 };
static int* U_KEY_CODE_TERMINAL_MODEL = U_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* U_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The i key code terminal model. */
static int I_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 23 };
static int* I_KEY_CODE_TERMINAL_MODEL = I_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* I_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The o key code terminal model. */
static int O_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 24 };
static int* O_KEY_CODE_TERMINAL_MODEL = O_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* O_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The p key code terminal model. */
static int P_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 25 };
static int* P_KEY_CODE_TERMINAL_MODEL = P_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* P_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left square bracket key code terminal model. */
static int LEFT_SQUARE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 26 };
static int* LEFT_SQUARE_KEY_CODE_TERMINAL_MODEL = LEFT_SQUARE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* LEFT_SQUARE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right square bracket key code terminal model. */
static int RIGHT_SQUARE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 27 };
static int* RIGHT_SQUARE_KEY_CODE_TERMINAL_MODEL = RIGHT_SQUARE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* RIGHT_SQUARE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The enter key code terminal model. */
static int ENTER_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 28 };
static int* ENTER_KEY_CODE_TERMINAL_MODEL = ENTER_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* ENTER_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left control key code terminal model. */
static int LEFT_CONTROL_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 29 };
static int* LEFT_CONTROL_KEY_CODE_TERMINAL_MODEL = LEFT_CONTROL_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* LEFT_CONTROL_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The a key code terminal model. */
static int A_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 30 };
static int* A_KEY_CODE_TERMINAL_MODEL = A_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* A_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The s key code terminal model. */
static int S_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 31 };
static int* S_KEY_CODE_TERMINAL_MODEL = S_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* S_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The d key code terminal model. */
static int D_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 32 };
static int* D_KEY_CODE_TERMINAL_MODEL = D_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* D_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f key code terminal model. */
static int F_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 33 };
static int* F_KEY_CODE_TERMINAL_MODEL = F_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The g key code terminal model. */
static int G_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 34 };
static int* G_KEY_CODE_TERMINAL_MODEL = G_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* G_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The h key code terminal model. */
static int H_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 35 };
static int* H_KEY_CODE_TERMINAL_MODEL = H_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* H_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The j key code terminal model. */
static int J_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 36 };
static int* J_KEY_CODE_TERMINAL_MODEL = J_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* J_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The k key code terminal model. */
static int K_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 37 };
static int* K_KEY_CODE_TERMINAL_MODEL = K_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* K_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The l key code terminal model. */
static int L_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 38 };
static int* L_KEY_CODE_TERMINAL_MODEL = L_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* L_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The semicolon key code terminal model. */
static int SEMICOLON_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 39 };
static int* SEMICOLON_KEY_CODE_TERMINAL_MODEL = SEMICOLON_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* SEMICOLON_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The apostrophe key code terminal model. */
static int APOSTROPHE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 40 };
static int* APOSTROPHE_KEY_CODE_TERMINAL_MODEL = APOSTROPHE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* APOSTROPHE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The accent grave key code terminal model. */
static int ACCENT_GRAVE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 41 };
static int* ACCENT_GRAVE_KEY_CODE_TERMINAL_MODEL = ACCENT_GRAVE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* ACCENT_GRAVE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left shift key code terminal model. */
static int LEFT_SHIFT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 42 };
static int* LEFT_SHIFT_KEY_CODE_TERMINAL_MODEL = LEFT_SHIFT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* LEFT_SHIFT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The backslash key code terminal model. */
static int BACKSLASH_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 43 };
static int* BACKSLASH_KEY_CODE_TERMINAL_MODEL = BACKSLASH_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* BACKSLASH_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The z key code terminal model. */
static int Z_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 44 };
static int* Z_KEY_CODE_TERMINAL_MODEL = Z_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* Z_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The x key code terminal model. */
static int X_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 45 };
static int* X_KEY_CODE_TERMINAL_MODEL = X_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* X_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The c key code terminal model. */
static int C_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 46 };
static int* C_KEY_CODE_TERMINAL_MODEL = C_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* C_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The v key code terminal model. */
static int V_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 47 };
static int* V_KEY_CODE_TERMINAL_MODEL = V_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* V_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The b key code terminal model. */
static int B_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 48 };
static int* B_KEY_CODE_TERMINAL_MODEL = B_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* B_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The n key code terminal model. */
static int N_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 49 };
static int* N_KEY_CODE_TERMINAL_MODEL = N_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* N_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The m key code terminal model. */
static int M_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 50 };
static int* M_KEY_CODE_TERMINAL_MODEL = M_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* M_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The comma key code terminal model. */
static int COMMA_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 51 };
static int* COMMA_KEY_CODE_TERMINAL_MODEL = COMMA_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* COMMA_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The dot key code terminal model. */
static int DOT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 52 };
static int* DOT_KEY_CODE_TERMINAL_MODEL = DOT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* DOT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The slash key code terminal model. */
static int SLASH_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 53 };
static int* SLASH_KEY_CODE_TERMINAL_MODEL = SLASH_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* SLASH_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right shift key code terminal model. */
static int RIGHT_SHIFT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 54 };
static int* RIGHT_SHIFT_KEY_CODE_TERMINAL_MODEL = RIGHT_SHIFT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* RIGHT_SHIFT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The asterisk key code terminal model. */
static int ASTERISK_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 55 };
static int* ASTERISK_KEY_CODE_TERMINAL_MODEL = ASTERISK_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* ASTERISK_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left alt key code terminal model. */
static int LEFT_ALT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 56 };
static int* LEFT_ALT_KEY_CODE_TERMINAL_MODEL = LEFT_ALT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* LEFT_ALT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The space key code terminal model. */
static int SPACE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 57 };
static int* SPACE_KEY_CODE_TERMINAL_MODEL = SPACE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* SPACE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The capitals lock key code terminal model. */
static int CAPITALS_LOCK_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 58 };
static int* CAPITALS_LOCK_KEY_CODE_TERMINAL_MODEL = CAPITALS_LOCK_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* CAPITALS_LOCK_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f1 key code terminal model. */
static int F1_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 59 };
static int* F1_KEY_CODE_TERMINAL_MODEL = F1_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F1_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f2 key code terminal model. */
static int F2_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 60 };
static int* F2_KEY_CODE_TERMINAL_MODEL = F2_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F2_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f3 key code terminal model. */
static int F3_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 61 };
static int* F3_KEY_CODE_TERMINAL_MODEL = F3_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F3_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f4 key code terminal model. */
static int F4_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 62 };
static int* F4_KEY_CODE_TERMINAL_MODEL = F4_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F4_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f5 key code terminal model. */
static int F5_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 63 };
static int* F5_KEY_CODE_TERMINAL_MODEL = F5_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F5_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f6 key code terminal model. */
static int F6_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 64 };
static int* F6_KEY_CODE_TERMINAL_MODEL = F6_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F6_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f7 key code terminal model. */
static int F7_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 65 };
static int* F7_KEY_CODE_TERMINAL_MODEL = F7_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F7_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f8 key code terminal model. */
static int F8_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 66 };
static int* F8_KEY_CODE_TERMINAL_MODEL = F8_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F8_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f9 key code terminal model. */
static int F9_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 67 };
static int* F9_KEY_CODE_TERMINAL_MODEL = F9_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F9_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f10 key code terminal model. */
static int F10_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 68 };
static int* F10_KEY_CODE_TERMINAL_MODEL = F10_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F10_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric lock key code terminal model. */
static int NUMERIC_LOCK_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 69 };
static int* NUMERIC_LOCK_KEY_CODE_TERMINAL_MODEL = NUMERIC_LOCK_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_LOCK_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The scroll lock key code terminal model. */
static int SCROLL_LOCK_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 70 };
static int* SCROLL_LOCK_KEY_CODE_TERMINAL_MODEL = SCROLL_LOCK_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* SCROLL_LOCK_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric home (seven) key code terminal model. */
static int NUMERIC_HOME_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 71 };
static int* NUMERIC_HOME_KEY_CODE_TERMINAL_MODEL = NUMERIC_HOME_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_HOME_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric up (eight) key code terminal model. */
static int NUMERIC_UP_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 72 };
static int* NUMERIC_UP_KEY_CODE_TERMINAL_MODEL = NUMERIC_UP_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_UP_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric page up (nine) key code terminal model. */
static int NUMERIC_PAGE_UP_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 73 };
static int* NUMERIC_PAGE_UP_KEY_CODE_TERMINAL_MODEL = NUMERIC_PAGE_UP_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_PAGE_UP_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric minus key code terminal model. */
static int NUMERIC_MINUS_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 74 };
static int* NUMERIC_MINUS_KEY_CODE_TERMINAL_MODEL = NUMERIC_MINUS_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_MINUS_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric left (four) key code terminal model. */
static int NUMERIC_LEFT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 75 };
static int* NUMERIC_LEFT_KEY_CODE_TERMINAL_MODEL = NUMERIC_LEFT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_LEFT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric centre (five) key code terminal model. */
static int NUMERIC_CENTRE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 76 };
static int* NUMERIC_CENTRE_KEY_CODE_TERMINAL_MODEL = NUMERIC_CENTRE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_CENTRE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric right (six) key code terminal model. */
static int NUMERIC_RIGHT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 77 };
static int* NUMERIC_RIGHT_KEY_CODE_TERMINAL_MODEL = NUMERIC_RIGHT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_RIGHT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric plus key code terminal model. */
static int NUMERIC_PLUS_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 78 };
static int* NUMERIC_PLUS_KEY_CODE_TERMINAL_MODEL = NUMERIC_PLUS_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_PLUS_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric end (one) key code terminal model. */
static int NUMERIC_END_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 79 };
static int* NUMERIC_END_KEY_CODE_TERMINAL_MODEL = NUMERIC_END_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_END_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric down (two) key code terminal model. */
static int NUMERIC_DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 80 };
static int* NUMERIC_DOWN_KEY_CODE_TERMINAL_MODEL = NUMERIC_DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_DOWN_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric page down (three) key code terminal model. */
static int NUMERIC_PAGE_DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 81 };
static int* NUMERIC_PAGE_DOWN_KEY_CODE_TERMINAL_MODEL = NUMERIC_PAGE_DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_PAGE_DOWN_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric insert (zero) key code terminal model. */
static int NUMERIC_INSERT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 82 };
static int* NUMERIC_INSERT_KEY_CODE_TERMINAL_MODEL = NUMERIC_INSERT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_INSERT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric delete (comma) key code terminal model. */
static int NUMERIC_DELETE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 83 };
static int* NUMERIC_DELETE_KEY_CODE_TERMINAL_MODEL = NUMERIC_DELETE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_DELETE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_1_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 84 };
static int* UNKNOWN_1_KEY_CODE_TERMINAL_MODEL = UNKNOWN_1_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_1_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_2_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 85 };
static int* UNKNOWN_2_KEY_CODE_TERMINAL_MODEL = UNKNOWN_2_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_2_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_3_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 86 };
static int* UNKNOWN_3_KEY_CODE_TERMINAL_MODEL = UNKNOWN_3_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_3_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f11 key code terminal model. */
static int F11_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 87 };
static int* F11_KEY_CODE_TERMINAL_MODEL = F11_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F11_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The f12 key code terminal model. */
static int F12_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 88 };
static int* F12_KEY_CODE_TERMINAL_MODEL = F12_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* F12_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_4_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 89 };
static int* UNKNOWN_4_KEY_CODE_TERMINAL_MODEL = UNKNOWN_4_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_4_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_5_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 90 };
static int* UNKNOWN_5_KEY_CODE_TERMINAL_MODEL = UNKNOWN_5_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_5_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_6_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 91 };
static int* UNKNOWN_6_KEY_CODE_TERMINAL_MODEL = UNKNOWN_6_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_6_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_7_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 92 };
static int* UNKNOWN_7_KEY_CODE_TERMINAL_MODEL = UNKNOWN_7_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_7_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_8_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 93 };
static int* UNKNOWN_8_KEY_CODE_TERMINAL_MODEL = UNKNOWN_8_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_8_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_9_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 94 };
static int* UNKNOWN_9_KEY_CODE_TERMINAL_MODEL = UNKNOWN_9_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_9_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_10_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 95 };
static int* UNKNOWN_10_KEY_CODE_TERMINAL_MODEL = UNKNOWN_10_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_10_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric enter key code terminal model. */
static int NUMERIC_ENTER_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 96 };
static int* NUMERIC_ENTER_KEY_CODE_TERMINAL_MODEL = NUMERIC_ENTER_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_ENTER_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right control key code terminal model. */
static int RIGHT_CONTROL_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 97 };
static int* RIGHT_CONTROL_KEY_CODE_TERMINAL_MODEL = RIGHT_CONTROL_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* RIGHT_CONTROL_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The numeric slash key code terminal model. */
static int NUMERIC_SLASH_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 98 };
static int* NUMERIC_SLASH_KEY_CODE_TERMINAL_MODEL = NUMERIC_SLASH_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* NUMERIC_SLASH_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The print key code terminal model. */
static int PRINT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 99 };
static int* PRINT_KEY_CODE_TERMINAL_MODEL = PRINT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* PRINT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right alt key code terminal model. */
static int RIGHT_ALT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 100 };
static int* RIGHT_ALT_KEY_CODE_TERMINAL_MODEL = RIGHT_ALT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* RIGHT_ALT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_11_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 101 };
static int* UNKNOWN_11_KEY_CODE_TERMINAL_MODEL = UNKNOWN_11_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_11_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The home key code terminal model. */
static int HOME_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 102 };
static int* HOME_KEY_CODE_TERMINAL_MODEL = HOME_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* HOME_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The up key code terminal model. */
static int UP_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 103 };
static int* UP_KEY_CODE_TERMINAL_MODEL = UP_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UP_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The page up key code terminal model. */
static int PAGE_UP_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 104 };
static int* PAGE_UP_KEY_CODE_TERMINAL_MODEL = PAGE_UP_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* PAGE_UP_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left key code terminal model. */
static int LEFT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 105 };
static int* LEFT_KEY_CODE_TERMINAL_MODEL = LEFT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* LEFT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right key code terminal model. */
static int RIGHT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 106 };
static int* RIGHT_KEY_CODE_TERMINAL_MODEL = RIGHT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* RIGHT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The end key code terminal model. */
static int END_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 107 };
static int* END_KEY_CODE_TERMINAL_MODEL = END_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* END_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The down key code terminal model. */
static int DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 108 };
static int* DOWN_KEY_CODE_TERMINAL_MODEL = DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* DOWN_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The page down key code terminal model. */
static int PAGE_DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 109 };
static int* PAGE_DOWN_KEY_CODE_TERMINAL_MODEL = PAGE_DOWN_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* PAGE_DOWN_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The insert key code terminal model. */
static int INSERT_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 110 };
static int* INSERT_KEY_CODE_TERMINAL_MODEL = INSERT_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* INSERT_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The delete key code terminal model. */
static int DELETE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 111 };
static int* DELETE_KEY_CODE_TERMINAL_MODEL = DELETE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* DELETE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_12_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 112 };
static int* UNKNOWN_12_KEY_CODE_TERMINAL_MODEL = UNKNOWN_12_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_12_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_13_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 113 };
static int* UNKNOWN_13_KEY_CODE_TERMINAL_MODEL = UNKNOWN_13_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_13_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_14_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 114 };
static int* UNKNOWN_14_KEY_CODE_TERMINAL_MODEL = UNKNOWN_14_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_14_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_15_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 115 };
static int* UNKNOWN_15_KEY_CODE_TERMINAL_MODEL = UNKNOWN_15_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_15_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_16_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 116 };
static int* UNKNOWN_16_KEY_CODE_TERMINAL_MODEL = UNKNOWN_16_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_16_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_17_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 117 };
static int* UNKNOWN_17_KEY_CODE_TERMINAL_MODEL = UNKNOWN_17_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_17_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The ?? key code terminal model. */
static int UNKNOWN_18_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 118 };
static int* UNKNOWN_18_KEY_CODE_TERMINAL_MODEL = UNKNOWN_18_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* UNKNOWN_18_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The pause key code terminal model. */
static int PAUSE_KEY_CODE_TERMINAL_MODEL_ARRAY[] = { 119 };
static int* PAUSE_KEY_CODE_TERMINAL_MODEL = PAUSE_KEY_CODE_TERMINAL_MODEL_ARRAY;
static int* PAUSE_KEY_CODE_TERMINAL_MODEL_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* KEY_CODE_TERMINAL_MODEL_CONSTANT_HEADER */
#endif
