/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

@Deprecated
public class AnimatedProgress
extends Canvas {
    static final int SLEEP = 70;
    static final int DEFAULT_WIDTH = 160;
    static final int DEFAULT_HEIGHT = 18;
    boolean active = false;
    boolean showStripes = false;
    int value;
    int orientation = 256;
    boolean showBorder = false;

    public AnimatedProgress(Composite parent, int style) {
        super(parent, AnimatedProgress.checkStyle(style));
        if ((style & 0x200) != 0) {
            this.orientation = 512;
        }
        this.showBorder = (style & 0x800) != 0;
        this.addControlListener(ControlListener.controlResizedAdapter(e2 -> this.redraw()));
        this.addPaintListener(e2 -> this.paint(e2));
        this.addDisposeListener(e2 -> this.stop());
    }

    private static int checkStyle(int style) {
        int mask = 0;
        return style & mask;
    }

    public synchronized void clear() {
        this.checkWidget();
        if (this.active) {
            this.stop();
        }
        this.showStripes = false;
        this.redraw();
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        Point size = null;
        size = this.orientation == 256 ? new Point(160, 18) : new Point(18, 160);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    private void drawBevelRect(GC gc, int x2, int y2, int w2, int h2, Color topleft, Color bottomright) {
        gc.setForeground(topleft);
        gc.drawLine(x2, y2, x2 + w2 - 1, y2);
        gc.drawLine(x2, y2, x2, y2 + h2 - 1);
        gc.setForeground(bottomright);
        gc.drawLine(x2 + w2, y2, x2 + w2, y2 + h2);
        gc.drawLine(x2, y2 + h2, x2 + w2, y2 + h2);
    }

    void paint(PaintEvent event) {
        GC gc = event.gc;
        Display disp = this.getDisplay();
        Rectangle rect = this.getClientArea();
        gc.fillRectangle(rect);
        if (this.showBorder) {
            this.drawBevelRect(gc, rect.x, rect.y, rect.width - 1, rect.height - 1, disp.getSystemColor(18), disp.getSystemColor(20));
        }
        this.paintStripes(gc);
    }

    void paintStripes(GC gc) {
        int foregroundValue;
        if (!this.showStripes) {
            return;
        }
        Rectangle rect = this.getClientArea();
        rect = new Rectangle(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
        gc.setLineWidth(2);
        gc.setClipping(rect);
        Color color = this.getDisplay().getSystemColor(26);
        gc.setBackground(color);
        gc.fillRectangle(rect);
        gc.setForeground(this.getBackground());
        int step = 12;
        int n2 = foregroundValue = this.value == 0 ? step - 2 : this.value - 2;
        if (this.orientation == 256) {
            int y2 = rect.y - 1;
            int w2 = rect.width;
            int h2 = rect.height + 2;
            int i2 = 0;
            while (i2 < w2) {
                int x2 = i2 + foregroundValue;
                gc.drawLine(x2, y2, x2, h2);
                i2 += step;
            }
        } else {
            int x3 = rect.x - 1;
            int w3 = rect.width + 2;
            int h3 = rect.height;
            int i3 = 0;
            while (i3 < h3) {
                int y3 = i3 + foregroundValue;
                gc.drawLine(x3, y3, w3, y3);
                i3 += step;
            }
        }
        if (this.active) {
            this.value = (this.value + 2) % step;
        }
    }

    public synchronized void start() {
        Runnable[] timer;
        this.checkWidget();
        if (this.active) {
            return;
        }
        this.active = true;
        this.showStripes = true;
        Display display = this.getDisplay();
        timer = new Runnable[]{() -> {
            if (!this.active) {
                return;
            }
            GC gc = new GC(this);
            this.paintStripes(gc);
            gc.dispose();
            display.timerExec(70, timer[0]);
        }};
        display.timerExec(70, timer[0]);
    }

    public synchronized void stop() {
        this.active = false;
    }
}

