/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.smmodellbau.GPSLoggerDialog;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.io.LogViewReader;
import gde.io.NMEAParser;
import gde.io.NMEAReaderWriter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.GPSHelper;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GPSLogger
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(GPSLogger.class.getName());
    static final String SM_GPS_LOGGER_INI = "SM GPS-Logger.ini";
    static final String SM_GPS_LOGGER_INI_DIR = "SM GPS-Logger setup";
    static final String SM_GPS_LOGGER_DIR_STUB = "GPS-Logger";
    static String selectedSetupFilePath;
    final DataExplorer application;
    final Channels channels;
    final GPSLoggerDialog dialog;

    public GPSLogger(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.gpslogger.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new GPSLoggerDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2004"), Messages.getString((String)"GDE_MSGT2004"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public GPSLogger(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.gpslogger.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new GPSLoggerDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2004"), Messages.getString((String)"GDE_MSGT2004"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        block6: {
            NMEAParser data = new NMEAParser(this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), (IDevice)this, this.channels.getActiveChannelNumber(), this.getUTCdelta());
            String sThreadId = String.format("%06d", Thread.currentThread().threadId());
            int progressCycle = 0;
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            try {
                int lastLength = 0;
                for (int i = 0; i < recordDataSize; ++i) {
                    byte[] subLengthBytes = new byte[4];
                    System.arraycopy(dataBuffer, lastLength, subLengthBytes, 0, 4);
                    int subLenght = LogViewReader.parse2Int((byte[])subLengthBytes) - 8;
                    byte[] lineBuffer = new byte[subLenght];
                    System.arraycopy(dataBuffer, 4 + lastLength, lineBuffer, 0, subLenght);
                    String textInput = new String(lineBuffer, "ISO-8859-1");
                    StringTokenizer st = new StringTokenizer(textInput);
                    Vector<String> vec = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        vec.add(st.nextToken("\r\n"));
                    }
                    data.parse(vec, vec.size());
                    lastLength += subLenght + 12;
                    recordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                    if (!doUpdateProgressBar || i % 50 != 0) continue;
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                this.updateVisibilityStatus(recordSet, true);
                if (doUpdateProgressBar) {
                    this.application.setProgress(100, sThreadId);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage() + Messages.getString((String)"GDE_MSGW0543");
                log.log(java.util.logging.Level.WARNING, msg, e);
                this.application.openMessageDialog(msg);
                if (!doUpdateProgressBar) break block6;
                this.application.setProgress(0, sThreadId);
            }
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordKeys = recordSet.getRecordNames();
        StringBuilder sb = new StringBuilder().append(GDE.LINE_SEPARATOR);
        Vector<String> cleanedRecordNames = new Vector<String>();
        Vector<String> noneCalculationRecordNames = new Vector<String>();
        try {
            switch (fileRecordsProperties.length) {
                case 15: 
                case 17: 
                case 20: 
                case 24: 
                case 26: 
                case 29: 
                case 32: 
                case 34: 
                case 35: 
                case 37: 
                case 43: {
                    for (int i = 0; i < recordSet.size(); ++i) {
                        recordSet.get(i).setName("????" + i);
                    }
                    return super.crossCheckMeasurements(fileRecordsProperties, recordSet);
                }
            }
            if (fileRecordsProperties.length != recordKeys.length) {
                int j = 0;
                block9: for (int i = 0; i < recordKeys.length; ++i) {
                    switch (i) {
                        case 15: 
                        case 16: {
                            sb.append(String.format("%02d added measurement set to isCalculation=true -> %s\n", i, recordKeys[i]));
                            recordSet.get(i).setActive(null);
                            continue block9;
                        }
                        default: {
                            if (j < fileRecordsProperties.length) {
                                HashMap recordProps = StringHelper.splitString((String)fileRecordsProperties[j], (String)"|-|", (String[])Record.propertyKeys);
                                sb.append(String.format("%02d %19s match %19s isAvtive = %s\n", i, recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                                cleanedRecordNames.add(recordKeys[i]);
                                noneCalculationRecordNames.add((String)recordProps.get("_name"));
                                if (fileRecordsProperties[j].contains("_isActive=false")) {
                                    recordSet.get(i).setActive(Boolean.valueOf(false));
                                }
                                ++j;
                                continue block9;
                            }
                            sb.append(String.format("%02d added measurement set to isCalculation=true -> %s\n", i, recordKeys[i]));
                            recordSet.get(i).setActive(null);
                        }
                    }
                }
            } else {
                for (int i = 0; i < recordKeys.length; ++i) {
                    if (!fileRecordsProperties[i].contains("_isActive")) {
                        sb.append(String.format("%02d added measurement set to isCalculation=true -> %s\n", i, recordKeys[i]));
                        recordSet.get(i).setActive(null);
                        cleanedRecordNames.add(recordKeys[i]);
                        continue;
                    }
                    HashMap recordProps = StringHelper.splitString((String)fileRecordsProperties[i], (String)"|-|", (String[])Record.propertyKeys);
                    sb.append(String.format("%02d %19s match %19s isAvtive = %s\n", i, recordKeys[i], recordProps.get("_name"), recordProps.get("_isActive")));
                    cleanedRecordNames.add(recordKeys[i]);
                    noneCalculationRecordNames.add((String)recordProps.get("_name"));
                    if (!fileRecordsProperties[i].contains("_isActive=false")) continue;
                    recordSet.get(i).setActive(Boolean.valueOf(false));
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.format("recordKey to fileRecordsProperties mismatch, check:\n %s \nfileRecordsProperties.length = %d recordKeys.length = %d %s", e.getMessage(), fileRecordsProperties.length, recordKeys.length, sb.toString()));
        }
        recordKeys = cleanedRecordNames.toArray(new String[1]);
        recordSet.setNoneCalculationRecordNames(noneCalculationRecordNames.toArray(new String[1]));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, sb.toString());
        }
        return recordKeys;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(java.util.logging.Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addNoneCalculationRecordsPoints(points);
            } else {
                recordSet.addNoneCalculationRecordsPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getOrdinal() == 0 || record.getOrdinal() == 1;
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getOrdinal() > 1 ? record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor) : record.getFormattedTableValue(rowIndex);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    /*
     * Unable to fully structure code
     */
    public double translateValue(Record record, double value) {
        block5: {
            factor = record.getFactor();
            offset = record.getOffset();
            reduction = record.getReduction();
            if (record.getOrdinal() != 2 && record.getOrdinal() != 8) break block5;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
                if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
                ** break block6
            }
            finally {
                newValue = 0.0;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    /*
     * Unable to fully structure code
     */
    public double reverseTranslateValue(Record record, double value) {
        block5: {
            factor = record.getFactor();
            offset = record.getOffset();
            reduction = record.getReduction();
            if (record.getOrdinal() != 2 && record.getOrdinal() != 8) break block5;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
                if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
                ** break block6
            }
            finally {
                newValue = 0.0;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + measurementNames[i]);
            }
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                if (log.isLoggable(Level.FINE) && record.hasReasonableData() && measurement.isActive()) {
                    log.log(Level.FINE, record.getName() + " hasReasonableData ");
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        Record recordAzimuth = recordSet.get(14);
        if (!recordAzimuth.hasReasonableData() && !recordAzimuth.getName().startsWith("Gl")) {
            recordAzimuth.clear();
            for (Integer value : GPSHelper.calculateAzimuth((IDevice)this, (RecordSet)recordSet, (int)0, (int)1, (int)2)) {
                recordAzimuth.add(value);
            }
        }
        this.application.updateStatisticsData();
    }

    public GPSLoggerDialog getDialog() {
        return this.dialog;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2000"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GPSLogger.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        Object selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!((String)selectedImportFile).toLowerCase().endsWith(".nmea")) {
                            if (((String)selectedImportFile).contains(".")) {
                                selectedImportFile = ((String)selectedImportFile).substring(0, ((String)selectedImportFile).indexOf(46));
                            }
                            selectedImportFile = (String)selectedImportFile + ".nmea";
                        }
                        log.log(java.util.logging.Level.FINE, "selectedImportFile = " + (String)selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            Integer channelConfigNumber = GPSLogger.this.application.getActiveChannelNumber();
                            String recordNameExtend = ((String)selectedImportFile).substring(((String)selectedImportFile).lastIndexOf(46) - 4, ((String)selectedImportFile).lastIndexOf(46));
                            DataInputStream binReader = new DataInputStream(new FileInputStream((String)selectedImportFile));
                            byte[] buffer = new byte[1024];
                            int numBytes = binReader.read(buffer);
                            while (numBytes > 0 && !new String(buffer).contains("$UL2") && !new String(buffer).contains("$UNILOG")) {
                                numBytes = binReader.read(buffer);
                            }
                            if (numBytes > 0 && new String(buffer).contains("$UL2")) {
                                channelConfigNumber = 2;
                                GPSLogger.this.channels.switchChannel(channelConfigNumber.intValue(), "");
                            } else if (numBytes > 0 && new String(buffer).contains("$UNILOG")) {
                                channelConfigNumber = 1;
                                GPSLogger.this.channels.switchChannel(channelConfigNumber.intValue(), "");
                            }
                            binReader.close();
                            NMEAReaderWriter.read((String)selectedImportFile, (IDevice)GPSLogger.this, (String)recordNameExtend, (Integer)channelConfigNumber);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    GPSLogger.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void updateFileMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT2005"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DRelativeItem action performed! " + String.valueOf(e));
                    GPSLogger.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2006"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                    GPSLogger.this.export2KMZ3D(1);
                }
            });
            convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2007"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                    GPSLogger.this.export2KMZ3D(2);
                }
            });
            MenuItem convertGPXItem = new MenuItem(exportMenue, 8);
            convertGPXItem.setText(Messages.getString((String)"GDE_MSGT0728"));
            convertGPXItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertGPXItem action performed! " + String.valueOf(e));
                    GPSLogger.this.export2GPX(false);
                }
            });
            if (this.getName().endsWith("2") || this.getName().endsWith("3")) {
                MenuItem convertGPXGarminItem = new MenuItem(exportMenue, 8);
                convertGPXGarminItem.setText(Messages.getString((String)"GDE_MSGT0729"));
                convertGPXGarminItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        log.log(java.util.logging.Level.FINEST, "convertGPXGarminItem action performed! " + String.valueOf(e));
                        GPSLogger.this.export2GPX(true);
                    }
                });
            }
        }
    }

    public void export2KMZ3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT2003"), 1, 0, 2, 7, 9, 11, -1, type == 0, type == 2);
    }

    public void export2GPX(boolean isGarminExtension) {
        if (isGarminExtension) {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 0, 1, 2, 7, 3, 5, 6, 4, new int[]{15, 16, 17});
        } else {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 0, 1, 2, 7, 3, 5, 6, 4, new int[0]);
        }
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(0).hasReasonableData() && activeRecordSet.get(1).hasReasonableData() && activeRecordSet.get(2).hasReasonableData();
        }
        return containsGPSdata;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            exportFileName = new FileHandler().exportFileKMZ(1, 0, 2, additionalMeasurementOrdinal, 9, 11, -1, true, isExportTmpDir);
        }
        return exportFileName;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 7;
        }
        return this.kmzMeasurementOrdinal;
    }

    public String translateGPS2IGC(RecordSet recordSet, int index, char fixValidity, int startAltitude, int offsetAltitude) {
        Record recordLatitude = recordSet.get(0);
        Record recordLongitude = recordSet.get(1);
        Record baroAlitude = recordSet.get(8);
        Record gpsAlitude = recordSet.get(2);
        return String.format("%02d%05d%s%03d%05d%s%c%05d%05d", recordLatitude.get(index) / 1000000, Double.valueOf((double)(recordLatitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLatitude.get(index) > 0 ? "N" : "S", recordLongitude.get(index) / 1000000, Double.valueOf((double)(recordLongitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLongitude.get(index) > 0 ? "E" : "W", Character.valueOf(fixValidity), Double.valueOf((double)baroAlitude.get(index).intValue() / 10000.0 + (double)startAltitude + (double)offsetAltitude).intValue(), Double.valueOf((double)gpsAlitude.get(index).intValue() / 1000.0 + (double)offsetAltitude).intValue());
    }

    String getDefaultConfigurationFileName() {
        return SM_GPS_LOGGER_INI;
    }

    String getConfigurationFileDirecotry() {
        if (selectedSetupFilePath == null) {
            Object searchPath;
            Object object = searchPath = "ObjectKey : " == null ? this.getDataBlockPreferredDataLocation().replace('\\', '/') : FileUtils.getDeviceImportDirectory((IDevice)this);
            if (((String)searchPath).contains(SM_GPS_LOGGER_DIR_STUB)) {
                searchPath = ((String)searchPath).substring(0, ((String)searchPath).indexOf(SM_GPS_LOGGER_DIR_STUB)) + SM_GPS_LOGGER_INI_DIR;
            } else {
                String dataFilePath = Settings.getInstance().getDataFilePath() + "/";
                if (((String)searchPath).equals(dataFilePath)) {
                    searchPath = (String)searchPath + this.getName() + "/";
                }
                searchPath = ((String)searchPath).endsWith("/") ? (String)searchPath + SM_GPS_LOGGER_INI_DIR : (String)searchPath + "/SM GPS-Logger setup";
            }
            return searchPath;
        }
        return selectedSetupFilePath.substring(0, selectedSetupFilePath.lastIndexOf(47));
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT2008", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT2008"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    GPSLogger.this.open_closeCommPort();
                }
            });
        }
    }

    public int[] getAtlitudeTripSpeedOrdinals() {
        return new int[]{8, 11, 7};
    }

    public String crossCheckChannelConfig(String channelConfig, HashMap<String, String> recordSetInfo) {
        if (channelConfig.endsWith("UniLog2")) {
            String updateChannelConfig = "2 : UniLog2";
            recordSetInfo.put("Channel/Configuration Name: ", updateChannelConfig);
            return updateChannelConfig;
        }
        return channelConfig;
    }
}

