/*
 * Decompiled with CFR 0.152.
 */
package gde.device.bantam;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.bantam.EStationDialog;
import gde.device.bantam.EStationSerialPort;
import gde.device.bantam.eStation;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.TimeLine;
import gde.utils.WaitTimer;
import java.util.HashMap;
import java.util.logging.Logger;

public class GathererThread
extends Thread {
    static final String $CLASS_NAME = GathererThread.class.getName();
    static final Logger log = Logger.getLogger(GathererThread.class.getName());
    static final int TIME_STEP_DEFAULT = 1250;
    static final int FILTER_TIME_DELTA_MS = 800;
    static final int WAIT_TIME_RETRYS = 3600;
    final DataExplorer application;
    final EStationSerialPort serialPort;
    final eStation device;
    final EStationDialog dialog;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    boolean isPortOpenedByLiveGatherer = false;
    boolean isGatheredRecordSetVisible = true;
    int numberBatteryCells = 0;
    int retryCounter = 3600;
    boolean isCollectDataStopped = false;
    int lastNumberDisplayableRecords = 0;

    public GathererThread(DataExplorer currentApplication, eStation useDevice, EStationSerialPort useSerialPort, int channelConfigNumber, EStationDialog useDialog) throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.dialog = useDialog;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        int posCells;
        String $METHOD_NAME = "run";
        RecordSet recordSet = null;
        int[] points = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        int waitTime_ms = 0;
        boolean isProgrammExecuting = false;
        HashMap<String, String> configData = new HashMap<String, String>();
        long startCycleTime = 0L;
        long tmpCycleTime = 0L;
        long measurementCount = 0L;
        boolean isCycleMode = false;
        int dryTimeCycleCount = 0;
        byte[] dataBuffer = null;
        this.isCollectDataStopped = false;
        log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        int n = posCells = this.device.getName().endsWith("80W") || this.device.getName().endsWith("BC6") || this.device.getName().endsWith("P6") || this.device.getName().endsWith("P60") ? 7 : 9;
        while (!this.isCollectDataStopped) {
            try {
                dataBuffer = this.serialPort.getData();
                String processName = this.device.USAGE_MODE[this.device.getProcessingMode(dataBuffer)];
                this.dialog.updateGlobalConfigData(this.device.getConfigurationValues(configData, dataBuffer));
                isProgrammExecuting = this.device.isProcessing(dataBuffer);
                isCycleMode = this.device.isCycleMode(dataBuffer);
                if (isCycleMode && measurementCount < 5L) {
                    dryTimeCycleCount = this.device.getNumberOfCycle(dataBuffer) > 0 ? this.device.getNumberOfCycle(dataBuffer) * 2 - 1 : 0;
                }
                log.logp(Level.FINER, $CLASS_NAME, "run", "processing mode = " + processName + " isCycleMode = " + isCycleMode + " dryTimeCycleCount = " + dryTimeCycleCount);
                if (isProgrammExecuting && (processName.equals(this.device.USAGE_MODE[1]) || processName.equals(this.device.USAGE_MODE[2]))) {
                    RecordSet activeRecordSet;
                    if (this.channel.size() == 0 || recordSet == null || !this.recordSetKey.endsWith(" " + processName)) {
                        this.application.setStatusMessage("");
                        this.setRetryCounter(3600);
                        waitTime_ms = Integer.valueOf(configData.get("wait_time")) * 60000;
                        log.logp(Level.FINE, $CLASS_NAME, "run", "waitTime_ms = " + waitTime_ms);
                        this.recordSetKey = this.channel.getNextRecordSetNumber() + ") [" + configData.get("battery_type") + "] " + processName;
                        this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                        log.logp(Level.FINE, $CLASS_NAME, "run", this.recordSetKey + " created for channel " + this.channel.getName());
                        if (this.channel.getActiveRecordSet() == null) {
                            this.channel.setActiveRecordSet(this.recordSetKey);
                        }
                        recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
                        this.channel.applyTemplateBasics(this.recordSetKey);
                        recordSet.setAllDisplayable();
                        this.channels.switchChannel(this.channel.getNumber(), this.recordSetKey);
                        this.channel.switchRecordSet(this.recordSetKey);
                        measurementCount = 0L;
                        startCycleTime = 0L;
                    }
                    this.isGatheredRecordSetVisible = this.recordSetKey.equals(this.channels.getActiveChannel().getActiveRecordSet().getName());
                    tmpCycleTime = System.nanoTime() / 1000000L;
                    if (measurementCount++ == 0L) {
                        startCycleTime = tmpCycleTime;
                    }
                    recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer), (double)(tmpCycleTime - startCycleTime));
                    log.logp(Level.TIME, $CLASS_NAME, "run", "time = " + TimeLine.getFomatedTimeWithUnit((double)(tmpCycleTime - startCycleTime)));
                    this.numberBatteryCells = 0;
                    for (int i = posCells; i < recordSet.size(); ++i) {
                        Record record = recordSet.get(i);
                        if (record.getRealMinValue() == 0 || record.getRealMaxValue() == 0) continue;
                        ++this.numberBatteryCells;
                        log.logp(Level.FINER, $CLASS_NAME, "run", "record = " + record.getName() + " " + record.getRealMinValue() + " " + record.getRealMaxValue());
                    }
                    if (recordSet.get(0).realSize() < 3 || recordSet.get(0).realSize() % 10 == 0) {
                        this.device.updateVisibilityStatus(recordSet, true);
                    }
                    if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) == null || recordSet.size() <= 0 || !recordSet.isChildOfActiveChannel() || !recordSet.equals((Object)activeRecordSet)) continue;
                    this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != recordSet.getConfiguredDisplayable());
                    this.lastNumberDisplayableRecords = recordSet.getConfiguredDisplayable();
                    continue;
                }
                this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1400"));
                log.logp(Level.FINE, $CLASS_NAME, "run", "wait for eStation activation");
                if (recordSet != null && recordSet.getRecordDataSize(true) > 5) {
                    this.finalizeRecordSet(false);
                    isProgrammExecuting = false;
                    recordSet = null;
                    this.setRetryCounter(3600);
                    this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGT1408"));
                    continue;
                }
                if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                log.log(Level.FINE, "eStation activation timeout");
                this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW1400"));
                this.stopDataGatheringThread(false, null);
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                this.cleanup(message);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException && isCycleMode && dryTimeCycleCount > 0) {
                    this.finalizeRecordSet(false);
                    log.logp(Level.FINE, $CLASS_NAME, "run", "(dry time) waiting...");
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1401"));
                    recordSet = null;
                    --dryTimeCycleCount;
                    WaitTimer.delay((long)waitTime_ms);
                    continue;
                }
                if (e instanceof TimeOutException && !isProgrammExecuting) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1400"));
                    log.logp(Level.FINE, $CLASS_NAME, "run", "wait for eStation activation ...");
                    if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                    log.log(Level.FINE, "eStation activation timeout");
                    this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW1400"));
                    this.stopDataGatheringThread(false, null);
                    continue;
                }
                log.log(Level.FINE, "eStation program end detected");
                this.stopDataGatheringThread(true, e);
            }
        }
        this.application.setStatusMessage("");
        log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        RecordSet recordSet;
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null && this.serialPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
        }
        if (this.serialPort != null && this.serialPort.isConnected() && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGT1409"));
            }
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}) + Messages.getString((String)"GDE_MSGT1408"));
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026") + Messages.getString((String)"GDE_MSGT1408"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialog(this.dialog.getDialogShell(), message);
                this.device.getDialog().resetButtons();
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        GathererThread.this.application.updateStatisticsData();
                        GathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        GathererThread.this.application.openMessageDialog(GathererThread.this.dialog.getDialogShell(), message);
                        GathererThread.this.device.getDialog().resetButtons();
                    }
                });
            }
        } else {
            this.application.openMessageDialog(this.dialog.getDialogShell(), message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

