/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.exception.NotSupportedFileFormatException;
import gde.io.OsdReaderWriter;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.ObjectKeyCompliance;
import gde.utils.OperatingSystemHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ObjectKeyScanner
extends Thread {
    private static final Logger log = Logger.getLogger(ObjectKeyScanner.class.getName());
    private final DataExplorer application = DataExplorer.getInstance();
    private final Settings settings = Settings.getInstance();
    String objectKey = "";
    final boolean addToExistentKeys;
    private List<String> obsoleteObjectKeys = new ArrayList<String>();

    public ObjectKeyScanner(boolean newAddToExistentKeys) {
        super("objectKeyScanner");
        this.addToExistentKeys = newAddToExistentKeys;
    }

    public ObjectKeyScanner(String newObjectKey) {
        super("objectKeyScanner");
        this.objectKey = newObjectKey;
        this.addToExistentKeys = false;
    }

    @Override
    public void run() {
        try {
            String objectKeyDirPath = this.settings.getDataFilePath() + "/" + this.objectKey;
            if (this.objectKey.length() >= 2) {
                FileUtils.checkDirectoryAndCreate(objectKeyDirPath);
                List<File> files = FileUtils.getFileListing(new File(this.settings.getDataFilePath()), 1);
                int progressDistance = 50;
                double progressStep = (99.0 - (double)GDE.getUiNotification().getProgressPercentage()) / ((double)files.size() + 1.0) * 50.0;
                int i = 0;
                for (File file : files) {
                    try {
                        String actualFilePath = file.getAbsolutePath().replace('\\', '/');
                        if (actualFilePath.endsWith("osd") && actualFilePath.equals(OperatingSystemHelper.getLinkContainedFilePath(actualFilePath))) {
                            log.log(Level.FINER, "working with " + file.getName());
                            if (this.objectKey.equals(OsdReaderWriter.getHeader(file.getCanonicalPath()).get("ObjectKey : "))) {
                                log.log(Level.FINER, "found file with given object key " + file.getName());
                                String newLinkFilePath = objectKeyDirPath + "/" + file.getName();
                                if (!new File(newLinkFilePath).exists()) {
                                    OperatingSystemHelper.createFileLink(file.getCanonicalPath(), newLinkFilePath);
                                }
                            }
                        }
                        if (i % 50 == 0) {
                            GDE.getUiNotification().setProgress((int)((double)i * progressStep));
                        }
                        ++i;
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, file.getAbsolutePath(), e);
                    }
                    catch (NotSupportedFileFormatException e) {
                        log.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.getLocalizedMessage(), t);
                    }
                }
                GDE.getUiNotification().setProgress(100);
            } else {
                log.log(Level.WARNING, "object key not set, actual object key = \"" + this.objectKey + "\" !");
                int progressPercentageLimit = 80;
                File rootDirectory = new File(this.settings.getDataFilePath());
                log.log(Level.FINE, "this.settings.getDataFilePath() = " + rootDirectory.toString());
                Vector<String> objectKeys = new Vector<String>();
                HashMap objectFilesMap = new HashMap();
                int fileCounter = 0;
                List<File> files = FileUtils.getFileListing(rootDirectory, 1);
                int progressDistance = 50;
                double progressStep = (99.0 - (double)GDE.getUiNotification().getProgressPercentage()) / ((double)files.size() + 1.0) * 50.0;
                int i = 0;
                for (File file : files) {
                    try {
                        String actualFilePath = file.getAbsolutePath().replace('\\', '/');
                        if (actualFilePath.endsWith("osd")) {
                            ++fileCounter;
                            if (actualFilePath.equals(OperatingSystemHelper.getLinkContainedFilePath(actualFilePath))) {
                                log.fine(() -> String.format("working with %s", file.getName()));
                                String foundObjectKey = OsdReaderWriter.getHeader(file.getCanonicalPath()).get("ObjectKey : ");
                                if (foundObjectKey != null && foundObjectKey.length() >= 2) {
                                    if (!objectKeys.contains(foundObjectKey)) {
                                        log.fine(() -> String.format("found new object key %s", foundObjectKey));
                                        objectKeys.add(foundObjectKey);
                                        Vector<File> tmpObjectFiles = new Vector<File>();
                                        tmpObjectFiles.add(file);
                                        objectFilesMap.put(foundObjectKey, tmpObjectFiles);
                                    } else {
                                        ((Vector)objectFilesMap.get(foundObjectKey)).add(file);
                                    }
                                    log.fine(() -> String.format("add file %s to object key %s", file.getName(), foundObjectKey));
                                }
                            }
                        }
                        if (i % 50 == 0) {
                            GDE.getUiNotification().setProgress((int)((double)i * progressStep));
                        }
                        ++i;
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                    catch (NotSupportedFileFormatException e) {
                        log.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.getLocalizedMessage(), t);
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("scanned %d files for object key, foundKeysSize = %d", fileCounter, objectKeys.size()));
                }
                GDE.getUiNotification().setProgress(80);
                int progressPercentageStart = GDE.getUiNotification().getProgressPercentage();
                double progressStep2 = (100.0 - (double)progressPercentageStart) / (double)objectKeys.size();
                int j = 0;
                for (String tmpObjKey : objectKeys) {
                    log.fine(() -> String.format("found object key in vector = %s", tmpObjKey));
                    objectKeyDirPath = this.settings.getDataFilePath() + "/" + tmpObjKey;
                    FileUtils.checkDirectoryAndCreate(objectKeyDirPath);
                    for (File file : (Vector)objectFilesMap.get(tmpObjKey)) {
                        try {
                            String newLinkFilePath = objectKeyDirPath + "/" + file.getName();
                            if (new File(newLinkFilePath).exists()) continue;
                            OperatingSystemHelper.createFileLink(file.getCanonicalPath(), newLinkFilePath);
                        }
                        catch (IOException e) {
                            log.log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                    }
                    GDE.getUiNotification().setProgress(progressPercentageStart + (int)((double)(++j) * progressStep2));
                }
                if (this.addToExistentKeys) {
                    Set<String> newObjectList = Settings.getInstance().getRealObjectKeys().collect(Collectors.toSet());
                    if (newObjectList.addAll(objectKeys) || !newObjectList.equals(new HashSet(objectKeys))) {
                        this.application.setObjectList(newObjectList.toArray(new String[0]), this.settings.getActiveObject());
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "object list updated: ", newObjectList);
                        }
                    }
                    this.obsoleteObjectKeys = this.getObsoleteObjectKeys(rootDirectory);
                } else {
                    this.application.setObjectList(objectKeys.toArray(new String[0]), this.settings.getActiveObject());
                }
                GDE.getUiNotification().setProgress(100);
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    private List<String> getObsoleteObjectKeys(File rootDirectory) throws FileNotFoundException {
        List<String> resultObjectKeys = this.settings.getRealObjectKeys().collect(Collectors.toList());
        TreeMap<String, DeviceConfiguration> devices = Analyzer.getInstance().getDeviceConfigurations().getAllConfigurations();
        resultObjectKeys.removeAll(ObjectKeyCompliance.defineObjectKeyNovelties(devices));
        for (File dir : FileUtils.getDirectories(rootDirectory)) {
            if (FileUtils.getFileListing(dir, Integer.MAX_VALUE).isEmpty()) continue;
            if (GDE.IS_WINDOWS) {
                ListIterator<String> iterator = resultObjectKeys.listIterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().toLowerCase().equals(dir.getName().toLowerCase())) continue;
                    iterator.remove();
                }
                continue;
            }
            resultObjectKeys.remove(dir.getName());
        }
        log.log(Level.INFO, "obsoleteObjectKeys: ", resultObjectKeys);
        return resultObjectKeys;
    }

    public static void cleanFileLinks() {
        try {
            List<File> files = FileUtils.getFileListing(new File(Settings.getInstance().getDataFilePath()), 1);
            for (File file : files) {
                try {
                    String actualFilePath = file.getAbsolutePath().replace('\\', '/');
                    if (!actualFilePath.endsWith("osd") || actualFilePath.equals(OperatingSystemHelper.getLinkContainedFilePath(actualFilePath))) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "working with " + file.getName());
                    }
                    if (file.delete() || !log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "could not delete " + file.getName());
                }
                catch (IOException e) {
                    log.log(Level.WARNING, file.getAbsolutePath(), e);
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, t.getLocalizedMessage(), t);
                }
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public List<String> getObsoleteObjectKeys() {
        return this.obsoleteObjectKeys;
    }
}

