/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.log.Level;
import gde.utils.ValueCollector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ValueEventCollector
extends TreeMap<Integer, ValueCollector> {
    private static final Logger log = Logger.getLogger(ValueEventCollector.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String LF = System.getProperty("line.separator");
    int maxCount;
    int minCount;
    int avgOffsetMaxCount;
    int avgOffsetMinCount;

    public ValueEventCollector() {
        this.reset();
    }

    public void addValuePair(int valueA, int valueB) {
        if (null == this.get(valueA)) {
            this.put(valueA, new ValueCollector(valueA, valueB));
        } else {
            ((ValueCollector)this.get(valueA)).add(valueA, valueB);
        }
    }

    public int getAvgDiffMaxCount() {
        if (this.avgOffsetMaxCount == Integer.MIN_VALUE) {
            this.maxCount = Integer.MIN_VALUE;
            int maxCountKey = 0;
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                if (((ValueCollector)this.get(key)).getCount() > this.maxCount) {
                    this.maxCount = ((ValueCollector)this.get(key)).getCount();
                    maxCountKey = key;
                    continue;
                }
                if (((ValueCollector)this.get(key)).getCount() != this.maxCount || ((ValueCollector)this.get(maxCountKey)).getAvgOffset() <= ((ValueCollector)this.get(key)).getAvgOffset()) continue;
                maxCountKey = key;
            }
            if (this.get(maxCountKey) != null) {
                this.avgOffsetMaxCount = ((ValueCollector)this.get(maxCountKey)).getAvgOffset();
            }
        }
        return this.avgOffsetMaxCount;
    }

    public int getAvgDiffMinCount() {
        if (this.avgOffsetMinCount == Integer.MAX_VALUE) {
            this.minCount = Integer.MAX_VALUE;
            int minCountKey = 0;
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                if (((ValueCollector)this.get(key)).getCount() >= this.minCount) continue;
                this.minCount = ((ValueCollector)this.get(key)).getCount();
                minCountKey = key;
            }
            if (this.get(minCountKey) != null) {
                this.avgOffsetMinCount = ((ValueCollector)this.get(minCountKey)).getAvgOffset();
            }
        }
        return this.avgOffsetMinCount;
    }

    public int getMaxEntryCount() {
        if (this.maxCount == Integer.MIN_VALUE) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                if (((ValueCollector)this.get(key)).getCount() <= this.maxCount) continue;
                this.maxCount = ((ValueCollector)this.get(key)).getCount();
            }
        }
        return this.maxCount;
    }

    public int getMinEntryCount() {
        if (this.minCount == Integer.MAX_VALUE) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                if (((ValueCollector)this.get(key)).getCount() >= this.minCount) continue;
                this.minCount = ((ValueCollector)this.get(key)).getCount();
            }
        }
        return this.minCount;
    }

    public void reset() {
        this.maxCount = Integer.MIN_VALUE;
        this.minCount = Integer.MAX_VALUE;
        this.avgOffsetMaxCount = Integer.MIN_VALUE;
        this.avgOffsetMinCount = Integer.MAX_VALUE;
    }

    @Override
    public String toString() {
        return new StringBuffer(this.getClass().getSimpleName()).append(": ").append(this.size()).append(" entries, ").append("max.count=").append(this.getMaxEntryCount()).append(", min.count=").append(this.getMinEntryCount()).append(", avg.offset@max.count=").append(this.getAvgDiffMaxCount()).append(", avg.offset@min.count=").append(this.getAvgDiffMinCount()).toString();
    }

    public String listValues() {
        StringBuffer sb = new StringBuffer("number of value entries=").append(this.size()).append(LF);
        int[] arKeys = new int[this.size()];
        int i = 0;
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            arKeys[i++] = key;
        }
        Arrays.sort(arKeys);
        for (int k = 0; k < arKeys.length; ++k) {
            sb.append(((ValueCollector)this.get(arKeys[k])).toString()).append(LF);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        double[] arStaticPressureHPa = new double[]{965.51, 965.52, 965.52, 965.51, 965.49, 965.5, 965.51, 965.49, 965.49, 965.49, 965.5};
        double[] arTECPressureHPa = new double[]{965.5, 965.5, 965.51, 965.48, 965.48, 965.49, 965.49, 965.48, 965.47, 965.47, 965.49};
        int[] arStaticPressure = new int[arStaticPressureHPa.length];
        int[] arTECPressure = new int[arTECPressureHPa.length];
        for (int i = 0; i < arStaticPressure.length; ++i) {
            arStaticPressure[i] = (int)(arStaticPressureHPa[i] * 1000.0);
            arTECPressure[i] = (int)(arTECPressureHPa[i] * 1000.0);
        }
        ValueEventCollector vec = new ValueEventCollector();
        for (int i = 0; i < arStaticPressure.length; ++i) {
            vec.addValuePair(arStaticPressure[i], arTECPressure[i]);
        }
        log.log(Level.OFF, vec.toString());
        log.log(Level.OFF, vec.listValues());
    }
}

