/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfEncodings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    @Deprecated
    public static <K, V> Set<K> getKeySet(Hashtable<K, V> table) {
        return table == null ? Collections.emptySet() : table.keySet();
    }

    public static Object[][] addToArray(Object[][] original, Object[] item2) {
        if (original == null) {
            original = new Object[][]{item2};
            return original;
        }
        Object[][] original2 = new Object[original.length + 1][];
        System.arraycopy(original, 0, original2, 0, original.length);
        original2[original.length] = item2;
        return original2;
    }

    public static boolean checkTrueOrFalse(Properties attributes, String key2) {
        return "true".equalsIgnoreCase(attributes.getProperty(key2));
    }

    public static String unEscapeURL(String src) {
        StringBuffer bf = new StringBuffer();
        char[] s2 = src.toCharArray();
        for (int k2 = 0; k2 < s2.length; ++k2) {
            char c2 = s2[k2];
            if (c2 == '%') {
                if (k2 + 2 >= s2.length) {
                    bf.append(c2);
                    continue;
                }
                int a0 = PRTokeniser.getHex(s2[k2 + 1]);
                int a1 = PRTokeniser.getHex(s2[k2 + 2]);
                if (a0 < 0 || a1 < 0) {
                    bf.append(c2);
                    continue;
                }
                bf.append((char)(a0 * 16 + a1));
                k2 += 2;
                continue;
            }
            bf.append(c2);
        }
        return bf.toString();
    }

    public static URL toURL(String filename) throws MalformedURLException {
        try {
            return new URL(filename);
        }
        catch (Exception e2) {
            return new File(filename).toURI().toURL();
        }
    }

    public static void skip(InputStream is, int size) throws IOException {
        long n2;
        while (size > 0 && (n2 = is.skip(size)) > 0L) {
            size = (int)((long)size - n2);
        }
    }

    public static final float millimetersToPoints(float value) {
        return Utilities.inchesToPoints(Utilities.millimetersToInches(value));
    }

    public static final float millimetersToInches(float value) {
        return value / 25.4f;
    }

    public static final float pointsToMillimeters(float value) {
        return Utilities.inchesToMillimeters(Utilities.pointsToInches(value));
    }

    public static final float pointsToInches(float value) {
        return value / 72.0f;
    }

    public static final float inchesToMillimeters(float value) {
        return value * 25.4f;
    }

    public static final float inchesToPoints(float value) {
        return value * 72.0f;
    }

    public static boolean isSurrogateHigh(char c2) {
        return c2 >= '\ud800' && c2 <= '\udbff';
    }

    public static boolean isSurrogateLow(char c2) {
        return c2 >= '\udc00' && c2 <= '\udfff';
    }

    public static boolean isSurrogatePair(String text2, int idx) {
        if (idx < 0 || idx > text2.length() - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(text2.charAt(idx)) && Utilities.isSurrogateLow(text2.charAt(idx + 1));
    }

    public static boolean isSurrogatePair(char[] text2, int idx) {
        if (idx < 0 || idx > text2.length - 2) {
            return false;
        }
        return Utilities.isSurrogateHigh(text2[idx]) && Utilities.isSurrogateLow(text2[idx + 1]);
    }

    public static int convertToUtf32(char highSurrogate, char lowSurrogate) {
        return (highSurrogate - 55296) * 1024 + lowSurrogate - 56320 + 65536;
    }

    public static int convertToUtf32(char[] text2, int idx) {
        return (text2[idx] - 55296) * 1024 + text2[idx + 1] - 56320 + 65536;
    }

    public static int convertToUtf32(String text2, int idx) {
        return (text2.charAt(idx) - 55296) * 1024 + text2.charAt(idx + 1) - 56320 + 65536;
    }

    public static String convertFromUtf32(int codePoint) {
        if (codePoint < 65536) {
            return Character.toString((char)codePoint);
        }
        return new String(new char[]{(char)((codePoint -= 65536) / 1024 + 55296), (char)(codePoint % 1024 + 56320)});
    }

    public static String readFileToString(String path2) throws IOException {
        return Utilities.readFileToString(new File(path2));
    }

    public static String readFileToString(File file) throws IOException {
        byte[] jsBytes = new byte[(int)file.length()];
        FileInputStream f2 = new FileInputStream(file);
        f2.read(jsBytes);
        return new String(jsBytes);
    }

    public static String convertToHex(byte[] bytes) {
        ByteBuffer buf = new ByteBuffer();
        for (byte b2 : bytes) {
            buf.appendHex(b2);
        }
        return PdfEncodings.convertToString(buf.toByteArray(), null).toUpperCase();
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        char[] copy2 = new char[newLength];
        System.arraycopy(original, from, copy2, 0, Math.min(original.length - from, newLength));
        return copy2;
    }
}

