/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.http.Consts;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.EofSensor;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.CharArrayBuffer;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LoggingSessionInputBuffer
implements SessionInputBuffer,
EofSensor {
    private final SessionInputBuffer in;
    private final EofSensor eofSensor;
    private final Wire wire;
    private final String charset;

    public LoggingSessionInputBuffer(SessionInputBuffer in, Wire wire, String charset) {
        this.in = in;
        this.eofSensor = in instanceof EofSensor ? (EofSensor)((Object)in) : null;
        this.wire = wire;
        this.charset = charset != null ? charset : Consts.ASCII.name();
    }

    public LoggingSessionInputBuffer(SessionInputBuffer in, Wire wire) {
        this(in, wire, null);
    }

    @Override
    public boolean isDataAvailable(int timeout) throws IOException {
        return this.in.isDataAvailable(timeout);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int readLen = this.in.read(b2, off, len);
        if (this.wire.enabled() && readLen > 0) {
            this.wire.input(b2, off, readLen);
        }
        return readLen;
    }

    @Override
    public int read() throws IOException {
        int b2 = this.in.read();
        if (this.wire.enabled() && b2 != -1) {
            this.wire.input(b2);
        }
        return b2;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int readLen = this.in.read(b2);
        if (this.wire.enabled() && readLen > 0) {
            this.wire.input(b2, 0, readLen);
        }
        return readLen;
    }

    @Override
    public String readLine() throws IOException {
        String s2 = this.in.readLine();
        if (this.wire.enabled() && s2 != null) {
            String tmp = s2 + "\r\n";
            this.wire.input(tmp.getBytes(this.charset));
        }
        return s2;
    }

    @Override
    public int readLine(CharArrayBuffer buffer) throws IOException {
        int readLen = this.in.readLine(buffer);
        if (this.wire.enabled() && readLen >= 0) {
            int pos = buffer.length() - readLen;
            String s2 = new String(buffer.buffer(), pos, readLen);
            String tmp = s2 + "\r\n";
            this.wire.input(tmp.getBytes(this.charset));
        }
        return readLen;
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.in.getMetrics();
    }

    @Override
    public boolean isEof() {
        if (this.eofSensor != null) {
            return this.eofSensor.isEof();
        }
        return false;
    }
}

