/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.ui.DataExplorer;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;

public class SimulatorSerialPort
extends DeviceCommPort {
    static final Logger log = Logger.getLogger(SimulatorSerialPort.class.getName());
    int lastRecord = -1;
    int lastVoltage = 0;
    int lastCurrent = 0;
    int xBound = 0;

    public SimulatorSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public HashMap<String, Object> getData(int recordNumber, int channelConfigNumber) throws Exception {
        int i;
        int numPoints;
        if (recordNumber != this.lastRecord) {
            this.lastRecord = recordNumber;
            this.lastVoltage = 0;
            this.lastCurrent = 0;
            this.xBound = 0;
            numPoints = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO) + 1;
            i = 0;
        } else {
            numPoints = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO);
            i = 1;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        Vector<Integer> voltage = new Vector<Integer>();
        Vector<Integer> current = new Vector<Integer>();
        this.xBound += 100;
        this.lastVoltage = this.xBound / 2;
        int yBound = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO);
        log.fine("numPoints = " + numPoints);
        while (i < this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO) + 1) {
            current.add(i * 1000 + this.lastCurrent);
            voltage.add(this.getNormalizedSine(i, this.xBound / 2, yBound) - this.lastVoltage);
            ++i;
        }
        this.lastCurrent = 0;
        String[] measurements = this.deviceConfig.getMeasurementNames(channelConfigNumber);
        data.put(measurements[0], voltage);
        data.put(measurements[1], current);
        return data;
    }

    int getNormalizedSine(int x, int halfY, int maxX) {
        double piDouble = Math.PI * 2;
        double factor = piDouble / (double)maxX;
        return (int)(Math.sin((double)x * factor) * (double)halfY + (double)halfY);
    }
}

