/*
 * Decompiled with CFR 0.152.
 */
package gde.device.kontronik;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelPropertyTypes;
import gde.device.DataTypes;
import gde.device.kontronik.Kosmik;
import gde.device.smmodellbau.JLog2Configuration;
import gde.device.smmodellbau.JLog2Dialog;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;

public class KosmikConfiguration
extends Composite {
    static final Logger log = Logger.getLogger(JLog2Configuration.class.getName());
    private CLabel kosmikHeaderLabel;
    private CLabel motorRotorRpmLabel;
    private CLabel numMotorPolsLabel;
    private CLabel motorPinionLabel;
    private CCombo motorRotorRpmCombo;
    private CCombo kosmikVersionCombo;
    private CCombo temperatureUnitCombo;
    private Slider mainGearToothCountSlider;
    private Text mainGearToothCountText;
    private Text motorPinionText;
    private Slider motorPinionSlider;
    private CCombo numMotorPolsCombo;
    private CLabel kosmikVersionLabel;
    private CLabel temperatureUnitLabel;
    private CLabel mainGearToothCountLabel;
    final DataExplorer application;
    final Channels channles;
    final JLog2Dialog dialog;
    final Kosmik device;
    final String[] oneTo50 = new String[50];
    boolean isVersion32 = true;

    public static void main(String[] args) {
        KosmikConfiguration.showGUI();
    }

    public static void showGUI() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        KosmikConfiguration inst = new KosmikConfiguration((Composite)shell, 0);
        Point size = inst.getSize();
        shell.setLayout((Layout)new FillLayout());
        shell.layout();
        if (size.x == 0 && size.y == 0) {
            inst.pack();
            shell.pack();
        } else {
            Rectangle shellBounds = shell.computeTrim(0, 0, size.x, size.y);
            shell.setSize(shellBounds.width, shellBounds.height);
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public KosmikConfiguration(Composite parent, int style, JLog2Dialog useDialog, Kosmik useDevice) {
        super(parent, style);
        this.application = DataExplorer.getInstance();
        this.channles = Channels.getInstance();
        this.dialog = useDialog;
        this.device = useDevice;
        for (int i = 0; i < this.oneTo50.length; ++i) {
            this.oneTo50[i] = "" + (i + 1);
        }
        this.initGUI();
    }

    public KosmikConfiguration(Composite parent, int style) {
        super(parent, style);
        for (int i = 0; i < this.oneTo50.length; ++i) {
            this.oneTo50[i] = "" + (i + 1);
        }
        this.application = null;
        this.channles = Channels.getInstance();
        this.dialog = null;
        this.device = null;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setLayout((Layout)new FormLayout());
            this.setSize(665, 334);
            this.kosmikHeaderLabel = new CLabel((Composite)this, 0x1000000);
            FormData kosmikHeaderLabelLData = new FormData();
            kosmikHeaderLabelLData.left = new FormAttachment(0, 1000, 10);
            kosmikHeaderLabelLData.top = new FormAttachment(0, 1000, 10);
            kosmikHeaderLabelLData.width = this.getClientArea().width - 20;
            kosmikHeaderLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            this.kosmikHeaderLabel.setLayoutData((Object)kosmikHeaderLabelLData);
            this.kosmikHeaderLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.kosmikHeaderLabel.setText(Messages.getString((String)"GDE_MSGW2804"));
            this.motorRotorRpmLabel = new CLabel((Composite)this, 0);
            this.motorRotorRpmLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorRotorRpmLabel.setText(Messages.getString((String)"GDE_MSGW2805"));
            FormData rpmLabelLData = new FormData();
            rpmLabelLData.width = 272;
            rpmLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            rpmLabelLData.left = new FormAttachment(0, 1000, 125);
            rpmLabelLData.top = new FormAttachment(0, 1000, 40);
            this.motorRotorRpmLabel.setLayoutData((Object)rpmLabelLData);
            this.motorRotorRpmCombo = new CCombo((Composite)this, 2048);
            this.motorRotorRpmCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorRotorRpmCombo.setItems(new String[]{"  Motor", "Propeller/Rotor"});
            FormData motorRotorRpmComboLData = new FormData();
            motorRotorRpmComboLData.width = 120;
            motorRotorRpmComboLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            motorRotorRpmComboLData.left = new FormAttachment(0, 1000, 400);
            motorRotorRpmComboLData.top = new FormAttachment(0, 1000, 40);
            this.motorRotorRpmCombo.setLayoutData((Object)motorRotorRpmComboLData);
            this.motorRotorRpmCombo.select(0);
            this.motorRotorRpmCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "motorRotorRpmCombo.widgetSelected, event=" + String.valueOf(evt));
                    }
                    KosmikConfiguration.this.updateMotorRotor(KosmikConfiguration.this.motorRotorRpmCombo.getSelectionIndex());
                    switch (KosmikConfiguration.this.motorRotorRpmCombo.getSelectionIndex()) {
                        case 1: {
                            KosmikConfiguration.this.setGearFactor();
                            break;
                        }
                        default: {
                            KosmikConfiguration.this.setPoleFactor();
                        }
                    }
                    KosmikConfiguration.this.device.setChannelProperty(ChannelPropertyTypes.NUMBER_POLES, DataTypes.INTEGER, "" + (KosmikConfiguration.this.numMotorPolsCombo.getSelectionIndex() + 1) * 2);
                }
            });
            this.numMotorPolsLabel = new CLabel((Composite)this, 0);
            this.numMotorPolsLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.numMotorPolsLabel.setText(Messages.getString((String)"GDE_MSGW2808"));
            FormData numPolsLabelLData = new FormData();
            numPolsLabelLData.width = 272;
            numPolsLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            numPolsLabelLData.left = new FormAttachment(0, 1000, 125);
            numPolsLabelLData.top = new FormAttachment(0, 1000, 75);
            this.numMotorPolsLabel.setLayoutData((Object)numPolsLabelLData);
            this.numMotorPolsCombo = new CCombo((Composite)this, 2048);
            this.numMotorPolsCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.numMotorPolsCombo.setItems(new String[]{"    2", "    4", "    6", "    8", "   10", "   12", "   14", "   16", "   18"});
            FormData numMotorPolsComboLData = new FormData();
            numMotorPolsComboLData.width = 80;
            numMotorPolsComboLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            numMotorPolsComboLData.left = new FormAttachment(0, 1000, 400);
            numMotorPolsComboLData.top = new FormAttachment(0, 1000, 75);
            this.numMotorPolsCombo.setLayoutData((Object)numMotorPolsComboLData);
            this.numMotorPolsCombo.select(6);
            this.numMotorPolsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "numMotorPolsCombo.widgetSelected, event=" + String.valueOf(evt));
                    }
                    if (KosmikConfiguration.this.motorRotorRpmCombo.getSelectionIndex() == 0) {
                        KosmikConfiguration.this.setPoleFactor();
                    } else {
                        KosmikConfiguration.this.setGearFactor();
                    }
                    KosmikConfiguration.this.device.setChannelProperty(ChannelPropertyTypes.NUMBER_POLES, DataTypes.INTEGER, "" + (KosmikConfiguration.this.numMotorPolsCombo.getSelectionIndex() + 1) * 2);
                    KosmikConfiguration.this.dialog.enableSaveButton(true);
                }
            });
            this.motorPinionLabel = new CLabel((Composite)this, 0);
            this.motorPinionLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorPinionLabel.setText(Messages.getString((String)"GDE_MSGW2806"));
            FormData motorPinionLabelLData = new FormData();
            motorPinionLabelLData.width = 272;
            motorPinionLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            motorPinionLabelLData.left = new FormAttachment(0, 1000, 125);
            motorPinionLabelLData.top = new FormAttachment(0, 1000, 110);
            this.motorPinionLabel.setLayoutData((Object)motorPinionLabelLData);
            this.motorPinionText = new Text((Composite)this, 0x1000800);
            this.motorPinionText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.motorPinionText.setText("17");
            FormData motorPinionTextLData = new FormData();
            motorPinionTextLData.width = 30;
            motorPinionTextLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            motorPinionTextLData.left = new FormAttachment(0, 1000, 400);
            motorPinionTextLData.top = new FormAttachment(0, 1000, 110);
            this.motorPinionText.setLayoutData((Object)motorPinionTextLData);
            this.motorPinionText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "motorPinionText.keyPressed, event=" + String.valueOf(evt));
                    }
                    KosmikConfiguration.this.motorPinionSlider.setSelection(Integer.valueOf(KosmikConfiguration.this.motorPinionText.getText().trim()) + KosmikConfiguration.this.motorPinionSlider.getMinimum());
                    KosmikConfiguration.this.setGearFactor();
                    KosmikConfiguration.this.dialog.enableSaveButton(true);
                }
            });
            this.motorPinionText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "motorPinionText.verifyText, event=" + String.valueOf(evt));
                    }
                    evt.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)evt.text);
                }
            });
            this.motorPinionSlider = new Slider((Composite)this, 2304);
            FormData motorPinionSliderLData = new FormData();
            motorPinionSliderLData.width = 100;
            motorPinionSliderLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            motorPinionSliderLData.left = new FormAttachment(0, 1000, 450);
            motorPinionSliderLData.top = new FormAttachment(0, 1000, 110);
            this.motorPinionSlider.setLayoutData((Object)motorPinionSliderLData);
            this.motorPinionSlider.setMaximum(50);
            this.motorPinionSlider.setMinimum(10);
            this.motorPinionSlider.setSelection(16);
            this.motorPinionSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "motorPinionSlider.widgetSelected, event=" + String.valueOf(evt));
                    }
                    KosmikConfiguration.this.motorPinionText.setText("" + KosmikConfiguration.this.motorPinionSlider.getSelection());
                    KosmikConfiguration.this.setGearFactor();
                    KosmikConfiguration.this.dialog.enableSaveButton(true);
                }
            });
            this.motorPinionText.setText("" + this.motorPinionSlider.getSelection());
            this.mainGearToothCountLabel = new CLabel((Composite)this, 0);
            this.mainGearToothCountLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mainGearToothCountLabel.setText(Messages.getString((String)"GDE_MSGW2807"));
            FormData mainGearToothCountLabelLData = new FormData();
            mainGearToothCountLabelLData.width = 272;
            mainGearToothCountLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            mainGearToothCountLabelLData.left = new FormAttachment(0, 1000, 125);
            mainGearToothCountLabelLData.top = new FormAttachment(0, 1000, 145);
            this.mainGearToothCountLabel.setLayoutData((Object)mainGearToothCountLabelLData);
            this.mainGearToothCountText = new Text((Composite)this, 0x1000800);
            this.mainGearToothCountText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.mainGearToothCountText.setText("87");
            FormData mainGearToothCountTextLData = new FormData();
            mainGearToothCountTextLData.width = 30;
            mainGearToothCountTextLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            mainGearToothCountTextLData.left = new FormAttachment(0, 1000, 400);
            mainGearToothCountTextLData.top = new FormAttachment(0, 1000, 145);
            this.mainGearToothCountText.setLayoutData((Object)mainGearToothCountTextLData);
            this.mainGearToothCountText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "mainGearToothCountText.keyPressed, event=" + String.valueOf(evt));
                    }
                    KosmikConfiguration.this.mainGearToothCountSlider.setSelection(Integer.valueOf(KosmikConfiguration.this.mainGearToothCountText.getText().trim()) + KosmikConfiguration.this.mainGearToothCountSlider.getMinimum());
                    KosmikConfiguration.this.setGearFactor();
                    KosmikConfiguration.this.dialog.enableSaveButton(true);
                }
            });
            this.mainGearToothCountText.addVerifyListener(new VerifyListener(this){

                public void verifyText(VerifyEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "mainGearToothCountText.verifyText, event=" + String.valueOf(evt));
                    }
                    evt.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)evt.text);
                }
            });
            this.mainGearToothCountSlider = new Slider((Composite)this, 2304);
            FormData mainGearToothCountSliderLData = new FormData();
            mainGearToothCountSliderLData.width = 100;
            mainGearToothCountSliderLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            mainGearToothCountSliderLData.left = new FormAttachment(0, 1000, 450);
            mainGearToothCountSliderLData.top = new FormAttachment(0, 1000, 145);
            this.mainGearToothCountSlider.setLayoutData((Object)mainGearToothCountSliderLData);
            this.mainGearToothCountSlider.setMaximum(300);
            this.mainGearToothCountSlider.setMinimum(30);
            this.mainGearToothCountSlider.setSelection(70);
            this.mainGearToothCountSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "mainGearToothCountSlider.widgetSelected, event=" + String.valueOf(evt));
                    }
                    KosmikConfiguration.this.mainGearToothCountText.setText("" + KosmikConfiguration.this.mainGearToothCountSlider.getSelection());
                    KosmikConfiguration.this.setGearFactor();
                    KosmikConfiguration.this.dialog.enableSaveButton(true);
                }
            });
            this.mainGearToothCountText.setText("" + this.mainGearToothCountSlider.getSelection());
            this.temperatureUnitLabel = new CLabel((Composite)this, 0);
            this.temperatureUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperatureUnitLabel.setText(Messages.getString((String)"GDE_MSGW2810"));
            FormData temperatureUnitLabelLData = new FormData();
            temperatureUnitLabelLData.width = 272;
            temperatureUnitLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            temperatureUnitLabelLData.left = new FormAttachment(0, 1000, 125);
            temperatureUnitLabelLData.top = new FormAttachment(0, 1000, 180);
            this.temperatureUnitLabel.setLayoutData((Object)temperatureUnitLabelLData);
            this.temperatureUnitCombo = new CCombo((Composite)this, 2048);
            this.temperatureUnitCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.temperatureUnitCombo.setItems(new String[]{"  Celsius", " Fahrenheit"});
            FormData temperatureUnitComboLData = new FormData();
            temperatureUnitComboLData.width = 100;
            temperatureUnitComboLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            temperatureUnitComboLData.left = new FormAttachment(0, 1000, 400);
            temperatureUnitComboLData.top = new FormAttachment(0, 1000, 180);
            this.temperatureUnitCombo.setLayoutData((Object)temperatureUnitComboLData);
            this.temperatureUnitCombo.select(0);
            this.temperatureUnitCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Channel activeChannel;
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "temperatureUnitCombo.widgetSelected, event=" + String.valueOf(evt));
                    }
                    if ((activeChannel = Channels.getInstance().getActiveChannel()) != null) {
                        double factor = 1.0;
                        double offset = 0.0;
                        int indexTempFET = KosmikConfiguration.this.isVersion32 ? 6 : 5;
                        int indexTempBEC = KosmikConfiguration.this.isVersion32 ? 10 : 9;
                        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                        if (activeRecordSet != null) {
                            if (KosmikConfiguration.this.temperatureUnitCombo.getSelectionIndex() == 1) {
                                factor = 1.8018;
                                offset = 32.0;
                                activeRecordSet.get(indexTempFET).setUnit("\u00b0F");
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempFET, "\u00b0F");
                                activeRecordSet.get(indexTempBEC).setUnit("\u00b0F");
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempBEC, "\u00b0F");
                            } else {
                                activeRecordSet.get(indexTempFET).setUnit("\u00b0C");
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempFET, "\u00b0C");
                                activeRecordSet.get(indexTempBEC).setUnit("\u00b0C");
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempBEC, "\u00b0C");
                            }
                            activeRecordSet.get(indexTempFET).setFactor(factor);
                            KosmikConfiguration.this.device.setMeasurementFactor(activeChannel.getNumber(), indexTempFET, factor);
                            activeRecordSet.get(indexTempFET).setOffset(offset);
                            KosmikConfiguration.this.device.setMeasurementOffset(activeChannel.getNumber(), indexTempFET, offset);
                            activeRecordSet.get(indexTempBEC).setFactor(factor);
                            KosmikConfiguration.this.device.setMeasurementFactor(activeChannel.getNumber(), indexTempBEC, factor);
                            activeRecordSet.get(indexTempBEC).setOffset(offset);
                            KosmikConfiguration.this.device.setMeasurementOffset(activeChannel.getNumber(), indexTempBEC, offset);
                            KosmikConfiguration.this.device.updateVisibilityStatus(activeRecordSet, false);
                            KosmikConfiguration.this.dialog.enableSaveButton(true);
                        } else {
                            if (KosmikConfiguration.this.temperatureUnitCombo.getSelectionIndex() == 1) {
                                factor = 1.8018;
                                offset = 32.0;
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempFET, "\u00b0F");
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempBEC, "\u00b0F");
                            } else {
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempFET, "\u00b0C");
                                KosmikConfiguration.this.device.setMeasurementUnit(activeChannel.getNumber(), indexTempBEC, "\u00b0C");
                            }
                            KosmikConfiguration.this.dialog.enableSaveButton(true);
                        }
                    }
                }
            });
            this.kosmikVersionLabel = new CLabel((Composite)this, 0);
            this.kosmikVersionLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.kosmikVersionLabel.setText("Kosmik Version:");
            FormData kosmikVersionLabelLData = new FormData();
            kosmikVersionLabelLData.width = 272;
            kosmikVersionLabelLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            kosmikVersionLabelLData.left = new FormAttachment(0, 1000, 125);
            kosmikVersionLabelLData.top = new FormAttachment(0, 1000, 225);
            this.kosmikVersionLabel.setLayoutData((Object)kosmikVersionLabelLData);
            this.kosmikVersionCombo = new CCombo((Composite)this, 2048);
            this.kosmikVersionCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.kosmikVersionCombo.setItems(new String[]{"  <= 3.1", "  >= 3.2"});
            FormData kosmikVersionComboLData = new FormData();
            kosmikVersionComboLData.width = 80;
            kosmikVersionComboLData.height = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
            kosmikVersionComboLData.left = new FormAttachment(0, 1000, 400);
            kosmikVersionComboLData.top = new FormAttachment(0, 1000, 225);
            this.kosmikVersionCombo.setLayoutData((Object)kosmikVersionComboLData);
            this.kosmikVersionCombo.select(this.channles.getActiveChannelNumber() - 1);
            this.kosmikVersionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "kosmikVersionCombo.widgetSelected, event=" + String.valueOf(evt));
                    }
                    KosmikConfiguration.this.channles.switchChannel(KosmikConfiguration.this.channles.getChannelNames()[KosmikConfiguration.this.kosmikVersionCombo.getSelectionIndex()]);
                }
            });
            this.isVersion32 = this.channles.getActiveChannelNumber() - 1 == 1;
            this.updateGUI();
            this.layout();
            this.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent evt) {
                    KosmikConfiguration.this.kosmikVersionCombo.select(KosmikConfiguration.this.channles.getActiveChannelNumber() - 1);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateMotorRotor(int selectionIndex) {
        this.motorPinionLabel.setEnabled(selectionIndex == 1);
        this.motorPinionText.setEnabled(selectionIndex == 1);
        this.motorPinionSlider.setEnabled(selectionIndex == 1);
        this.mainGearToothCountLabel.setEnabled(selectionIndex == 1);
        this.mainGearToothCountText.setEnabled(selectionIndex == 1);
        this.mainGearToothCountSlider.setEnabled(selectionIndex == 1);
    }

    protected void updateGUI() {
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null) {
            if (this.device.getMeasurementFactor(activeChannel.getNumber(), 0) > 0.1) {
                this.motorRotorRpmCombo.select(0);
                this.numMotorPolsCombo.select((int)(2.0 / (this.device.getMeasurementFactor(activeChannel.getNumber(), 0) * 2.0) - 1.0));
                this.motorPinionText.setText("10");
                this.motorPinionSlider.setSelection(10);
                double factor = 2.0 / (double)((this.numMotorPolsCombo.getSelectionIndex() + 1) * 2);
                int selectIndex = (int)(2.0 / factor * 2.0);
                this.mainGearToothCountText.setText("" + selectIndex * 10);
                this.mainGearToothCountSlider.setSelection(selectIndex);
            } else {
                Integer main;
                Integer pinion;
                int numMotorPoles;
                this.motorRotorRpmCombo.select(1);
                try {
                    numMotorPoles = Integer.valueOf(this.device.getChannelProperty(ChannelPropertyTypes.NUMBER_POLES).getValue());
                }
                catch (NumberFormatException e) {
                    numMotorPoles = 2;
                }
                this.numMotorPolsCombo.select(numMotorPoles / 2 - 1);
                try {
                    pinion = Integer.valueOf(this.device.getChannelProperty(ChannelPropertyTypes.PINION_GEAR).getValue());
                }
                catch (NumberFormatException e) {
                    pinion = 10;
                }
                this.motorPinionText.setText("" + pinion);
                this.motorPinionSlider.setSelection(pinion - this.motorPinionSlider.getMinimum());
                try {
                    main = Integer.valueOf(this.device.getChannelProperty(ChannelPropertyTypes.MAIN_GEAR).getValue());
                }
                catch (NumberFormatException e) {
                    main = 40;
                }
                this.mainGearToothCountText.setText("" + main);
                this.mainGearToothCountSlider.setSelection(main - this.mainGearToothCountSlider.getMinimum());
            }
            this.updateMotorRotor(this.motorRotorRpmCombo.getSelectionIndex());
            this.temperatureUnitCombo.select(this.device.getMeasurementUnit(activeChannel.getNumber(), this.isVersion32 ? 6 : 5).contains("C") ? 0 : 1);
        }
        this.kosmikVersionCombo.select(this.channles.getActiveChannelNumber() - 1);
    }

    private void setGearFactor() {
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null) {
            double factor = 2.0 / (double)((this.numMotorPolsCombo.getSelectionIndex() + 1) * 2);
            this.device.setChannelProperty(ChannelPropertyTypes.MAIN_GEAR, DataTypes.INTEGER, this.mainGearToothCountText.getText().trim());
            this.device.setChannelProperty(ChannelPropertyTypes.PINION_GEAR, DataTypes.INTEGER, this.motorPinionText.getText().trim());
            double gearFactor = 1.0 * (double)Integer.valueOf(this.mainGearToothCountText.getText().trim()).intValue() / (double)Integer.valueOf(this.motorPinionText.getText().trim()).intValue();
            factor /= gearFactor;
            RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
            if (activeRecordSet != null) {
                activeRecordSet.get(0).setFactor(factor);
                this.device.setMeasurementFactor(activeChannel.getNumber(), 0, factor);
                this.device.updateVisibilityStatus(activeRecordSet, false);
            }
            this.device.setMeasurementFactor(activeChannel.getNumber(), 0, factor);
        }
    }

    private void setPoleFactor() {
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null) {
            RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
            double factor = 2.0 / (double)((this.numMotorPolsCombo.getSelectionIndex() + 1) * 2);
            if (activeRecordSet != null) {
                activeRecordSet.get(0).setFactor(factor);
                this.device.setMeasurementFactor(activeChannel.getNumber(), 0, factor);
                this.device.updateVisibilityStatus(activeRecordSet, false);
            }
            this.device.setMeasurementFactor(activeChannel.getNumber(), 0, factor);
        }
    }
}

