/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.innercache;

import com.sun.istack.Nullable;
import gde.histo.innercache.AbstractCache;
import gde.histo.innercache.Cache;
import gde.histo.innercache.CacheBuilder;
import gde.histo.innercache.CacheLoader;
import gde.histo.innercache.CacheStats;
import gde.histo.innercache.ExecutionError;
import gde.histo.innercache.RemovalCause;
import gde.histo.innercache.RemovalListener;
import gde.histo.innercache.RemovalNotification;
import gde.histo.innercache.UncheckedExecutionException;
import gde.histo.innercache.Weigher;
import gde.histo.utils.Preconditions;
import gde.histo.utils.Stopwatch;
import gde.log.Level;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;

class SynchronousCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MINIMUM_CAPACITY = 16;
    static final int MAX_SEGMENTS = 65536;
    static final int CONTAINS_VALUE_RETRIES = 1;
    static final int DRAIN_THRESHOLD = 63;
    static final Logger logger = Logger.getLogger(SynchronousCache.class.getName());
    final Segment<K, V> segments;
    final int concurrencyLevel;
    final Strength keyStrength;
    final Strength valueStrength;
    final long maxWeight;
    final Weigher<K, V> weigher;
    final Queue<RemovalNotification<K, V>> removalNotificationQueue;
    final RemovalListener<K, V> removalListener;
    final Stopwatch.Ticker ticker;
    final EntryFactory entryFactory;
    final AbstractCache.StatsCounter globalStatsCounter;
    @Nullable
    final CacheLoader<? super K, V> defaultLoader;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public int getWeight() {
            return 0;
        }

        @Override
        public ReferenceEntry<Object, Object> getEntry() {
            return null;
        }

        @Override
        @Deprecated
        public ValueReference<Object, Object> copyFor(ReferenceQueue<Object> queue, @Nullable Object value, ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        @Deprecated
        public boolean isLoading() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isActive() {
            return false;
        }

        @Override
        @Deprecated
        public Object waitForValue() {
            return null;
        }

        @Override
        @Deprecated
        public void notifyNewValue(Object newValue) {
        }
    };
    static final Queue<? extends Object> DISCARDING_QUEUE = new AbstractQueue<Object>(){

        @Override
        public boolean offer(Object o) {
            return true;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }
    };
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;

    SynchronousCache(CacheBuilder<? super K, ? super V> builder, @Nullable CacheLoader<? super K, V> loader) {
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        this.keyStrength = Strength.STRONG;
        this.valueStrength = Strength.STRONG;
        this.maxWeight = builder.getMaximumWeight();
        this.weigher = builder.getWeigher();
        this.removalListener = builder.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == CacheBuilder.NullListener.INSTANCE ? SynchronousCache.discardingQueue() : new ConcurrentLinkedQueue();
        this.ticker = builder.getTicker(this.recordsTime());
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.usesAccessEntries(), this.usesWriteEntries());
        this.globalStatsCounter = builder.getStatsCounterSupplier().get();
        this.defaultLoader = loader;
        int initialCapacity = Math.min(builder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize() && !this.customWeigher()) {
            initialCapacity = Math.min(initialCapacity, (int)this.maxWeight);
        }
        this.segments = this.createSegment(16, this.maxWeight, builder.getStatsCounterSupplier().get());
    }

    boolean evictsBySize() {
        return this.maxWeight >= 0L;
    }

    boolean customWeigher() {
        return this.weigher != CacheBuilder.OneWeigher.INSTANCE;
    }

    boolean usesAccessQueue() {
        return this.evictsBySize();
    }

    boolean recordsTime() {
        return false;
    }

    boolean usesWriteEntries() {
        return false;
    }

    boolean usesAccessEntries() {
        return this.usesAccessQueue();
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    ReferenceEntry<K, V> newEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
        return this.segments.newEntry(key);
    }

    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
        return this.segments.copyEntry(original, newNext);
    }

    Segment<K, V> createSegment(@Deprecated int initialCapacity, long maxSegmentWeight, AbstractCache.StatsCounter statsCounter) {
        return new Segment(this, initialCapacity, maxSegmentWeight, statsCounter);
    }

    @Nullable
    V getLiveValue(ReferenceEntry<K, V> entry, long now) {
        if (entry.getKey() == null) {
            return null;
        }
        V value = entry.getValueReference().get();
        if (value == null) {
            return null;
        }
        return value;
    }

    static <K, V> void connectAccessOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextInAccessQueue(next);
        next.setPreviousInAccessQueue(previous);
    }

    static <K, V> void nullifyAccessOrder(ReferenceEntry<K, V> nulled) {
        ReferenceEntry<K, V> nullEntry = SynchronousCache.nullEntry();
        nulled.setNextInAccessQueue(nullEntry);
        nulled.setPreviousInAccessQueue(nullEntry);
    }

    static <K, V> void connectWriteOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextInWriteQueue(next);
        next.setPreviousInWriteQueue(previous);
    }

    static <K, V> void nullifyWriteOrder(ReferenceEntry<K, V> nulled) {
        ReferenceEntry<K, V> nullEntry = SynchronousCache.nullEntry();
        nulled.setNextInWriteQueue(nullEntry);
        nulled.setPreviousInWriteQueue(nullEntry);
    }

    void processPendingNotifications() {
        RemovalNotification<K, V> notification;
        while ((notification = this.removalNotificationQueue.poll()) != null) {
            try {
                this.removalListener.onRemoval(notification);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", e);
            }
        }
    }

    final Segment<K, V>[] newSegmentArray(int ssize) {
        return new Segment[ssize];
    }

    public void cleanUp() {
        this.segments.cleanUp();
    }

    @Override
    public boolean isEmpty() {
        return this.segments.count() == 0;
    }

    @Override
    public int size() {
        return this.segments.count();
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        return this.segments.get(key);
    }

    @Nullable
    public V getIfPresent(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        V value = this.segments.get(key);
        if (value == null) {
            this.globalStatsCounter.recordMisses(1);
        } else {
            this.globalStatsCounter.recordHits(1);
        }
        return value;
    }

    @Override
    @Nullable
    public V getOrDefault(@Nullable Object key, @Nullable V defaultValue) {
        V result = this.get(key);
        return result != null ? result : defaultValue;
    }

    V get(K key, CacheLoader<? super K, V> loader) throws ExecutionException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.segments.get((K)key, loader);
    }

    Map<K, V> getAllPresent(Iterable<?> keys) {
        int hits = 0;
        int misses = 0;
        LinkedHashMap result = new LinkedHashMap();
        for (Object key : keys) {
            V value = this.get(key);
            if (value == null) {
                ++misses;
                continue;
            }
            Object castKey = key;
            result.put(castKey, value);
            ++hits;
        }
        this.globalStatsCounter.recordHits(hits);
        this.globalStatsCounter.recordMisses(misses);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        int hits = 0;
        int misses = 0;
        LinkedHashMap<Object, V> result = new LinkedHashMap<Object, V>();
        LinkedHashSet<K> keysToLoad = new LinkedHashSet<K>();
        for (K key : keys) {
            V value = this.get(key);
            if (result.containsKey(key)) continue;
            result.put(key, value);
            if (value == null) {
                ++misses;
                keysToLoad.add(key);
                continue;
            }
            ++hits;
        }
        try {
            if (!keysToLoad.isEmpty()) {
                try {
                    Map<K, V> newEntries = this.loadAll(keysToLoad, this.defaultLoader);
                    for (Object key : keysToLoad) {
                        V value = newEntries.get(key);
                        if (value == null) {
                            throw new CacheLoader.InvalidCacheLoadException("loadAll failed to return a value for " + String.valueOf(key));
                        }
                        result.put(key, value);
                    }
                }
                catch (CacheLoader.UnsupportedLoadingOperationException e) {
                    for (Object key : keysToLoad) {
                        --misses;
                        result.put(key, this.get(key, this.defaultLoader));
                    }
                }
            }
            LinkedHashMap<Object, V> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.globalStatsCounter.recordHits(hits);
            this.globalStatsCounter.recordMisses(misses);
        }
    }

    @Nullable
    Map<K, V> loadAll(Set<? extends K> keys, CacheLoader<? super K, V> loader) throws ExecutionException {
        Map<K, V> result;
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean success = false;
        try {
            Map<K, V> map;
            result = map = loader.loadAll(keys);
            success = true;
        }
        catch (CacheLoader.UnsupportedLoadingOperationException e) {
            success = true;
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExecutionException(e);
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
        finally {
            if (!success) {
                this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
        }
        if (result == null) {
            this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            throw new CacheLoader.InvalidCacheLoadException(String.valueOf(loader) + " returned null map from loadAll");
        }
        stopwatch.stop();
        boolean nullsPresent = false;
        for (Map.Entry<K, V> entry : result.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) {
                nullsPresent = true;
                continue;
            }
            this.put(key, value);
        }
        if (nullsPresent) {
            this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            throw new CacheLoader.InvalidCacheLoadException(String.valueOf(loader) + " returned null keys or values from loadAll");
        }
        this.globalStatsCounter.recordLoadSuccess(stopwatch.elapsed(TimeUnit.NANOSECONDS));
        return result;
    }

    ReferenceEntry<K, V> getEntry(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        return this.segments.getEntry(key);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        return this.segments.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.segments.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return this.segments.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return this.segments.put(key, value, true);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(K key, V newValue, BiFunction<? super V, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        return this.segments.remove(key);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        if (key == null || value == null) {
            return false;
        }
        return this.segments.remove(key, value);
    }

    @Override
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (oldValue == null) {
            return false;
        }
        return this.segments.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V newValue) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return this.segments.replace(key, newValue);
    }

    @Override
    public void clear() {
        this.segments.clear();
    }

    void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            this.remove(key);
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this));
    }

    private static <E> ArrayList<E> toArrayList(Collection<E> c) {
        ArrayList<E> result = new ArrayList<E>(c.size());
        for (E e : c) {
            result.add(e);
        }
        return result;
    }

    boolean removeIf(BiPredicate<? super K, ? super V> filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        block0: for (K key : this.keySet()) {
            V value;
            while ((value = this.get(key)) != null && filter.test(key, value)) {
                if (!this.remove(key, value)) continue;
                changed = true;
                continue block0;
            }
        }
        return changed;
    }

    static enum Strength {
        STRONG{

            @Override
            <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                return weight == 1 ? new StrongValueReference(value) : new WeightedStrongValueReference(value, weight);
            }
        };


        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3, int var4);
    }

    static enum EntryFactory {
        STRONG{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key) {
                return new StrongEntry(key);
            }
        }
        ,
        STRONG_ACCESS{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key) {
                return new StrongAccessEntry(key);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                this.copyAccessEntry(original, newEntry);
                return newEntry;
            }
        };

        static final int ACCESS_MASK = 1;
        static final int WRITE_MASK = 2;
        static final int WEAK_MASK = 4;
        static final EntryFactory[] factories;

        static EntryFactory getFactory(Strength keyStrength, boolean usesAccessQueue, boolean usesWriteQueue) {
            int flags = 0 | (usesAccessQueue ? 1 : 0) | (usesWriteQueue ? 2 : 0);
            return factories[flags];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2);

        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            return this.newEntry(segment, original.getKey());
        }

        <K, V> void copyAccessEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            newEntry.setAccessTime(original.getAccessTime());
            SynchronousCache.connectAccessOrder(original.getPreviousInAccessQueue(), newEntry);
            SynchronousCache.connectAccessOrder(newEntry, original.getNextInAccessQueue());
            SynchronousCache.nullifyAccessOrder(original);
        }

        <K, V> void copyWriteEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            newEntry.setWriteTime(original.getWriteTime());
            SynchronousCache.connectWriteOrder(original.getPreviousInWriteQueue(), newEntry);
            SynchronousCache.connectWriteOrder(newEntry, original.getNextInWriteQueue());
            SynchronousCache.nullifyWriteOrder(original);
        }

        static {
            factories = new EntryFactory[]{STRONG, STRONG_ACCESS};
        }
    }

    static class Segment<K, V> {
        final SynchronousCache<K, V> map;
        long totalWeight;
        int modCount;
        int threshold;
        LinkedHashMap<K, ReferenceEntry<K, V>> table;
        final long maxSegmentWeight;
        final Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount = new AtomicInteger();
        final Queue<ReferenceEntry<K, V>> accessQueue;
        final AbstractCache.StatsCounter statsCounter;

        int count() {
            return this.table.size();
        }

        Segment(SynchronousCache<K, V> map, @Deprecated int initialCapacity, long maxSegmentWeight, AbstractCache.StatsCounter statsCounter) {
            if (statsCounter == null) {
                throw new IllegalArgumentException();
            }
            this.map = map;
            this.maxSegmentWeight = maxSegmentWeight;
            this.statsCounter = Objects.requireNonNull(statsCounter);
            this.initTable(this.newEntryContainer(initialCapacity));
            this.recencyQueue = map.usesAccessQueue() ? new ConcurrentLinkedQueue() : SynchronousCache.discardingQueue();
            this.accessQueue = map.usesAccessQueue() ? new AccessQueue() : SynchronousCache.discardingQueue();
        }

        private LinkedHashMap<K, ReferenceEntry<K, V>> newEntryContainer(@Deprecated int size) {
            return new LinkedHashMap(16, 0.75f, true);
        }

        private void initTable(LinkedHashMap<K, ReferenceEntry<K, V>> newTable) {
            this.table = newTable;
        }

        ReferenceEntry<K, V> newEntry(K key) {
            return this.map.entryFactory.newEntry(this, Objects.requireNonNull(key));
        }

        ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            if (original.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = original.getValueReference();
            V value = valueReference.get();
            if (value == null && valueReference.isActive()) {
                return null;
            }
            ReferenceEntry<K, V> newEntry = this.map.entryFactory.copyEntry(this, original, newNext);
            newEntry.setValueReference(valueReference);
            return newEntry;
        }

        private void setValue(ReferenceEntry<K, V> entry, K key, V value, long now) {
            ValueReference<K, V> previous = entry.getValueReference();
            int weight = this.map.weigher.weigh(key, value);
            Preconditions.checkState(weight >= 0, "Weights must be non-negative");
            ValueReference<K, V> valueReference = this.map.valueStrength.referenceValue(this, entry, value, weight);
            entry.setValueReference(valueReference);
            this.recordWrite(entry, weight, now);
            previous.notifyNewValue(value);
        }

        V get(K key, CacheLoader<? super K, V> loader) throws ExecutionException {
            Objects.requireNonNull(key);
            Objects.requireNonNull(loader);
            try {
                V value;
                ReferenceEntry<K, V> e = this.table.get(key);
                long now = this.map.ticker.read();
                if (e != null && (value = e.getValueReference().get()) != null) {
                    this.recordRead(e, now);
                    this.statsCounter.recordHits(1);
                    V v = value;
                    return v;
                }
                V v = this.getOrLoad(key, loader);
                return v;
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause instanceof Error) {
                    throw new ExecutionError((Error)cause);
                }
                if (cause instanceof RuntimeException) {
                    throw new UncheckedExecutionException(cause);
                }
                throw ee;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private V getOrLoad(K key, CacheLoader<? super K, V> loader) throws ExecutionException {
            ReferenceEntry e;
            ValueReference<K, V> valueReference = null;
            AccessValueReference accessValueReference = null;
            boolean createNewEntry = true;
            try {
                V value;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                e = this.table.get(key);
                if (e != null && (value = (valueReference = e.getValueReference()).get()) != null) {
                    this.recordRead(e, now);
                    this.statsCounter.recordHits(1);
                    V v = value;
                    return v;
                }
                if (createNewEntry) {
                    accessValueReference = new AccessValueReference();
                    if (e == null) {
                        e = this.newEntry(key);
                        e.setValueReference(accessValueReference);
                        this.table.put(key, e);
                    } else {
                        e.setValueReference(accessValueReference);
                    }
                }
            }
            finally {
                this.postWriteCleanup();
            }
            if (createNewEntry) {
                try {
                    ReferenceEntry referenceEntry = e;
                    synchronized (referenceEntry) {
                        Object v = this.loadSync(key, accessValueReference, loader);
                        return v;
                    }
                }
                finally {
                    this.statsCounter.recordMisses(1);
                }
            }
            throw new UnsupportedOperationException("ET2 null entry values do not exist due to synchronous loading");
        }

        private V loadSync(K key, AccessValueReference<K, V> accessValueReference, CacheLoader<? super K, V> loader) throws ExecutionException {
            CompletableFuture<V> loadingFuture = accessValueReference.loadSynced((K)key, loader);
            return this.getAndRecordStats(key, accessValueReference, loadingFuture);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private V getAndRecordStats(K key, AccessValueReference<K, V> accessValueReference, CompletableFuture<V> newValue) throws ExecutionException {
            V value = null;
            try {
                value = newValue.get();
                if (value == null) {
                    throw new CacheLoader.InvalidCacheLoadException("CacheLoader returned null for key " + String.valueOf(key) + ".");
                }
                this.statsCounter.recordLoadSuccess(accessValueReference.elapsedNanos());
                this.storeAccessedValue(key, accessValueReference, value);
                V v = value;
                return v;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                V v = null;
                return v;
            }
            finally {
                if (value == null) {
                    throw new UnsupportedOperationException("ET null entry values do not exist due to synchronous loading");
                }
            }
        }

        private void recordRead(ReferenceEntry<K, V> entry, long now) {
            this.recencyQueue.add(entry);
        }

        private void recordWrite(ReferenceEntry<K, V> entry, int weight, long now) {
            this.totalWeight += (long)weight;
            this.accessQueue.add(entry);
        }

        private void drainRecencyQueue() {
            ReferenceEntry<K, V> e;
            while ((e = this.recencyQueue.poll()) != null) {
                if (!this.accessQueue.contains(e)) continue;
                this.accessQueue.add(e);
            }
        }

        private void enqueueNotification(@Nullable K key, @Nullable V value, int weight, RemovalCause cause) {
            this.totalWeight -= (long)weight;
            if (cause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                RemovalNotification<K, V> notification = RemovalNotification.create(key, value, cause);
                this.map.removalNotificationQueue.offer(notification);
            }
        }

        private void evictEntries(ReferenceEntry<K, V> newest) {
            if (!this.map.evictsBySize()) {
                return;
            }
            this.drainRecencyQueue();
            if ((long)newest.getValueReference().getWeight() > this.maxSegmentWeight && !this.removeEntry(newest, RemovalCause.SIZE)) {
                throw new AssertionError();
            }
            while (this.totalWeight > this.maxSegmentWeight) {
                ReferenceEntry<K, V> e = this.getNextEvictable();
                if (!this.removeEntry(e, RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
            }
        }

        private ReferenceEntry<K, V> getNextEvictable() {
            for (ReferenceEntry referenceEntry : this.accessQueue) {
                int weight = referenceEntry.getValueReference().getWeight();
                if (weight <= 0) continue;
                return referenceEntry;
            }
            throw new AssertionError();
        }

        @Nullable
        ReferenceEntry<K, V> getEntry(Object key) {
            return this.table.get(key);
        }

        @Nullable
        private ReferenceEntry<K, V> getLiveEntry(Object key, long now) {
            ReferenceEntry<K, V> e = this.getEntry(key);
            if (e == null) {
                return null;
            }
            return e;
        }

        V getLiveValue(ReferenceEntry<K, V> entry, long now) {
            V value = entry.getValueReference().get();
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        V get(Object key) {
            try {
                V value;
                ReferenceEntry<K, V> e = this.table.get(key);
                long now = this.map.ticker.read();
                if (e != null && (value = e.getValueReference().get()) != null) {
                    this.recordRead(e, now);
                    V v = value;
                    return v;
                }
                V v = null;
                return v;
            }
            finally {
                this.postReadCleanup();
            }
        }

        boolean containsKey(Object key) {
            try {
                boolean bl = this.table.containsKey(key);
                return bl;
            }
            finally {
                this.postReadCleanup();
            }
        }

        boolean containsValue(Object value) {
            try {
                if (this.count() != 0) {
                    boolean bl = this.table.containsValue(value);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        V put(K key, V value, boolean onlyIfAbsent) {
            try {
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                ReferenceEntry<K, V> e = this.table.get(key);
                if (e != null) {
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (onlyIfAbsent) {
                        this.recordRead(e, now);
                        V v = entryValue;
                        return v;
                    }
                    ++this.modCount;
                    this.enqueueNotification(key, entryValue, valueReference.getWeight(), RemovalCause.REPLACED);
                    this.setValue(e, key, value, now);
                    this.evictEntries(e);
                    V v = entryValue;
                    return v;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key);
                this.setValue(newEntry, key, value, now);
                this.table.put(key, newEntry);
                this.evictEntries(newEntry);
                V v = null;
                return v;
            }
            finally {
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, V oldValue, V newValue) {
            try {
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                ReferenceEntry<K, V> e = this.table.get(key);
                if (e != null) {
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (oldValue.equals(entryValue)) {
                        ++this.modCount;
                        this.enqueueNotification(key, entryValue, valueReference.getWeight(), RemovalCause.REPLACED);
                        this.setValue(e, key, newValue, now);
                        this.evictEntries(e);
                        boolean bl = true;
                        return bl;
                    }
                    this.recordRead(e, now);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        V replace(K key, V newValue) {
            try {
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                ReferenceEntry<K, V> e = this.table.get(key);
                if (e != null) {
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    ++this.modCount;
                    this.enqueueNotification(key, entryValue, valueReference.getWeight(), RemovalCause.REPLACED);
                    this.setValue(e, key, newValue, now);
                    this.evictEntries(e);
                    V v = entryValue;
                    return v;
                }
                V v = null;
                return v;
            }
            finally {
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        V remove(Object key) {
            try {
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                ReferenceEntry<K, V> e = this.table.get(key);
                if (e != null) {
                    RemovalCause cause = RemovalCause.EXPLICIT;
                    V entryValue = e.getValueReference().get();
                    ++this.modCount;
                    this.removeEntry(e, cause);
                    V v = entryValue;
                    return v;
                }
                V v = null;
                return v;
            }
            finally {
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean storeAccessedValue(K key, AccessValueReference<K, V> oldValueReference, V newValue) {
            try {
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                ReferenceEntry<K, V> e = this.table.get(key);
                if (e != null) {
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (oldValueReference == valueReference || entryValue == null && valueReference != UNSET) {
                        ++this.modCount;
                        this.setValue(e, key, newValue, now);
                        this.evictEntries(e);
                        boolean bl = true;
                        return bl;
                    }
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key);
                this.setValue(newEntry, key, newValue, now);
                this.table.put(key, newEntry);
                this.evictEntries(newEntry);
                boolean bl = true;
                return bl;
            }
            finally {
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(Object key, Object value) {
            try {
                V entryValue;
                long now = this.map.ticker.read();
                this.preWriteCleanup(now);
                ReferenceEntry<K, V> e = this.table.get(key);
                if (e != null && value.equals(entryValue = e.getValueReference().get())) {
                    RemovalCause cause = RemovalCause.EXPLICIT;
                    ++this.modCount;
                    this.removeEntry(e, cause);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.postWriteCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (!this.table.isEmpty()) {
                try {
                    long now = this.map.ticker.read();
                    this.preWriteCleanup(now);
                    Iterator<Map.Entry<K, ReferenceEntry<K, V>>> iterator = this.table.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, ReferenceEntry<K, V>> entry = iterator.next();
                        ReferenceEntry<K, V> e = entry.getValue();
                        ValueReference<K, V> valueReference = e.getValueReference();
                        V value = valueReference.get();
                        iterator.remove();
                        this.enqueueNotification(entry.getKey(), value, valueReference.getWeight(), RemovalCause.EXPLICIT);
                    }
                    this.accessQueue.clear();
                    this.readCount.set(0);
                    ++this.modCount;
                }
                finally {
                    this.postWriteCleanup();
                }
            }
        }

        @Nullable
        private boolean removeEntry(ReferenceEntry<K, V> e, RemovalCause cause) {
            ValueReference<K, V> valueReference = e.getValueReference();
            V value = valueReference.get();
            this.enqueueNotification(e.getKey(), value, valueReference.getWeight(), cause);
            this.accessQueue.remove(e);
            return this.table.remove(e.getKey()) != null;
        }

        private void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.cleanUp();
            }
        }

        private void preWriteCleanup(long now) {
            this.runLockedCleanup(now);
        }

        private void postWriteCleanup() {
            this.runUnlockedCleanup();
        }

        void cleanUp() {
            long now = this.map.ticker.read();
            this.runLockedCleanup(now);
            this.runUnlockedCleanup();
        }

        private void runLockedCleanup(long now) {
            this.drainRecencyQueue();
            this.readCount.set(0);
        }

        private void runUnlockedCleanup() {
            this.map.processPendingNotifications();
        }
    }

    static interface ValueReference<K, V> {
        @Nullable
        public V get();

        @Deprecated
        public V waitForValue() throws ExecutionException;

        public int getWeight();

        @Nullable
        public ReferenceEntry<K, V> getEntry();

        @Deprecated
        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, @Nullable V var2, ReferenceEntry<K, V> var3);

        @Deprecated
        public void notifyNewValue(@Nullable V var1);

        @Deprecated
        public boolean isLoading();

        @Deprecated
        public boolean isActive();
    }

    private static enum NullEntry implements ReferenceEntry<Object, Object>
    {
        INSTANCE;


        @Override
        public ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public int getHash() {
            return 0;
        }

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public long getAccessTime() {
            return 0L;
        }

        @Override
        public void setAccessTime(long time) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextInAccessQueue() {
            return this;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousInAccessQueue() {
            return this;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public long getWriteTime() {
            return 0L;
        }

        @Override
        public void setWriteTime(long time) {
        }

        @Override
        public ReferenceEntry<Object, Object> getNextInWriteQueue() {
            return this;
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public ReferenceEntry<Object, Object> getPreviousInWriteQueue() {
            return this;
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<Object, Object> previous) {
        }
    }

    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        @Nullable
        public ReferenceEntry<K, V> getNext();

        public int getHash();

        @Nullable
        public K getKey();

        public long getAccessTime();

        public void setAccessTime(long var1);

        public ReferenceEntry<K, V> getNextInAccessQueue();

        public void setNextInAccessQueue(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousInAccessQueue();

        public void setPreviousInAccessQueue(ReferenceEntry<K, V> var1);

        public long getWriteTime();

        public void setWriteTime(long var1);

        public ReferenceEntry<K, V> getNextInWriteQueue();

        public void setNextInWriteQueue(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousInWriteQueue();

        public void setPreviousInWriteQueue(ReferenceEntry<K, V> var1);
    }

    final class KeySet
    extends AbstractCacheSet<K> {
        KeySet(Map<?, ?> map) {
            super(SynchronousCache.this, map);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(SynchronousCache.this);
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private final ConcurrentMap<?, ?> map;

        Values(ConcurrentMap<?, ?> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(SynchronousCache.this);
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            if (filter == null) {
                throw new IllegalArgumentException();
            }
            return SynchronousCache.this.removeIf((? super K k, ? super V v) -> filter.test((Object)v));
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public Object[] toArray() {
            return SynchronousCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return SynchronousCache.toArrayList(this).toArray(a);
        }
    }

    final class EntrySet
    extends AbstractCacheSet<Map.Entry<K, V>> {
        EntrySet(Map<?, ?> map) {
            super(SynchronousCache.this, map);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(SynchronousCache.this);
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            if (filter == null) {
                throw new IllegalArgumentException();
            }
            return SynchronousCache.this.removeIf((? super K k, ? super V v) -> filter.test(new AbstractMap.SimpleEntry<Object, Object>(k, v)));
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = SynchronousCache.this.get(key);
            return v != null;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && SynchronousCache.this.remove(key, e.getValue());
        }
    }

    static class SynchronousManualCache<K, V>
    implements Cache<K, V>,
    Serializable {
        final SynchronousCache<K, V> localCache;

        SynchronousManualCache(CacheBuilder<? super K, ? super V> builder) {
            this(new SynchronousCache<K, V>(builder, null));
        }

        private SynchronousManualCache(SynchronousCache<K, V> localCache) {
            this.localCache = localCache;
        }

        @Override
        @Nullable
        public V getIfPresent(Object key) {
            return this.localCache.getIfPresent(key);
        }

        @Override
        public V get(K key, final Callable<? extends V> valueLoader) throws ExecutionException {
            if (valueLoader == null) {
                throw new IllegalArgumentException();
            }
            return this.localCache.get(key, new CacheLoader<Object, V>(this){

                @Override
                public V load(Object key) throws Exception {
                    return valueLoader.call();
                }
            });
        }

        @Override
        public Map<K, V> getAllPresent(Iterable<?> keys) {
            return this.localCache.getAllPresent(keys);
        }

        @Override
        public void put(K key, V value) {
            this.localCache.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.localCache.putAll(m);
        }

        @Override
        public void invalidate(Object key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.localCache.remove(key);
        }

        @Override
        public void invalidateAll(Iterable<?> keys) {
            this.localCache.invalidateAll(keys);
        }

        @Override
        public void invalidateAll() {
            this.localCache.clear();
        }

        @Override
        public long size() {
            return this.localCache.size();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            return this.localCache;
        }

        @Override
        public CacheStats stats() {
            AbstractCache.SimpleStatsCounter aggregator = new AbstractCache.SimpleStatsCounter();
            aggregator.incrementBy(this.localCache.globalStatsCounter);
            aggregator.incrementBy(this.localCache.segments.statsCounter);
            return aggregator.snapshot();
        }

        @Override
        public void cleanUp() {
            this.localCache.cleanUp();
        }
    }

    abstract class AbstractCacheSet<T>
    extends AbstractSet<T> {
        final Map<?, ?> map;

        AbstractCacheSet(SynchronousCache this$0, Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Object[] toArray() {
            return SynchronousCache.toArrayList(this).toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return SynchronousCache.toArrayList(this).toArray(a);
        }
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        EntryIterator(SynchronousCache this$0) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V newValue) {
            Object oldValue = SynchronousCache.this.put(this.key, newValue);
            this.value = newValue;
            return oldValue;
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }

    final class ValueIterator
    extends HashIterator<V> {
        ValueIterator(SynchronousCache this$0) {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator<K> {
        KeyIterator(SynchronousCache this$0) {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        Segment<K, V> currentSegment;
        LinkedHashMap<K, ReferenceEntry<K, V>> currentTable;
        Iterator<Map.Entry<K, ReferenceEntry<K, V>>> iterator;

        HashIterator() {
            this.currentSegment = SynchronousCache.this.segments;
            this.currentTable = this.currentSegment.table;
            this.iterator = this.currentTable.entrySet().iterator();
        }

        @Override
        public abstract T next();

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        WriteThroughEntry nextEntry() {
            Map.Entry next = this.iterator.next();
            this.currentSegment.postReadCleanup();
            return new WriteThroughEntry(next.getKey(), next.getValue().getValueReference().get());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    static abstract class AbstractSequentialIterator<T>
    implements Iterator<T> {
        private T nextOrNull;

        protected AbstractSequentialIterator(@Nullable T firstOrNull) {
            this.nextOrNull = firstOrNull;
        }

        protected abstract T computeNext(T var1);

        @Override
        public final boolean hasNext() {
            return this.nextOrNull != null;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                T t = this.nextOrNull;
                return t;
            }
            finally {
                this.nextOrNull = this.computeNext(this.nextOrNull);
            }
        }
    }

    static final class AccessQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            ReferenceEntry<K, V> nextAccess = this;
            ReferenceEntry<K, V> previousAccess = this;

            @Override
            public long getAccessTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public void setAccessTime(long time) {
            }

            @Override
            public ReferenceEntry<K, V> getNextInAccessQueue() {
                return this.nextAccess;
            }

            @Override
            public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
                this.nextAccess = next;
            }

            @Override
            public ReferenceEntry<K, V> getPreviousInAccessQueue() {
                return this.previousAccess;
            }

            @Override
            public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
                this.previousAccess = previous;
            }
        };

        AccessQueue() {
        }

        @Override
        public boolean offer(ReferenceEntry<K, V> entry) {
            SynchronousCache.connectAccessOrder(entry.getPreviousInAccessQueue(), entry.getNextInAccessQueue());
            SynchronousCache.connectAccessOrder(this.head.getPreviousInAccessQueue(), entry);
            SynchronousCache.connectAccessOrder(entry, this.head);
            return true;
        }

        @Override
        public ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> next = this.head.getNextInAccessQueue();
            return next == this.head ? null : next;
        }

        @Override
        public ReferenceEntry<K, V> poll() {
            ReferenceEntry<K, V> next = this.head.getNextInAccessQueue();
            if (next == this.head) {
                return null;
            }
            this.remove(next);
            return next;
        }

        @Override
        public boolean remove(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousInAccessQueue();
            ReferenceEntry next = e.getNextInAccessQueue();
            SynchronousCache.connectAccessOrder(previous, next);
            SynchronousCache.nullifyAccessOrder(e);
            return next != NullEntry.INSTANCE;
        }

        @Override
        public boolean contains(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            return e.getNextInAccessQueue() != NullEntry.INSTANCE;
        }

        @Override
        public boolean isEmpty() {
            return this.head.getNextInAccessQueue() == this.head;
        }

        @Override
        public int size() {
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextInAccessQueue(); e != this.head; e = e.getNextInAccessQueue()) {
                ++size;
            }
            return size;
        }

        @Override
        public void clear() {
            ReferenceEntry<K, V> e = this.head.getNextInAccessQueue();
            while (e != this.head) {
                ReferenceEntry<K, V> next = e.getNextInAccessQueue();
                SynchronousCache.nullifyAccessOrder(e);
                e = next;
            }
            this.head.setNextInAccessQueue(this.head);
            this.head.setPreviousInAccessQueue(this.head);
        }

        @Override
        public Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>((ReferenceEntry)this.peek()){

                @Override
                protected ReferenceEntry<K, V> computeNext(ReferenceEntry<K, V> previous) {
                    ReferenceEntry next = previous.getNextInAccessQueue();
                    return next == head ? null : next;
                }
            };
        }
    }

    static class AccessValueReference<K, V>
    implements ValueReference<K, V> {
        volatile ValueReference<K, V> oldValue;
        final CompletableFuture<V> futureValue = new CompletableFuture();
        final Stopwatch stopwatch = Stopwatch.createUnstarted();

        public AccessValueReference() {
            this(null);
        }

        public AccessValueReference(ValueReference<K, V> oldValue) {
            this.oldValue = oldValue == null ? SynchronousCache.unset() : oldValue;
        }

        @Override
        @Deprecated
        public boolean isLoading() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isActive() {
            return false;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        public boolean set(@Nullable V newValue) {
            return this.futureValue.complete(newValue);
        }

        public boolean setException(Throwable t) {
            return this.futureValue.completeExceptionally(t);
        }

        @Override
        @Deprecated
        public void notifyNewValue(@Nullable V newValue) {
            if (newValue != null) {
                this.set(newValue);
            } else {
                this.oldValue = SynchronousCache.unset();
            }
        }

        public CompletableFuture<V> loadSynced(K key, CacheLoader<? super K, V> loader) {
            try {
                this.stopwatch.start();
                this.set(loader.load(key));
                return this.futureValue;
            }
            catch (Throwable t) {
                this.setException(t);
                return this.futureValue;
            }
        }

        @Deprecated
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> function) {
            V previousValue;
            this.stopwatch.start();
            try {
                previousValue = this.oldValue.waitForValue();
            }
            catch (ExecutionException e) {
                previousValue = null;
            }
            V newValue = function.apply(key, previousValue);
            this.set(newValue);
            return newValue;
        }

        public long elapsedNanos() {
            return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        }

        @Override
        @Deprecated
        public V waitForValue() throws ExecutionException {
            throw new UnsupportedOperationException("ET");
        }

        @Override
        public V get() {
            return this.oldValue.get();
        }

        public ValueReference<K, V> getOldValue() {
            return this.oldValue;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        @Deprecated
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, @Nullable V value, ReferenceEntry<K, V> entry) {
            return this;
        }
    }

    static final class WeightedStrongValueReference<K, V>
    extends StrongValueReference<K, V> {
        final int weight;

        WeightedStrongValueReference(V referent, int weight) {
            super(referent);
            this.weight = weight;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }

    static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V referent) {
            this.referent = referent;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        @Deprecated
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        @Deprecated
        public boolean isLoading() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isActive() {
            return true;
        }

        @Override
        @Deprecated
        public V waitForValue() {
            return this.get();
        }

        @Override
        @Deprecated
        public void notifyNewValue(V newValue) {
        }
    }

    static final class StrongAccessEntry<K, V>
    extends StrongEntry<K, V> {
        volatile long accessTime = Long.MAX_VALUE;
        ReferenceEntry<K, V> nextAccess = SynchronousCache.nullEntry();
        ReferenceEntry<K, V> previousAccess = SynchronousCache.nullEntry();

        StrongAccessEntry(K key) {
            super(key);
        }

        @Override
        public long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public void setAccessTime(long time) {
            this.accessTime = time;
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            this.nextAccess = next;
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            this.previousAccess = previous;
        }
    }

    static class StrongEntry<K, V>
    extends AbstractReferenceEntry<K, V> {
        final K key;
        volatile ValueReference<K, V> valueReference = SynchronousCache.unset();

        StrongEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }
    }
}

