/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.ui.SWTResourceManager;
import java.util.Random;
import org.eclipse.swt.graphics.Color;

public final class ColorUtils {
    public static String getDefaultRgb(int ordinal) {
        return switch (ordinal) {
            case 0 -> "0,0,255";
            case 1 -> "0,128,0";
            case 2 -> "128,0,0";
            case 3 -> "255,0,255";
            case 4 -> "64,0,64";
            case 5 -> "0,128,128";
            case 6 -> "128,128,0";
            case 7 -> "128,0,128";
            case 8 -> "0,128,255";
            case 9 -> "128,255,0";
            case 10 -> "255,0,128";
            case 11 -> "0,64,128";
            case 12 -> "64,128,0";
            case 13 -> "128,0,64";
            case 14 -> "128,64,0";
            case 15 -> "0,128,64";
            default -> {
                Random rand = new Random();
                yield ColorUtils.toRGB(rand.nextInt() & 0xFF, rand.nextInt() & 0xFF, rand.nextInt() & 0xFF);
            }
        };
    }

    public static String toRGB(int red, int green, int blue) {
        return red + "," + green + "," + blue;
    }

    public static int toRGB(String rgb) {
        int r = Integer.parseInt(rgb.split(",")[0]);
        int g = Integer.parseInt(rgb.split(",")[1]);
        int b = Integer.parseInt(rgb.split(",")[2]);
        return ColorUtils.toIntRGB(r, g, b);
    }

    public static String toRGB(int rgb) {
        return ColorUtils.toRGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static int toIntRGB(int red, int green, int blue) {
        return red << 16 + green << 8 + blue;
    }

    public static Color getColor(String rgb) {
        int r = Integer.parseInt(rgb.split(",")[0]);
        int g = Integer.parseInt(rgb.split(",")[1]);
        int b = Integer.parseInt(rgb.split(",")[2]);
        Color color = SWTResourceManager.getColor(r, g, b);
        return color;
    }
}

