/*
 * Decompiled with CFR 0.152.
 */
package gde.device.unitrend;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.unitrend.GathererThread;
import gde.device.unitrend.UniTrendDialog;
import gde.device.unitrend.UniTrendSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class UniTrend
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(UniTrend.class.getName());
    public static final String INPUT_TYPE = "input_type";
    public static final String INPUT_SYMBOL = "input_symbol";
    public static final String INPUT_UNIT = "input_unit";
    final DataExplorer application;
    final UniTrendSerialPort serialPort;
    final UniTrendDialog dialog;

    public UniTrend(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.unitrend.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new UniTrendSerialPort(this, this.application);
        this.dialog = new UniTrendDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public UniTrend(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.unitrend.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new UniTrendSerialPort(this, this.application);
        this.dialog = new UniTrendDialog(this.application.getShell(), this);
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW0022"));
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW0022"));
        return "";
    }

    public int getLovDataByteSize() {
        return 20;
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int lovDataSize = this.getLovDataByteSize();
        int deviceDataBufferSize = 8;
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        int[] points = new int[this.getNumberOfMeasurements(1)];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i <= 5; ++i) {
                sb.append(String.format("%02x", dataBuffer[i])).append(" ");
            }
            log.log(Level.FINE, sb.toString());
        }
        points[0] = Integer.valueOf(String.format("%c%c%c%c%c", dataBuffer[1], dataBuffer[2], dataBuffer[3], dataBuffer[4], dataBuffer[5]));
        block0 : switch (dataBuffer[6]) {
            default: {
                switch (dataBuffer[0]) {
                    case 48: {
                        points[0] = points[0] / 10;
                        break block0;
                    }
                    case 50: {
                        points[0] = points[0] * 10;
                        break block0;
                    }
                    case 51: {
                        points[0] = points[0] * 100;
                        break block0;
                    }
                    case 52: {
                        points[0] = points[0] * 10;
                        break block0;
                    }
                }
                break;
            }
            case 51: {
                switch (dataBuffer[0]) {
                    case 48: {
                        points[0] = points[0] * 10;
                        break;
                    }
                    case 50: {
                        break;
                    }
                    case 51: {
                        points[0] = points[0] * 10;
                        break;
                    }
                    case 52: {
                        points[0] = points[0] / 10;
                        break;
                    }
                    case 53: {
                        break;
                    }
                    case 54: {
                        points[0] = points[0] / 100000;
                        break;
                    }
                    case 49: {
                        points[0] = points[0] / 10;
                    }
                }
                break;
            }
            case 53: {
                break;
            }
            case 49: {
                points[0] = points[0] / 10;
                break;
            }
            case 54: {
                switch (dataBuffer[0]) {
                    case 49: 
                    case 52: 
                    case 55: {
                        points[0] = points[0] * 10;
                        break block0;
                    }
                    case 50: 
                    case 53: {
                        points[0] = points[0] / 10;
                        break block0;
                    }
                }
                break;
            }
            case 50: {
                break;
            }
            case 61: {
                switch (dataBuffer[0]) {
                    default: {
                        points[0] = points[0] * 10;
                        break block0;
                    }
                    case 49: 
                }
                points[0] = points[0] * 100;
                break;
            }
            case 63: {
                switch (dataBuffer[0]) {
                    default: {
                        points[0] = points[0] / 1;
                        break block0;
                    }
                    case 49: 
                }
                points[0] = points[0] * 10;
                break;
            }
            case 48: {
                switch (dataBuffer[0]) {
                    default: 
                }
                points[0] = points[0] / 1;
            }
        }
        if ((dataBuffer[7] & 4) > 0) {
            points[0] = points[0] * -1;
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 0;
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        }
        for (int i = 0; i < recordDataSize; ++i) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            }
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            dataTableRow[1] = recordSet.get(0).getDecimalFormat().format((double)recordSet.get(0).realGet(rowIndex).intValue() / 1000.0);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public boolean isBatteryLevelLow(byte[] buffer) {
        return (buffer[7] & 2) != 1;
    }

    public HashMap<String, String> getMeasurementInfo(byte[] buffer, HashMap<String, String> measurementInfo) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "buffer : " + StringHelper.byte2Hex4CharString((byte[])buffer, (int)buffer.length));
            log.log(Level.FINE, "Schalterstellung (Byte[6]): " + buffer[6]);
            log.log(Level.FINE, "Bereich          (Byte[0]): " + buffer[0]);
            log.log(Level.FINE, "Kopplung        (Byte[10]): " + buffer[10]);
        }
        String unit = "";
        block1 : switch (buffer[6]) {
            default: {
                switch (buffer[0]) {
                    case 52: {
                        unit = "mV";
                        break;
                    }
                    default: {
                        unit = "V";
                    }
                }
                switch (buffer[10]) {
                    case 57: {
                        unit = "%";
                        break block1;
                    }
                    case 59: {
                        unit = "Hz";
                        break block1;
                    }
                }
                break;
            }
            case 51: {
                switch (buffer[0]) {
                    case 49: 
                    case 50: 
                    case 51: {
                        unit = "k\u03a9";
                        break block1;
                    }
                    case 52: 
                    case 53: 
                    case 54: {
                        unit = "M\u03a9";
                        break block1;
                    }
                }
                unit = "\u03a9";
                break;
            }
            case 53: {
                unit = "\u03a9";
                break;
            }
            case 49: {
                unit = "V";
                break;
            }
            case 54: {
                switch (buffer[0]) {
                    default: {
                        unit = "nF";
                        break block1;
                    }
                    case 50: 
                    case 51: 
                    case 52: {
                        unit = "\u00b5F";
                        break block1;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                }
                unit = "mF";
                break;
            }
            case 50: {
                switch (buffer[0]) {
                    default: {
                        unit = "Hz";
                        break block1;
                    }
                    case 51: 
                    case 52: {
                        unit = "kHz";
                        break block1;
                    }
                    case 53: 
                    case 54: 
                    case 55: 
                }
                unit = "MHz";
                break;
            }
            case 61: {
                unit = "\u00b5A";
                break;
            }
            case 63: {
                unit = "mA";
                break;
            }
            case 48: {
                unit = "A";
            }
        }
        measurementInfo.put(INPUT_UNIT, unit);
        String typeSymbol = Messages.getString((String)"GDE_MSGT1500");
        if (unit.contains("V")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1501");
        } else if (unit.endsWith("A")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1503");
        } else if (unit.endsWith("\u03a9")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1504");
        } else if (unit.endsWith("F")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1505");
        } else if (unit.endsWith("Hz")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1506");
        } else if (unit.endsWith("\u00b0C")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1507");
        } else if (unit.endsWith("%")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1537");
        }
        try {
            measurementInfo.put(INPUT_TYPE, typeSymbol.split(" ")[0]);
            measurementInfo.put(INPUT_SYMBOL, typeSymbol.split(" ")[1]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return measurementInfo;
    }

    public String getMode(byte[] buffer) {
        Object mode = (buffer[10] & 2) > 0 ? Messages.getString((String)"GDE_MSGT1511") : Messages.getString((String)"GDE_MSGT1510");
        if ((buffer[10] & 8) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1512");
        } else if ((buffer[10] & 4) > 0) {
            mode = (String)mode + Messages.getString((String)"GDE_MSGT1513");
        }
        return mode;
    }

    public double translateValue(Record record, double value) {
        double newValue = value;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double newValue = value;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        recordSet.setAllVisibleAndDisplayable();
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        log.log(Level.FINE, "no update required for " + recordSet.getName());
    }

    public UniTrendDialog getDialog() {
        return this.dialog;
    }

    public UniTrendSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public void open_closeCommPort() {
        block12: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block12;
                        this.getDialog().dataGatherThread = new GathererThread(this.application, this, this.serialPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.serialPort.isConnected()) {
                                this.getDialog().dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                        if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                            this.getDialog().boundsComposite.redraw();
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                } else {
                    if (this.getDialog().dataGatherThread != null) {
                        this.getDialog().dataGatherThread.stopDataGatheringThread(false);
                    }
                    if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                        this.getDialog().boundsComposite.redraw();
                    }
                    this.serialPort.close();
                }
            }
        }
    }
}

