/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import javax.usb.UsbInterface;

public class ModsterUsbPort
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = ModsterUsbPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final short VENDOR_ID = 1155;
    protected static final short PRODUCT_ID = 22352;
    protected static final byte INTERFACE_ID = 1;
    protected static final byte IN_ENDPOINT = -127;
    protected static final byte OUT_ENDPOINT = 1;
    protected static final int TIMEOUT = 1000;
    protected final byte interfaceId;
    protected final byte endpointIn;
    protected final byte endpointOut;
    final int dataSize = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO);
    int retrys = 1;

    public ModsterUsbPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
        this.interfaceId = this.device.getUsbInterface();
        this.endpointIn = this.device.getUsbEndpointIn();
        this.endpointOut = this.device.getUsbEndpointOut();
        byte[] tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryOperationData.CHANNEL_A.value(), 0, tmpData, 0, QueryOperationData.CHANNEL_A.value().length);
        QueryOperationData.CHANNEL_A.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryChannelData.CHANNEL_A.value(), 0, tmpData, 0, QueryChannelData.CHANNEL_A.value().length);
        QueryChannelData.CHANNEL_A.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemInfo.CHANNEL_A.value(), 0, tmpData, 0, QuerySystemInfo.CHANNEL_A.value().length);
        QuerySystemInfo.CHANNEL_A.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemSetting.CHANNEL_A.value(), 0, tmpData, 0, QuerySystemSetting.CHANNEL_A.value().length);
        QuerySystemSetting.CHANNEL_A.setValue(tmpData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getSystemInfo(UsbInterface usbInterface, byte[] systemInfoCmd) throws Exception {
        String $METHOD_NAME = "getSystemInfo";
        byte[] data = new byte[Math.abs(this.dataSize)];
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            UsbInterface usbInterface2 = iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemInfo", StringHelper.byte2Hex2CharString((byte[])systemInfoCmd, (int)systemInfoCmd.length));
            }
            this.write(iface, this.endpointIn, systemInfoCmd);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemInfo", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (!this.isChecksumOK(data) && this.retrys-- <= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getSystemInfo", String.format("Error: Checksum = 0x%02X != 0x%02X", ModsterUsbPort.calculateCheckSum(data, data[1] - 1), data[data[1] + 2]));
                byte[] byArray = this.getSystemInfo(iface, systemInfoCmd);
                return byArray;
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getSystemInfo", e.getMessage(), e);
        }
        finally {
            if (isPortOpenedByCall) {
                this.closeUsbPort(iface);
            }
        }
        this.retrys = 1;
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getSystemSetting(UsbInterface usbInterface, byte[] systemSettingCmd) throws Exception {
        String $METHOD_NAME = "getSystemSetting";
        byte[] data = new byte[Math.abs(this.dataSize)];
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            UsbInterface usbInterface2 = iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemSetting", StringHelper.byte2Hex2CharString((byte[])systemSettingCmd, (int)systemSettingCmd.length));
            }
            this.write(iface, this.endpointIn, systemSettingCmd);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemSetting", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (!this.isChecksumOK(data) && this.retrys-- <= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getSystemSetting", String.format("Error: Checksum = 0x%02X != 0x%02X", ModsterUsbPort.calculateCheckSum(data, data[1] - 1), data[data[1] + 2]));
                byte[] byArray = this.getSystemInfo(iface, systemSettingCmd);
                return byArray;
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getSystemSetting", e.getMessage(), e);
        }
        finally {
            if (isPortOpenedByCall) {
                this.closeUsbPort(iface);
            }
        }
        this.retrys = 1;
        return data;
    }

    public synchronized byte[] getData(UsbInterface iface, byte[] request) throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.dataSize)];
        try {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])request, (int)request.length));
            }
            this.write(iface, this.endpointIn, request);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (!this.isChecksumOK(data) && this.retrys-- <= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getData", String.format("Error: Checksum = 0x%02X == 0x%02X", ModsterUsbPort.calculateCheckSum(data, data[1] - 1), data[data[1] + 2]));
                return this.getData(iface, request);
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getData", e.getMessage(), e);
        }
        this.retrys = 1;
        return data;
    }

    public static byte calculateCheckSum(byte[] buffer, int length) {
        return (byte)(Checksum.ADD((byte[])buffer, (int)2, (int)length) % 256);
    }

    private boolean isChecksumOK(byte[] buffer) {
        String $METHOD_NAME = "isChecksumOK";
        byte chkSum = ModsterUsbPort.calculateCheckSum(buffer, buffer[1]);
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "isChecksumOK", String.format("Checksum = 0x%02X == 0x%02X", chkSum, buffer[buffer[1] + 1]));
        }
        return chkSum == buffer[buffer[1] + 1];
    }

    public static enum QueryOperationData {
        CHANNEL_A(new byte[]{15, 3, 85, 0, 85, -1, -1});

        private byte[] value;

        private QueryOperationData(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum QueryChannelData {
        CHANNEL_A(new byte[]{15, 3, 95, 0, 95, -1, -1});

        private byte[] value;

        private QueryChannelData(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum QuerySystemInfo {
        CHANNEL_A(new byte[]{15, 5, 87, 0, 0, 0, 87, -1, -1});

        private byte[] value;

        private QuerySystemInfo(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum QuerySystemSetting {
        CHANNEL_A(new byte[]{15, 3, 90, 0, 90, -1, -1});

        private byte[] value;

        private QuerySystemSetting(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }
}

