/*
 * Decompiled with CFR 0.152.
 */
package gde.device.elprog;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.elprog.Pulsar3;
import gde.device.elprog.PulsarSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.logging.Logger;

public class PulsarGathererThread
extends Thread {
    static final String $CLASS_NAME = PulsarGathererThread.class.getName();
    static final Logger log = Logger.getLogger(PulsarGathererThread.class.getName());
    static final int TIME_STEP_DEFAULT = 1000;
    static final int WAIT_TIME_RETRYS = 3600;
    final DataExplorer application;
    final PulsarSerialPort serialPort;
    final Pulsar3 device;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    int retryCounter = 3600;
    boolean isCollectDataStopped = false;
    boolean isProgrammExecuting = false;
    boolean isPortOpenedByLiveGatherer = false;
    boolean isContinuousRecordSet = Settings.getInstance().isContinuousRecordSet();
    int lastNumberDisplayableRecords = 0;

    public PulsarGathererThread(DataExplorer currentApplication, Pulsar3 useDevice, PulsarSerialPort useSerialPort, int channelConfigNumber) throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
            try {
                this.serialPort.cleanInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet = null;
        int[] points = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        boolean isProgrammExecuting = false;
        long measurementCount = 0L;
        byte startByte = (byte)this.device.getDataBlockLeader().charAt(0);
        int startByteRi = 33;
        int maxBufferSize = this.device.getDataBlockSize(InputTypes.SERIAL_IO);
        byte[] tmpBuffer = null;
        byte[] dataBuffer = new byte[158];
        byte[] dataBufferRi = new byte[64];
        String processName = "";
        long lastCycleTime = 0L;
        this.isCollectDataStopped = false;
        log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        lastCycleTime = System.nanoTime() / 1000000L;
        while (!this.isCollectDataStopped) {
            try {
                block38: {
                    tmpBuffer = this.serialPort.getData();
                    log.log(Level.INFO, startByte + " " + new String(tmpBuffer));
                    if (tmpBuffer.length <= maxBufferSize) {
                        int index;
                        for (index = 0; tmpBuffer.length > 160 && index < tmpBuffer.length && tmpBuffer[index] != 33; ++index) {
                        }
                        if (index > 159 && tmpBuffer[index] == 33 && tmpBuffer.length - index == 66) {
                            System.arraycopy(tmpBuffer, index, dataBufferRi, 0, dataBufferRi.length);
                            log.log(Level.INFO, "33 " + new String(dataBufferRi));
                        }
                    }
                    System.arraycopy(tmpBuffer, 0, dataBuffer, 0, dataBuffer.length);
                    try {
                        block37: {
                            try {
                                processName = this.device.getProcessName(dataBuffer);
                                isProgrammExecuting = this.device.isProcessing(dataBuffer);
                                if (!log.isLoggable(Level.FINE)) break block37;
                                log.log(Level.FINE, String.format("isProgramExecuting = %s, processName = %s", isProgrammExecuting, processName));
                            }
                            catch (Exception e) {
                                log.log(Level.WARNING, String.format("Error in getProcessName evaluating '%s'", StringHelper.byte2CharString((byte[])dataBuffer, (int)dataBuffer.length)));
                                continue;
                            }
                        }
                        if (!log.isLoggable(Level.FINE)) break block38;
                        log.logp(Level.FINE, $CLASS_NAME, "run", "processing mode = " + processName);
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : dataBuffer) {
                            sb.append((char)b);
                        }
                        while (sb.length() > 5 && (sb.charAt(sb.length() - 1) == '\n' || sb.charAt(sb.length() - 1) == '\r')) {
                            sb.deleteCharAt(sb.length() - 1);
                        }
                        log.log(Level.WARNING, sb.toString());
                        log.log(Level.WARNING, e.getMessage(), e);
                        continue;
                    }
                }
                if (isProgrammExecuting) {
                    if (this.channel.size() == 0 || recordSet == null || processName.length() > 3 && !this.recordSetKey.endsWith(" " + processName)) {
                        this.application.setStatusMessage("");
                        this.setRetryCounter(3600);
                        this.recordSetKey = this.channel.getNextRecordSetNumber() + ") " + processName;
                        this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                        if (log.isLoggable(Level.FINE)) {
                            log.logp(Level.FINE, $CLASS_NAME, "run", this.recordSetKey + " created for channel " + this.channel.getName());
                        }
                        if (this.channel.getActiveRecordSet() == null) {
                            this.channel.setActiveRecordSet(this.recordSetKey);
                        }
                        recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
                        this.channel.applyTemplateBasics(this.recordSetKey);
                        if (this.channel.getName().equals(this.channels.getActiveChannel().getName())) {
                            this.channels.getActiveChannel().switchRecordSet(this.recordSetKey);
                        }
                        measurementCount = 0L;
                    }
                    if (measurementCount > 0L) {
                        if (dataBufferRi != null && dataBufferRi[0] == 33) {
                            points = this.device.convertDataBytes(points, dataBufferRi);
                        }
                        recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
                    }
                    ++measurementCount;
                    if (recordSet != null) {
                        RecordSet activeRecordSet;
                        if (measurementCount > 0L && measurementCount % 2L == 0L) {
                            this.device.updateVisibilityStatus(recordSet, true);
                            recordSet.syncScaleOfSyncableRecords();
                        }
                        if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null && recordSet.size() > 0 && recordSet.isChildOfActiveChannel() && recordSet.equals((Object)activeRecordSet)) {
                            this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != recordSet.getConfiguredDisplayable());
                            this.lastNumberDisplayableRecords = recordSet.getConfiguredDisplayable();
                        }
                    }
                    this.application.setStatusMessage("");
                } else {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3900"));
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, $CLASS_NAME, "run", "wait for device activation");
                    }
                    if (recordSet != null && recordSet.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(false);
                        isProgrammExecuting = false;
                        recordSet = null;
                        this.setRetryCounter(3600);
                        this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGT3907"));
                    } else if (0 == this.setRetryCounter(this.getRetryCounter() - 1)) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "iCharge activation timeout");
                        }
                        this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW3900"));
                        this.stopDataGatheringThread(false, null);
                    }
                }
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                this.cleanup(message);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException && isProgrammExecuting) {
                    this.application.setStatusMessage(">>>> serial port timeout <<<<");
                }
                if (e instanceof TimeOutException && !isProgrammExecuting) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3900"));
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, $CLASS_NAME, "run", "wait for device activation ...");
                    }
                    if (0 == this.setRetryCounter(this.getRetryCounter() - 1)) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "device activation timeout");
                        }
                        this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW3900"));
                        this.stopDataGatheringThread(false, null);
                    }
                }
                log.log(Level.SEVERE, e.getMessage(), e);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "program end detected");
                }
                this.stopDataGatheringThread(true, e);
            }
            long delay = (lastCycleTime += 5000L) - System.nanoTime() / 1000000L;
            if (delay > 0L) {
                WaitTimer.delay((long)delay);
            }
            if (!log.isLoggable(Level.INFO)) continue;
            log.log(Level.INFO, String.format("delay = %d", delay));
        }
        this.application.setStatusMessage("");
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
        }
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null && this.serialPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
        }
        if (this.serialPort != null && this.serialPort.isConnected() && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        log.log(Level.INFO, "stopDataGatheringThread - this.isCollectDataStopped=" + this.isCollectDataStopped);
        log.log(Level.INFO, "stopDataGatheringThread - this.serialPortisConnected=" + this.serialPort.isConnected());
        RecordSet recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
        log.log(Level.INFO, "stopDataGatheringThread - " + (recordSet != null && recordSet.getRecordDataSize(true) > 5));
        if (recordSet != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT3907"));
            }
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}) + Messages.getString((String)"GDE_MSGT3908"));
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026") + Messages.getString((String)"GDE_MSGT3908"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PulsarGathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        PulsarGathererThread.this.application.updateStatisticsData();
                        PulsarGathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        PulsarGathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

