/*
 * Decompiled with CFR 0.152.
 */
package gde.device.estner;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.estner.AkkumatikDialog;
import gde.device.estner.AkkumatikSerialPort;
import gde.device.estner.GathererThread;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.io.LogViewReader;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class Akkumatik
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(Akkumatik.class.getName());
    public static String[] PROCESS_MODE_LI = new String[8];
    public static String[] PROCESS_MODE_NI = new String[7];
    public static String[] PROCESS_MODE_PB = new String[7];
    public static String[] PROCESS_MODE;
    public static String[] ACCU_TYPES;
    public static String[] CHARGE_MODE;
    public static String[] CHARGE_MODE_LI;
    public static String[] CHARGE_MODE_NI;
    public static String[] CHARGE_MODE_PB;
    public static String[] PROCESS_MODE_CH2;
    protected final DataExplorer application;
    protected final AkkumatikDialog dialog;
    protected final AkkumatikSerialPort serialPort;
    protected final Channels channels;
    protected GathererThread dataGatherThread = null;
    protected final Settings settings = Settings.getInstance();

    public Akkumatik(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.estner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        PROCESS_MODE = new String[]{Messages.getString((String)"GDE_MSGT3400"), Messages.getString((String)"GDE_MSGT3401"), Messages.getString((String)"GDE_MSGT3402"), Messages.getString((String)"GDE_MSGT3403"), Messages.getString((String)"GDE_MSGT3404"), Messages.getString((String)"GDE_MSGT3405"), Messages.getString((String)"GDE_MSGT3406"), Messages.getString((String)"GDE_MSGT3407")};
        ACCU_TYPES = new String[]{Messages.getString((String)"GDE_MSGT3430"), Messages.getString((String)"GDE_MSGT3431"), Messages.getString((String)"GDE_MSGT3432"), Messages.getString((String)"GDE_MSGT3433"), Messages.getString((String)"GDE_MSGT3434"), Messages.getString((String)"GDE_MSGT3435"), Messages.getString((String)"GDE_MSGT3436"), Messages.getString((String)"GDE_MSGT3437")};
        CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT3410"), Messages.getString((String)"GDE_MSGT3411"), Messages.getString((String)"GDE_MSGT3412"), Messages.getString((String)"GDE_MSGT3413")};
        System.arraycopy(PROCESS_MODE, 0, PROCESS_MODE_LI, 0, PROCESS_MODE.length);
        System.arraycopy(PROCESS_MODE, 0, PROCESS_MODE_NI, 0, PROCESS_MODE.length - 1);
        System.arraycopy(PROCESS_MODE, 0, PROCESS_MODE_PB, 0, PROCESS_MODE.length - 1);
        PROCESS_MODE_CH2 = new String[]{PROCESS_MODE[0]};
        CHARGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3410"), Messages.getString((String)"GDE_MSGT3413")};
        CHARGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3410"), Messages.getString((String)"GDE_MSGT3411"), Messages.getString((String)"GDE_MSGT3412")};
        CHARGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3410")};
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.serialPort = new AkkumatikSerialPort(this, this.application);
        this.dialog = new AkkumatikDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public Akkumatik(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.estner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        PROCESS_MODE = new String[]{Messages.getString((String)"GDE_MSGT3400"), Messages.getString((String)"GDE_MSGT3401"), Messages.getString((String)"GDE_MSGT3402"), Messages.getString((String)"GDE_MSGT3403"), Messages.getString((String)"GDE_MSGT3404"), Messages.getString((String)"GDE_MSGT3405"), Messages.getString((String)"GDE_MSGT3406"), Messages.getString((String)"GDE_MSGT3407")};
        ACCU_TYPES = new String[]{Messages.getString((String)"GDE_MSGT3430"), Messages.getString((String)"GDE_MSGT3431"), Messages.getString((String)"GDE_MSGT3432"), Messages.getString((String)"GDE_MSGT3433"), Messages.getString((String)"GDE_MSGT3434"), Messages.getString((String)"GDE_MSGT3435"), Messages.getString((String)"GDE_MSGT3436"), Messages.getString((String)"GDE_MSGT3437")};
        CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT3410"), Messages.getString((String)"GDE_MSGT3411"), Messages.getString((String)"GDE_MSGT3412"), Messages.getString((String)"GDE_MSGT3413")};
        System.arraycopy(PROCESS_MODE, 0, PROCESS_MODE_LI, 0, PROCESS_MODE.length);
        System.arraycopy(PROCESS_MODE, 0, PROCESS_MODE_NI, 0, PROCESS_MODE.length - 1);
        System.arraycopy(PROCESS_MODE, 0, PROCESS_MODE_PB, 0, PROCESS_MODE.length - 1);
        PROCESS_MODE_CH2 = new String[]{PROCESS_MODE[0]};
        CHARGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3410"), Messages.getString((String)"GDE_MSGT3413")};
        CHARGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3410"), Messages.getString((String)"GDE_MSGT3411"), Messages.getString((String)"GDE_MSGT3412")};
        CHARGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3410")};
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.serialPort = new AkkumatikSerialPort(this, this.application);
        this.dialog = new AkkumatikDialog(this.application.getShell(), this);
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 81;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        long startCycleTime = 0L;
        long timeStep = 0L;
        long lastCycleTime = -1L;
        byte[] sizeBuffer = new byte[4];
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize - 1; ++i) {
            System.arraycopy(dataBuffer, offset, sizeBuffer, 0, sizeBuffer.length);
            lovDataSize = 4 + LogViewReader.parse2Int((byte[])sizeBuffer);
            System.arraycopy(dataBuffer, offset + 4, convertBuffer, 0, lovDataSize);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "  Read : " + StringHelper.byte2Hex2CharString((byte[])convertBuffer, (int)convertBuffer.length));
                log.log(Level.FINE, "0123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789");
                log.log(Level.FINE, new String(convertBuffer));
            }
            String[] data = new String(convertBuffer).split(new String(new byte[]{-1}));
            if (startCycleTime == 0L) {
                startCycleTime = this.getProcessingTime(data);
            }
            if (lastCycleTime < (timeStep = this.getProcessingTime(data) - startCycleTime)) {
                recordSet.addPoints(this.convertDataBytes(points, data), (double)timeStep);
                lastCycleTime = timeStep;
            }
            offset += lovDataSize;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    public int[] convertDataBytes(int[] points, String[] dataBuffer) {
        int numCells;
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        points[0] = Integer.valueOf(dataBuffer[2]);
        points[1] = Integer.valueOf(dataBuffer[3].replace("+", ""));
        points[2] = Integer.valueOf(dataBuffer[4].replace("+", "")) * 1000;
        points[3] = Double.valueOf((double)(points[0] * points[1]) / 1000.0).intValue();
        points[4] = Double.valueOf((double)points[0] / 1000.0 * (double)points[2] / 1000.0).intValue();
        points[5] = Integer.valueOf(dataBuffer[5]);
        points[6] = Integer.valueOf(dataBuffer[6]) * 1000;
        points[7] = Integer.valueOf(dataBuffer[7]) * 1000;
        points[8] = Integer.valueOf(dataBuffer[17]) * 1000;
        points[9] = 0;
        if (this.getAccuCellType(dataBuffer) > 3 && (numCells = this.getNumberOfLithiumCells(dataBuffer)) > 1 && dataBuffer.length >= 19 + numCells) {
            for (int i = 0; i < numCells; ++i) {
                points[i + 10] = Integer.valueOf(dataBuffer[i + 18]);
                if (points[i + 10] <= 0) continue;
                maxVotage = points[i + 10] > maxVotage ? points[i + 10] : maxVotage;
                minVotage = points[i + 10] < minVotage ? points[i + 10] : minVotage;
            }
            points[9] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 1000;
        }
        return points;
    }

    boolean isCycleMode(String[] dataBuffer) {
        return this.getProcessingMode(dataBuffer) >= 2 && this.getProcessingMode(dataBuffer) <= 5;
    }

    public int getNumberOfCycle(String[] dataBuffer) {
        return Integer.valueOf(dataBuffer[10]);
    }

    public int getNumberOfLithiumCells(String[] dataBuffer) {
        return Integer.valueOf(dataBuffer[8]);
    }

    public int getNumberStatus(String[] dataBuffer) {
        return Integer.valueOf(dataBuffer[8]);
    }

    public int getAccuCellType(String[] dataBuffer) {
        return Integer.valueOf(dataBuffer[12]);
    }

    public boolean isProcessing(String[] dataBuffer) {
        if (this.settings.isReduceChargeDischarge()) {
            return this.getProcessingPhase(dataBuffer) != 0 && this.getProcessingPhase(dataBuffer) != 10;
        }
        return this.getProcessingPhase(dataBuffer) != 0;
    }

    public int getProcessingMode(String[] dataBuffer) {
        return Integer.valueOf(dataBuffer[13]);
    }

    public int getProcessingPhase(String[] dataBuffer) {
        return Integer.valueOf(dataBuffer[9]);
    }

    public int getProcessingType(String[] dataBuffer) {
        return Integer.valueOf(dataBuffer[14]);
    }

    public long getProcessingTime(String[] dataBuffer) {
        String[] time = dataBuffer[1].split(":");
        return (Integer.valueOf(time[0]) * 3600 + Integer.valueOf(time[1]) * 60 + Integer.valueOf(time[2])) * 1000;
    }

    public long getProcessingTime(byte[] dataBuffer) {
        return (((dataBuffer[2] - 48) * 10 + (dataBuffer[3] - 48)) * 3600 + ((dataBuffer[5] - 48) * 10 + (dataBuffer[6] - 48)) * 60 + ((dataBuffer[8] - 48) * 10 + (dataBuffer[9] - 48))) * 1000;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 0;
        if (!recordSet.isTimeStepConstant()) {
            timeStampBufferSize = 4 * recordDataSize;
            byte[] timeStampBuffer = new byte[timeStampBufferSize];
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (int i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[1] / 1000.0) * 1000.0).intValue();
            points[4] = Double.valueOf((double)points[0] / 1000.0 * ((double)points[2] / 1000.0)).intValue();
            points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
            points[7] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
            points[8] = ((convertBuffer[24] & 0xFF) << 24) + ((convertBuffer[25] & 0xFF) << 16) + ((convertBuffer[26] & 0xFF) << 8) + ((convertBuffer[27] & 0xFF) << 0);
            points[9] = 0;
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            while (j < 12) {
                points[j + 10] = ((convertBuffer[k + 28] & 0xFF) << 24) + ((convertBuffer[k + 29] & 0xFF) << 16) + ((convertBuffer[k + 30] & 0xFF) << 8) + ((convertBuffer[k + 31] & 0xFF) << 0);
                if (points[j + 10] > 0) {
                    maxVotage = points[j + 10] > maxVotage ? points[j + 10] : maxVotage;
                    minVotage = points[j + 10] < minVotage ? points[j + 10] : minVotage;
                }
                ++j;
                k += 4;
            }
            points[9] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 1000;
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getOrdinal() > 8 && record.getUnit().equals("V") ? String.format("%.3f", (double)record.realGet(rowIndex).intValue() / 1000.0 * factor) : record.getDecimalFormat().format((double)record.realGet(rowIndex).intValue() / 1000.0 * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value * factor + offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double offset = record.getOffset();
        double factor = record.getFactor();
        double newValue = value / factor - offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        for (String recordKey : recordSet.getNoneCalculationRecordNames()) {
            recordSet.get((Object)recordKey).setActive(Boolean.valueOf(true));
        }
        for (i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " setDisplayable=" + record.hasReasonableData());
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                Record record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (String measurementKey : recordSet.keySet()) {
                    Record record = recordSet.get((Object)measurementKey);
                    if (!record.isActive() || record.getOrdinal() > 6 && !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                ++displayableCounter;
                log.log(Level.FINE, "displayableCounter = " + ++displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public AkkumatikSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public DeviceDialog getDialog() {
        return this.dialog;
    }

    public void open_closeCommPort() {
        block14: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block14;
                        this.dataGatherThread = new GathererThread(this.application, this, this.serialPort, activChannel.getNumber());
                        try {
                            if (this.serialPort.isConnected()) {
                                this.dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        try {
                            this.dataGatherThread.stopDataGatheringThread(false, null);
                            this.dataGatherThread = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.serialPort.close();
                }
            }
        }
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return null;
    }

    public int getCurrentSmoothIndex() {
        return 1;
    }

    public GathererThread getDataGathererThread() {
        return this.dataGatherThread;
    }
}

