/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.Analyzer;
import gde.data.Record;
import gde.device.PropertyType;
import gde.device.TrailDisplayType;
import gde.histo.cache.HistoVault;
import gde.histo.recordings.TrailSelector;
import java.util.List;
import java.util.Optional;

public interface IChannelItem {
    public String getChannelItemId();

    public String getName();

    public String getSymbol();

    public String getUnit();

    public boolean isActive();

    public String getLabel();

    public double getOffset();

    public double getReduction();

    public double getFactor();

    public boolean isBits();

    public boolean isTokens();

    public int getSyncMasterRecordOrdinal();

    public List<PropertyType> getProperty();

    public Optional<TrailDisplayType> getTrailDisplay();

    public PropertyType getProperty(String var1);

    public void setDataType(Record.DataType var1);

    public Record.DataType getDataType();

    default public Record.DataType getUnifiedDataType() {
        if (this.getDataType() == null || this.getDataType() == Record.DataType.DEFAULT) {
            Record.DataType guess = Record.DataType.guess(this.getName());
            if (guess != null) {
                return guess;
            }
            return Record.DataType.DEFAULT;
        }
        return this.getDataType();
    }

    public Integer getVaultPoint(HistoVault var1, int var2);

    public TrailSelector createTrailSelector(Analyzer var1, String var2, boolean var3);
}

