/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;

public class Bullet {
    public int type;
    public StyleRange style;
    public String text;
    int[] linesIndices;
    int count;

    public Bullet(StyleRange style) {
        this(1, style);
    }

    public Bullet(int type2, StyleRange style) {
        if (style == null) {
            SWT.error(4);
        }
        if (style.metrics == null) {
            SWT.error(4);
        }
        this.type = type2;
        this.style = style;
    }

    void addIndices(int startLine, int lineCount) {
        if (this.linesIndices == null) {
            this.linesIndices = new int[lineCount];
            this.count = lineCount;
            int i2 = 0;
            while (i2 < lineCount) {
                this.linesIndices[i2] = startLine + i2;
                ++i2;
            }
        } else {
            int modifyStart = 0;
            while (modifyStart < this.count) {
                if (startLine <= this.linesIndices[modifyStart]) break;
                ++modifyStart;
            }
            int modifyEnd = modifyStart;
            while (modifyEnd < this.count) {
                if (startLine + lineCount <= this.linesIndices[modifyEnd]) break;
                ++modifyEnd;
            }
            int newSize = modifyStart + lineCount + this.count - modifyEnd;
            if (newSize > this.linesIndices.length) {
                int[] newLinesIndices = new int[newSize];
                System.arraycopy(this.linesIndices, 0, newLinesIndices, 0, this.count);
                this.linesIndices = newLinesIndices;
            }
            System.arraycopy(this.linesIndices, modifyEnd, this.linesIndices, modifyStart + lineCount, this.count - modifyEnd);
            int i3 = 0;
            while (i3 < lineCount) {
                this.linesIndices[modifyStart + i3] = startLine + i3;
                ++i3;
            }
            this.count = newSize;
        }
    }

    int indexOf(int lineIndex) {
        int i2 = 0;
        while (i2 < this.count) {
            if (this.linesIndices[i2] == lineIndex) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int hashCode() {
        return this.style.hashCode() ^ this.type;
    }

    int[] removeIndices(int startLine, int replaceLineCount, int newLineCount, boolean update) {
        if (this.count == 0) {
            return null;
        }
        if (startLine > this.linesIndices[this.count - 1]) {
            return null;
        }
        int endLine = startLine + replaceLineCount;
        int delta = newLineCount - replaceLineCount;
        int i2 = 0;
        while (i2 < this.count) {
            int index = this.linesIndices[i2];
            if (startLine <= index) {
                int j2 = i2;
                while (j2 < this.count) {
                    if (this.linesIndices[j2] >= endLine) break;
                    ++j2;
                }
                if (update) {
                    int k2 = j2;
                    while (k2 < this.count) {
                        int n2 = k2++;
                        this.linesIndices[n2] = this.linesIndices[n2] + delta;
                    }
                }
                int[] redrawLines = new int[this.count - j2];
                System.arraycopy(this.linesIndices, j2, redrawLines, 0, this.count - j2);
                System.arraycopy(this.linesIndices, j2, this.linesIndices, i2, this.count - j2);
                this.count -= j2 - i2;
                return redrawLines;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.count) {
            int n3 = i2++;
            this.linesIndices[n3] = this.linesIndices[n3] + delta;
        }
        return null;
    }

    int size() {
        return this.count;
    }
}

