/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.opengl.win32.PIXELFORMATDESCRIPTOR;
import org.eclipse.swt.internal.opengl.win32.WGL;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    long context;
    int pixelFormat;
    static final String USE_OWNDC_KEY = "org.eclipse.swt.internal.win32.useOwnDC";

    public GLCanvas(Composite parent, int style, GLData data2) {
        super(parent, GLCanvas.checkStyle(parent, style));
        parent.getDisplay().setData(USE_OWNDC_KEY, false);
        if (data2 == null) {
            SWT.error(4);
        }
        PIXELFORMATDESCRIPTOR pfd = new PIXELFORMATDESCRIPTOR();
        pfd.nSize = (short)40;
        pfd.nVersion = 1;
        pfd.dwFlags = 36;
        pfd.dwLayerMask = 0;
        pfd.iPixelType = 0;
        if (data2.doubleBuffer) {
            pfd.dwFlags |= 1;
        }
        if (data2.stereo) {
            pfd.dwFlags |= 2;
        }
        pfd.cRedBits = (byte)data2.redSize;
        pfd.cGreenBits = (byte)data2.greenSize;
        pfd.cBlueBits = (byte)data2.blueSize;
        pfd.cAlphaBits = (byte)data2.alphaSize;
        pfd.cDepthBits = (byte)data2.depthSize;
        pfd.cStencilBits = (byte)data2.stencilSize;
        pfd.cAccumRedBits = (byte)data2.accumRedSize;
        pfd.cAccumGreenBits = (byte)data2.accumGreenSize;
        pfd.cAccumBlueBits = (byte)data2.accumBlueSize;
        pfd.cAccumAlphaBits = (byte)data2.accumAlphaSize;
        pfd.cAccumBits = (byte)(pfd.cAccumRedBits + pfd.cAccumGreenBits + pfd.cAccumBlueBits + pfd.cAccumAlphaBits);
        long hDC = OS.GetDC(this.handle);
        this.pixelFormat = WGL.ChoosePixelFormat(hDC, pfd);
        if (this.pixelFormat == 0 || !WGL.SetPixelFormat(hDC, this.pixelFormat, pfd)) {
            OS.ReleaseDC(this.handle, hDC);
            this.dispose();
            SWT.error(38);
        }
        this.context = WGL.wglCreateContext(hDC);
        if (this.context == 0L) {
            OS.ReleaseDC(this.handle, hDC);
            SWT.error(2);
        }
        OS.ReleaseDC(this.handle, hDC);
        if (data2.shareContext != null) {
            WGL.wglShareLists(data2.shareContext.context, this.context);
        }
        Listener listener2 = event -> {
            switch (event.type) {
                case 12: {
                    WGL.wglDeleteContext(this.context);
                }
            }
        };
        this.addListener(12, listener2);
    }

    static int checkStyle(Composite parent, int style) {
        if (parent != null) {
            parent.getDisplay().setData(USE_OWNDC_KEY, true);
        }
        return style;
    }

    public GLData getGLData() {
        this.checkWidget();
        GLData data2 = new GLData();
        PIXELFORMATDESCRIPTOR pfd = new PIXELFORMATDESCRIPTOR();
        pfd.nSize = (short)40;
        long hDC = OS.GetDC(this.handle);
        WGL.DescribePixelFormat(hDC, this.pixelFormat, 40, pfd);
        OS.ReleaseDC(this.handle, hDC);
        data2.doubleBuffer = (pfd.dwFlags & 1) != 0;
        data2.stereo = (pfd.dwFlags & 2) != 0;
        data2.redSize = pfd.cRedBits;
        data2.greenSize = pfd.cGreenBits;
        data2.blueSize = pfd.cBlueBits;
        data2.alphaSize = pfd.cAlphaBits;
        data2.depthSize = pfd.cDepthBits;
        data2.stencilSize = pfd.cStencilBits;
        data2.accumRedSize = pfd.cAccumRedBits;
        data2.accumGreenSize = pfd.cAccumGreenBits;
        data2.accumBlueSize = pfd.cAccumBlueBits;
        data2.accumAlphaSize = pfd.cAccumAlphaBits;
        return data2;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return WGL.wglGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (WGL.wglGetCurrentContext() == this.context) {
            return;
        }
        long hDC = OS.GetDC(this.handle);
        WGL.wglMakeCurrent(hDC, this.context);
        OS.ReleaseDC(this.handle, hDC);
    }

    public void swapBuffers() {
        this.checkWidget();
        long hDC = OS.GetDC(this.handle);
        WGL.SwapBuffers(hDC);
        OS.ReleaseDC(this.handle, hDC);
    }
}

