/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser;

import org.xhtmlrenderer.css.parser.FSColor;

public class FSRGBColor
implements FSColor {
    public static final FSRGBColor TRANSPARENT = new FSRGBColor(0, 0, 0);
    public static final FSRGBColor RED = new FSRGBColor(255, 0, 0);
    public static final FSRGBColor GREEN = new FSRGBColor(0, 255, 0);
    public static final FSRGBColor BLUE = new FSRGBColor(0, 0, 255);
    private int _red;
    private int _green;
    private int _blue;

    public FSRGBColor(int red, int green, int blue) {
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException();
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException();
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException();
        }
        this._red = red;
        this._green = green;
        this._blue = blue;
    }

    public FSRGBColor(int color) {
        this((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
    }

    public int getBlue() {
        return this._blue;
    }

    public int getGreen() {
        return this._green;
    }

    public int getRed() {
        return this._red;
    }

    public String toString() {
        return '#' + this.toString(this._red) + this.toString(this._green) + this.toString(this._blue);
    }

    private String toString(int color) {
        String result2 = Integer.toHexString(color);
        if (result2.length() == 1) {
            return "0" + result2;
        }
        return result2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof FSRGBColor)) {
            return false;
        }
        FSRGBColor that = (FSRGBColor)o2;
        if (this._blue != that._blue) {
            return false;
        }
        if (this._green != that._green) {
            return false;
        }
        return this._red == that._red;
    }

    public int hashCode() {
        int result2 = this._red;
        result2 = 31 * result2 + this._green;
        result2 = 31 * result2 + this._blue;
        return result2;
    }

    @Override
    public FSColor lightenColor() {
        float[] hsb = FSRGBColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        float hBase = hsb[0];
        float sBase = hsb[1];
        float bBase = hsb[2];
        float hLighter = hBase;
        float sLighter = 0.35f * bBase * sBase;
        float bLighter = 0.6999f + 0.3f * bBase;
        int[] rgb = FSRGBColor.HSBtoRGB(hLighter, sLighter, bLighter);
        return new FSRGBColor(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public FSColor darkenColor() {
        float[] hsb = FSRGBColor.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        float hBase = hsb[0];
        float sBase = hsb[1];
        float bBase = hsb[2];
        float hDarker = hBase;
        float sDarker = sBase;
        float bDarker = 0.56f * bBase;
        int[] rgb = FSRGBColor.HSBtoRGB(hDarker, sDarker, bDarker);
        return new FSRGBColor(rgb[0], rgb[1], rgb[2]);
    }

    private static float[] RGBtoHSB(int r2, int g2, int b2, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n2 = cmax = r2 > g2 ? r2 : g2;
        if (b2 > cmax) {
            cmax = b2;
        }
        int n3 = cmin = r2 < g2 ? r2 : g2;
        if (b2 < cmin) {
            cmin = b2;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r2) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g2) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b2) / (float)(cmax - cmin);
            hue = r2 == cmax ? bluec - greenc : (g2 == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    private static int[] HSBtoRGB(float hue, float saturation, float brightness) {
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        if (saturation == 0.0f) {
            g2 = b2 = (int)(brightness * 255.0f + 0.5f);
            r2 = b2;
        } else {
            float h2 = (hue - (float)Math.floor(hue)) * 6.0f;
            float f2 = h2 - (float)Math.floor(h2);
            float p2 = brightness * (1.0f - saturation);
            float q2 = brightness * (1.0f - saturation * f2);
            float t2 = brightness * (1.0f - saturation * (1.0f - f2));
            switch ((int)h2) {
                case 0: {
                    r2 = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(t2 * 255.0f + 0.5f);
                    b2 = (int)(p2 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r2 = (int)(q2 * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b2 = (int)(p2 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r2 = (int)(p2 * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b2 = (int)(t2 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r2 = (int)(p2 * 255.0f + 0.5f);
                    g2 = (int)(q2 * 255.0f + 0.5f);
                    b2 = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r2 = (int)(t2 * 255.0f + 0.5f);
                    g2 = (int)(p2 * 255.0f + 0.5f);
                    b2 = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r2 = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(p2 * 255.0f + 0.5f);
                    b2 = (int)(q2 * 255.0f + 0.5f);
                }
            }
        }
        return new int[]{r2, g2, b2};
    }
}

