/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.newtable;

import java.awt.Rectangle;
import java.util.List;
import java.util.Set;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.Length;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.CollapsedBorderSide;
import org.xhtmlrenderer.layout.FloatManager;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.newtable.CollapsedBorderValue;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableColumn;
import org.xhtmlrenderer.newtable.TableRowBox;
import org.xhtmlrenderer.newtable.TableSectionBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.ContentLimit;
import org.xhtmlrenderer.render.ContentLimitContainer;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;

public class TableCellBox
extends BlockBox {
    public static final TableCellBox SPANNING_CELL = new TableCellBox();
    private int _row;
    private int _col;
    private TableBox _table;
    private TableSectionBox _section;
    private BorderPropertySet _collapsedLayoutBorder;
    private BorderPropertySet _collapsedPaintingBorder;
    private CollapsedBorderValue _collapsedBorderTop;
    private CollapsedBorderValue _collapsedBorderRight;
    private CollapsedBorderValue _collapsedBorderBottom;
    private CollapsedBorderValue _collapsedBorderLeft;
    private static final int[] BORDER_PRIORITIES = new int[IdentValue.getIdentCount()];
    private static final int BCELL = 10;
    private static final int BROW = 9;
    private static final int BROWGROUP = 8;
    private static final int BCOL = 7;
    private static final int BTABLE = 6;

    @Override
    public BlockBox copyOf() {
        TableCellBox result2 = new TableCellBox();
        result2.setStyle(this.getStyle());
        result2.setElement(this.getElement());
        return result2;
    }

    @Override
    public BorderPropertySet getBorder(CssContext cssCtx) {
        if (this.getTable().getStyle().isCollapseBorders()) {
            return this._collapsedLayoutBorder == null ? BorderPropertySet.EMPTY_BORDER : this._collapsedLayoutBorder;
        }
        return super.getBorder(cssCtx);
    }

    public void calcCollapsedBorder(CssContext c2) {
        CollapsedBorderValue top2 = this.collapsedTopBorder(c2);
        CollapsedBorderValue right2 = this.collapsedRightBorder(c2);
        CollapsedBorderValue bottom2 = this.collapsedBottomBorder(c2);
        CollapsedBorderValue left2 = this.collapsedLeftBorder(c2);
        this._collapsedPaintingBorder = new BorderPropertySet(top2, right2, bottom2, left2);
        top2.setWidth((top2.width() + 1) / 2);
        right2.setWidth(right2.width() / 2);
        bottom2.setWidth(bottom2.width() / 2);
        left2.setWidth((left2.width() + 1) / 2);
        this._collapsedLayoutBorder = new BorderPropertySet(top2, right2, bottom2, left2);
        this._collapsedBorderTop = top2;
        this._collapsedBorderRight = right2;
        this._collapsedBorderBottom = bottom2;
        this._collapsedBorderLeft = left2;
    }

    public int getCol() {
        return this._col;
    }

    public void setCol(int col) {
        this._col = col;
    }

    public int getRow() {
        return this._row;
    }

    public void setRow(int row2) {
        this._row = row2;
    }

    @Override
    public void layout(LayoutContext c2) {
        super.layout(c2);
    }

    public TableBox getTable() {
        if (this._table == null) {
            this._table = (TableBox)this.getParent().getParent().getParent();
        }
        return this._table;
    }

    protected TableSectionBox getSection() {
        if (this._section == null) {
            this._section = (TableSectionBox)this.getParent().getParent();
        }
        return this._section;
    }

    public Length getOuterStyleWidth(CssContext c2) {
        Length result2 = this.getStyle().asLength(c2, CSSName.WIDTH);
        if (result2.isVariable() || result2.isPercent()) {
            return result2;
        }
        int bordersAndPadding = 0;
        BorderPropertySet border = this.getBorder(c2);
        bordersAndPadding += (int)border.left() + (int)border.right();
        RectPropertySet padding = this.getPadding(c2);
        result2.setValue(result2.value() + (long)(bordersAndPadding += (int)padding.left() + (int)padding.right()));
        return result2;
    }

    public Length getOuterStyleOrColWidth(CssContext c2) {
        Length result2 = this.getOuterStyleWidth(c2);
        if (this.getStyle().getColSpan() > 1 || !result2.isVariable()) {
            return result2;
        }
        TableColumn col = this.getTable().colElement(this.getCol());
        if (col != null) {
            result2 = col.getStyle().asLength(c2, CSSName.WIDTH);
        }
        return result2;
    }

    public void setLayoutWidth(LayoutContext c2, int width) {
        this.calcDimensions(c2);
        this.setContentWidth(width - this.getLeftMBP() - this.getRightMBP());
    }

    @Override
    public boolean isAutoHeight() {
        return this.getStyle().isAutoHeight() || !this.getStyle().hasAbsoluteUnit(CSSName.HEIGHT);
    }

    @Override
    public int calcBaseline(LayoutContext c2) {
        int result2 = super.calcBaseline(c2);
        if (result2 != Integer.MIN_VALUE) {
            return result2;
        }
        Rectangle contentArea = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), c2);
        return (int)contentArea.getY();
    }

    public int calcBlockBaseline(LayoutContext c2) {
        return super.calcBaseline(c2);
    }

    public void moveContent(LayoutContext c2, final int deltaY) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box b2 = this.getChild(i2);
            b2.setY(b2.getY() + deltaY);
        }
        this.getPersistentBFC().getFloatManager().performFloatOperation(new FloatManager.FloatOperation(){

            @Override
            public void operate(Box floater) {
                floater.setY(floater.getY() + deltaY);
            }
        });
        this.calcChildLocations();
    }

    public boolean isPageBreaksChange(LayoutContext c2, int posDeltaY) {
        if (!c2.isPageBreaksAllowed()) {
            return false;
        }
        PageBox page = c2.getRootLayer().getFirstPage(c2, this);
        int bottomEdge = this.getAbsY() + this.getChildrenHeight();
        return page != null && (bottomEdge >= page.getBottom() - c2.getExtraSpaceBottom() || bottomEdge + posDeltaY >= page.getBottom() - c2.getExtraSpaceBottom());
    }

    public IdentValue getVerticalAlign() {
        IdentValue val = this.getStyle().getIdent(CSSName.VERTICAL_ALIGN);
        if (val == IdentValue.TOP || val == IdentValue.MIDDLE || val == IdentValue.BOTTOM) {
            return val;
        }
        return IdentValue.BASELINE;
    }

    private boolean isPaintBackgroundsAndBorders() {
        boolean showEmpty = this.getStyle().isShowEmptyCells();
        return showEmpty || this.getChildrenContentType() != 4;
    }

    @Override
    public void paintBackground(RenderingContext c2) {
        Rectangle bounds;
        if (this.isPaintBackgroundsAndBorders() && this.getStyle().isVisible() && (bounds = c2.isPrint() && this.getTable().getStyle().isPaginateTable() ? this.getContentLimitedBorderEdge(c2) : this.getPaintingBorderEdge(c2)) != null) {
            this.paintBackgroundStack(c2, bounds);
        }
    }

    private void paintBackgroundStack(RenderingContext c2, Rectangle bounds) {
        BorderPropertySet border = this.getStyle().getBorder(c2);
        TableColumn column2 = this.getTable().colElement(this.getCol());
        if (column2 != null) {
            c2.getOutputDevice().paintBackground(c2, column2.getStyle(), bounds, this.getTable().getColumnBounds(c2, this.getCol()), border);
        }
        Box row2 = this.getParent();
        Box section = row2.getParent();
        CalculatedStyle tableStyle = this.getTable().getStyle();
        CalculatedStyle sectionStyle = section.getStyle();
        Rectangle imageContainer = section.getPaintingBorderEdge(c2);
        imageContainer.y += tableStyle.getBorderVSpacing(c2);
        imageContainer.height -= tableStyle.getBorderVSpacing(c2);
        imageContainer.x += tableStyle.getBorderHSpacing(c2);
        imageContainer.width -= 2 * tableStyle.getBorderHSpacing(c2);
        c2.getOutputDevice().paintBackground(c2, sectionStyle, bounds, imageContainer, sectionStyle.getBorder(c2));
        CalculatedStyle rowStyle = row2.getStyle();
        imageContainer = row2.getPaintingBorderEdge(c2);
        imageContainer.x += tableStyle.getBorderHSpacing(c2);
        imageContainer.width -= 2 * tableStyle.getBorderHSpacing(c2);
        c2.getOutputDevice().paintBackground(c2, rowStyle, bounds, imageContainer, rowStyle.getBorder(c2));
        c2.getOutputDevice().paintBackground(c2, this.getStyle(), bounds, this.getPaintingBorderEdge(c2), border);
    }

    @Override
    public void paintBorder(RenderingContext c2) {
        if (this.isPaintBackgroundsAndBorders() && !this.hasCollapsedPaintingBorder()) {
            if (c2.isPrint() && this.getTable().getStyle().isPaginateTable() && this.getStyle().isVisible()) {
                Rectangle bounds = this.getContentLimitedBorderEdge(c2);
                if (bounds != null) {
                    c2.getOutputDevice().paintBorder(c2, this.getStyle(), bounds, this.getBorderSides());
                }
            } else {
                super.paintBorder(c2);
            }
        }
    }

    public void paintCollapsedBorder(RenderingContext c2, int side) {
        c2.getOutputDevice().paintCollapsedBorder(c2, this.getCollapsedPaintingBorder(), this.getCollapsedBorderBounds(c2), side);
    }

    private Rectangle getContentLimitedBorderEdge(RenderingContext c2) {
        ContentLimit limit;
        Rectangle result2 = this.getPaintingBorderEdge(c2);
        TableSectionBox section = this.getSection();
        if (section.isHeader() || section.isFooter()) {
            return result2;
        }
        ContentLimitContainer contentLimitContainer = ((TableRowBox)this.getParent()).getContentLimitContainer();
        ContentLimit contentLimit = limit = contentLimitContainer != null ? contentLimitContainer.getContentLimit(c2.getPageNo()) : null;
        if (limit == null) {
            return null;
        }
        if (limit.getTop() == -1 || limit.getBottom() == -1) {
            return result2;
        }
        int top2 = c2.getPageNo() == contentLimitContainer.getInitialPageNo() ? result2.y : limit.getTop() - ((TableRowBox)this.getParent()).getExtraSpaceTop();
        int bottom2 = c2.getPageNo() == contentLimitContainer.getLastPageNo() ? result2.y + result2.height : limit.getBottom() + ((TableRowBox)this.getParent()).getExtraSpaceBottom();
        result2.y = top2;
        result2.height = bottom2 - top2;
        return result2;
    }

    @Override
    public Rectangle getChildrenClipEdge(RenderingContext c2) {
        Rectangle bounds;
        if (c2.isPrint() && this.getTable().getStyle().isPaginateTable() && (bounds = this.getContentLimitedBorderEdge(c2)) != null) {
            BorderPropertySet border = this.getBorder(c2);
            RectPropertySet padding = this.getPadding(c2);
            bounds.y += (int)border.top() + (int)padding.top();
            bounds.height -= (int)border.height() + (int)padding.height();
            return bounds;
        }
        return super.getChildrenClipEdge(c2);
    }

    @Override
    protected boolean isFixedWidthAdvisoryOnly() {
        return this.getTable().getStyle().isIdent(CSSName.TABLE_LAYOUT, IdentValue.AUTO);
    }

    @Override
    protected boolean isSkipWhenCollapsingMargins() {
        return true;
    }

    public static CollapsedBorderValue compareBorders(CollapsedBorderValue border1, CollapsedBorderValue border2, boolean returnNullOnEqual) {
        if (!border2.defined()) {
            return border1;
        }
        if (!border1.defined()) {
            return border2;
        }
        if (border1.style() == IdentValue.HIDDEN) {
            return border1;
        }
        if (border2.style() == IdentValue.HIDDEN) {
            return border2;
        }
        if (border2.style() == IdentValue.NONE) {
            return border1;
        }
        if (border1.style() == IdentValue.NONE) {
            return border2;
        }
        if (border1.width() != border2.width()) {
            return border1.width() > border2.width() ? border1 : border2;
        }
        if (border1.style() != border2.style()) {
            return BORDER_PRIORITIES[border1.style().FS_ID] > BORDER_PRIORITIES[border2.style().FS_ID] ? border1 : border2;
        }
        if (returnNullOnEqual && border1.precedence() == border2.precedence()) {
            return null;
        }
        return border1.precedence() >= border2.precedence() ? border1 : border2;
    }

    private static CollapsedBorderValue compareBorders(CollapsedBorderValue border1, CollapsedBorderValue border2) {
        return TableCellBox.compareBorders(border1, border2, false);
    }

    private CollapsedBorderValue collapsedLeftBorder(CssContext c2) {
        TableColumn colElt;
        BorderPropertySet border = this.getStyle().getBorder(c2);
        CollapsedBorderValue result2 = CollapsedBorderValue.borderLeft(border, 10);
        TableCellBox prevCell = this.getTable().cellLeft(this);
        if (prevCell != null) {
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderRight(prevCell.getStyle().getBorder(c2), 10))).hidden()) {
                return result2;
            }
        } else if (this.getCol() == 0) {
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderLeft(this.getParent().getStyle().getBorder(c2), 9))).hidden()) {
                return result2;
            }
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderLeft(this.getSection().getStyle().getBorder(c2), 8))).hidden()) {
                return result2;
            }
        }
        if ((colElt = this.getTable().colElement(this.getCol())) != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderLeft(colElt.getStyle().getBorder(c2), 7))).hidden()) {
            return result2;
        }
        if (this.getCol() > 0 && (colElt = this.getTable().colElement(this.getCol() - 1)) != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderRight(colElt.getStyle().getBorder(c2), 7))).hidden()) {
            return result2;
        }
        if (this.getCol() == 0 && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderLeft(this.getTable().getStyle().getBorder(c2), 6))).hidden()) {
            return result2;
        }
        return result2;
    }

    private CollapsedBorderValue collapsedRightBorder(CssContext c2) {
        TableColumn colElt;
        TableBox tableElt = this.getTable();
        boolean inLastColumn = false;
        int effCol = tableElt.colToEffCol(this.getCol() + this.getStyle().getColSpan() - 1);
        if (effCol == tableElt.numEffCols() - 1) {
            inLastColumn = true;
        }
        CollapsedBorderValue result2 = CollapsedBorderValue.borderRight(this.getStyle().getBorder(c2), 10);
        if (!inLastColumn) {
            TableCellBox nextCell = tableElt.cellRight(this);
            if (nextCell != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderLeft(nextCell.getStyle().getBorder(c2), 10))).hidden()) {
                return result2;
            }
        } else {
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderRight(this.getParent().getStyle().getBorder(c2), 9))).hidden()) {
                return result2;
            }
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderRight(this.getSection().getStyle().getBorder(c2), 8))).hidden()) {
                return result2;
            }
        }
        if ((colElt = this.getTable().colElement(this.getCol() + this.getStyle().getColSpan() - 1)) != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderRight(colElt.getStyle().getBorder(c2), 7))).hidden()) {
            return result2;
        }
        if (!inLastColumn ? (colElt = tableElt.colElement(this.getCol() + this.getStyle().getColSpan())) != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderLeft(colElt.getStyle().getBorder(c2), 7))).hidden() : (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderRight(tableElt.getStyle().getBorder(c2), 6))).hidden()) {
            return result2;
        }
        return result2;
    }

    private CollapsedBorderValue collapsedTopBorder(CssContext c2) {
        CollapsedBorderValue result2 = CollapsedBorderValue.borderTop(this.getStyle().getBorder(c2), 10);
        TableCellBox prevCell = this.getTable().cellAbove(this);
        if (prevCell != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderBottom(prevCell.getStyle().getBorder(c2), 10))).hidden()) {
            return result2;
        }
        if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderTop(this.getParent().getStyle().getBorder(c2), 9))).hidden()) {
            return result2;
        }
        if (prevCell != null) {
            TableRowBox prevRow = null;
            prevRow = prevCell.getSection() == this.getSection() ? (TableRowBox)this.getParent().getPreviousSibling() : prevCell.getSection().getLastRow();
            if (prevRow != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderBottom(prevRow.getStyle().getBorder(c2), 9))).hidden()) {
                return result2;
            }
        }
        TableSectionBox currSection = this.getSection();
        if (this.getRow() == 0) {
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderTop(currSection.getStyle().getBorder(c2), 8))).hidden()) {
                return result2;
            }
            currSection = this.getTable().sectionAbove(currSection, false);
            if (currSection != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderBottom(currSection.getStyle().getBorder(c2), 8))).hidden()) {
                return result2;
            }
        }
        if (currSection == null) {
            TableColumn colElt = this.getTable().colElement(this.getCol());
            if (colElt != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderTop(colElt.getStyle().getBorder(c2), 7))).hidden()) {
                return result2;
            }
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderTop(this.getTable().getStyle().getBorder(c2), 6))).hidden()) {
                return result2;
            }
        }
        return result2;
    }

    private CollapsedBorderValue collapsedBottomBorder(CssContext c2) {
        CollapsedBorderValue result2 = CollapsedBorderValue.borderBottom(this.getStyle().getBorder(c2), 10);
        TableCellBox nextCell = this.getTable().cellBelow(this);
        if (nextCell != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderTop(nextCell.getStyle().getBorder(c2), 10))).hidden()) {
            return result2;
        }
        if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderBottom(this.getParent().getStyle().getBorder(c2), 9))).hidden()) {
            return result2;
        }
        if (nextCell != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderTop(nextCell.getParent().getStyle().getBorder(c2), 9))).hidden()) {
            return result2;
        }
        TableSectionBox currSection = this.getSection();
        if (this.getRow() + this.getStyle().getRowSpan() >= currSection.numRows()) {
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderBottom(currSection.getStyle().getBorder(c2), 8))).hidden()) {
                return result2;
            }
            currSection = this.getTable().sectionBelow(currSection, false);
            if (currSection != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderTop(currSection.getStyle().getBorder(c2), 8))).hidden()) {
                return result2;
            }
        }
        if (currSection == null) {
            TableColumn colElt = this.getTable().colElement(this.getCol());
            if (colElt != null && (result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderBottom(colElt.getStyle().getBorder(c2), 7))).hidden()) {
                return result2;
            }
            if ((result2 = TableCellBox.compareBorders(result2, CollapsedBorderValue.borderBottom(this.getTable().getStyle().getBorder(c2), 6))).hidden()) {
                return result2;
            }
        }
        return result2;
    }

    private Rectangle getCollapsedBorderBounds(CssContext c2) {
        BorderPropertySet border = this.getCollapsedPaintingBorder();
        Rectangle bounds = this.getPaintingBorderEdge(c2);
        bounds.x -= (int)border.left() / 2;
        bounds.y -= (int)border.top() / 2;
        bounds.width += (int)border.left() / 2 + ((int)border.right() + 1) / 2;
        bounds.height += (int)border.top() / 2 + ((int)border.bottom() + 1) / 2;
        return bounds;
    }

    @Override
    public Rectangle getPaintingClipEdge(CssContext c2) {
        if (this.hasCollapsedPaintingBorder()) {
            return this.getCollapsedBorderBounds(c2);
        }
        return super.getPaintingClipEdge(c2);
    }

    public boolean hasCollapsedPaintingBorder() {
        return this._collapsedPaintingBorder != null;
    }

    protected BorderPropertySet getCollapsedPaintingBorder() {
        return this._collapsedPaintingBorder;
    }

    public CollapsedBorderValue getCollapsedBorderBottom() {
        return this._collapsedBorderBottom;
    }

    public CollapsedBorderValue getCollapsedBorderLeft() {
        return this._collapsedBorderLeft;
    }

    public CollapsedBorderValue getCollapsedBorderRight() {
        return this._collapsedBorderRight;
    }

    public CollapsedBorderValue getCollapsedBorderTop() {
        return this._collapsedBorderTop;
    }

    public void addCollapsedBorders(Set all, List borders) {
        if (this._collapsedBorderTop.exists() && !all.contains(this._collapsedBorderTop)) {
            all.add(this._collapsedBorderTop);
            borders.add(new CollapsedBorderSide(this, 1));
        }
        if (this._collapsedBorderRight.exists() && !all.contains(this._collapsedBorderRight)) {
            all.add(this._collapsedBorderRight);
            borders.add(new CollapsedBorderSide(this, 8));
        }
        if (this._collapsedBorderBottom.exists() && !all.contains(this._collapsedBorderBottom)) {
            all.add(this._collapsedBorderBottom);
            borders.add(new CollapsedBorderSide(this, 4));
        }
        if (this._collapsedBorderLeft.exists() && !all.contains(this._collapsedBorderLeft)) {
            all.add(this._collapsedBorderLeft);
            borders.add(new CollapsedBorderSide(this, 2));
        }
    }

    @Override
    protected int getCSSHeight(CssContext c2) {
        if (this.getStyle().isAutoHeight()) {
            return -1;
        }
        int result2 = (int)this.getStyle().getFloatPropertyProportionalWidth(CSSName.HEIGHT, this.getContainingBlock().getContentWidth(), c2);
        BorderPropertySet border = this.getBorder(c2);
        result2 -= (int)border.top() + (int)border.bottom();
        RectPropertySet padding = this.getPadding(c2);
        return (result2 -= (int)padding.top() + (int)padding.bottom()) >= 0 ? result2 : -1;
    }

    @Override
    protected boolean isAllowHeightToShrink() {
        return false;
    }

    @Override
    public boolean isNeedsClipOnPaint(RenderingContext c2) {
        boolean result2 = super.isNeedsClipOnPaint(c2);
        if (result2) {
            return result2;
        }
        ContentLimitContainer contentLimitContainer = ((TableRowBox)this.getParent()).getContentLimitContainer();
        if (contentLimitContainer == null) {
            return false;
        }
        return c2.isPrint() && this.getTable().getStyle().isPaginateTable() && contentLimitContainer.isContainsMultiplePages();
    }

    static {
        TableCellBox.BORDER_PRIORITIES[IdentValue.DOUBLE.FS_ID] = 1;
        TableCellBox.BORDER_PRIORITIES[IdentValue.SOLID.FS_ID] = 2;
        TableCellBox.BORDER_PRIORITIES[IdentValue.DASHED.FS_ID] = 3;
        TableCellBox.BORDER_PRIORITIES[IdentValue.DOTTED.FS_ID] = 4;
        TableCellBox.BORDER_PRIORITIES[IdentValue.RIDGE.FS_ID] = 5;
        TableCellBox.BORDER_PRIORITIES[IdentValue.OUTSET.FS_ID] = 6;
        TableCellBox.BORDER_PRIORITIES[IdentValue.GROOVE.FS_ID] = 7;
        TableCellBox.BORDER_PRIORITIES[IdentValue.INSET.FS_ID] = 8;
    }
}

