/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;

public class LineNumberTableAttribute
extends Attribute {
    public int u2lineNumberTableLength;
    public LineNumberInfo[] lineNumberTable;

    public LineNumberTableAttribute() {
    }

    public LineNumberTableAttribute(int n, int n2, LineNumberInfo[] lineNumberInfoArray) {
        super(n);
        this.u2lineNumberTableLength = n2;
        this.lineNumberTable = lineNumberInfoArray;
    }

    public int getLineNumber(int n) {
        for (int i = this.u2lineNumberTableLength - 1; i >= 0; --i) {
            LineNumberInfo lineNumberInfo = this.lineNumberTable[i];
            if (n < lineNumberInfo.u2startPC) continue;
            return lineNumberInfo.u2lineNumber;
        }
        return this.u2lineNumberTableLength > 0 ? this.lineNumberTable[0].u2lineNumber : 0;
    }

    public int getLowestLineNumber() {
        if (this.u2lineNumberTableLength == 0) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            int n2 = this.lineNumberTable[i].u2lineNumber;
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public int getHighestLineNumber() {
        if (this.u2lineNumberTableLength == 0) {
            return 0;
        }
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            int n2 = this.lineNumberTable[i].u2lineNumber;
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitLineNumberTableAttribute(clazz, method, codeAttribute, this);
    }

    public void lineNumbersAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfoVisitor lineNumberInfoVisitor) {
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            lineNumberInfoVisitor.visitLineNumberInfo(clazz, method, codeAttribute, this.lineNumberTable[i]);
        }
    }
}

