/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.UsageMarker;

public class SignatureUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor,
ClassVisitor,
ConstantVisitor {
    private final UsageMarker usageMarker;
    private boolean attributeUsed;

    public SignatureUsageMarker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.attributeUsed = true;
        signatureAttribute.referencedClassesAccept(this);
        if (this.attributeUsed) {
            this.usageMarker.markAsUsed(signatureAttribute);
            this.markConstant(clazz, signatureAttribute.u2attributeNameIndex);
            this.markConstant(clazz, signatureAttribute.u2signatureIndex);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (!this.usageMarker.isUsed(programClass)) {
            this.attributeUsed = false;
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.usageMarker.markAsUsed(constant);
    }

    private void markConstant(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this);
    }
}

