/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedUnarchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.PMResolution;
import org.eclipse.swt.internal.cocoa.SWTPrinterView;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    NSPrinter printer;
    NSPrintInfo printInfo;
    NSPrintOperation operation;
    NSView view;
    NSWindow window;
    boolean isGCCreated;
    static final String DRIVER = "Mac";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrinterData[] getPrinterList() {
        PrinterData[] printerDataArray;
        block4: {
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSArray nSArray = NSPrinter.printerNames();
                int n = nSArray.count();
                PrinterData[] printerDataArray2 = new PrinterData[n];
                for (int i = 0; i < n; ++i) {
                    NSString nSString = new NSString(nSArray.objectAtIndex(i));
                    printerDataArray2[i] = new PrinterData(DRIVER, nSString.getString());
                }
                printerDataArray = printerDataArray2;
                Object var7_7 = null;
                if (nSAutoreleasePool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_8 = null;
                    if (nSAutoreleasePool == null) break block5;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return printerDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrinterData getDefaultPrinterData() {
        PrinterData printerData;
        block6: {
            NSPrinter nSPrinter;
            NSAutoreleasePool nSAutoreleasePool;
            block4: {
                PrinterData printerData2;
                block5: {
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        nSPrinter = NSPrintInfo.defaultPrinter();
                        if (nSPrinter != null) break block4;
                        printerData2 = null;
                        Object var5_4 = null;
                        if (nSAutoreleasePool == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var5_6 = null;
                            if (nSAutoreleasePool == null) break block7;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return printerData2;
            }
            NSString nSString = nSPrinter.name();
            printerData = new PrinterData(DRIVER, nSString.getString());
            Object var5_5 = null;
            if (nSAutoreleasePool == null) break block6;
            nSAutoreleasePool.release();
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSSize nSSize = this.printInfo.paperSize();
                NSRect nSRect = this.printInfo.imageablePageBounds();
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                float f = this.scalingFactor();
                n = (int)((float)n - nSRect.x * (float)point.x / (float)point2.x / f);
                n2 = (int)((float)n2 - nSRect.y * (float)point.y / (float)point2.y / f);
                n3 = (int)((float)n3 + (nSSize.width - nSRect.width) * (float)point.x / (float)point2.x / f);
                n4 = (int)((float)n4 + (nSSize.height - nSRect.height) * (float)point.y / (float)point2.y / f);
                rectangle = new Rectangle(n, n2, n3, n4);
                Object var13_12 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var13_13 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void create(DeviceData deviceData) {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSString nSString;
            NSObject nSObject;
            NSApplication.sharedApplication();
            this.data = (PrinterData)deviceData;
            if (this.data.otherData != null) {
                nSObject = NSData.dataWithBytes(this.data.otherData, this.data.otherData.length);
                this.printInfo = new NSPrintInfo(NSKeyedUnarchiver.unarchiveObjectWithData((NSData)nSObject).id);
            } else {
                this.printInfo = NSPrintInfo.sharedPrintInfo();
            }
            this.printInfo.retain();
            this.printer = NSPrinter.printerWithName(NSString.stringWith(this.data.name));
            if (this.printer != null) {
                this.printer.retain();
                this.printInfo.setPrinter(this.printer);
            }
            if (this.data.duplex != -1) {
                int n = this.printInfo.PMPrintSettings();
                int n2 = this.data.duplex == 2 ? 3 : (this.data.duplex == 1 ? 2 : 1);
                OS.PMSetDuplex(n, n2);
            }
            this.printInfo.updateFromPMPrintSettings();
            nSObject = this.printInfo.dictionary();
            if (this.data.collate) {
                ((NSMutableDictionary)nSObject).setValue(NSNumber.numberWithBool(this.data.collate), OS.NSPrintMustCollate);
            }
            if (this.data.copyCount != 1) {
                ((NSMutableDictionary)nSObject).setValue(NSNumber.numberWithInt(this.data.copyCount), OS.NSPrintCopies);
            }
            ((NSMutableDictionary)nSObject).setValue(NSNumber.numberWithInt(this.data.orientation == 2 ? 1 : 0), OS.NSPrintOrientation);
            if (this.data.printToFile) {
                ((NSMutableDictionary)nSObject).setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
                if (this.data.fileName != null) {
                    ((NSMutableDictionary)nSObject).setValue(NSString.stringWith(this.data.fileName), OS.NSPrintSavePath);
                }
            }
            if ((nSString = this.printInfo.jobDisposition()).isEqual(new NSString(OS.NSPrintPreviewJob()))) {
                this.printInfo.setJobDisposition(nSString);
            }
            NSRect nSRect = new NSRect();
            this.window = (NSWindow)new NSWindow().alloc();
            this.window.initWithContentRect(nSRect, 0, 2, false);
            String string = "SWTPrinterView";
            if (OS.objc_lookUpClass(string) == 0) {
                int n = OS.objc_allocateClassPair(OS.class_NSView, string, 0);
                OS.class_addMethod(n, OS.sel_isFlipped, OS.isFlipped_CALLBACK(), "@:");
                OS.objc_registerClassPair(n);
            }
            this.view = (NSView)new SWTPrinterView().alloc();
            this.view.initWithFrame(nSRect);
            this.window.setContentView(this.view);
            this.operation = NSPrintOperation.printOperationWithView(this.view, this.printInfo);
            this.operation.retain();
            this.operation.setShowsPrintPanel(false);
            this.operation.setShowsProgressPanel(false);
            Object var9_10 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void destroy() {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.printer != null) {
                this.printer.release();
            }
            if (this.printInfo != null) {
                this.printInfo.release();
            }
            if (this.view != null) {
                this.view.release();
            }
            if (this.window != null) {
                this.window.release();
            }
            if (this.operation != null) {
                this.operation.release();
            }
            this.printer = null;
            this.printInfo = null;
            this.view = null;
            this.window = null;
            this.operation = null;
            Object var3_2 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internal_new_GC(GCData gCData) {
        int n;
        block6: {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                if (gCData != null) {
                    if (this.isGCCreated) {
                        SWT.error(5);
                    }
                    gCData.device = this;
                    gCData.background = this.getSystemColor((int)1).handle;
                    gCData.foreground = this.getSystemColor((int)2).handle;
                    gCData.font = this.getSystemFont();
                    float f = this.scalingFactor();
                    Point point = this.getDPI();
                    Point point2 = this.getIndependentDPI();
                    NSSize nSSize = this.printInfo.paperSize();
                    nSSize.width = nSSize.width * (float)(point.x / point2.x) / f;
                    nSSize.height = nSSize.height * (float)point.y / (float)point2.y / f;
                    gCData.size = nSSize;
                    this.isGCCreated = true;
                }
                this.createContext();
                n = this.operation.context().id;
                Object var8_8 = null;
                if (nSAutoreleasePool == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_9 = null;
                    if (nSAutoreleasePool == null) break block7;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init() {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            super.init();
            Object var3_2 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        if (gCData != null) {
            this.isGCCreated = false;
        }
    }

    protected void release() {
        super.release();
    }

    float scalingFactor() {
        NSNumber nSNumber = new NSNumber(this.printInfo.dictionary().objectForKey(OS.NSPrintScalingFactor));
        return nSNumber.floatValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startJob(String string) {
        boolean bl;
        block7: {
            NSAutoreleasePool nSAutoreleasePool;
            block5: {
                boolean bl2;
                block6: {
                    this.checkDevice();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        if (string != null && string.length() != 0) {
                            this.operation.setJobTitle(NSString.stringWith(string));
                        }
                        if (!this.createContext()) break block5;
                        this.view.beginDocument();
                        bl2 = true;
                        Object var5_5 = null;
                        if (nSAutoreleasePool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var5_7 = null;
                            if (nSAutoreleasePool == null) break block8;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return bl2;
            }
            bl = false;
            Object var5_6 = null;
            if (nSAutoreleasePool == null) break block7;
            nSAutoreleasePool.release();
        }
        return bl;
    }

    boolean createContext() {
        if (this.operation.context() != null) {
            return true;
        }
        this.printInfo.setUpPrintOperationDefaultValues();
        NSPrintOperation.setCurrentOperation(this.operation);
        return this.operation.createContext() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endJob() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.view.endDocument();
            this.operation.deliverResult();
            this.operation.destroyContext();
            this.operation.cleanUpOperation();
            Object var3_2 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancelJob() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.operation.destroyContext();
            this.operation.cleanUpOperation();
            Object var3_2 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startPage() {
        boolean bl;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                float f = this.scalingFactor();
                NSSize nSSize = this.printInfo.paperSize();
                nSSize.width /= f;
                nSSize.height /= f;
                NSRect nSRect = new NSRect();
                nSRect.width = nSSize.width;
                nSRect.height = nSSize.height;
                this.view.beginPageInRect(nSRect, new NSPoint());
                NSRect nSRect2 = this.printInfo.imageablePageBounds();
                nSRect2.x /= f;
                nSRect2.y /= f;
                nSRect2.width /= f;
                nSRect2.height /= f;
                NSBezierPath.bezierPathWithRect(nSRect2).setClip();
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                nSAffineTransform.translateXBy(nSRect2.x, nSRect2.y);
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                nSAffineTransform.scaleXBy((float)point2.x / (float)point.x, (float)point2.y / (float)point.y);
                nSAffineTransform.concat();
                this.operation.context().saveGraphicsState();
                bl = true;
                Object var11_10 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var11_11 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endPage() {
        this.checkDevice();
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.operation.context().restoreGraphicsState();
            this.view.endPage();
            Object var3_2 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getDPI() {
        Point point;
        block8: {
            NSAutoreleasePool nSAutoreleasePool;
            block6: {
                Object object;
                block7: {
                    this.checkDevice();
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        short[] sArray;
                        int n;
                        int n2 = this.printInfo.PMPrintSession();
                        int[] nArray = new int[1];
                        int n3 = OS.PMSessionGetCurrentPrinter(n2, nArray);
                        if (n3 != 0 || OS.PMSessionGetDestinationType(n2, n = this.printInfo.PMPrintSettings(), sArray = new short[1]) != 0 || sArray[0] != 1) break block6;
                        PMResolution pMResolution = new PMResolution();
                        if (OS.PMPrinterGetOutputResolution(nArray[0], n, pMResolution) != 0 && OS.PMPrinterGetPrinterResolutionCount(nArray[0], object = new int[1]) == 0) {
                            PMResolution pMResolution2 = new PMResolution();
                            pMResolution2.vRes = 300.0;
                            pMResolution2.hRes = 300.0;
                            for (int i = 1; i <= object[0]; ++i) {
                                if (OS.PMPrinterGetIndexedPrinterResolution(nArray[0], i, pMResolution2) != 0 || !(pMResolution2.vRes > pMResolution.vRes) || !(pMResolution2.hRes > pMResolution.hRes)) continue;
                                pMResolution = pMResolution2;
                            }
                        }
                        object = new Point((int)pMResolution.hRes, (int)pMResolution.vRes);
                        Object var12_12 = null;
                        if (nSAutoreleasePool == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var12_14 = null;
                            if (nSAutoreleasePool == null) break block9;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return object;
            }
            point = this.getIndependentDPI();
            Object var12_13 = null;
            if (nSAutoreleasePool == null) break block8;
            nSAutoreleasePool.release();
        }
        return point;
    }

    Point getIndependentDPI() {
        return super.getDPI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSSize nSSize = this.printInfo.paperSize();
                float f = this.scalingFactor();
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                rectangle = new Rectangle(0, 0, (int)(nSSize.width * (float)point.x / (float)point2.x / f), (int)(nSSize.height * (float)point.y / (float)point2.y / f));
                Object var8_7 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getClientArea() {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                float f = this.scalingFactor();
                NSRect nSRect = this.printInfo.imageablePageBounds();
                Point point = this.getDPI();
                Point point2 = this.getIndependentDPI();
                rectangle = new Rectangle(0, 0, (int)(nSRect.width * (float)point.x / (float)point2.x / f), (int)(nSRect.height * (float)point.y / (float)point2.y / f));
                Object var8_7 = null;
                if (nSAutoreleasePool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (nSAutoreleasePool == null) break block4;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return rectangle;
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

