/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.HeaderBlock;
import com.monstarmike.tlmreader.datablock.normalizer.DataNormalizer;
import com.monstarmike.tlmreader.datablock.normalizer.RpmNormalizer;
import com.monstarmike.tlmreader.primitives.Shorts;

public class HeaderRpmBlock
extends HeaderBlock {
    byte poles;
    boolean active;
    short ratioInHunderth;
    short minRpm;
    short maxRpm;
    byte statusReport;
    byte warningReport;

    public HeaderRpmBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
    }

    private void decode(byte[] rawData) {
        this.poles = new Byte(rawData[6]);
        this.active = new Boolean(1 == rawData[7]);
        this.ratioInHunderth = Shorts.fromBytes(rawData[11], rawData[10]);
        this.minRpm = Shorts.fromBytes(rawData[13], rawData[12]);
        this.maxRpm = Shorts.fromBytes(rawData[15], rawData[14]);
        this.statusReport = new Byte(rawData[16]);
        this.warningReport = new Byte(rawData[17]);
    }

    public static boolean isRpmHeader(byte[] bytes) {
        return bytes.length > 6 && bytes[4] == 126 && bytes[5] == 126;
    }

    public String toString() {
        return "RpmHeader; poles: " + this.getPoles() + ", active: " + this.isActive() + ", ratio: " + this.getRatioInHunderth() + ", minRpm: " + this.getMinRpm() + ", maxRpm: " + this.getMaxRpm() + ", statusReport: " + this.getStatusReport() + ", warningReport: " + this.getWarningReport();
    }

    @Override
    public DataNormalizer getNormalizer() {
        return new RpmNormalizer();
    }

    public byte getPoles() {
        return this.poles;
    }

    public boolean isActive() {
        return this.active;
    }

    public short getRatioInHunderth() {
        return this.ratioInHunderth;
    }

    public short getMinRpm() {
        return this.minRpm;
    }

    public short getMaxRpm() {
        return this.maxRpm;
    }

    public String getStatusReport() {
        return this.convertReportTime(this.statusReport);
    }

    public String getWarningReport() {
        return this.convertReportTime(this.warningReport);
    }
}

