# Dezyne --- Dezyne command line tools
#
# Copyright © 2019, 2020, 2021, 2022, 2023, 2024, 2025, 2026 Janneke Nieuwenhuizen <janneke@gnu.org>
# Copyright © 2020, 2021, 2022, 2023, 2024, 2025 Rutger (regtur) van Beusekom <rutger@dezyne.org>
# Copyright © 2020, 2021, 2022, 2023, 2024, 2025 Paul Hoogendijk <paul@dezyne.org>
# Copyright © 2020 Johri van Eerd <vaneerd.johri@gmail.com>
# Copyright © 2020 Rob Wieringa <rma.wieringa@gmail.com>
# Copyright © 2023 Karol Kobiela <karol.kobiela@verum.com>
#
# This file is part of Dezyne.
#
# Dezyne is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Dezyne is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public
# License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.
#
# Commentary:
#
# Code:

EXTRA_DIST += %D%/README

SMOKE_TESTS =					\
 %D%/parse_syntax				\
 %D%/parse_type_mismatch			\
 %D%/hello					\
 %D%/compliance_reply_false

SEMANTIC_TESTS =				\
 %D%/i_world					\
 %D%/ihello					\
 %D%/ihello__world				\
 %D%/ihello_choice				\
 %D%/ihello_cruel__world			\
 %D%/ihello_cruel_world				\
 %D%/ihello_cruelworld				\
 %D%/ihello_i_world				\
 %D%/ihello_optional_choice			\
 %D%/ihello_reply_0				\
 %D%/ihello_reply_bool				\
 %D%/ihello_reply_int				\
 %D%/ihello_reply_true				\
 %D%/ihello_world				\
 %D%/ihellocruel__world				\
 %D%/ihellocruelworld				\
 %D%/ihelloworld				\
 %D%/ihelloworld_reply_true			\
						\
 %D%/hello_block				\
 %D%/hello_block_reply_bool_requires		\
 %D%/hello_block_reply_bool_requires2		\
 %D%/hello_block_requires			\
 %D%/hello_choice				\
 %D%/hello_choice_requires			\
 %D%/hello_cruelworld				\
 %D%/hello_cruelworld_requires			\
 %D%/hello_inevitable_choice			\
 %D%/hello_reply_bool				\
 %D%/hello_reply_bool_requires			\
 %D%/hello_requires				\
 %D%/hello_world				\
 %D%/hello_world_external			\
 %D%/hello_world_external2			\
 %D%/hello_world_requires			\
 %D%/hellocruelworld				\
 %D%/hellocruelworld_requires			\
 %D%/helloworld					\
 %D%/helloworld_external			\
 %D%/helloworld_external2			\
 %D%/helloworld_reply_true			\
 %D%/helloworld_reply_true_requires		\
 %D%/helloworld_requires			\
						\
 %D%/blocking_system				\
 %D%/system_hello_choice_requires		\
 %D%/system_hello_cruelworld_requires		\
 %D%/system_hello_requires			\
 %D%/system_hello_world_requires		\
 %D%/system_hellocruelworld			\
 %D%/system_helloworld_reply_true		\
 %D%/system_helloworld_requires

SEMANTIC_ERROR_TESTS =				\
 %D%/deadlock_ihello				\
 %D%/deadlock_ihellohello			\
 %D%/livelock_ihello				\
						\
 %D%/compliance_hello_world			\
 %D%/compliance_helloworld			\
 %D%/compliance_livelock_refusal		\
 %D%/compliance_refusal_cruel__world		\
 %D%/compliance_refusal_cruel_world		\
 %D%/compliance_refusal_world			\
 %D%/compliance_return				\
 %D%/compliance_return_implicit			\
 %D%/deadlock_hello				\
 %D%/deadlock_hellohello			\
 %D%/determinism_hello_world_external		\
 %D%/livelock_hello

FEATURE_TESTS =					\
 %D%/compliance_external			\
 %D%/cruel_project				\
 %D%/deadlock_implicit				\
 %D%/determinism0				\
 %D%/determinism1				\
 %D%/determinism_interface			\
 %D%/determinism_out				\
 %D%/hello_alpha				\
 %D%/hello_blocking_external			\
 %D%/hello_bool					\
 %D%/hello_circular_import			\
 %D%/hello_comment				\
 %D%/hello_constraint				\
 %D%/hello_constraint_modeling			\
 %D%/hello_constraint_multiple_provides		\
 %D%/hello_cruel_block				\
 %D%/hello_cxx20				\
 %D%/hello_data					\
 %D%/hello_data_argument			\
 %D%/hello_data_assign				\
 %D%/hello_data_function			\
 %D%/hello_data_reply				\
 %D%/hello_defer				\
 %D%/hello_else					\
 %D%/hello_enum					\
 %D%/hello_expression				\
 %D%/hello_external				\
 %D%/hello_foreign_function_bool		\
 %D%/hello_foreign_function_bool_state		\
 %D%/hello_foreign_function_data		\
 %D%/hello_foreign_function_data_space		\
 %D%/hello_foreign_function_enum		\
 %D%/hello_foreign_function_enum_space		\
 %D%/hello_foreign_function_int			\
 %D%/hello_external_inevitable			\
 %D%/hello_flush				\
 %D%/hello_foreign				\
 %D%/hello_function				\
 %D%/hello_function_argument			\
 %D%/hello_function_arguments			\
 %D%/hello_function_assign			\
 %D%/hello_function_enum			\
 %D%/hello_function_shared			\
 %D%/hello_function_variable			\
 %D%/hello_header				\
 %D%/hello_global_function			\
 %D%/hello_guard				\
 %D%/hello_guard_if				\
 %D%/hello_if					\
 %D%/hello_if_action				\
 %D%/hello_import				\
 %D%/hello_incomplete				\
 %D%/hello_inevitable				\
 %D%/hello_injected				\
 %D%/hello_int					\
 %D%/hello_int_guard				\
 %D%/hello_invariant				\
 %D%/hello_local				\
 %D%/hello_local_bool				\
 %D%/hello_locations				\
 %D%/hello_mock					\
 %D%/hello_multiple_choice			\
 %D%/hello_multiple_provides			\
 %D%/hello_nonstrict				\
 %D%/hello_optional				\
 %D%/hello_otherwise				\
 %D%/hello_out					\
 %D%/hello_out_state				\
 %D%/hello_parse				\
 %D%/hello_project				\
 %D%/hello_reorder				\
 %D%/hello_reply				\
 %D%/hello_shared				\
 %D%/hello_shell				\
 %D%/hello_system				\
 %D%/hello_trigger_list				\
 %D%/hello_two					\
 %D%/hello_usuk					\
 %D%/hello_void					\
 %D%/hello_variant				\
 %D%/ihello_mock				\
 %D%/ihello_nonstrict				\
 %D%/illegal_component0				\
 %D%/illegal_interface_incomplete		\
 %D%/inline-functions				\
 %D%/queuefull_component0			\
 %D%/semantics					\
 %D%/state-diagram				\
 %D%/unreachable_component

DOC_SEMANTICS_TESTS =				\
 %D%/direct_in					\
 %D%/direct_out					\
 %D%/indirect_out				\
 %D%/indirect_in				\
 %D%/direct_multiple_out1			\
 %D%/direct_multiple_out2			\
 %D%/indirect_multiple_out1			\
 %D%/indirect_multiple_out2			\
 %D%/indirect_multiple_out3			\
 %D%/indirect_blocking_out			\
 %D%/external_multiple_out1			\
 %D%/external_multiple_out2			\
 %D%/external_multiple_out3			\
 %D%/indirect_blocking_multiple_external_out

REGRESSION_TESTS =				\
 %D%/Camera					\
 %D%/alpha_event				\
 %D%/alpha_field_test				\
 %D%/alpha_local				\
 %D%/alpha_shadow_port				\
 %D%/alpha_variable				\
 %D%/assign_formal				\
 %D%/bool_expressions				\
 %D%/blocking-local-state-diagram		\
 %D%/blocking_local_state			\
 %D%/blocking_binding				\
 %D%/blocking_bottom_system			\
 %D%/blocking_cancel_race			\
 %D%/blocking_cancel_race_bool			\
 %D%/blocking_choice				\
 %D%/blocking_defer				\
 %D%/blocking_external				\
 %D%/blocking_external2				\
 %D%/blocking_function_reply			\
 %D%/blocking_function_reply2			\
 %D%/blocking_function_skip			\
 %D%/blocking_if_action_in_function		\
 %D%/blocking_if_skip				\
 %D%/blocking_imperative			\
 %D%/blocking_multiple_provides0		\
 %D%/blocking_multiple_provides2		\
 %D%/blocking_multiple_provides3		\
 %D%/blocking_mux				\
 %D%/blocking_normalize				\
 %D%/blocking_optional				\
 %D%/blocking_provides_state			\
 %D%/blocking_race				\
 %D%/blocking_release				\
 %D%/blocking_requires				\
 %D%/blocking_requires_normalize		\
 %D%/blocking_shared_reply			\
 %D%/blocking_shell				\
 %D%/blocking_skip				\
 %D%/blocking_skip_race				\
 %D%/blocking_sync_asynchronous_out		\
 %D%/blocking_system2				\
 %D%/blocking_system3				\
 %D%/blocking_system4				\
 %D%/blocking_system_diamond			\
 %D%/call_before_variable			\
 %D%/calling_context				\
 %D%/choice_invariant				\
 %D%/circular_import_directory			\
 %D%/clash_event_name				\
 %D%/clash_port_variable			\
 %D%/closed_system_foreigns			\
 %D%/collateral_blocking			\
 %D%/collateral_blocking_backdoor		\
 %D%/collateral_blocking_backdoor_bypass	\
 %D%/collateral_blocking_bridges		\
 %D%/collateral_blocking_double_release		\
 %D%/collateral_blocking_multiple_provides	\
 %D%/collateral_blocking_multiple_provides0	\
 %D%/collateral_blocking_multiple_provides2	\
 %D%/collateral_blocking_out			\
 %D%/collateral_blocking_out2			\
 %D%/collateral_blocking_release		\
 %D%/collateral_blocking_reorder		\
 %D%/collateral_blocking_reorder_bypass		\
 %D%/collateral_blocking_reorder_parallel	\
 %D%/collateral_blocking_reply			\
 %D%/collateral_blocking_shared_reply		\
 %D%/collateral_blocking_shell			\
 %D%/collateral_blocking_shell2			\
 %D%/collateral_blocking_top			\
 %D%/collateral_cancel_guarantee		\
 %D%/collateral_double_blocked			\
 %D%/collateral_double_blocked_out		\
 %D%/collateral_illegal				\
 %D%/comment_traceability			\
 %D%/complex_and				\
 %D%/complex_arguments0				\
 %D%/complex_arguments1				\
 %D%/complex_arguments2				\
 %D%/complex_arguments3				\
 %D%/complex_arguments4				\
 %D%/complex_arguments5				\
 %D%/complex_arguments6				\
 %D%/complex_assign0				\
 %D%/complex_assign1				\
 %D%/complex_assign2				\
 %D%/complex_assign3				\
 %D%/complex_assign4				\
 %D%/complex_assign5				\
 %D%/complex_data				\
 %D%/complex_expressions			\
 %D%/complex_int0				\
 %D%/complex_int1				\
 %D%/complex_int2				\
 %D%/complex_int3				\
 %D%/complex_int4				\
 %D%/complex_member				\
 %D%/complex_not0				\
 %D%/complex_not1				\
 %D%/complex_not2				\
 %D%/complex_not3				\
 %D%/complex_not4				\
 %D%/complex_not5				\
 %D%/complex_or					\
 %D%/compliance_blocking_double_release		\
 %D%/compliance_blocking_double_release2	\
 %D%/compliance_blocking_function		\
 %D%/compliance_blocking_multiple_provides	\
 %D%/compliance_blocking_out			\
 %D%/compliance_defer				\
 %D%/compliance_determinism_optional		\
 %D%/compliance_external_inevitable		\
 %D%/compliance_failures_blocking		\
 %D%/compliance_failures_blocking_race		\
 %D%/compliance_failures_choice			\
 %D%/compliance_failures_defer			\
 %D%/compliance_failures_inevitable		\
 %D%/compliance_failures_inevitable_optional    \
 %D%/compliance_failures_multiple_provides	\
 %D%/compliance_failures_optional		\
 %D%/compliance_failures_reply			\
 %D%/compliance_fork_blocking_bypass		\
 %D%/compliance_fork_lookup			\
 %D%/compliance_fork_provides			\
 %D%/compliance_fork_requires			\
 %D%/compliance_fork_requires2			\
 %D%/compliance_invalid_action			\
 %D%/compliance_livelock			\
 %D%/compliance_livelock_escape			\
 %D%/compliance_nonsynchronous_sync		\
 %D%/compliance_optional			\
 %D%/compliance_out_sync			\
 %D%/compliance_provides_bool			\
 %D%/compliance_provides_enum			\
 %D%/compliance_provides_illegal		\
 %D%/compliance_provides_illegal4		\
 %D%/compliance_provides_illegal5		\
 %D%/compliance_provides_int			\
 %D%/compliance_provides_out			\
 %D%/compliance_reply_bool			\
 %D%/compliance_reply_illegal			\
 %D%/compliance_requires_illegal		\
 %D%/compliance_second_out_action		\
 %D%/compliance_single_to_multiple		\
 %D%/compliance_sync_action			\
 %D%/compliance_system_provides_bool		\
 %D%/component_missing_reply			\
 %D%/component_modeling_loop			\
 %D%/compound.space				\
 %D%/constraint_choice				\
 %D%/constraint_choice2				\
 %D%/constraint_modeling_choice			\
 %D%/cruise-control				\
 %D%/cxx_enum_to_string				\
 %D%/data_full					\
 %D%/deadlock_asynchronous_sync_reply		\
 %D%/deadlock_blocking_compliance		\
 %D%/deadlock_blocking_flush			\
 %D%/deadlock_blocking_guard			\
 %D%/deadlock_blocking_inevitable		\
 %D%/deadlock_blocking_optional			\
 %D%/deadlock_blocking_replies			\
 %D%/deadlock_defer_calls			\
 %D%/deadlock_inner_guard_shared_state		\
 %D%/deadlock_interface_determinism		\
 %D%/deadlock_optional_out_only			\
 %D%/deadlock_port_blocked			\
 %D%/deadlock_reply				\
 %D%/deadlock_reply_modeling			\
 %D%/deadlock_state				\
 %D%/defer_after_call				\
 %D%/defer_async				\
 %D%/defer_blocking				\
 %D%/defer_cancel				\
 %D%/defer_cancel_call				\
 %D%/defer_collateral_blocking			\
 %D%/defer_cruel				\
 %D%/defer_data					\
 %D%/defer_data_no_state			\
 %D%/defer_double				\
 %D%/defer_empty_selection			\
 %D%/defer_foreign				\
 %D%/defer_local				\
 %D%/defer_local_field_test			\
 %D%/defer_locals				\
 %D%/defer_loop					\
 %D%/defer_if					\
 %D%/defer_nested				\
 %D%/defer_nested_parallel			\
 %D%/defer_parallel				\
 %D%/defer_poll					\
 %D%/defer_priority				\
 %D%/defer_selection				\
 %D%/defer_shadow				\
 %D%/defer_twice				\
 %D%/defer_twice_noisy				\
 %D%/defer_typed_call				\
 %D%/determinism_deadlock			\
 %D%/determinism_shared				\
 %D%/determinism_shared2			\
 %D%/determinism_modeling			\
 %D%/determinism_silent				\
 %D%/dining_philosophers			\
 %D%/dollars					\
 %D%/dollar_import				\
 %D%/double_collateral_blocking_shell		\
 %D%/double_hello_block				\
 %D%/double_inevitable				\
 %D%/empty_dollars				\
 %D%/empty_system				\
 %D%/end_of_trail				\
 %D%/end_of_trail_action			\
 %D%/end_of_trail_action2			\
 %D%/end_of_trail_interface			\
 %D%/end_of_trail_interface_action		\
 %D%/end_of_trail_int				\
 %D%/enum_expressions				\
 %D%/enum_only					\
 %D%/equal_binary				\
 %D%/extern_in_interface			\
 %D%/external_asynchronous_sync			\
 %D%/external_blocking_livelock                 \
 %D%/external_requires_twice			\
 %D%/failures_inevitable			\
 %D%/failures_nondet_inevitable			\
 %D%/failures_second_inevitable			\
 %D%/flush_inevitable_sync_out			\
 %D%/foreign_function_shadow_event		\
 %D%/foreign_function_space_function		\
 %D%/foreign_handwritten			\
 %D%/foreign_import				\
 %D%/foreign_import_system			\
 %D%/foreign_import_two				\
 %D%/foreign_injected				\
 %D%/foreign_multiple_provides			\
 %D%/foreign_namespace				\
 %D%/foreign_only				\
 %D%/foreign_only_flush				\
 %D%/foreign_optional				\
 %D%/foreign_reply				\
 %D%/foreign_requires				\
 %D%/foreign_trivial_integration		\
 %D%/foreign_trivial_proxied			\
 %D%/formal_binding				\
 %D%/function_early_return			\
 %D%/function_if				\
 %D%/function_reply_early_return		\
 %D%/global_function_chain			\
 %D%/global_function_shadow			\
 %D%/global_function_space			\
 %D%/guard_expressions				\
 %D%/guard_predicates				\
 %D%/generalized_integer			\
 %D%/generalized_integer_temporaries		\
 %D%/hash_collision				\
 %D%/hash_collision2				\
 %D%/hello_blocking_asynchronous_sync_out	\
 %D%/hello_blocking_multiple_out		\
 %D%/hello_check_bindings			\
 %D%/hello_choice2				\
 %D%/hello_choice3				\
 %D%/hello_choice_action			\
 %D%/hello_choice_async				\
 %D%/hello_choice_defer				\
 %D%/hello_choice_reply				\
 %D%/hello_complete_action			\
 %D%/hello_complete_reply			\
 %D%/hello_enum_function			\
 %D%/hello_foreign_file				\
 %D%/hello_foreign_path				\
 %D%/hello_function_local			\
 %D%/hello_function_local_nest			\
 %D%/hello_functions_local			\
 %D%/hello_function_nest			\
 %D%/hello_function_void_bool_if		\
 %D%/hello_functions				\
 %D%/hello_garbage				\
 %D%/hello_guard_two				\
 %D%/hello_hello_block				\
 %D%/hello_ifelse				\
 %D%/hello_ifif					\
 %D%/hello_implicit_enum			\
 %D%/hello_implicit_illegal			\
 %D%/hello_implicit_temporaries			\
 %D%/hello_import_component			\
 %D%/hello_imported				\
 %D%/hello_inevitable_action			\
 %D%/hello_inevitable_blocking_sync_out		\
 %D%/hello_inevitable_hidden			\
 %D%/hello_inevitable_illegal			\
 %D%/hello_interface_function			\
 %D%/hello_interface_optional			\
 %D%/hello_local_assign				\
 %D%/hello_local_enum				\
 %D%/hello_match				\
 %D%/hello_multiple_out				\
 %D%/hello_multiple_provides_requires		\
 %D%/hello_namespace_enum			\
 %D%/hello_namespace_foreign			\
 %D%/hello_namespace_shadow			\
 %D%/hello_namespace_shadow2			\
 %D%/hello_no_compliance			\
 %D%/hello_optional_flush			\
 %D%/hello_out_data				\
 %D%/hello_out_provides				\
 %D%/hello_provides				\
 %D%/hello_recursive				\
 %D%/hello_shadow				\
 %D%/hello_sync_out_reply			\
 %D%/hello_systems				\
 %D%/hello_tail_recursive_function		\
 %D%/hello_tick					\
 %D%/hello_true_guard				\
 %D%/hello_unused_assign			\
 %D%/hellofundata				\
 %D%/hellointbug				\
 %D%/hellooutevent				\
 %D%/helloparam					\
 %D%/helloparams				\
 %D%/huge_interface				\
 %D%/huge_constraint				\
 %D%/if_return_arrow				\
 %D%/ihello_int_1_1_reply_0			\
 %D%/ihello_optional_choice2			\
 %D%/ihello_optional_choice3			\
 %D%/ihello_optional_choice4			\
 %D%/illegal_blocking_race			\
 %D%/illegal_external				\
 %D%/illegal_external_inevitable		\
 %D%/illegal_external_requires_twice		\
 %D%/illegal_external_requires_twice2		\
 %D%/illegal_garbage				\
 %D%/illegal_interface.space			\
 %D%/illegal_optional				\
 %D%/illegal_pessimism_external			\
 %D%/illegal_provides				\
 %D%/illegal_requires				\
 %D%/illegal_requires_out			\
 %D%/illegal_system_requires			\
 %D%/implicit_illegal_garbage			\
 %D%/implicit_temporary0			\
 %D%/implicit_temporary1			\
 %D%/implicit_temporary2			\
 %D%/implicit_temporary3			\
 %D%/implicit_temporary4			\
 %D%/implicit_temporary5			\
 %D%/import_cycle				\
 %D%/implies_expressions			\
 %D%/import_path				\
 %D%/imported.space				\
 %D%/inevitable_multiple_requires		\
 %D%/inevitable_performance			\
 %D%/injected_dangling				\
 %D%/injected_foreign				\
 %D%/inner.space				\
 %D%/integer_expressions			\
 %D%/interface_action_missing_reply		\
 %D%/interface_enum				\
 %D%/interface_int				\
 %D%/interface_missing_reply			\
 %D%/invariant_blocking_two_out			\
 %D%/invariant_functions_expression		\
 %D%/invariant_group_expressions 		\
 %D%/invariant_guarded				\
 %D%/invariant_out_forward			\
 %D%/invariant_sync_out				\
 %D%/invariant_two_out				\
 %D%/iteration					\
 %D%/label_instance_mismatch			\
 %D%/list-models				\
 %D%/livelock_choice				\
 %D%/livelock_iterator				\
 %D%/livelock_recurse				\
 %D%/livelock_synchronous			\
 %D%/livelock_unfold				\
 %D%/match_blocking_race			\
 %D%/missing_reply				\
 %D%/multiple_provides				\
 %D%/name.space					\
 %D%/nested.space.interface_function		\
 %D%/nested.space.system_hello			\
 %D%/no_return					\
 %D%/no_unreachable				\
 %D%/parameter_shadow_port			\
 %D%/parameter_shadow_function			\
 %D%/port_shadow_interface			\
 %D%/pump_twice					\
 %D%/queue_size_four				\
 %D%/queuefull_collateral			\
 %D%/queuefull_collateral_reply			\
 %D%/queuefull_component1			\
 %D%/queuefull_constraint_defer			\
 %D%/queuefull_defer				\
 %D%/queuefull_external				\
 %D%/queuefull_external2			\
 %D%/range_action				\
 %D%/range_argument				\
 %D%/range_assign				\
 %D%/range_assign_expression			\
 %D%/range_call					\
 %D%/range_local				\
 %D%/range_local_expression			\
 %D%/range_member				\
 %D%/range_return				\
 %D%/reachable_expression_function		\
 %D%/reply_data_action_call			\
 %D%/reply_data_call_action			\
 %D%/reply_data_full				\
 %D%/reply_expression				\
 %D%/reply_extern				\
 %D%/requires_twice				\
 %D%/resolve_formal_shadow			\
 %D%/resolve_member				\
 %D%/reuse_body					\
 %D%/second_reply				\
 %D%/second_reply_sync				\
 %D%/second_reply_blocking			\
 %D%/shadow_port				\
 %D%/shadow_port2				\
 %D%/shadow_shared_enum				\
 %D%/shared_assign				\
 %D%/shared_async_provides			\
 %D%/shared_async_requires			\
 %D%/shared_block				\
 %D%/shared_blocking_race			\
 %D%/shared_choice				\
 %D%/shared_choice2				\
 %D%/shared_defer				\
 %D%/shared_defer2				\
 %D%/shared_defer_trailing_assign		\
 %D%/shared_double_inevitable			\
 %D%/shared_enum				\
 %D%/shared_field_test				\
 %D%/shared_function				\
 %D%/shared_glue				\
 %D%/shared_indirect_type			\
 %D%/shared_multiple_provides			\
 %D%/shared_nested				\
 %D%/shared_no_function				\
 %D%/shared_out_sync_provides			\
 %D%/shared_out_sync_requires			\
 %D%/shared_reply				\
 %D%/shared_requires				\
 %D%/shared_requires_guard			\
 %D%/shared_state_defer				\
 %D%/shared_guarded_trailing_assign		\
 %D%/shared_trailing_assign			\
 %D%/shared_type_lookup				\
 %D%/shared_variable				\
 %D%/shell_injected_foreign			\
 %D%/simplify_guards				\
 %D%/space.function				\
 %D%/space.shell				\
 %D%/space.foreign				\
 %D%/space.foreign_functions			\
 %D%/space.import_interface_shadow		\
 %D%/space.interface_function			\
 %D%/space.interface_shadow			\
 %D%/space.space				\
 %D%/space.wostream				\
 %D%/starving_philosophers			\
 %D%/stateful_injected				\
 %D%/step_state					\
 %D%/stress_comment				\
 %D%/sync_out_reply_binding			\
 %D%/sync_out_reply_enum			\
 %D%/system_bool_enum				\
 %D%/system_check_bindings			\
 %D%/system_defer				\
 %D%/system_double_inevitable			\
 %D%/system_double_out				\
 %D%/system_flush				\
 %D%/system_flush_double			\
 %D%/system_foreign_only			\
 %D%/system_foreign_only_flush			\
 %D%/system_import_foreign			\
 %D%/system_hello_choice_reply			\
 %D%/system_helloworld				\
 %D%/system_inevitable				\
 %D%/system_mix_bindings			\
 %D%/system_optional				\
 %D%/system_out					\
 %D%/system_out_internal			\
 %D%/system_out_two				\
 %D%/system_reply_bool				\
 %D%/system_reply_data				\
 %D%/system_reply_enum				\
 %D%/system_shared_choice2			\
 %D%/system_shared_defer			\
 %D%/unreachable_constraint			\
 %D%/unreachable_crosstalk			\
 %D%/unreachable_defer		 		\
 %D%/unreachable_determinism			\
 %D%/unreachable_function			\
 %D%/unreachable_if				\
 %D%/unreachable_interface	 		\
 %D%/unreachable_multiple_provides		\
 %D%/unreachable_multiple_triggers		\
 %D%/unreachable_predicates			\
 %D%/unreachable_return				\
 %D%/unused_assign				\
 %D%/unused_event				\
 %D%/unused_function				\
 %D%/unused_interface_type			\
 %D%/variant_blocking_out			\
 %D%/variant_component				\
 %D%/variant_defer				\
 %D%/variant_immediately			\
 %D%/variant_interface				\
 %D%/variant_out				\
 %D%/wostream

PARSER_TESTS =					\
 %D%/code-json					\
 %D%/parse-flags				\
 %D%/parse_assign_void				\
 %D%/parse_block_comment_import			\
 %D%/parse_component_shadow_missing_event	\
 %D%/parse_component_without_trigger		\
 %D%/parse_defer				\
 %D%/parse_defer_expression			\
 %D%/parse_defer_shared				\
 %D%/parse_duplicate_definition			\
 %D%/parse_duplicate_import_prefix		\
 %D%/parse_function_shadow_event		\
 %D%/parse_function_shadow_port			\
 %D%/parse_formal_shadow_type			\
 %D%/parse_imperative_guard			\
 %D%/parse_import_both				\
 %D%/parse_import_end				\
 %D%/parse_import_order				\
 %D%/parse_import_path				\
 %D%/parse_import_self				\
 %D%/parse_import_twice				\
 %D%/parse_interface_parens			\
 %D%/parse_locations				\
 %D%/parse_missing_event			\
 %D%/parse_mixing_imperative			\
 %D%/parse_non_existent_import			\
 %D%/parse_on_without_statement			\
 %D%/parse_out_binding				\
 %D%/parse_out_binding_argument			\
 %D%/parse_fall_back_import_path 		\
 %D%/parse_fall_back_import_self 		\
 %D%/parse_fall_back_non_existent_import 	\
 %D%/parse_fall_back_out_binding_argument 	\
 %D%/parse_fall_back_preprocessed_foo 		\
 %D%/parse_fall_back_preprocessed_imported_bar 	\
 %D%/parse_fall_back_preprocessed_imported_baz 	\
 %D%/parse_fall_back_syntax 			\
 %D%/parse_function_out_state			\
 %D%/parse_parameter_mismatch			\
 %D%/parse_peg_locations			\
 %D%/parse_preprocessed_foo			\
 %D%/parse_preprocessed_imported_bar		\
 %D%/parse_preprocessed_imported_baz		\
 %D%/parse.space.lookup				\
 %D%/parse_port_qualifier			\
 %D%/parse_predicate				\
 %D%/parse_reply_void_expression		\
 %D%/parse_return_void_expression		\
 %D%/parse_space_duplicate_definition		\
 %D%/parse_unknown_enum				\
 %D%/parse_void_parameter			\
 %D%/parse_void_variable			\
 %D%/wf_actionNotInOnEvent			\
 %D%/wf_actionValueDiscarded			\
 %D%/wf_assignmentExpressionNotInEventInstance	\
 %D%/wf_assignmentNotInOnEvent			\
 %D%/wf_bindingCycle				\
 %D%/wf_bindingDoubleWildcard			\
 %D%/wf_bindingExternals			\
 %D%/wf_bindingPortBoundTwice			\
 %D%/wf_bindingPortDirection			\
 %D%/wf_bindingPortNotBound			\
 %D%/wf_bindingRequiredWildcard			\
 %D%/wf_bindingSameType				\
 %D%/wf_blockingInblocking			\
 %D%/wf_blockingInInterface			\
 %D%/wf_blockingReply				\
 %D%/wf_blocking_port				\
 %D%/wf_componentNeedsProvides			\
 %D%/wf_componentNeedsTrigger			\
 %D%/wf_coverageDuplicate			\
 %D%/wf_coverageUnexpected			\
 %D%/wf_dataInoutInOutEvent			\
 %D%/wf_dataOutInOutEvent			\
 %D%/wf_declarativeImperative			\
 %D%/wf_definedBefore				\
 %D%/wf_eventNotAction				\
 %D%/wf_eventNotTrigger				\
 %D%/wf_eventNotValuedAction			\
 %D%/wf_expressionExpected			\
 %D%/wf_foreign_conflict			\
 %D%/wf_functionReturnNotExpected		\
 %D%/wf_functionReturnValue			\
 %D%/wf_functionTailRecursion			\
 %D%/wf_functionValueDiscarded			\
 %D%/wf_illegalInFunction			\
 %D%/wf_illegalInIf				\
 %D%/wf_illegalOnlyStatement			\
 %D%/wf_imperativeDeclarative			\
 %D%/wf_injectionOutEvent			\
 %D%/wf_interfaceMustDefineBehavior		\
 %D%/wf_interfaceMustDefineEvent		\
 %D%/wf_missing_bindings			\
 %D%/wf_NameClash				\
 %D%/wf_notPort					\
 %D%/wf_onEventInOnEvent			\
 %D%/wf_otherwiseWithNonGuard			\
 %D%/wf_otherwiseWithOtherwise			\
 %D%/wf_outEventNonVoidReturn			\
 %D%/wf_parameterBinding			\
 %D%/wf_parameterDataType			\
 %D%/wf_replyFunctionExpression			\
 %D%/wf_replyFunctionMultiplePort		\
 %D%/wf_replyOnOutEventMultiplePort		\
 %D%/wf_replyOnPort				\
 %D%/wf_replyOnType				\
 %D%/wf_replyPort				\
 %D%/wf_replyRequiresPort			\
 %D%/wf_replyTypeMismatch			\
 %D%/wf_subintMinMax				\
 %D%/wf_systemRecursion				\
 %D%/wf_typeerror				\
 %D%/wf_undefined				\
 %D%/wf_undefined_function			\
 %D%/wf_variableInitExpression			\
 %D%/undefined/and				\
 %D%/undefined/group				\
 %D%/undefined/not				\
 %D%/undefined/reply				\
 %D%/undefined/return				\
 %D%/undefined/component/action			\
 %D%/undefined/component/action_type		\
 %D%/undefined/component/argument		\
 %D%/undefined/component/argument_seen		\
 %D%/undefined/component/enum_as_action		\
 %D%/undefined/component/port			\
 %D%/undefined/interface/shared			\
 %D%/undefined/component/trigger		\
 %D%/undefined/foreign/port_type		\
 %D%/undefined/formal_type			\
 %D%/undefined/guard				\
 %D%/undefined/if				\
 %D%/undefined/interface/action			\
 %D%/undefined/interface/call_in_function	\
 %D%/undefined/interface/function		\
 %D%/undefined/interface/shared			\
 %D%/undefined/interface/trigger		\
 %D%/undefined/var

USAGE_TESTS = 					\
 %D%/usage/code/shell

UNSTABLE_TESTS =				\
 %D%/illegal_external_nonsynchronous		\
 %D%/livelock_synchronous_illegal		\
 %D%/queuefull_external_sync

XFAIL_LTS =					\
 %D%/compliance_single_to_multiple

XFAIL_PARSE =					\
 %D%/comment_traceability

XFAIL_VERIFY =					\
 %D%/blocking_defer				\
 %D%/compliance_livelock			\
 %D%/compliance_livelock_escape			\
 %D%/compliance_livelock_refusal		\
 %D%/external_blocking_livelock

XFAIL_SIMULATE =				\
 %D%/blocking_shared_reply			\
 %D%/compliance_livelock

XFAIL_TESTS =					\
 $(XFAIL_LTS)					\
 $(XFAIL_PARSE)					\
 $(XFAIL_VERIFY)				\
 $(XFAIL_SIMULATE)

HELLO_TESTS =					\
 $(SMOKE_TESTS)					\
 $(SEMANTIC_TESTS)				\
 $(FEATURE_TESTS)

FULL_TESTS =					\
 $(SMOKE_TESTS)					\
 $(SEMANTIC_TESTS)				\
 $(SEMANTIC_ERROR_TESTS)			\
 $(HELLO_TESTS)					\
 $(DOC_SEMANTICS_TESTS)				\
 $(PARSER_TESTS)				\
 $(REGRESSION_TESTS)				\
 $(UNSTABLE_TESTS)				\
 $(USAGE_TESTS)

dzn_exampledir = $(pkgdatadir)/examples
nodist_dzn_example_DATA =				\
 %D%/cruise-control/cruise-control-interfaces.dzn	\
 %D%/cruise-control/cruise-control.dzn			\
 %D%/ihello/ihello.dzn					\
 %D%/hello/hello.dzn
