require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_KVM_H)) {
    eval 'sub __LINUX_KVM_H () {1;}' unless defined(&__LINUX_KVM_H);
    require 'linux/const.ph';
    require 'linux/types.ph';
    require 'linux/ioctl.ph';
    require 'asm/kvm.ph';
    eval 'sub KVM_API_VERSION () {12;}' unless defined(&KVM_API_VERSION);
    eval 'sub __KVM_HAVE_GUEST_DEBUG () {1;}' unless defined(&__KVM_HAVE_GUEST_DEBUG);
    eval 'sub KVM_MEM_LOG_DIRTY_PAGES () {(1 << 0);}' unless defined(&KVM_MEM_LOG_DIRTY_PAGES);
    eval 'sub KVM_MEM_READONLY () {(1 << 1);}' unless defined(&KVM_MEM_READONLY);
    eval 'sub KVM_MEM_GUEST_MEMFD () {(1 << 2);}' unless defined(&KVM_MEM_GUEST_MEMFD);
    if(defined(&__KVM_HAVE_PIT)) {
    }
    if(defined(&__KVM_HAVE_IOAPIC)) {
    }
    eval 'sub KVM_PIT_SPEAKER_DUMMY () {1;}' unless defined(&KVM_PIT_SPEAKER_DUMMY);
    eval 'sub KVM_EXIT_HYPERV_SYNIC () {1;}' unless defined(&KVM_EXIT_HYPERV_SYNIC);
    eval 'sub KVM_EXIT_HYPERV_HCALL () {2;}' unless defined(&KVM_EXIT_HYPERV_HCALL);
    eval 'sub KVM_EXIT_HYPERV_SYNDBG () {3;}' unless defined(&KVM_EXIT_HYPERV_SYNDBG);
    eval 'sub KVM_EXIT_XEN_HCALL () {1;}' unless defined(&KVM_EXIT_XEN_HCALL);
    eval 'sub KVM_S390_GET_SKEYS_NONE () {1;}' unless defined(&KVM_S390_GET_SKEYS_NONE);
    eval 'sub KVM_S390_SKEYS_MAX () {1048576;}' unless defined(&KVM_S390_SKEYS_MAX);
    eval 'sub KVM_EXIT_UNKNOWN () {0;}' unless defined(&KVM_EXIT_UNKNOWN);
    eval 'sub KVM_EXIT_EXCEPTION () {1;}' unless defined(&KVM_EXIT_EXCEPTION);
    eval 'sub KVM_EXIT_IO () {2;}' unless defined(&KVM_EXIT_IO);
    eval 'sub KVM_EXIT_HYPERCALL () {3;}' unless defined(&KVM_EXIT_HYPERCALL);
    eval 'sub KVM_EXIT_DEBUG () {4;}' unless defined(&KVM_EXIT_DEBUG);
    eval 'sub KVM_EXIT_HLT () {5;}' unless defined(&KVM_EXIT_HLT);
    eval 'sub KVM_EXIT_MMIO () {6;}' unless defined(&KVM_EXIT_MMIO);
    eval 'sub KVM_EXIT_IRQ_WINDOW_OPEN () {7;}' unless defined(&KVM_EXIT_IRQ_WINDOW_OPEN);
    eval 'sub KVM_EXIT_SHUTDOWN () {8;}' unless defined(&KVM_EXIT_SHUTDOWN);
    eval 'sub KVM_EXIT_FAIL_ENTRY () {9;}' unless defined(&KVM_EXIT_FAIL_ENTRY);
    eval 'sub KVM_EXIT_INTR () {10;}' unless defined(&KVM_EXIT_INTR);
    eval 'sub KVM_EXIT_SET_TPR () {11;}' unless defined(&KVM_EXIT_SET_TPR);
    eval 'sub KVM_EXIT_TPR_ACCESS () {12;}' unless defined(&KVM_EXIT_TPR_ACCESS);
    eval 'sub KVM_EXIT_S390_SIEIC () {13;}' unless defined(&KVM_EXIT_S390_SIEIC);
    eval 'sub KVM_EXIT_S390_RESET () {14;}' unless defined(&KVM_EXIT_S390_RESET);
    eval 'sub KVM_EXIT_DCR () {15;}' unless defined(&KVM_EXIT_DCR);
    eval 'sub KVM_EXIT_NMI () {16;}' unless defined(&KVM_EXIT_NMI);
    eval 'sub KVM_EXIT_INTERNAL_ERROR () {17;}' unless defined(&KVM_EXIT_INTERNAL_ERROR);
    eval 'sub KVM_EXIT_OSI () {18;}' unless defined(&KVM_EXIT_OSI);
    eval 'sub KVM_EXIT_PAPR_HCALL () {19;}' unless defined(&KVM_EXIT_PAPR_HCALL);
    eval 'sub KVM_EXIT_S390_UCONTROL () {20;}' unless defined(&KVM_EXIT_S390_UCONTROL);
    eval 'sub KVM_EXIT_WATCHDOG () {21;}' unless defined(&KVM_EXIT_WATCHDOG);
    eval 'sub KVM_EXIT_S390_TSCH () {22;}' unless defined(&KVM_EXIT_S390_TSCH);
    eval 'sub KVM_EXIT_EPR () {23;}' unless defined(&KVM_EXIT_EPR);
    eval 'sub KVM_EXIT_SYSTEM_EVENT () {24;}' unless defined(&KVM_EXIT_SYSTEM_EVENT);
    eval 'sub KVM_EXIT_S390_STSI () {25;}' unless defined(&KVM_EXIT_S390_STSI);
    eval 'sub KVM_EXIT_IOAPIC_EOI () {26;}' unless defined(&KVM_EXIT_IOAPIC_EOI);
    eval 'sub KVM_EXIT_HYPERV () {27;}' unless defined(&KVM_EXIT_HYPERV);
    eval 'sub KVM_EXIT_ARM_NISV () {28;}' unless defined(&KVM_EXIT_ARM_NISV);
    eval 'sub KVM_EXIT_X86_RDMSR () {29;}' unless defined(&KVM_EXIT_X86_RDMSR);
    eval 'sub KVM_EXIT_X86_WRMSR () {30;}' unless defined(&KVM_EXIT_X86_WRMSR);
    eval 'sub KVM_EXIT_DIRTY_RING_FULL () {31;}' unless defined(&KVM_EXIT_DIRTY_RING_FULL);
    eval 'sub KVM_EXIT_AP_RESET_HOLD () {32;}' unless defined(&KVM_EXIT_AP_RESET_HOLD);
    eval 'sub KVM_EXIT_X86_BUS_LOCK () {33;}' unless defined(&KVM_EXIT_X86_BUS_LOCK);
    eval 'sub KVM_EXIT_XEN () {34;}' unless defined(&KVM_EXIT_XEN);
    eval 'sub KVM_EXIT_RISCV_SBI () {35;}' unless defined(&KVM_EXIT_RISCV_SBI);
    eval 'sub KVM_EXIT_RISCV_CSR () {36;}' unless defined(&KVM_EXIT_RISCV_CSR);
    eval 'sub KVM_EXIT_NOTIFY () {37;}' unless defined(&KVM_EXIT_NOTIFY);
    eval 'sub KVM_EXIT_LOONGARCH_IOCSR () {38;}' unless defined(&KVM_EXIT_LOONGARCH_IOCSR);
    eval 'sub KVM_EXIT_MEMORY_FAULT () {39;}' unless defined(&KVM_EXIT_MEMORY_FAULT);
    eval 'sub KVM_EXIT_TDX () {40;}' unless defined(&KVM_EXIT_TDX);
    eval 'sub KVM_EXIT_ARM_SEA () {41;}' unless defined(&KVM_EXIT_ARM_SEA);
    eval 'sub KVM_INTERNAL_ERROR_EMULATION () {1;}' unless defined(&KVM_INTERNAL_ERROR_EMULATION);
    eval 'sub KVM_INTERNAL_ERROR_SIMUL_EX () {2;}' unless defined(&KVM_INTERNAL_ERROR_SIMUL_EX);
    eval 'sub KVM_INTERNAL_ERROR_DELIVERY_EV () {3;}' unless defined(&KVM_INTERNAL_ERROR_DELIVERY_EV);
    eval 'sub KVM_INTERNAL_ERROR_UNEXPECTED_EXIT_REASON () {4;}' unless defined(&KVM_INTERNAL_ERROR_UNEXPECTED_EXIT_REASON);
    eval 'sub KVM_INTERNAL_ERROR_EMULATION_FLAG_INSTRUCTION_BYTES () {(1 << 0);}' unless defined(&KVM_INTERNAL_ERROR_EMULATION_FLAG_INSTRUCTION_BYTES);
    eval 'sub HINT_UNSAFE_IN_KVM {
        my($_symbol) = @_;
	    eval q($_symbol);
    }' unless defined(&HINT_UNSAFE_IN_KVM);
    if(defined(&__KVM_S390)) {
    }
    eval 'sub KVM_EXIT_IO_IN () {0;}' unless defined(&KVM_EXIT_IO_IN);
    eval 'sub KVM_EXIT_IO_OUT () {1;}' unless defined(&KVM_EXIT_IO_OUT);
    eval 'sub KVM_SYSTEM_EVENT_SHUTDOWN () {1;}' unless defined(&KVM_SYSTEM_EVENT_SHUTDOWN);
    eval 'sub KVM_SYSTEM_EVENT_RESET () {2;}' unless defined(&KVM_SYSTEM_EVENT_RESET);
    eval 'sub KVM_SYSTEM_EVENT_CRASH () {3;}' unless defined(&KVM_SYSTEM_EVENT_CRASH);
    eval 'sub KVM_SYSTEM_EVENT_WAKEUP () {4;}' unless defined(&KVM_SYSTEM_EVENT_WAKEUP);
    eval 'sub KVM_SYSTEM_EVENT_SUSPEND () {5;}' unless defined(&KVM_SYSTEM_EVENT_SUSPEND);
    eval 'sub KVM_SYSTEM_EVENT_SEV_TERM () {6;}' unless defined(&KVM_SYSTEM_EVENT_SEV_TERM);
    eval 'sub KVM_SYSTEM_EVENT_TDX_FATAL () {7;}' unless defined(&KVM_SYSTEM_EVENT_TDX_FATAL);
    eval 'sub KVM_MSR_EXIT_REASON_INVAL () {(1<< 0);}' unless defined(&KVM_MSR_EXIT_REASON_INVAL);
    eval 'sub KVM_MSR_EXIT_REASON_UNKNOWN () {(1<< 1);}' unless defined(&KVM_MSR_EXIT_REASON_UNKNOWN);
    eval 'sub KVM_MSR_EXIT_REASON_FILTER () {(1<< 2);}' unless defined(&KVM_MSR_EXIT_REASON_FILTER);
    eval 'sub KVM_MSR_EXIT_REASON_VALID_MASK () {( &KVM_MSR_EXIT_REASON_INVAL |  &KVM_MSR_EXIT_REASON_UNKNOWN |  &KVM_MSR_EXIT_REASON_FILTER);}' unless defined(&KVM_MSR_EXIT_REASON_VALID_MASK);
    eval 'sub KVM_NOTIFY_CONTEXT_INVALID () {(1<< 0);}' unless defined(&KVM_NOTIFY_CONTEXT_INVALID);
    eval 'sub KVM_MEMORY_EXIT_FLAG_PRIVATE () {(1 << 3);}' unless defined(&KVM_MEMORY_EXIT_FLAG_PRIVATE);
    eval 'sub KVM_EXIT_ARM_SEA_FLAG_GPA_VALID () {(1 << 0);}' unless defined(&KVM_EXIT_ARM_SEA_FLAG_GPA_VALID);
    eval 'sub SYNC_REGS_SIZE_BYTES () {2048;}' unless defined(&SYNC_REGS_SIZE_BYTES);
    eval 'sub KVM_COALESCED_MMIO_MAX () {(( &PAGE_SIZE - $sizeof{\'struct kvm_coalesced_mmio_ring\'}) / $sizeof{\'struct kvm_coalesced_mmio\'});}' unless defined(&KVM_COALESCED_MMIO_MAX);
    eval 'sub KVM_MP_STATE_RUNNABLE () {0;}' unless defined(&KVM_MP_STATE_RUNNABLE);
    eval 'sub KVM_MP_STATE_UNINITIALIZED () {1;}' unless defined(&KVM_MP_STATE_UNINITIALIZED);
    eval 'sub KVM_MP_STATE_INIT_RECEIVED () {2;}' unless defined(&KVM_MP_STATE_INIT_RECEIVED);
    eval 'sub KVM_MP_STATE_HALTED () {3;}' unless defined(&KVM_MP_STATE_HALTED);
    eval 'sub KVM_MP_STATE_SIPI_RECEIVED () {4;}' unless defined(&KVM_MP_STATE_SIPI_RECEIVED);
    eval 'sub KVM_MP_STATE_STOPPED () {5;}' unless defined(&KVM_MP_STATE_STOPPED);
    eval 'sub KVM_MP_STATE_CHECK_STOP () {6;}' unless defined(&KVM_MP_STATE_CHECK_STOP);
    eval 'sub KVM_MP_STATE_OPERATING () {7;}' unless defined(&KVM_MP_STATE_OPERATING);
    eval 'sub KVM_MP_STATE_LOAD () {8;}' unless defined(&KVM_MP_STATE_LOAD);
    eval 'sub KVM_MP_STATE_AP_RESET_HOLD () {9;}' unless defined(&KVM_MP_STATE_AP_RESET_HOLD);
    eval 'sub KVM_MP_STATE_SUSPENDED () {10;}' unless defined(&KVM_MP_STATE_SUSPENDED);
    eval 'sub KVM_GUESTDBG_ENABLE () {0x1;}' unless defined(&KVM_GUESTDBG_ENABLE);
    eval 'sub KVM_GUESTDBG_SINGLESTEP () {0x2;}' unless defined(&KVM_GUESTDBG_SINGLESTEP);
    eval("sub kvm_ioeventfd_flag_nr_datamatch () { 0; }") unless defined(&kvm_ioeventfd_flag_nr_datamatch);
    eval("sub kvm_ioeventfd_flag_nr_pio () { 1; }") unless defined(&kvm_ioeventfd_flag_nr_pio);
    eval("sub kvm_ioeventfd_flag_nr_deassign () { 2; }") unless defined(&kvm_ioeventfd_flag_nr_deassign);
    eval("sub kvm_ioeventfd_flag_nr_virtio_ccw_notify () { 3; }") unless defined(&kvm_ioeventfd_flag_nr_virtio_ccw_notify);
    eval("sub kvm_ioeventfd_flag_nr_fast_mmio () { 4; }") unless defined(&kvm_ioeventfd_flag_nr_fast_mmio);
    eval("sub kvm_ioeventfd_flag_nr_max () { 5; }") unless defined(&kvm_ioeventfd_flag_nr_max);
    eval 'sub KVM_IOEVENTFD_FLAG_DATAMATCH () {(1<<  &kvm_ioeventfd_flag_nr_datamatch);}' unless defined(&KVM_IOEVENTFD_FLAG_DATAMATCH);
    eval 'sub KVM_IOEVENTFD_FLAG_PIO () {(1<<  &kvm_ioeventfd_flag_nr_pio);}' unless defined(&KVM_IOEVENTFD_FLAG_PIO);
    eval 'sub KVM_IOEVENTFD_FLAG_DEASSIGN () {(1<<  &kvm_ioeventfd_flag_nr_deassign);}' unless defined(&KVM_IOEVENTFD_FLAG_DEASSIGN);
    eval 'sub KVM_IOEVENTFD_FLAG_VIRTIO_CCW_NOTIFY () {(1<<  &kvm_ioeventfd_flag_nr_virtio_ccw_notify);}' unless defined(&KVM_IOEVENTFD_FLAG_VIRTIO_CCW_NOTIFY);
    eval 'sub KVM_IOEVENTFD_VALID_FLAG_MASK () {((1<<  &kvm_ioeventfd_flag_nr_max) - 1);}' unless defined(&KVM_IOEVENTFD_VALID_FLAG_MASK);
    eval 'sub KVM_X86_DISABLE_EXITS_MWAIT () {(1<< 0);}' unless defined(&KVM_X86_DISABLE_EXITS_MWAIT);
    eval 'sub KVM_X86_DISABLE_EXITS_HLT () {(1<< 1);}' unless defined(&KVM_X86_DISABLE_EXITS_HLT);
    eval 'sub KVM_X86_DISABLE_EXITS_PAUSE () {(1<< 2);}' unless defined(&KVM_X86_DISABLE_EXITS_PAUSE);
    eval 'sub KVM_X86_DISABLE_EXITS_CSTATE () {(1<< 3);}' unless defined(&KVM_X86_DISABLE_EXITS_CSTATE);
    eval 'sub KVM_X86_DISABLE_EXITS_APERFMPERF () {(1<< 4);}' unless defined(&KVM_X86_DISABLE_EXITS_APERFMPERF);
    eval 'sub KVMIO () {0xae;}' unless defined(&KVMIO);
    eval 'sub KVM_VM_S390_UCONTROL () {1;}' unless defined(&KVM_VM_S390_UCONTROL);
    eval 'sub KVM_VM_PPC_HV () {1;}' unless defined(&KVM_VM_PPC_HV);
    eval 'sub KVM_VM_PPC_PR () {2;}' unless defined(&KVM_VM_PPC_PR);
    eval 'sub KVM_VM_MIPS_AUTO () {0;}' unless defined(&KVM_VM_MIPS_AUTO);
    eval 'sub KVM_VM_MIPS_VZ () {1;}' unless defined(&KVM_VM_MIPS_VZ);
    eval 'sub KVM_VM_MIPS_TE () {2;}' unless defined(&KVM_VM_MIPS_TE);
    eval 'sub KVM_S390_SIE_PAGE_OFFSET () {1;}' unless defined(&KVM_S390_SIE_PAGE_OFFSET);
    eval 'sub KVM_VM_TYPE_ARM_IPA_SIZE_MASK () {0xff;}' unless defined(&KVM_VM_TYPE_ARM_IPA_SIZE_MASK);
    eval 'sub KVM_VM_TYPE_ARM_IPA_SIZE {
        my($x) = @_;
	    eval q((($x) &  &KVM_VM_TYPE_ARM_IPA_SIZE_MASK));
    }' unless defined(&KVM_VM_TYPE_ARM_IPA_SIZE);
    eval 'sub KVM_GET_API_VERSION () { &_IO( &KVMIO, 0x);}' unless defined(&KVM_GET_API_VERSION);
    eval 'sub KVM_CREATE_VM () { &_IO( &KVMIO, 0x1);}' unless defined(&KVM_CREATE_VM);
    eval 'sub KVM_GET_MSR_INDEX_LIST () { &_IOWR( &KVMIO, 0x2, \'struct kvm_msr_list\');}' unless defined(&KVM_GET_MSR_INDEX_LIST);
    eval 'sub KVM_S390_ENABLE_SIE () { &_IO( &KVMIO, 0x6);}' unless defined(&KVM_S390_ENABLE_SIE);
    eval 'sub KVM_CHECK_EXTENSION () { &_IO( &KVMIO, 0x3);}' unless defined(&KVM_CHECK_EXTENSION);
    eval 'sub KVM_GET_VCPU_MMAP_SIZE () { &_IO( &KVMIO, 0x4);}' unless defined(&KVM_GET_VCPU_MMAP_SIZE);
    eval 'sub KVM_GET_SUPPORTED_CPUID () { &_IOWR( &KVMIO, 0x5, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_SUPPORTED_CPUID);
    eval 'sub KVM_GET_EMULATED_CPUID () { &_IOWR( &KVMIO, 0x9, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_EMULATED_CPUID);
    eval 'sub KVM_GET_MSR_FEATURE_INDEX_LIST () { &_IOWR( &KVMIO, 0xa, \'struct kvm_msr_list\');}' unless defined(&KVM_GET_MSR_FEATURE_INDEX_LIST);
    eval 'sub KVM_CAP_IRQCHIP () {0;}' unless defined(&KVM_CAP_IRQCHIP);
    eval 'sub KVM_CAP_HLT () {1;}' unless defined(&KVM_CAP_HLT);
    eval 'sub KVM_CAP_MMU_SHADOW_CACHE_CONTROL () {2;}' unless defined(&KVM_CAP_MMU_SHADOW_CACHE_CONTROL);
    eval 'sub KVM_CAP_USER_MEMORY () {3;}' unless defined(&KVM_CAP_USER_MEMORY);
    eval 'sub KVM_CAP_SET_TSS_ADDR () {4;}' unless defined(&KVM_CAP_SET_TSS_ADDR);
    eval 'sub KVM_CAP_VAPIC () {6;}' unless defined(&KVM_CAP_VAPIC);
    eval 'sub KVM_CAP_EXT_CPUID () {7;}' unless defined(&KVM_CAP_EXT_CPUID);
    eval 'sub KVM_CAP_CLOCKSOURCE () {8;}' unless defined(&KVM_CAP_CLOCKSOURCE);
    eval 'sub KVM_CAP_NR_VCPUS () {9;}' unless defined(&KVM_CAP_NR_VCPUS);
    eval 'sub KVM_CAP_NR_MEMSLOTS () {10;}' unless defined(&KVM_CAP_NR_MEMSLOTS);
    eval 'sub KVM_CAP_PIT () {11;}' unless defined(&KVM_CAP_PIT);
    eval 'sub KVM_CAP_NOP_IO_DELAY () {12;}' unless defined(&KVM_CAP_NOP_IO_DELAY);
    eval 'sub KVM_CAP_PV_MMU () {13;}' unless defined(&KVM_CAP_PV_MMU);
    eval 'sub KVM_CAP_MP_STATE () {14;}' unless defined(&KVM_CAP_MP_STATE);
    eval 'sub KVM_CAP_COALESCED_MMIO () {15;}' unless defined(&KVM_CAP_COALESCED_MMIO);
    eval 'sub KVM_CAP_SYNC_MMU () {16;}' unless defined(&KVM_CAP_SYNC_MMU);
    eval 'sub KVM_CAP_IOMMU () {18;}' unless defined(&KVM_CAP_IOMMU);
    eval 'sub KVM_CAP_DESTROY_MEMORY_REGION_WORKS () {21;}' unless defined(&KVM_CAP_DESTROY_MEMORY_REGION_WORKS);
    eval 'sub KVM_CAP_USER_NMI () {22;}' unless defined(&KVM_CAP_USER_NMI);
    eval 'sub KVM_CAP_SET_GUEST_DEBUG () {23;}' unless defined(&KVM_CAP_SET_GUEST_DEBUG);
    if(defined(&__KVM_HAVE_PIT)) {
	eval 'sub KVM_CAP_REINJECT_CONTROL () {24;}' unless defined(&KVM_CAP_REINJECT_CONTROL);
    }
    eval 'sub KVM_CAP_IRQ_ROUTING () {25;}' unless defined(&KVM_CAP_IRQ_ROUTING);
    eval 'sub KVM_CAP_IRQ_INJECT_STATUS () {26;}' unless defined(&KVM_CAP_IRQ_INJECT_STATUS);
    eval 'sub KVM_CAP_ASSIGN_DEV_IRQ () {29;}' unless defined(&KVM_CAP_ASSIGN_DEV_IRQ);
    eval 'sub KVM_CAP_JOIN_MEMORY_REGIONS_WORKS () {30;}' unless defined(&KVM_CAP_JOIN_MEMORY_REGIONS_WORKS);
    if(defined(&__KVM_HAVE_MCE)) {
	eval 'sub KVM_CAP_MCE () {31;}' unless defined(&KVM_CAP_MCE);
    }
    eval 'sub KVM_CAP_IRQFD () {32;}' unless defined(&KVM_CAP_IRQFD);
    if(defined(&__KVM_HAVE_PIT)) {
	eval 'sub KVM_CAP_PIT2 () {33;}' unless defined(&KVM_CAP_PIT2);
    }
    eval 'sub KVM_CAP_SET_BOOT_CPU_ID () {34;}' unless defined(&KVM_CAP_SET_BOOT_CPU_ID);
    if(defined(&__KVM_HAVE_PIT_STATE2)) {
	eval 'sub KVM_CAP_PIT_STATE2 () {35;}' unless defined(&KVM_CAP_PIT_STATE2);
    }
    eval 'sub KVM_CAP_IOEVENTFD () {36;}' unless defined(&KVM_CAP_IOEVENTFD);
    eval 'sub KVM_CAP_SET_IDENTITY_MAP_ADDR () {37;}' unless defined(&KVM_CAP_SET_IDENTITY_MAP_ADDR);
    if(defined(&__KVM_HAVE_XEN_HVM)) {
	eval 'sub KVM_CAP_XEN_HVM () {38;}' unless defined(&KVM_CAP_XEN_HVM);
    }
    eval 'sub KVM_CAP_ADJUST_CLOCK () {39;}' unless defined(&KVM_CAP_ADJUST_CLOCK);
    eval 'sub KVM_CAP_INTERNAL_ERROR_DATA () {40;}' unless defined(&KVM_CAP_INTERNAL_ERROR_DATA);
    if(defined(&__KVM_HAVE_VCPU_EVENTS)) {
	eval 'sub KVM_CAP_VCPU_EVENTS () {41;}' unless defined(&KVM_CAP_VCPU_EVENTS);
    }
    eval 'sub KVM_CAP_S390_PSW () {42;}' unless defined(&KVM_CAP_S390_PSW);
    eval 'sub KVM_CAP_PPC_SEGSTATE () {43;}' unless defined(&KVM_CAP_PPC_SEGSTATE);
    eval 'sub KVM_CAP_HYPERV () {44;}' unless defined(&KVM_CAP_HYPERV);
    eval 'sub KVM_CAP_HYPERV_VAPIC () {45;}' unless defined(&KVM_CAP_HYPERV_VAPIC);
    eval 'sub KVM_CAP_HYPERV_SPIN () {46;}' unless defined(&KVM_CAP_HYPERV_SPIN);
    eval 'sub KVM_CAP_PCI_SEGMENT () {47;}' unless defined(&KVM_CAP_PCI_SEGMENT);
    eval 'sub KVM_CAP_PPC_PAIRED_SINGLES () {48;}' unless defined(&KVM_CAP_PPC_PAIRED_SINGLES);
    eval 'sub KVM_CAP_INTR_SHADOW () {49;}' unless defined(&KVM_CAP_INTR_SHADOW);
    if(defined(&__KVM_HAVE_DEBUGREGS)) {
	eval 'sub KVM_CAP_DEBUGREGS () {50;}' unless defined(&KVM_CAP_DEBUGREGS);
    }
    eval 'sub KVM_CAP_X86_ROBUST_SINGLESTEP () {51;}' unless defined(&KVM_CAP_X86_ROBUST_SINGLESTEP);
    eval 'sub KVM_CAP_PPC_OSI () {52;}' unless defined(&KVM_CAP_PPC_OSI);
    eval 'sub KVM_CAP_PPC_UNSET_IRQ () {53;}' unless defined(&KVM_CAP_PPC_UNSET_IRQ);
    eval 'sub KVM_CAP_ENABLE_CAP () {54;}' unless defined(&KVM_CAP_ENABLE_CAP);
    if(defined(&__KVM_HAVE_XSAVE)) {
	eval 'sub KVM_CAP_XSAVE () {55;}' unless defined(&KVM_CAP_XSAVE);
    }
    if(defined(&__KVM_HAVE_XCRS)) {
	eval 'sub KVM_CAP_XCRS () {56;}' unless defined(&KVM_CAP_XCRS);
    }
    eval 'sub KVM_CAP_PPC_GET_PVINFO () {57;}' unless defined(&KVM_CAP_PPC_GET_PVINFO);
    eval 'sub KVM_CAP_PPC_IRQ_LEVEL () {58;}' unless defined(&KVM_CAP_PPC_IRQ_LEVEL);
    eval 'sub KVM_CAP_ASYNC_PF () {59;}' unless defined(&KVM_CAP_ASYNC_PF);
    eval 'sub KVM_CAP_TSC_CONTROL () {60;}' unless defined(&KVM_CAP_TSC_CONTROL);
    eval 'sub KVM_CAP_GET_TSC_KHZ () {61;}' unless defined(&KVM_CAP_GET_TSC_KHZ);
    eval 'sub KVM_CAP_PPC_BOOKE_SREGS () {62;}' unless defined(&KVM_CAP_PPC_BOOKE_SREGS);
    eval 'sub KVM_CAP_SPAPR_TCE () {63;}' unless defined(&KVM_CAP_SPAPR_TCE);
    eval 'sub KVM_CAP_PPC_SMT () {64;}' unless defined(&KVM_CAP_PPC_SMT);
    eval 'sub KVM_CAP_PPC_RMA () {65;}' unless defined(&KVM_CAP_PPC_RMA);
    eval 'sub KVM_CAP_MAX_VCPUS () {66;}' unless defined(&KVM_CAP_MAX_VCPUS);
    eval 'sub KVM_CAP_PPC_HIOR () {67;}' unless defined(&KVM_CAP_PPC_HIOR);
    eval 'sub KVM_CAP_PPC_PAPR () {68;}' unless defined(&KVM_CAP_PPC_PAPR);
    eval 'sub KVM_CAP_SW_TLB () {69;}' unless defined(&KVM_CAP_SW_TLB);
    eval 'sub KVM_CAP_ONE_REG () {70;}' unless defined(&KVM_CAP_ONE_REG);
    eval 'sub KVM_CAP_S390_GMAP () {71;}' unless defined(&KVM_CAP_S390_GMAP);
    eval 'sub KVM_CAP_TSC_DEADLINE_TIMER () {72;}' unless defined(&KVM_CAP_TSC_DEADLINE_TIMER);
    eval 'sub KVM_CAP_S390_UCONTROL () {73;}' unless defined(&KVM_CAP_S390_UCONTROL);
    eval 'sub KVM_CAP_SYNC_REGS () {74;}' unless defined(&KVM_CAP_SYNC_REGS);
    eval 'sub KVM_CAP_PCI_2_3 () {75;}' unless defined(&KVM_CAP_PCI_2_3);
    eval 'sub KVM_CAP_KVMCLOCK_CTRL () {76;}' unless defined(&KVM_CAP_KVMCLOCK_CTRL);
    eval 'sub KVM_CAP_SIGNAL_MSI () {77;}' unless defined(&KVM_CAP_SIGNAL_MSI);
    eval 'sub KVM_CAP_PPC_GET_SMMU_INFO () {78;}' unless defined(&KVM_CAP_PPC_GET_SMMU_INFO);
    eval 'sub KVM_CAP_S390_COW () {79;}' unless defined(&KVM_CAP_S390_COW);
    eval 'sub KVM_CAP_PPC_ALLOC_HTAB () {80;}' unless defined(&KVM_CAP_PPC_ALLOC_HTAB);
    eval 'sub KVM_CAP_READONLY_MEM () {81;}' unless defined(&KVM_CAP_READONLY_MEM);
    eval 'sub KVM_CAP_IRQFD_RESAMPLE () {82;}' unless defined(&KVM_CAP_IRQFD_RESAMPLE);
    eval 'sub KVM_CAP_PPC_BOOKE_WATCHDOG () {83;}' unless defined(&KVM_CAP_PPC_BOOKE_WATCHDOG);
    eval 'sub KVM_CAP_PPC_HTAB_FD () {84;}' unless defined(&KVM_CAP_PPC_HTAB_FD);
    eval 'sub KVM_CAP_S390_CSS_SUPPORT () {85;}' unless defined(&KVM_CAP_S390_CSS_SUPPORT);
    eval 'sub KVM_CAP_PPC_EPR () {86;}' unless defined(&KVM_CAP_PPC_EPR);
    eval 'sub KVM_CAP_ARM_PSCI () {87;}' unless defined(&KVM_CAP_ARM_PSCI);
    eval 'sub KVM_CAP_ARM_SET_DEVICE_ADDR () {88;}' unless defined(&KVM_CAP_ARM_SET_DEVICE_ADDR);
    eval 'sub KVM_CAP_DEVICE_CTRL () {89;}' unless defined(&KVM_CAP_DEVICE_CTRL);
    eval 'sub KVM_CAP_IRQ_MPIC () {90;}' unless defined(&KVM_CAP_IRQ_MPIC);
    eval 'sub KVM_CAP_PPC_RTAS () {91;}' unless defined(&KVM_CAP_PPC_RTAS);
    eval 'sub KVM_CAP_IRQ_XICS () {92;}' unless defined(&KVM_CAP_IRQ_XICS);
    eval 'sub KVM_CAP_ARM_EL1_32BIT () {93;}' unless defined(&KVM_CAP_ARM_EL1_32BIT);
    eval 'sub KVM_CAP_SPAPR_MULTITCE () {94;}' unless defined(&KVM_CAP_SPAPR_MULTITCE);
    eval 'sub KVM_CAP_EXT_EMUL_CPUID () {95;}' unless defined(&KVM_CAP_EXT_EMUL_CPUID);
    eval 'sub KVM_CAP_HYPERV_TIME () {96;}' unless defined(&KVM_CAP_HYPERV_TIME);
    eval 'sub KVM_CAP_IOAPIC_POLARITY_IGNORED () {97;}' unless defined(&KVM_CAP_IOAPIC_POLARITY_IGNORED);
    eval 'sub KVM_CAP_ENABLE_CAP_VM () {98;}' unless defined(&KVM_CAP_ENABLE_CAP_VM);
    eval 'sub KVM_CAP_S390_IRQCHIP () {99;}' unless defined(&KVM_CAP_S390_IRQCHIP);
    eval 'sub KVM_CAP_IOEVENTFD_NO_LENGTH () {100;}' unless defined(&KVM_CAP_IOEVENTFD_NO_LENGTH);
    eval 'sub KVM_CAP_VM_ATTRIBUTES () {101;}' unless defined(&KVM_CAP_VM_ATTRIBUTES);
    eval 'sub KVM_CAP_ARM_PSCI_0_2 () {102;}' unless defined(&KVM_CAP_ARM_PSCI_0_2);
    eval 'sub KVM_CAP_PPC_FIXUP_HCALL () {103;}' unless defined(&KVM_CAP_PPC_FIXUP_HCALL);
    eval 'sub KVM_CAP_PPC_ENABLE_HCALL () {104;}' unless defined(&KVM_CAP_PPC_ENABLE_HCALL);
    eval 'sub KVM_CAP_CHECK_EXTENSION_VM () {105;}' unless defined(&KVM_CAP_CHECK_EXTENSION_VM);
    eval 'sub KVM_CAP_S390_USER_SIGP () {106;}' unless defined(&KVM_CAP_S390_USER_SIGP);
    eval 'sub KVM_CAP_S390_VECTOR_REGISTERS () {107;}' unless defined(&KVM_CAP_S390_VECTOR_REGISTERS);
    eval 'sub KVM_CAP_S390_MEM_OP () {108;}' unless defined(&KVM_CAP_S390_MEM_OP);
    eval 'sub KVM_CAP_S390_USER_STSI () {109;}' unless defined(&KVM_CAP_S390_USER_STSI);
    eval 'sub KVM_CAP_S390_SKEYS () {110;}' unless defined(&KVM_CAP_S390_SKEYS);
    eval 'sub KVM_CAP_MIPS_FPU () {111;}' unless defined(&KVM_CAP_MIPS_FPU);
    eval 'sub KVM_CAP_MIPS_MSA () {112;}' unless defined(&KVM_CAP_MIPS_MSA);
    eval 'sub KVM_CAP_S390_INJECT_IRQ () {113;}' unless defined(&KVM_CAP_S390_INJECT_IRQ);
    eval 'sub KVM_CAP_S390_IRQ_STATE () {114;}' unless defined(&KVM_CAP_S390_IRQ_STATE);
    eval 'sub KVM_CAP_PPC_HWRNG () {115;}' unless defined(&KVM_CAP_PPC_HWRNG);
    eval 'sub KVM_CAP_DISABLE_QUIRKS () {116;}' unless defined(&KVM_CAP_DISABLE_QUIRKS);
    eval 'sub KVM_CAP_X86_SMM () {117;}' unless defined(&KVM_CAP_X86_SMM);
    eval 'sub KVM_CAP_MULTI_ADDRESS_SPACE () {118;}' unless defined(&KVM_CAP_MULTI_ADDRESS_SPACE);
    eval 'sub KVM_CAP_GUEST_DEBUG_HW_BPS () {119;}' unless defined(&KVM_CAP_GUEST_DEBUG_HW_BPS);
    eval 'sub KVM_CAP_GUEST_DEBUG_HW_WPS () {120;}' unless defined(&KVM_CAP_GUEST_DEBUG_HW_WPS);
    eval 'sub KVM_CAP_SPLIT_IRQCHIP () {121;}' unless defined(&KVM_CAP_SPLIT_IRQCHIP);
    eval 'sub KVM_CAP_IOEVENTFD_ANY_LENGTH () {122;}' unless defined(&KVM_CAP_IOEVENTFD_ANY_LENGTH);
    eval 'sub KVM_CAP_HYPERV_SYNIC () {123;}' unless defined(&KVM_CAP_HYPERV_SYNIC);
    eval 'sub KVM_CAP_S390_RI () {124;}' unless defined(&KVM_CAP_S390_RI);
    eval 'sub KVM_CAP_SPAPR_TCE_64 () {125;}' unless defined(&KVM_CAP_SPAPR_TCE_64);
    eval 'sub KVM_CAP_ARM_PMU_V3 () {126;}' unless defined(&KVM_CAP_ARM_PMU_V3);
    eval 'sub KVM_CAP_VCPU_ATTRIBUTES () {127;}' unless defined(&KVM_CAP_VCPU_ATTRIBUTES);
    eval 'sub KVM_CAP_MAX_VCPU_ID () {128;}' unless defined(&KVM_CAP_MAX_VCPU_ID);
    eval 'sub KVM_CAP_X2APIC_API () {129;}' unless defined(&KVM_CAP_X2APIC_API);
    eval 'sub KVM_CAP_S390_USER_INSTR0 () {130;}' unless defined(&KVM_CAP_S390_USER_INSTR0);
    eval 'sub KVM_CAP_MSI_DEVID () {131;}' unless defined(&KVM_CAP_MSI_DEVID);
    eval 'sub KVM_CAP_PPC_HTM () {132;}' unless defined(&KVM_CAP_PPC_HTM);
    eval 'sub KVM_CAP_SPAPR_RESIZE_HPT () {133;}' unless defined(&KVM_CAP_SPAPR_RESIZE_HPT);
    eval 'sub KVM_CAP_PPC_MMU_RADIX () {134;}' unless defined(&KVM_CAP_PPC_MMU_RADIX);
    eval 'sub KVM_CAP_PPC_MMU_HASH_V3 () {135;}' unless defined(&KVM_CAP_PPC_MMU_HASH_V3);
    eval 'sub KVM_CAP_IMMEDIATE_EXIT () {136;}' unless defined(&KVM_CAP_IMMEDIATE_EXIT);
    eval 'sub KVM_CAP_MIPS_VZ () {137;}' unless defined(&KVM_CAP_MIPS_VZ);
    eval 'sub KVM_CAP_MIPS_TE () {138;}' unless defined(&KVM_CAP_MIPS_TE);
    eval 'sub KVM_CAP_MIPS_64BIT () {139;}' unless defined(&KVM_CAP_MIPS_64BIT);
    eval 'sub KVM_CAP_S390_GS () {140;}' unless defined(&KVM_CAP_S390_GS);
    eval 'sub KVM_CAP_S390_AIS () {141;}' unless defined(&KVM_CAP_S390_AIS);
    eval 'sub KVM_CAP_SPAPR_TCE_VFIO () {142;}' unless defined(&KVM_CAP_SPAPR_TCE_VFIO);
    eval 'sub KVM_CAP_X86_DISABLE_EXITS () {143;}' unless defined(&KVM_CAP_X86_DISABLE_EXITS);
    eval 'sub KVM_CAP_ARM_USER_IRQ () {144;}' unless defined(&KVM_CAP_ARM_USER_IRQ);
    eval 'sub KVM_CAP_S390_CMMA_MIGRATION () {145;}' unless defined(&KVM_CAP_S390_CMMA_MIGRATION);
    eval 'sub KVM_CAP_PPC_FWNMI () {146;}' unless defined(&KVM_CAP_PPC_FWNMI);
    eval 'sub KVM_CAP_PPC_SMT_POSSIBLE () {147;}' unless defined(&KVM_CAP_PPC_SMT_POSSIBLE);
    eval 'sub KVM_CAP_HYPERV_SYNIC2 () {148;}' unless defined(&KVM_CAP_HYPERV_SYNIC2);
    eval 'sub KVM_CAP_HYPERV_VP_INDEX () {149;}' unless defined(&KVM_CAP_HYPERV_VP_INDEX);
    eval 'sub KVM_CAP_S390_AIS_MIGRATION () {150;}' unless defined(&KVM_CAP_S390_AIS_MIGRATION);
    eval 'sub KVM_CAP_PPC_GET_CPU_CHAR () {151;}' unless defined(&KVM_CAP_PPC_GET_CPU_CHAR);
    eval 'sub KVM_CAP_S390_BPB () {152;}' unless defined(&KVM_CAP_S390_BPB);
    eval 'sub KVM_CAP_GET_MSR_FEATURES () {153;}' unless defined(&KVM_CAP_GET_MSR_FEATURES);
    eval 'sub KVM_CAP_HYPERV_EVENTFD () {154;}' unless defined(&KVM_CAP_HYPERV_EVENTFD);
    eval 'sub KVM_CAP_HYPERV_TLBFLUSH () {155;}' unless defined(&KVM_CAP_HYPERV_TLBFLUSH);
    eval 'sub KVM_CAP_S390_HPAGE_1M () {156;}' unless defined(&KVM_CAP_S390_HPAGE_1M);
    eval 'sub KVM_CAP_NESTED_STATE () {157;}' unless defined(&KVM_CAP_NESTED_STATE);
    eval 'sub KVM_CAP_ARM_INJECT_SERROR_ESR () {158;}' unless defined(&KVM_CAP_ARM_INJECT_SERROR_ESR);
    eval 'sub KVM_CAP_MSR_PLATFORM_INFO () {159;}' unless defined(&KVM_CAP_MSR_PLATFORM_INFO);
    eval 'sub KVM_CAP_PPC_NESTED_HV () {160;}' unless defined(&KVM_CAP_PPC_NESTED_HV);
    eval 'sub KVM_CAP_HYPERV_SEND_IPI () {161;}' unless defined(&KVM_CAP_HYPERV_SEND_IPI);
    eval 'sub KVM_CAP_COALESCED_PIO () {162;}' unless defined(&KVM_CAP_COALESCED_PIO);
    eval 'sub KVM_CAP_HYPERV_ENLIGHTENED_VMCS () {163;}' unless defined(&KVM_CAP_HYPERV_ENLIGHTENED_VMCS);
    eval 'sub KVM_CAP_EXCEPTION_PAYLOAD () {164;}' unless defined(&KVM_CAP_EXCEPTION_PAYLOAD);
    eval 'sub KVM_CAP_ARM_VM_IPA_SIZE () {165;}' unless defined(&KVM_CAP_ARM_VM_IPA_SIZE);
    eval 'sub KVM_CAP_MANUAL_DIRTY_LOG_PROTECT () {166;}' unless defined(&KVM_CAP_MANUAL_DIRTY_LOG_PROTECT);
    eval 'sub KVM_CAP_HYPERV_CPUID () {167;}' unless defined(&KVM_CAP_HYPERV_CPUID);
    eval 'sub KVM_CAP_MANUAL_DIRTY_LOG_PROTECT2 () {168;}' unless defined(&KVM_CAP_MANUAL_DIRTY_LOG_PROTECT2);
    eval 'sub KVM_CAP_PPC_IRQ_XIVE () {169;}' unless defined(&KVM_CAP_PPC_IRQ_XIVE);
    eval 'sub KVM_CAP_ARM_SVE () {170;}' unless defined(&KVM_CAP_ARM_SVE);
    eval 'sub KVM_CAP_ARM_PTRAUTH_ADDRESS () {171;}' unless defined(&KVM_CAP_ARM_PTRAUTH_ADDRESS);
    eval 'sub KVM_CAP_ARM_PTRAUTH_GENERIC () {172;}' unless defined(&KVM_CAP_ARM_PTRAUTH_GENERIC);
    eval 'sub KVM_CAP_PMU_EVENT_FILTER () {173;}' unless defined(&KVM_CAP_PMU_EVENT_FILTER);
    eval 'sub KVM_CAP_ARM_IRQ_LINE_LAYOUT_2 () {174;}' unless defined(&KVM_CAP_ARM_IRQ_LINE_LAYOUT_2);
    eval 'sub KVM_CAP_HYPERV_DIRECT_TLBFLUSH () {175;}' unless defined(&KVM_CAP_HYPERV_DIRECT_TLBFLUSH);
    eval 'sub KVM_CAP_PPC_GUEST_DEBUG_SSTEP () {176;}' unless defined(&KVM_CAP_PPC_GUEST_DEBUG_SSTEP);
    eval 'sub KVM_CAP_ARM_NISV_TO_USER () {177;}' unless defined(&KVM_CAP_ARM_NISV_TO_USER);
    eval 'sub KVM_CAP_ARM_INJECT_EXT_DABT () {178;}' unless defined(&KVM_CAP_ARM_INJECT_EXT_DABT);
    eval 'sub KVM_CAP_S390_VCPU_RESETS () {179;}' unless defined(&KVM_CAP_S390_VCPU_RESETS);
    eval 'sub KVM_CAP_S390_PROTECTED () {180;}' unless defined(&KVM_CAP_S390_PROTECTED);
    eval 'sub KVM_CAP_PPC_SECURE_GUEST () {181;}' unless defined(&KVM_CAP_PPC_SECURE_GUEST);
    eval 'sub KVM_CAP_HALT_POLL () {182;}' unless defined(&KVM_CAP_HALT_POLL);
    eval 'sub KVM_CAP_ASYNC_PF_INT () {183;}' unless defined(&KVM_CAP_ASYNC_PF_INT);
    eval 'sub KVM_CAP_LAST_CPU () {184;}' unless defined(&KVM_CAP_LAST_CPU);
    eval 'sub KVM_CAP_SMALLER_MAXPHYADDR () {185;}' unless defined(&KVM_CAP_SMALLER_MAXPHYADDR);
    eval 'sub KVM_CAP_S390_DIAG318 () {186;}' unless defined(&KVM_CAP_S390_DIAG318);
    eval 'sub KVM_CAP_STEAL_TIME () {187;}' unless defined(&KVM_CAP_STEAL_TIME);
    eval 'sub KVM_CAP_X86_USER_SPACE_MSR () {188;}' unless defined(&KVM_CAP_X86_USER_SPACE_MSR);
    eval 'sub KVM_CAP_X86_MSR_FILTER () {189;}' unless defined(&KVM_CAP_X86_MSR_FILTER);
    eval 'sub KVM_CAP_ENFORCE_PV_FEATURE_CPUID () {190;}' unless defined(&KVM_CAP_ENFORCE_PV_FEATURE_CPUID);
    eval 'sub KVM_CAP_SYS_HYPERV_CPUID () {191;}' unless defined(&KVM_CAP_SYS_HYPERV_CPUID);
    eval 'sub KVM_CAP_DIRTY_LOG_RING () {192;}' unless defined(&KVM_CAP_DIRTY_LOG_RING);
    eval 'sub KVM_CAP_X86_BUS_LOCK_EXIT () {193;}' unless defined(&KVM_CAP_X86_BUS_LOCK_EXIT);
    eval 'sub KVM_CAP_PPC_DAWR1 () {194;}' unless defined(&KVM_CAP_PPC_DAWR1);
    eval 'sub KVM_CAP_SET_GUEST_DEBUG2 () {195;}' unless defined(&KVM_CAP_SET_GUEST_DEBUG2);
    eval 'sub KVM_CAP_SGX_ATTRIBUTE () {196;}' unless defined(&KVM_CAP_SGX_ATTRIBUTE);
    eval 'sub KVM_CAP_VM_COPY_ENC_CONTEXT_FROM () {197;}' unless defined(&KVM_CAP_VM_COPY_ENC_CONTEXT_FROM);
    eval 'sub KVM_CAP_PTP_KVM () {198;}' unless defined(&KVM_CAP_PTP_KVM);
    eval 'sub KVM_CAP_HYPERV_ENFORCE_CPUID () {199;}' unless defined(&KVM_CAP_HYPERV_ENFORCE_CPUID);
    eval 'sub KVM_CAP_SREGS2 () {200;}' unless defined(&KVM_CAP_SREGS2);
    eval 'sub KVM_CAP_EXIT_HYPERCALL () {201;}' unless defined(&KVM_CAP_EXIT_HYPERCALL);
    eval 'sub KVM_CAP_PPC_RPT_INVALIDATE () {202;}' unless defined(&KVM_CAP_PPC_RPT_INVALIDATE);
    eval 'sub KVM_CAP_BINARY_STATS_FD () {203;}' unless defined(&KVM_CAP_BINARY_STATS_FD);
    eval 'sub KVM_CAP_EXIT_ON_EMULATION_FAILURE () {204;}' unless defined(&KVM_CAP_EXIT_ON_EMULATION_FAILURE);
    eval 'sub KVM_CAP_ARM_MTE () {205;}' unless defined(&KVM_CAP_ARM_MTE);
    eval 'sub KVM_CAP_VM_MOVE_ENC_CONTEXT_FROM () {206;}' unless defined(&KVM_CAP_VM_MOVE_ENC_CONTEXT_FROM);
    eval 'sub KVM_CAP_VM_GPA_BITS () {207;}' unless defined(&KVM_CAP_VM_GPA_BITS);
    eval 'sub KVM_CAP_XSAVE2 () {208;}' unless defined(&KVM_CAP_XSAVE2);
    eval 'sub KVM_CAP_SYS_ATTRIBUTES () {209;}' unless defined(&KVM_CAP_SYS_ATTRIBUTES);
    eval 'sub KVM_CAP_PPC_AIL_MODE_3 () {210;}' unless defined(&KVM_CAP_PPC_AIL_MODE_3);
    eval 'sub KVM_CAP_S390_MEM_OP_EXTENSION () {211;}' unless defined(&KVM_CAP_S390_MEM_OP_EXTENSION);
    eval 'sub KVM_CAP_PMU_CAPABILITY () {212;}' unless defined(&KVM_CAP_PMU_CAPABILITY);
    eval 'sub KVM_CAP_DISABLE_QUIRKS2 () {213;}' unless defined(&KVM_CAP_DISABLE_QUIRKS2);
    eval 'sub KVM_CAP_VM_TSC_CONTROL () {214;}' unless defined(&KVM_CAP_VM_TSC_CONTROL);
    eval 'sub KVM_CAP_SYSTEM_EVENT_DATA () {215;}' unless defined(&KVM_CAP_SYSTEM_EVENT_DATA);
    eval 'sub KVM_CAP_ARM_SYSTEM_SUSPEND () {216;}' unless defined(&KVM_CAP_ARM_SYSTEM_SUSPEND);
    eval 'sub KVM_CAP_S390_PROTECTED_DUMP () {217;}' unless defined(&KVM_CAP_S390_PROTECTED_DUMP);
    eval 'sub KVM_CAP_X86_TRIPLE_FAULT_EVENT () {218;}' unless defined(&KVM_CAP_X86_TRIPLE_FAULT_EVENT);
    eval 'sub KVM_CAP_X86_NOTIFY_VMEXIT () {219;}' unless defined(&KVM_CAP_X86_NOTIFY_VMEXIT);
    eval 'sub KVM_CAP_VM_DISABLE_NX_HUGE_PAGES () {220;}' unless defined(&KVM_CAP_VM_DISABLE_NX_HUGE_PAGES);
    eval 'sub KVM_CAP_S390_ZPCI_OP () {221;}' unless defined(&KVM_CAP_S390_ZPCI_OP);
    eval 'sub KVM_CAP_S390_CPU_TOPOLOGY () {222;}' unless defined(&KVM_CAP_S390_CPU_TOPOLOGY);
    eval 'sub KVM_CAP_DIRTY_LOG_RING_ACQ_REL () {223;}' unless defined(&KVM_CAP_DIRTY_LOG_RING_ACQ_REL);
    eval 'sub KVM_CAP_S390_PROTECTED_ASYNC_DISABLE () {224;}' unless defined(&KVM_CAP_S390_PROTECTED_ASYNC_DISABLE);
    eval 'sub KVM_CAP_DIRTY_LOG_RING_WITH_BITMAP () {225;}' unless defined(&KVM_CAP_DIRTY_LOG_RING_WITH_BITMAP);
    eval 'sub KVM_CAP_PMU_EVENT_MASKED_EVENTS () {226;}' unless defined(&KVM_CAP_PMU_EVENT_MASKED_EVENTS);
    eval 'sub KVM_CAP_COUNTER_OFFSET () {227;}' unless defined(&KVM_CAP_COUNTER_OFFSET);
    eval 'sub KVM_CAP_ARM_EAGER_SPLIT_CHUNK_SIZE () {228;}' unless defined(&KVM_CAP_ARM_EAGER_SPLIT_CHUNK_SIZE);
    eval 'sub KVM_CAP_ARM_SUPPORTED_BLOCK_SIZES () {229;}' unless defined(&KVM_CAP_ARM_SUPPORTED_BLOCK_SIZES);
    eval 'sub KVM_CAP_ARM_SUPPORTED_REG_MASK_RANGES () {230;}' unless defined(&KVM_CAP_ARM_SUPPORTED_REG_MASK_RANGES);
    eval 'sub KVM_CAP_USER_MEMORY2 () {231;}' unless defined(&KVM_CAP_USER_MEMORY2);
    eval 'sub KVM_CAP_MEMORY_FAULT_INFO () {232;}' unless defined(&KVM_CAP_MEMORY_FAULT_INFO);
    eval 'sub KVM_CAP_MEMORY_ATTRIBUTES () {233;}' unless defined(&KVM_CAP_MEMORY_ATTRIBUTES);
    eval 'sub KVM_CAP_GUEST_MEMFD () {234;}' unless defined(&KVM_CAP_GUEST_MEMFD);
    eval 'sub KVM_CAP_VM_TYPES () {235;}' unless defined(&KVM_CAP_VM_TYPES);
    eval 'sub KVM_CAP_PRE_FAULT_MEMORY () {236;}' unless defined(&KVM_CAP_PRE_FAULT_MEMORY);
    eval 'sub KVM_CAP_X86_APIC_BUS_CYCLES_NS () {237;}' unless defined(&KVM_CAP_X86_APIC_BUS_CYCLES_NS);
    eval 'sub KVM_CAP_X86_GUEST_MODE () {238;}' unless defined(&KVM_CAP_X86_GUEST_MODE);
    eval 'sub KVM_CAP_ARM_WRITABLE_IMP_ID_REGS () {239;}' unless defined(&KVM_CAP_ARM_WRITABLE_IMP_ID_REGS);
    eval 'sub KVM_CAP_ARM_EL2 () {240;}' unless defined(&KVM_CAP_ARM_EL2);
    eval 'sub KVM_CAP_ARM_EL2_E2H0 () {241;}' unless defined(&KVM_CAP_ARM_EL2_E2H0);
    eval 'sub KVM_CAP_RISCV_MP_STATE_RESET () {242;}' unless defined(&KVM_CAP_RISCV_MP_STATE_RESET);
    eval 'sub KVM_CAP_ARM_CACHEABLE_PFNMAP_SUPPORTED () {243;}' unless defined(&KVM_CAP_ARM_CACHEABLE_PFNMAP_SUPPORTED);
    eval 'sub KVM_CAP_GUEST_MEMFD_FLAGS () {244;}' unless defined(&KVM_CAP_GUEST_MEMFD_FLAGS);
    eval 'sub KVM_CAP_ARM_SEA_TO_USER () {245;}' unless defined(&KVM_CAP_ARM_SEA_TO_USER);
    eval 'sub KVM_CAP_S390_USER_OPEREXEC () {246;}' unless defined(&KVM_CAP_S390_USER_OPEREXEC);
    eval 'sub KVM_IRQ_ROUTING_XEN_EVTCHN_PRIO_2LEVEL () {(( &__u32)(-1));}' unless defined(&KVM_IRQ_ROUTING_XEN_EVTCHN_PRIO_2LEVEL);
    eval 'sub KVM_IRQ_ROUTING_IRQCHIP () {1;}' unless defined(&KVM_IRQ_ROUTING_IRQCHIP);
    eval 'sub KVM_IRQ_ROUTING_MSI () {2;}' unless defined(&KVM_IRQ_ROUTING_MSI);
    eval 'sub KVM_IRQ_ROUTING_S390_ADAPTER () {3;}' unless defined(&KVM_IRQ_ROUTING_S390_ADAPTER);
    eval 'sub KVM_IRQ_ROUTING_HV_SINT () {4;}' unless defined(&KVM_IRQ_ROUTING_HV_SINT);
    eval 'sub KVM_IRQ_ROUTING_XEN_EVTCHN () {5;}' unless defined(&KVM_IRQ_ROUTING_XEN_EVTCHN);
    eval 'sub KVM_IRQFD_FLAG_DEASSIGN () {(1<< 0);}' unless defined(&KVM_IRQFD_FLAG_DEASSIGN);
    eval 'sub KVM_IRQFD_FLAG_RESAMPLE () {(1<< 1);}' unless defined(&KVM_IRQFD_FLAG_RESAMPLE);
    eval 'sub KVM_CLOCK_TSC_STABLE () {2;}' unless defined(&KVM_CLOCK_TSC_STABLE);
    eval 'sub KVM_CLOCK_REALTIME () {(1<< 2);}' unless defined(&KVM_CLOCK_REALTIME);
    eval 'sub KVM_CLOCK_HOST_TSC () {(1<< 3);}' unless defined(&KVM_CLOCK_HOST_TSC);
    eval 'sub KVM_MMU_FSL_BOOKE_NOHV () {0;}' unless defined(&KVM_MMU_FSL_BOOKE_NOHV);
    eval 'sub KVM_MMU_FSL_BOOKE_HV () {1;}' unless defined(&KVM_MMU_FSL_BOOKE_HV);
    eval 'sub KVM_REG_ARCH_MASK () {0xff00000000000000;}' unless defined(&KVM_REG_ARCH_MASK);
    eval 'sub KVM_REG_GENERIC () {0x;}' unless defined(&KVM_REG_GENERIC);
    eval 'sub KVM_REG_PPC () {0x1000000000000000;}' unless defined(&KVM_REG_PPC);
    eval 'sub KVM_REG_X86 () {0x2000000000000000;}' unless defined(&KVM_REG_X86);
    eval 'sub KVM_REG_IA64 () {0x3000000000000000;}' unless defined(&KVM_REG_IA64);
    eval 'sub KVM_REG_ARM () {0x4000000000000000;}' unless defined(&KVM_REG_ARM);
    eval 'sub KVM_REG_S390 () {0x5000000000000000;}' unless defined(&KVM_REG_S390);
    eval 'sub KVM_REG_ARM64 () {0x6000000000000000;}' unless defined(&KVM_REG_ARM64);
    eval 'sub KVM_REG_MIPS () {0x7000000000000000;}' unless defined(&KVM_REG_MIPS);
    eval 'sub KVM_REG_RISCV () {0x8000000000000000;}' unless defined(&KVM_REG_RISCV);
    eval 'sub KVM_REG_LOONGARCH () {0x9000000000000000;}' unless defined(&KVM_REG_LOONGARCH);
    eval 'sub KVM_REG_SIZE_SHIFT () {52;}' unless defined(&KVM_REG_SIZE_SHIFT);
    eval 'sub KVM_REG_SIZE_MASK () {0xf0000000000000;}' unless defined(&KVM_REG_SIZE_MASK);
    eval 'sub KVM_REG_SIZE {
        my($id) = @_;
	    eval q((1 << ((($id) &  &KVM_REG_SIZE_MASK) >>  &KVM_REG_SIZE_SHIFT)));
    }' unless defined(&KVM_REG_SIZE);
    eval 'sub KVM_REG_SIZE_U8 () {0x;}' unless defined(&KVM_REG_SIZE_U8);
    eval 'sub KVM_REG_SIZE_U16 () {0x10000000000000;}' unless defined(&KVM_REG_SIZE_U16);
    eval 'sub KVM_REG_SIZE_U32 () {0x20000000000000;}' unless defined(&KVM_REG_SIZE_U32);
    eval 'sub KVM_REG_SIZE_U64 () {0x30000000000000;}' unless defined(&KVM_REG_SIZE_U64);
    eval 'sub KVM_REG_SIZE_U128 () {0x40000000000000;}' unless defined(&KVM_REG_SIZE_U128);
    eval 'sub KVM_REG_SIZE_U256 () {0x50000000000000;}' unless defined(&KVM_REG_SIZE_U256);
    eval 'sub KVM_REG_SIZE_U512 () {0x60000000000000;}' unless defined(&KVM_REG_SIZE_U512);
    eval 'sub KVM_REG_SIZE_U1024 () {0x70000000000000;}' unless defined(&KVM_REG_SIZE_U1024);
    eval 'sub KVM_REG_SIZE_U2048 () {0x80000000000000;}' unless defined(&KVM_REG_SIZE_U2048);
    eval 'sub KVM_MSI_VALID_DEVID () {(1 << 0);}' unless defined(&KVM_MSI_VALID_DEVID);
    eval 'sub KVM_CREATE_DEVICE_TEST () {1;}' unless defined(&KVM_CREATE_DEVICE_TEST);
    eval 'sub KVM_DEV_VFIO_FILE () {1;}' unless defined(&KVM_DEV_VFIO_FILE);
    eval 'sub KVM_DEV_VFIO_FILE_ADD () {1;}' unless defined(&KVM_DEV_VFIO_FILE_ADD);
    eval 'sub KVM_DEV_VFIO_FILE_DEL () {2;}' unless defined(&KVM_DEV_VFIO_FILE_DEL);
    eval 'sub KVM_DEV_VFIO_GROUP () { &KVM_DEV_VFIO_FILE;}' unless defined(&KVM_DEV_VFIO_GROUP);
    eval 'sub KVM_DEV_VFIO_GROUP_ADD () { &KVM_DEV_VFIO_FILE_ADD;}' unless defined(&KVM_DEV_VFIO_GROUP_ADD);
    eval 'sub KVM_DEV_VFIO_GROUP_DEL () { &KVM_DEV_VFIO_FILE_DEL;}' unless defined(&KVM_DEV_VFIO_GROUP_DEL);
    eval 'sub KVM_DEV_VFIO_GROUP_SET_SPAPR_TCE () {3;}' unless defined(&KVM_DEV_VFIO_GROUP_SET_SPAPR_TCE);
    eval("sub KVM_DEV_TYPE_FSL_MPIC_20 () { 1; }") unless defined(&KVM_DEV_TYPE_FSL_MPIC_20);
    eval("sub KVM_DEV_TYPE_FSL_MPIC_42 () { 2; }") unless defined(&KVM_DEV_TYPE_FSL_MPIC_42);
    eval("sub KVM_DEV_TYPE_XICS () { 3; }") unless defined(&KVM_DEV_TYPE_XICS);
    eval("sub KVM_DEV_TYPE_VFIO () { 4; }") unless defined(&KVM_DEV_TYPE_VFIO);
    eval("sub KVM_DEV_TYPE_ARM_VGIC_V2 () { 5; }") unless defined(&KVM_DEV_TYPE_ARM_VGIC_V2);
    eval("sub KVM_DEV_TYPE_FLIC () { 6; }") unless defined(&KVM_DEV_TYPE_FLIC);
    eval("sub KVM_DEV_TYPE_ARM_VGIC_V3 () { 7; }") unless defined(&KVM_DEV_TYPE_ARM_VGIC_V3);
    eval("sub KVM_DEV_TYPE_ARM_VGIC_ITS () { 8; }") unless defined(&KVM_DEV_TYPE_ARM_VGIC_ITS);
    eval("sub KVM_DEV_TYPE_XIVE () { 9; }") unless defined(&KVM_DEV_TYPE_XIVE);
    eval("sub KVM_DEV_TYPE_ARM_PV_TIME () { 10; }") unless defined(&KVM_DEV_TYPE_ARM_PV_TIME);
    eval("sub KVM_DEV_TYPE_RISCV_AIA () { 11; }") unless defined(&KVM_DEV_TYPE_RISCV_AIA);
    eval("sub KVM_DEV_TYPE_LOONGARCH_IPI () { 12; }") unless defined(&KVM_DEV_TYPE_LOONGARCH_IPI);
    eval("sub KVM_DEV_TYPE_LOONGARCH_EIOINTC () { 13; }") unless defined(&KVM_DEV_TYPE_LOONGARCH_EIOINTC);
    eval("sub KVM_DEV_TYPE_LOONGARCH_PCHPIC () { 14; }") unless defined(&KVM_DEV_TYPE_LOONGARCH_PCHPIC);
    eval("sub KVM_DEV_TYPE_MAX () { 15; }") unless defined(&KVM_DEV_TYPE_MAX);
    eval 'sub KVM_CREATE_VCPU () { &_IO( &KVMIO, 0x41);}' unless defined(&KVM_CREATE_VCPU);
    eval 'sub KVM_GET_DIRTY_LOG () { &_IOW( &KVMIO, 0x42, \'struct kvm_dirty_log\');}' unless defined(&KVM_GET_DIRTY_LOG);
    eval 'sub KVM_SET_NR_MMU_PAGES () { &_IO( &KVMIO, 0x44);}' unless defined(&KVM_SET_NR_MMU_PAGES);
    eval 'sub KVM_GET_NR_MMU_PAGES () { &_IO( &KVMIO, 0x45);}' unless defined(&KVM_GET_NR_MMU_PAGES);
    eval 'sub KVM_SET_USER_MEMORY_REGION () { &_IOW( &KVMIO, 0x46, \'struct kvm_userspace_memory_region\');}' unless defined(&KVM_SET_USER_MEMORY_REGION);
    eval 'sub KVM_SET_TSS_ADDR () { &_IO( &KVMIO, 0x47);}' unless defined(&KVM_SET_TSS_ADDR);
    eval 'sub KVM_SET_IDENTITY_MAP_ADDR () { &_IOW( &KVMIO, 0x48,  &__u64);}' unless defined(&KVM_SET_IDENTITY_MAP_ADDR);
    eval 'sub KVM_SET_USER_MEMORY_REGION2 () { &_IOW( &KVMIO, 0x49, \'struct kvm_userspace_memory_region2\');}' unless defined(&KVM_SET_USER_MEMORY_REGION2);
    eval 'sub KVM_S390_UCAS_MAP () { &_IOW( &KVMIO, 0x50, \'struct kvm_s390_ucas_mapping\');}' unless defined(&KVM_S390_UCAS_MAP);
    eval 'sub KVM_S390_UCAS_UNMAP () { &_IOW( &KVMIO, 0x51, \'struct kvm_s390_ucas_mapping\');}' unless defined(&KVM_S390_UCAS_UNMAP);
    eval 'sub KVM_S390_VCPU_FAULT () { &_IOW( &KVMIO, 0x52, \'unsigned long\');}' unless defined(&KVM_S390_VCPU_FAULT);
    eval 'sub KVM_CREATE_IRQCHIP () { &_IO( &KVMIO, 0x60);}' unless defined(&KVM_CREATE_IRQCHIP);
    eval 'sub KVM_IRQ_LINE () { &_IOW( &KVMIO, 0x61, \'struct kvm_irq_level\');}' unless defined(&KVM_IRQ_LINE);
    eval 'sub KVM_GET_IRQCHIP () { &_IOWR( &KVMIO, 0x62, \'struct kvm_irqchip\');}' unless defined(&KVM_GET_IRQCHIP);
    eval 'sub KVM_SET_IRQCHIP () { &_IOR( &KVMIO, 0x63, \'struct kvm_irqchip\');}' unless defined(&KVM_SET_IRQCHIP);
    eval 'sub KVM_CREATE_PIT () { &_IO( &KVMIO, 0x64);}' unless defined(&KVM_CREATE_PIT);
    eval 'sub KVM_GET_PIT () { &_IOWR( &KVMIO, 0x65, \'struct kvm_pit_state\');}' unless defined(&KVM_GET_PIT);
    eval 'sub KVM_SET_PIT () { &_IOR( &KVMIO, 0x66, \'struct kvm_pit_state\');}' unless defined(&KVM_SET_PIT);
    eval 'sub KVM_IRQ_LINE_STATUS () { &_IOWR( &KVMIO, 0x67, \'struct kvm_irq_level\');}' unless defined(&KVM_IRQ_LINE_STATUS);
    eval 'sub KVM_REGISTER_COALESCED_MMIO () { &_IOW( &KVMIO, 0x67, \'struct kvm_coalesced_mmio_zone\');}' unless defined(&KVM_REGISTER_COALESCED_MMIO);
    eval 'sub KVM_UNREGISTER_COALESCED_MMIO () { &_IOW( &KVMIO, 0x68, \'struct kvm_coalesced_mmio_zone\');}' unless defined(&KVM_UNREGISTER_COALESCED_MMIO);
    eval 'sub KVM_SET_GSI_ROUTING () { &_IOW( &KVMIO, 0x6a, \'struct kvm_irq_routing\');}' unless defined(&KVM_SET_GSI_ROUTING);
    eval 'sub KVM_REINJECT_CONTROL () { &_IO( &KVMIO, 0x71);}' unless defined(&KVM_REINJECT_CONTROL);
    eval 'sub KVM_IRQFD () { &_IOW( &KVMIO, 0x76, \'struct kvm_irqfd\');}' unless defined(&KVM_IRQFD);
    eval 'sub KVM_CREATE_PIT2 () { &_IOW( &KVMIO, 0x77, \'struct kvm_pit_config\');}' unless defined(&KVM_CREATE_PIT2);
    eval 'sub KVM_SET_BOOT_CPU_ID () { &_IO( &KVMIO, 0x78);}' unless defined(&KVM_SET_BOOT_CPU_ID);
    eval 'sub KVM_IOEVENTFD () { &_IOW( &KVMIO, 0x79, \'struct kvm_ioeventfd\');}' unless defined(&KVM_IOEVENTFD);
    eval 'sub KVM_XEN_HVM_CONFIG () { &_IOW( &KVMIO, 0x7a, \'struct kvm_xen_hvm_config\');}' unless defined(&KVM_XEN_HVM_CONFIG);
    eval 'sub KVM_SET_CLOCK () { &_IOW( &KVMIO, 0x7b, \'struct kvm_clock_data\');}' unless defined(&KVM_SET_CLOCK);
    eval 'sub KVM_GET_CLOCK () { &_IOR( &KVMIO, 0x7c, \'struct kvm_clock_data\');}' unless defined(&KVM_GET_CLOCK);
    eval 'sub KVM_GET_PIT2 () { &_IOR( &KVMIO, 0x9f, \'struct kvm_pit_state2\');}' unless defined(&KVM_GET_PIT2);
    eval 'sub KVM_SET_PIT2 () { &_IOW( &KVMIO, 0xa0, \'struct kvm_pit_state2\');}' unless defined(&KVM_SET_PIT2);
    eval 'sub KVM_PPC_GET_PVINFO () { &_IOW( &KVMIO, 0xa1, \'struct kvm_ppc_pvinfo\');}' unless defined(&KVM_PPC_GET_PVINFO);
    eval 'sub KVM_SET_TSC_KHZ () { &_IO( &KVMIO, 0xa2);}' unless defined(&KVM_SET_TSC_KHZ);
    eval 'sub KVM_GET_TSC_KHZ () { &_IO( &KVMIO, 0xa3);}' unless defined(&KVM_GET_TSC_KHZ);
    eval 'sub KVM_SIGNAL_MSI () { &_IOW( &KVMIO, 0xa5, \'struct kvm_msi\');}' unless defined(&KVM_SIGNAL_MSI);
    eval 'sub KVM_PPC_GET_SMMU_INFO () { &_IOR( &KVMIO, 0xa6, \'struct kvm_ppc_smmu_info\');}' unless defined(&KVM_PPC_GET_SMMU_INFO);
    eval 'sub KVM_PPC_ALLOCATE_HTAB () { &_IOWR( &KVMIO, 0xa7,  &__u32);}' unless defined(&KVM_PPC_ALLOCATE_HTAB);
    eval 'sub KVM_CREATE_SPAPR_TCE () { &_IOW( &KVMIO, 0xa8, \'struct kvm_create_spapr_tce\');}' unless defined(&KVM_CREATE_SPAPR_TCE);
    eval 'sub KVM_CREATE_SPAPR_TCE_64 () { &_IOW( &KVMIO, 0xa8, \'struct kvm_create_spapr_tce_64\');}' unless defined(&KVM_CREATE_SPAPR_TCE_64);
    eval 'sub KVM_ALLOCATE_RMA () { &_IOR( &KVMIO, 0xa9, \'struct kvm_allocate_rma\');}' unless defined(&KVM_ALLOCATE_RMA);
    eval 'sub KVM_PPC_GET_HTAB_FD () { &_IOW( &KVMIO, 0xaa, \'struct kvm_get_htab_fd\');}' unless defined(&KVM_PPC_GET_HTAB_FD);
    eval 'sub KVM_ARM_SET_DEVICE_ADDR () { &_IOW( &KVMIO, 0xab, \'struct kvm_arm_device_addr\');}' unless defined(&KVM_ARM_SET_DEVICE_ADDR);
    eval 'sub KVM_PPC_RTAS_DEFINE_TOKEN () { &_IOW( &KVMIO, 0xac, \'struct kvm_rtas_token_args\');}' unless defined(&KVM_PPC_RTAS_DEFINE_TOKEN);
    eval 'sub KVM_PPC_RESIZE_HPT_PREPARE () { &_IOR( &KVMIO, 0xad, \'struct kvm_ppc_resize_hpt\');}' unless defined(&KVM_PPC_RESIZE_HPT_PREPARE);
    eval 'sub KVM_PPC_RESIZE_HPT_COMMIT () { &_IOR( &KVMIO, 0xae, \'struct kvm_ppc_resize_hpt\');}' unless defined(&KVM_PPC_RESIZE_HPT_COMMIT);
    eval 'sub KVM_PPC_CONFIGURE_V3_MMU () { &_IOW( &KVMIO, 0xaf, \'struct kvm_ppc_mmuv3_cfg\');}' unless defined(&KVM_PPC_CONFIGURE_V3_MMU);
    eval 'sub KVM_PPC_GET_RMMU_INFO () { &_IOW( &KVMIO, 0xb0, \'struct kvm_ppc_rmmu_info\');}' unless defined(&KVM_PPC_GET_RMMU_INFO);
    eval 'sub KVM_PPC_GET_CPU_CHAR () { &_IOR( &KVMIO, 0xb1, \'struct kvm_ppc_cpu_char\');}' unless defined(&KVM_PPC_GET_CPU_CHAR);
    eval 'sub KVM_SET_PMU_EVENT_FILTER () { &_IOW( &KVMIO, 0xb2, \'struct kvm_pmu_event_filter\');}' unless defined(&KVM_SET_PMU_EVENT_FILTER);
    eval 'sub KVM_PPC_SVM_OFF () { &_IO( &KVMIO, 0xb3);}' unless defined(&KVM_PPC_SVM_OFF);
    eval 'sub KVM_ARM_MTE_COPY_TAGS () { &_IOR( &KVMIO, 0xb4, \'struct kvm_arm_copy_mte_tags\');}' unless defined(&KVM_ARM_MTE_COPY_TAGS);
    eval 'sub KVM_ARM_SET_COUNTER_OFFSET () { &_IOW( &KVMIO, 0xb5, \'struct kvm_arm_counter_offset\');}' unless defined(&KVM_ARM_SET_COUNTER_OFFSET);
    eval 'sub KVM_ARM_GET_REG_WRITABLE_MASKS () { &_IOR( &KVMIO, 0xb6, \'struct reg_mask_range\');}' unless defined(&KVM_ARM_GET_REG_WRITABLE_MASKS);
    eval 'sub KVM_CREATE_DEVICE () { &_IOWR( &KVMIO, 0xe0, \'struct kvm_create_device\');}' unless defined(&KVM_CREATE_DEVICE);
    eval 'sub KVM_SET_DEVICE_ATTR () { &_IOW( &KVMIO, 0xe1, \'struct kvm_device_attr\');}' unless defined(&KVM_SET_DEVICE_ATTR);
    eval 'sub KVM_GET_DEVICE_ATTR () { &_IOW( &KVMIO, 0xe2, \'struct kvm_device_attr\');}' unless defined(&KVM_GET_DEVICE_ATTR);
    eval 'sub KVM_HAS_DEVICE_ATTR () { &_IOW( &KVMIO, 0xe3, \'struct kvm_device_attr\');}' unless defined(&KVM_HAS_DEVICE_ATTR);
    eval 'sub KVM_RUN () { &_IO( &KVMIO, 0x80);}' unless defined(&KVM_RUN);
    eval 'sub KVM_GET_REGS () { &_IOR( &KVMIO, 0x81, \'struct kvm_regs\');}' unless defined(&KVM_GET_REGS);
    eval 'sub KVM_SET_REGS () { &_IOW( &KVMIO, 0x82, \'struct kvm_regs\');}' unless defined(&KVM_SET_REGS);
    eval 'sub KVM_GET_SREGS () { &_IOR( &KVMIO, 0x83, \'struct kvm_sregs\');}' unless defined(&KVM_GET_SREGS);
    eval 'sub KVM_SET_SREGS () { &_IOW( &KVMIO, 0x84, \'struct kvm_sregs\');}' unless defined(&KVM_SET_SREGS);
    eval 'sub KVM_TRANSLATE () { &_IOWR( &KVMIO, 0x85, \'struct kvm_translation\');}' unless defined(&KVM_TRANSLATE);
    eval 'sub KVM_INTERRUPT () { &_IOW( &KVMIO, 0x86, \'struct kvm_interrupt\');}' unless defined(&KVM_INTERRUPT);
    eval 'sub KVM_GET_MSRS () { &_IOWR( &KVMIO, 0x88, \'struct kvm_msrs\');}' unless defined(&KVM_GET_MSRS);
    eval 'sub KVM_SET_MSRS () { &_IOW( &KVMIO, 0x89, \'struct kvm_msrs\');}' unless defined(&KVM_SET_MSRS);
    eval 'sub KVM_SET_CPUID () { &_IOW( &KVMIO, 0x8a, \'struct kvm_cpuid\');}' unless defined(&KVM_SET_CPUID);
    eval 'sub KVM_SET_SIGNAL_MASK () { &_IOW( &KVMIO, 0x8b, \'struct kvm_signal_mask\');}' unless defined(&KVM_SET_SIGNAL_MASK);
    eval 'sub KVM_GET_FPU () { &_IOR( &KVMIO, 0x8c, \'struct kvm_fpu\');}' unless defined(&KVM_GET_FPU);
    eval 'sub KVM_SET_FPU () { &_IOW( &KVMIO, 0x8d, \'struct kvm_fpu\');}' unless defined(&KVM_SET_FPU);
    eval 'sub KVM_GET_LAPIC () { &_IOR( &KVMIO, 0x8e, \'struct kvm_lapic_state\');}' unless defined(&KVM_GET_LAPIC);
    eval 'sub KVM_SET_LAPIC () { &_IOW( &KVMIO, 0x8f, \'struct kvm_lapic_state\');}' unless defined(&KVM_SET_LAPIC);
    eval 'sub KVM_SET_CPUID2 () { &_IOW( &KVMIO, 0x90, \'struct kvm_cpuid2\');}' unless defined(&KVM_SET_CPUID2);
    eval 'sub KVM_GET_CPUID2 () { &_IOWR( &KVMIO, 0x91, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_CPUID2);
    eval 'sub KVM_TPR_ACCESS_REPORTING () { &_IOWR( &KVMIO, 0x92, \'struct kvm_tpr_access_ctl\');}' unless defined(&KVM_TPR_ACCESS_REPORTING);
    eval 'sub KVM_SET_VAPIC_ADDR () { &_IOW( &KVMIO, 0x93, \'struct kvm_vapic_addr\');}' unless defined(&KVM_SET_VAPIC_ADDR);
    eval 'sub KVM_S390_INTERRUPT () { &_IOW( &KVMIO, 0x94, \'struct kvm_s390_interrupt\');}' unless defined(&KVM_S390_INTERRUPT);
    eval 'sub KVM_S390_STORE_STATUS_NOADDR () {(-1);}' unless defined(&KVM_S390_STORE_STATUS_NOADDR);
    eval 'sub KVM_S390_STORE_STATUS_PREFIXED () {(-2);}' unless defined(&KVM_S390_STORE_STATUS_PREFIXED);
    eval 'sub KVM_S390_STORE_STATUS () { &_IOW( &KVMIO, 0x95, \'unsigned long\');}' unless defined(&KVM_S390_STORE_STATUS);
    eval 'sub KVM_S390_SET_INITIAL_PSW () { &_IOW( &KVMIO, 0x96, \'struct kvm_s390_psw\');}' unless defined(&KVM_S390_SET_INITIAL_PSW);
    eval 'sub KVM_S390_INITIAL_RESET () { &_IO( &KVMIO, 0x97);}' unless defined(&KVM_S390_INITIAL_RESET);
    eval 'sub KVM_GET_MP_STATE () { &_IOR( &KVMIO, 0x98, \'struct kvm_mp_state\');}' unless defined(&KVM_GET_MP_STATE);
    eval 'sub KVM_SET_MP_STATE () { &_IOW( &KVMIO, 0x99, \'struct kvm_mp_state\');}' unless defined(&KVM_SET_MP_STATE);
    eval 'sub KVM_NMI () { &_IO( &KVMIO, 0x9a);}' unless defined(&KVM_NMI);
    eval 'sub KVM_SET_GUEST_DEBUG () { &_IOW( &KVMIO, 0x9b, \'struct kvm_guest_debug\');}' unless defined(&KVM_SET_GUEST_DEBUG);
    eval 'sub KVM_X86_SETUP_MCE () { &_IOW( &KVMIO, 0x9c,  &__u64);}' unless defined(&KVM_X86_SETUP_MCE);
    eval 'sub KVM_X86_GET_MCE_CAP_SUPPORTED () { &_IOR( &KVMIO, 0x9d,  &__u64);}' unless defined(&KVM_X86_GET_MCE_CAP_SUPPORTED);
    eval 'sub KVM_X86_SET_MCE () { &_IOW( &KVMIO, 0x9e, \'struct kvm_x86_mce\');}' unless defined(&KVM_X86_SET_MCE);
    eval 'sub KVM_GET_VCPU_EVENTS () { &_IOR( &KVMIO, 0x9f, \'struct kvm_vcpu_events\');}' unless defined(&KVM_GET_VCPU_EVENTS);
    eval 'sub KVM_SET_VCPU_EVENTS () { &_IOW( &KVMIO, 0xa0, \'struct kvm_vcpu_events\');}' unless defined(&KVM_SET_VCPU_EVENTS);
    eval 'sub KVM_GET_DEBUGREGS () { &_IOR( &KVMIO, 0xa1, \'struct kvm_debugregs\');}' unless defined(&KVM_GET_DEBUGREGS);
    eval 'sub KVM_SET_DEBUGREGS () { &_IOW( &KVMIO, 0xa2, \'struct kvm_debugregs\');}' unless defined(&KVM_SET_DEBUGREGS);
    eval 'sub KVM_ENABLE_CAP () { &_IOW( &KVMIO, 0xa3, \'struct kvm_enable_cap\');}' unless defined(&KVM_ENABLE_CAP);
    eval 'sub KVM_GET_XSAVE () { &_IOR( &KVMIO, 0xa4, \'struct kvm_xsave\');}' unless defined(&KVM_GET_XSAVE);
    eval 'sub KVM_SET_XSAVE () { &_IOW( &KVMIO, 0xa5, \'struct kvm_xsave\');}' unless defined(&KVM_SET_XSAVE);
    eval 'sub KVM_GET_XCRS () { &_IOR( &KVMIO, 0xa6, \'struct kvm_xcrs\');}' unless defined(&KVM_GET_XCRS);
    eval 'sub KVM_SET_XCRS () { &_IOW( &KVMIO, 0xa7, \'struct kvm_xcrs\');}' unless defined(&KVM_SET_XCRS);
    eval 'sub KVM_DIRTY_TLB () { &_IOW( &KVMIO, 0xaa, \'struct kvm_dirty_tlb\');}' unless defined(&KVM_DIRTY_TLB);
    eval 'sub KVM_GET_ONE_REG () { &_IOW( &KVMIO, 0xab, \'struct kvm_one_reg\');}' unless defined(&KVM_GET_ONE_REG);
    eval 'sub KVM_SET_ONE_REG () { &_IOW( &KVMIO, 0xac, \'struct kvm_one_reg\');}' unless defined(&KVM_SET_ONE_REG);
    eval 'sub KVM_KVMCLOCK_CTRL () { &_IO( &KVMIO, 0xad);}' unless defined(&KVM_KVMCLOCK_CTRL);
    eval 'sub KVM_ARM_VCPU_INIT () { &_IOW( &KVMIO, 0xae, \'struct kvm_vcpu_init\');}' unless defined(&KVM_ARM_VCPU_INIT);
    eval 'sub KVM_ARM_PREFERRED_TARGET () { &_IOR( &KVMIO, 0xaf, \'struct kvm_vcpu_init\');}' unless defined(&KVM_ARM_PREFERRED_TARGET);
    eval 'sub KVM_GET_REG_LIST () { &_IOWR( &KVMIO, 0xb0, \'struct kvm_reg_list\');}' unless defined(&KVM_GET_REG_LIST);
    eval 'sub KVM_S390_MEM_OP () { &_IOW( &KVMIO, 0xb1, \'struct kvm_s390_mem_op\');}' unless defined(&KVM_S390_MEM_OP);
    eval 'sub KVM_S390_GET_SKEYS () { &_IOW( &KVMIO, 0xb2, \'struct kvm_s390_skeys\');}' unless defined(&KVM_S390_GET_SKEYS);
    eval 'sub KVM_S390_SET_SKEYS () { &_IOW( &KVMIO, 0xb3, \'struct kvm_s390_skeys\');}' unless defined(&KVM_S390_SET_SKEYS);
    eval 'sub KVM_S390_IRQ () { &_IOW( &KVMIO, 0xb4, \'struct kvm_s390_irq\');}' unless defined(&KVM_S390_IRQ);
    eval 'sub KVM_S390_SET_IRQ_STATE () { &_IOW( &KVMIO, 0xb5, \'struct kvm_s390_irq_state\');}' unless defined(&KVM_S390_SET_IRQ_STATE);
    eval 'sub KVM_S390_GET_IRQ_STATE () { &_IOW( &KVMIO, 0xb6, \'struct kvm_s390_irq_state\');}' unless defined(&KVM_S390_GET_IRQ_STATE);
    eval 'sub KVM_SMI () { &_IO( &KVMIO, 0xb7);}' unless defined(&KVM_SMI);
    eval 'sub KVM_S390_GET_CMMA_BITS () { &_IOWR( &KVMIO, 0xb8, \'struct kvm_s390_cmma_log\');}' unless defined(&KVM_S390_GET_CMMA_BITS);
    eval 'sub KVM_S390_SET_CMMA_BITS () { &_IOW( &KVMIO, 0xb9, \'struct kvm_s390_cmma_log\');}' unless defined(&KVM_S390_SET_CMMA_BITS);
    eval 'sub KVM_MEMORY_ENCRYPT_OP () { &_IOWR( &KVMIO, 0xba, \'unsigned long\');}' unless defined(&KVM_MEMORY_ENCRYPT_OP);
    eval 'sub KVM_MEMORY_ENCRYPT_REG_REGION () { &_IOR( &KVMIO, 0xbb, \'struct kvm_enc_region\');}' unless defined(&KVM_MEMORY_ENCRYPT_REG_REGION);
    eval 'sub KVM_MEMORY_ENCRYPT_UNREG_REGION () { &_IOR( &KVMIO, 0xbc, \'struct kvm_enc_region\');}' unless defined(&KVM_MEMORY_ENCRYPT_UNREG_REGION);
    eval 'sub KVM_HYPERV_EVENTFD () { &_IOW( &KVMIO, 0xbd, \'struct kvm_hyperv_eventfd\');}' unless defined(&KVM_HYPERV_EVENTFD);
    eval 'sub KVM_GET_NESTED_STATE () { &_IOWR( &KVMIO, 0xbe, \'struct kvm_nested_state\');}' unless defined(&KVM_GET_NESTED_STATE);
    eval 'sub KVM_SET_NESTED_STATE () { &_IOW( &KVMIO, 0xbf, \'struct kvm_nested_state\');}' unless defined(&KVM_SET_NESTED_STATE);
    eval 'sub KVM_CLEAR_DIRTY_LOG () { &_IOWR( &KVMIO, 0xc0, \'struct kvm_clear_dirty_log\');}' unless defined(&KVM_CLEAR_DIRTY_LOG);
    eval 'sub KVM_GET_SUPPORTED_HV_CPUID () { &_IOWR( &KVMIO, 0xc1, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_SUPPORTED_HV_CPUID);
    eval 'sub KVM_ARM_VCPU_FINALIZE () { &_IOW( &KVMIO, 0xc2, \'int\');}' unless defined(&KVM_ARM_VCPU_FINALIZE);
    eval 'sub KVM_S390_NORMAL_RESET () { &_IO( &KVMIO, 0xc3);}' unless defined(&KVM_S390_NORMAL_RESET);
    eval 'sub KVM_S390_CLEAR_RESET () { &_IO( &KVMIO, 0xc4);}' unless defined(&KVM_S390_CLEAR_RESET);
    eval 'sub KVM_S390_PV_COMMAND () { &_IOWR( &KVMIO, 0xc5, \'struct kvm_pv_cmd\');}' unless defined(&KVM_S390_PV_COMMAND);
    eval 'sub KVM_X86_SET_MSR_FILTER () { &_IOW( &KVMIO, 0xc6, \'struct kvm_msr_filter\');}' unless defined(&KVM_X86_SET_MSR_FILTER);
    eval 'sub KVM_RESET_DIRTY_RINGS () { &_IO( &KVMIO, 0xc7);}' unless defined(&KVM_RESET_DIRTY_RINGS);
    eval 'sub KVM_XEN_HVM_GET_ATTR () { &_IOWR( &KVMIO, 0xc8, \'struct kvm_xen_hvm_attr\');}' unless defined(&KVM_XEN_HVM_GET_ATTR);
    eval 'sub KVM_XEN_HVM_SET_ATTR () { &_IOW( &KVMIO, 0xc9, \'struct kvm_xen_hvm_attr\');}' unless defined(&KVM_XEN_HVM_SET_ATTR);
    eval 'sub KVM_XEN_VCPU_GET_ATTR () { &_IOWR( &KVMIO, 0xca, \'struct kvm_xen_vcpu_attr\');}' unless defined(&KVM_XEN_VCPU_GET_ATTR);
    eval 'sub KVM_XEN_VCPU_SET_ATTR () { &_IOW( &KVMIO, 0xcb, \'struct kvm_xen_vcpu_attr\');}' unless defined(&KVM_XEN_VCPU_SET_ATTR);
    eval 'sub KVM_XEN_HVM_EVTCHN_SEND () { &_IOW( &KVMIO, 0xd0, \'struct kvm_irq_routing_xen_evtchn\');}' unless defined(&KVM_XEN_HVM_EVTCHN_SEND);
    eval 'sub KVM_GET_SREGS2 () { &_IOR( &KVMIO, 0xcc, \'struct kvm_sregs2\');}' unless defined(&KVM_GET_SREGS2);
    eval 'sub KVM_SET_SREGS2 () { &_IOW( &KVMIO, 0xcd, \'struct kvm_sregs2\');}' unless defined(&KVM_SET_SREGS2);
    eval 'sub KVM_DIRTY_LOG_MANUAL_PROTECT_ENABLE () {(1<< 0);}' unless defined(&KVM_DIRTY_LOG_MANUAL_PROTECT_ENABLE);
    eval 'sub KVM_DIRTY_LOG_INITIALLY_SET () {(1<< 1);}' unless defined(&KVM_DIRTY_LOG_INITIALLY_SET);
    unless(defined(&KVM_DIRTY_LOG_PAGE_OFFSET)) {
	eval 'sub KVM_DIRTY_LOG_PAGE_OFFSET () {0;}' unless defined(&KVM_DIRTY_LOG_PAGE_OFFSET);
    }
    eval 'sub KVM_DIRTY_GFN_F_DIRTY () { &_BITUL(0);}' unless defined(&KVM_DIRTY_GFN_F_DIRTY);
    eval 'sub KVM_DIRTY_GFN_F_RESET () { &_BITUL(1);}' unless defined(&KVM_DIRTY_GFN_F_RESET);
    eval 'sub KVM_DIRTY_GFN_F_MASK () {0x3;}' unless defined(&KVM_DIRTY_GFN_F_MASK);
    eval 'sub KVM_BUS_LOCK_DETECTION_OFF () {(1<< 0);}' unless defined(&KVM_BUS_LOCK_DETECTION_OFF);
    eval 'sub KVM_BUS_LOCK_DETECTION_EXIT () {(1<< 1);}' unless defined(&KVM_BUS_LOCK_DETECTION_EXIT);
    eval 'sub KVM_PMU_CAP_DISABLE () {(1<< 0);}' unless defined(&KVM_PMU_CAP_DISABLE);
    eval 'sub KVM_STATS_TYPE_SHIFT () {0;}' unless defined(&KVM_STATS_TYPE_SHIFT);
    eval 'sub KVM_STATS_TYPE_MASK () {(0xf <<  &KVM_STATS_TYPE_SHIFT);}' unless defined(&KVM_STATS_TYPE_MASK);
    eval 'sub KVM_STATS_TYPE_CUMULATIVE () {(0x <<  &KVM_STATS_TYPE_SHIFT);}' unless defined(&KVM_STATS_TYPE_CUMULATIVE);
    eval 'sub KVM_STATS_TYPE_INSTANT () {(0x1 <<  &KVM_STATS_TYPE_SHIFT);}' unless defined(&KVM_STATS_TYPE_INSTANT);
    eval 'sub KVM_STATS_TYPE_PEAK () {(0x2 <<  &KVM_STATS_TYPE_SHIFT);}' unless defined(&KVM_STATS_TYPE_PEAK);
    eval 'sub KVM_STATS_TYPE_LINEAR_HIST () {(0x3 <<  &KVM_STATS_TYPE_SHIFT);}' unless defined(&KVM_STATS_TYPE_LINEAR_HIST);
    eval 'sub KVM_STATS_TYPE_LOG_HIST () {(0x4 <<  &KVM_STATS_TYPE_SHIFT);}' unless defined(&KVM_STATS_TYPE_LOG_HIST);
    eval 'sub KVM_STATS_TYPE_MAX () { &KVM_STATS_TYPE_LOG_HIST;}' unless defined(&KVM_STATS_TYPE_MAX);
    eval 'sub KVM_STATS_UNIT_SHIFT () {4;}' unless defined(&KVM_STATS_UNIT_SHIFT);
    eval 'sub KVM_STATS_UNIT_MASK () {(0xf <<  &KVM_STATS_UNIT_SHIFT);}' unless defined(&KVM_STATS_UNIT_MASK);
    eval 'sub KVM_STATS_UNIT_NONE () {(0x <<  &KVM_STATS_UNIT_SHIFT);}' unless defined(&KVM_STATS_UNIT_NONE);
    eval 'sub KVM_STATS_UNIT_BYTES () {(0x1 <<  &KVM_STATS_UNIT_SHIFT);}' unless defined(&KVM_STATS_UNIT_BYTES);
    eval 'sub KVM_STATS_UNIT_SECONDS () {(0x2 <<  &KVM_STATS_UNIT_SHIFT);}' unless defined(&KVM_STATS_UNIT_SECONDS);
    eval 'sub KVM_STATS_UNIT_CYCLES () {(0x3 <<  &KVM_STATS_UNIT_SHIFT);}' unless defined(&KVM_STATS_UNIT_CYCLES);
    eval 'sub KVM_STATS_UNIT_BOOLEAN () {(0x4 <<  &KVM_STATS_UNIT_SHIFT);}' unless defined(&KVM_STATS_UNIT_BOOLEAN);
    eval 'sub KVM_STATS_UNIT_MAX () { &KVM_STATS_UNIT_BOOLEAN;}' unless defined(&KVM_STATS_UNIT_MAX);
    eval 'sub KVM_STATS_BASE_SHIFT () {8;}' unless defined(&KVM_STATS_BASE_SHIFT);
    eval 'sub KVM_STATS_BASE_MASK () {(0xf <<  &KVM_STATS_BASE_SHIFT);}' unless defined(&KVM_STATS_BASE_MASK);
    eval 'sub KVM_STATS_BASE_POW10 () {(0x <<  &KVM_STATS_BASE_SHIFT);}' unless defined(&KVM_STATS_BASE_POW10);
    eval 'sub KVM_STATS_BASE_POW2 () {(0x1 <<  &KVM_STATS_BASE_SHIFT);}' unless defined(&KVM_STATS_BASE_POW2);
    eval 'sub KVM_STATS_BASE_MAX () { &KVM_STATS_BASE_POW2;}' unless defined(&KVM_STATS_BASE_MAX);
    eval 'sub KVM_GET_STATS_FD () { &_IO( &KVMIO, 0xce);}' unless defined(&KVM_GET_STATS_FD);
    eval 'sub KVM_GET_XSAVE2 () { &_IOR( &KVMIO, 0xcf, \'struct kvm_xsave\');}' unless defined(&KVM_GET_XSAVE2);
    eval 'sub KVM_S390_PV_CPU_COMMAND () { &_IOWR( &KVMIO, 0xd0, \'struct kvm_pv_cmd\');}' unless defined(&KVM_S390_PV_CPU_COMMAND);
    eval 'sub KVM_X86_NOTIFY_VMEXIT_ENABLED () {(1 << 0);}' unless defined(&KVM_X86_NOTIFY_VMEXIT_ENABLED);
    eval 'sub KVM_X86_NOTIFY_VMEXIT_USER () {(1 << 1);}' unless defined(&KVM_X86_NOTIFY_VMEXIT_USER);
    eval 'sub KVM_S390_ZPCI_OP () { &_IOW( &KVMIO, 0xd1, \'struct kvm_s390_zpci_op\');}' unless defined(&KVM_S390_ZPCI_OP);
    eval 'sub KVM_SET_MEMORY_ATTRIBUTES () { &_IOW( &KVMIO, 0xd2, \'struct kvm_memory_attributes\');}' unless defined(&KVM_SET_MEMORY_ATTRIBUTES);
    eval 'sub KVM_MEMORY_ATTRIBUTE_PRIVATE () {(1 << 3);}' unless defined(&KVM_MEMORY_ATTRIBUTE_PRIVATE);
    eval 'sub KVM_CREATE_GUEST_MEMFD () { &_IOWR( &KVMIO, 0xd4, \'struct kvm_create_guest_memfd\');}' unless defined(&KVM_CREATE_GUEST_MEMFD);
    eval 'sub GUEST_MEMFD_FLAG_MMAP () {(1 << 0);}' unless defined(&GUEST_MEMFD_FLAG_MMAP);
    eval 'sub GUEST_MEMFD_FLAG_INIT_SHARED () {(1 << 1);}' unless defined(&GUEST_MEMFD_FLAG_INIT_SHARED);
    eval 'sub KVM_PRE_FAULT_MEMORY () { &_IOWR( &KVMIO, 0xd5, \'struct kvm_pre_fault_memory\');}' unless defined(&KVM_PRE_FAULT_MEMORY);
}
1;
