// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Nko`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x0007C0, 0x0007FA],
    [0x0007FD, 0x0007FF]
  ]
});
testPropertyEscapes(
  /^\p{Script=Nko}+$/u,
  matchSymbols,
  "\\p{Script=Nko}"
);
testPropertyEscapes(
  /^\p{Script=Nkoo}+$/u,
  matchSymbols,
  "\\p{Script=Nkoo}"
);
testPropertyEscapes(
  /^\p{sc=Nko}+$/u,
  matchSymbols,
  "\\p{sc=Nko}"
);
testPropertyEscapes(
  /^\p{sc=Nkoo}+$/u,
  matchSymbols,
  "\\p{sc=Nkoo}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x0007BF],
    [0x0007FB, 0x0007FC],
    [0x000800, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Nko}+$/u,
  nonMatchSymbols,
  "\\P{Script=Nko}"
);
testPropertyEscapes(
  /^\P{Script=Nkoo}+$/u,
  nonMatchSymbols,
  "\\P{Script=Nkoo}"
);
testPropertyEscapes(
  /^\P{sc=Nko}+$/u,
  nonMatchSymbols,
  "\\P{sc=Nko}"
);
testPropertyEscapes(
  /^\P{sc=Nkoo}+$/u,
  nonMatchSymbols,
  "\\P{sc=Nkoo}"
);

reportCompare(0, 0);
