#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 HS-157
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Tiny & Big in Grandpa's Leftovers
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251010.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='tiny-and-big'
GAME_NAME='Tiny & Big in Grandpa’s Leftovers'

ARCHIVE_BASE_GOG_0_NAME='tiny_and_big_grandpa_s_leftovers_en_1_4_2_15616.sh'
ARCHIVE_BASE_GOG_0_MD5='bdcc1ea8366dedcfe00b50c439fd5ec9'
ARCHIVE_BASE_GOG_0_SIZE='2400000'
ARCHIVE_BASE_GOG_0_VERSION='1.4.2-gog15616'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/tiny_and_big_grandpas_leftovers'

ARCHIVE_BASE_HUMBLE_0_NAME='tinyandbig_grandpasleftovers-retail-linux-1.4.1_1370968537.tar.bz2'
ARCHIVE_BASE_HUMBLE_0_MD5='c6c2bc286f11e4a232211c5176105890'
ARCHIVE_BASE_HUMBLE_0_SIZE='2400000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.4.1-humble1370968537'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/tiny-big-grandpas-leftovers'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='tiny-and-big_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='043fa61c838ba6b2ef301c52660352b1'
ARCHIVE_OPTIONAL_ICONS_URL='http://downloads.dotslashplay.it/games/tiny-and-big/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48
64x64'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='tinyandbig'
## TODO: Check if some shipped libraries could be replaced with system-provided ones.
CONTENT_LIBS_BIN_FILES='
libcal3d.so
libCgGL.so
libCg.so'
CONTENT_LIBS_BIN64_RELATIVE_PATH='bin64"'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH='bin32'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_FILES='
bin64/tinyandbig'
CONTENT_GAME_BIN32_FILES='
bin32/tinyandbig'
CONTENT_GAME_DATA_FILES='
assets'

USER_PERSISTENT_FILES='
options.txt
*.save'

APP_MAIN_EXE_BIN64='bin64/tinyandbig'
APP_MAIN_EXE_BIN32='bin32/tinyandbig'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libstdc++.so.6
libX11.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
