if("Vanilla" IN_LIST NAMES)
	message(STATUS "Use libraries: System")
	return()
elseif("Qt" IN_LIST NAMES)
	message(STATUS "Use libraries: Qt")
	find_program(AQT aqt REQUIRED)
else()
	message(STATUS "Use libraries: Governikus")
	if(DEFINED ENV{JENKINS_HOME})
		message(STATUS "Use libraries: Jenkins")
		return()
	endif()
endif()

if(EXISTS ${T_LIBS_DIR})
	step(${CMAKE_COMMAND} -E rm -r ${T_LIBS_DIR})
endif()

if(AQT)
	if(NOT QT)
		message(FATAL_ERROR "Provide version via -DQT=")
	endif()
	step(${AQT} install-qt -O ${T_LIBS_DIR} linux desktop ${QT} --modules qtwebsockets qtscxml qtconnectivity)
	step(${CMAKE_COMMAND} -E create_symlink ${QT}/gcc_64 ${T_LIBS_DIR}/dist)
	return()
endif()



if("FreeBSD" IN_LIST NAMES)
	set(PRESET ci-debug)
elseif("Android" IN_LIST NAMES)
	set(PRESET ci-android)
elseif("iOS" IN_LIST NAMES)
	if("Simulator" IN_LIST NAMES)
		set(PRESET ci-ios-simulator)
		if("x86" IN_LIST NAMES AND "64" IN_LIST NAMES)
			set(PRESET ${PRESET}-x86_64)
		elseif("arm64" IN_LIST NAMES)
			set(PRESET ${PRESET}-arm64)
		endif()
	else()
		set(PRESET ci-ios)
	endif()

	step(security unlock-keychain $ENV{KEYCHAIN_CREDENTIALS} $ENV{HOME}/Library/Keychains/login.keychain-db)
elseif("Win" IN_LIST NAMES)
	if("GNU" IN_LIST NAMES)
		set(PRESET ci-gnu-release)
	else()
		set(VCVARS cmd /c vcvarsall.bat amd64 && call)
		if("dev" IN_LIST NAMES)
			set(PRESET ci-msvc-debug)
		else()
			set(PRESET ci-msvc-release)
		endif()
	endif()
else()
	set(PRESET ci-release)
endif()

CALC_CHECKSUM(SALT ${CMAKE_CURRENT_LIST_FILE})
if(CMAKE_PARENT_LIST_FILE STREQUAL CMAKE_SCRIPT_MODE_FILE)
	set(LIBRARIES_SCRIPT_ONLY ON)
endif()

if(LIBRARIES_SCRIPT_ONLY OR PROPAGATE)
	set(cfg ${T_CFG_LIBS})
else()
	set(cfg ${T_CFG_LIBS_DEPS})
endif()

if(DEFINED OPENSSL)
	list(APPEND CUSTOM_VERSION -DOPENSSL=${OPENSSL})
endif()
if(DEFINED QT)
	list(APPEND CUSTOM_VERSION -DQT=${QT})
endif()

step(${VCVARS} ${cfg} --preset ${PRESET} -DSALT=${SALT} ${CUSTOM_VERSION} NO_ECHO)
find_package(Governikus REQUIRED PATHS ${T_LIBS_DIR} NO_CMAKE_PATH NO_CMAKE_SYSTEM_PATH)
set(CACHED_TARBALL ${CACHE_DIR}/${LIBS_TARBALL})

block()
	include(Files)
endblock()

if(EXISTS "${CACHED_TARBALL}")
	message(STATUS "Use cached libraries: ${LIBS_TARBALL}")
elseif(NOT PROVIDER_NO_DOWNLOAD)
	download_pkg_libs("${CACHED_TARBALL}")
endif()

if(NOT EXISTS "${CACHED_TARBALL}" AND NOT PROVIDER_NO_BUILD)
	message(STATUS "Build libraries...")
	if("Win" IN_LIST NAMES)
		set(OPTIONAL_PATH PATH ${WORKSPACE}/${T_LIBS_DIR}/dist/bin)
	endif()

	step(${VCVARS} ${CMAKE_COMMAND} --build ${T_LIBS_DIR} --target compress ${OPTIONAL_PATH})
	step(${CMAKE_COMMAND} -E copy_if_different "${T_LIBS_DIR}/${LIBS_TARBALL}" "${CACHED_TARBALL}")
	if(DEFINED ENV{GITLAB_CI})
		upload_pkg_libs("${CACHED_TARBALL}")
	endif()
endif()

step(${CMAKE_COMMAND} -E rm -r ${T_LIBS_DIR})

if(NOT LIBRARIES_SCRIPT_ONLY)
	step(${CMAKE_COMMAND} -E make_directory ${T_LIBS_DIR})
	step(${CMAKE_COMMAND} -E tar xf "${CACHED_TARBALL}" CHDIR ${T_LIBS_DIR})
endif()
