---
title: PICOTOOL-OTP-GET
section: 1
header: User Commands
---
# NAME

picotool\-otp\-get \- Get the value of one or more OTP registers/fields

# SYNOPSIS

picotool otp get \[\-c \<copies\>\] \[\-r\] \[\-e\] \[\-n\] \[\-i \<filename\>\] \[device\-selection\] \[\-z\] \[\<selector\>\.\.\]


# OPTIONS

Row/field options

**\-c** \<*copies*\>
: Read multiple redundant values

**\-r**, **\-\-raw**
: Get raw 24\-bit values

**\-e**, **\-\-ecc**
: Use error correction

**\-n**, **\-\-no\-descriptions**
: Don't show descriptions

**\-i** \<*filename*\>
: Include extra otp definition

Row/Field Selection

**\-z**, **\-\-fuzzy**
: Allow fuzzy name searches in selector vs exact match

\<*selector*\>
: The row/field selector, each of which can select a whole row:

ROW\_NAME to select a whole row by name\. ROW\_NUMBER to select a whole row by number\. PAGE:PAGE\_ROW\_NUMBER to select a whole row by page and number within page\.

\.\.\. or can select a single field/subset of a row \(where ROW\_SEL is one of the above row selectors\):

ROW\_SEL\.FIELD\_NAME to select a field within a row by name\. ROW\_SEL\.n\-m to select a range of bits within a row\. ROW\_SEL\.n to select a single bit within a row\. \.FIELD\_NAME to select any row's field by name\.

\.\. or can select multiple rows by using blank or '\*' for PAGE or PAGE\_ROW\_NUMBER

# TARGET SELECTION

Target device selection

**\-\-bus** \<*bus*\>
: Filter devices by USB bus number

**\-\-address** \<*addr*\>
: Filter devices by USB device address

**\-\-vid** \<*vid*\>
: Filter by vendor id

**\-\-pid** \<*pid*\>
: Filter by product id

**\-\-ser** \<*ser*\>
: Filter by serial number

**\-f**, **\-\-force**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will berebooted back to application mode

**\-F**, **\-\-force\-no\-reboot**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will be leftconnected and accessible to picotool, but without the USB drivemounted

