/* strtree.h BEGIN { */
#ifndef UREGLEX_STRTREE_H
#define UREGLEX_STRTREE_H 
typedef enum {ULX_REQ = 1, ULX_BRA, ULX_FIN, ULX_BAD} ureglex_stree_op_t;
typedef struct ureglex_strtree_s { int *code, *ip; } ureglex_strtree_t;
int ureglex_strtree_exec(ureglex_strtree_t *ctx, int chr);
#define UREGLEX_STRTREE_MORE -5
#endif
/* strtree.h END } */

/* exec.h BEGIN { */
#ifndef UREGLEX_EXEC_COMMON_H
#define UREGLEX_EXEC_COMMON_H 
#define MAXTAG 10
typedef struct ureglex_precomp_s {
 const unsigned char *nfa;
 const unsigned char *bittab;
 const unsigned char *chrtyp;
 double weight;
} ureglex_precomp_t;
typedef struct ureglex_s {
 ureglex_precomp_t *pc;
 const char *bol;
 const char *bopat[MAXTAG];
 const char *eopat[MAXTAG];
 int score;
 const char *endp;
 union { const void *ptr; int i; } pmstk[30];
 int pmsp;
 const unsigned char *pm_ap;
 const char *pm_lp;
 int pm_c;
 const char *pm_bp;
 const char *pm_ep;
 const char *pm_are;
 const char *ex_lp;
 unsigned char ex_c;
 int ex_loop, pm_loop, pm_loop2, pm_loop2_later;
 int exec_state;
} ureglex_t;
typedef enum {
 UREGLEX_MORE = -1,
 UREGLEX_TOO_LONG = -2,
 UREGLEX_NO_MATCH = -3,
 UREGLEX_NOP = -4
} ureglex_error_t;
extern const unsigned char ureglex_nfa_str[];
#define ULX_BUF ctx->buff
#define ULX_TAGP(n) (ctx->state[ruleid].bopat[(n)])
#define ULX_TAGL(n) (ctx->state[ruleid].eopat[(n)] - ctx->state[ruleid].bopat[(n)])
#define ULX_IGNORE goto ureglex_ignore;
void ureglex_exec_init(ureglex_t *r, const char *lp, int buff_used);
int ureglex_exec(ureglex_t *r);
#endif
/* exec.h END } */

#define sch_bxl_num_rules 74
typedef struct sch_bxl_ureglex_s {
	ureglex_precomp_t *rules;
	char buff[256];
	int num_rules, buff_used, step_back_to, buff_save_term, by_len;
	long loc_offs[2], loc_line[2], loc_col[2];
	ureglex_t state[sch_bxl_num_rules];
	const char *sp;
	int strtree_state, strtree_len, strtree_score;
	ureglex_strtree_t strtree;
	ureglex_t *pending_intcode;
} sch_bxl_ureglex_t;

/* exec_spec.h BEGIN { */
void sch_bxl_lex_reset(sch_bxl_ureglex_t *ctx);
void sch_bxl_lex_init(sch_bxl_ureglex_t *ctx, ureglex_precomp_t *rules);
int sch_bxl_lex_char(sch_bxl_ureglex_t *ctx, void *user_ctx, int chr);
/* exec_spec.h END } */

#ifndef URELGLEX_EXEC_sch_bxl_H
#define URELGLEX_EXEC_sch_bxl_H
extern ureglex_precomp_t sch_bxl_rules[];
#define URELGLEX_EXEC_sch_bxl_HAS_COMMON 0
#endif
