[comment {-*- tcl -*- doctools manpage}]
[manpage_begin jsend 1 0.1]
[copyright {2015 Sergei Golovan <sgolovan@nes.ru>}]
[moddesc {Tcl XMPP library}]
[titledesc {Tcl XMPP command line send utility}]
[description]
[para]

This utility is a part of the Tcl XMPP library. It implements a command
line client which can send a single or multiple messages via XMPP
network. To do that it connects to an XMPP server using specified
login and password.

[list_begin definitions]
[call [cmd jsend] [arg recipient] \
        [opt "[option -option] [arg value] ..."]]

[para]

The required Tcl packages for the [cmd jsend] utility are [arg tls]
and quite a few modules from the [arg Tcllib] collection.

[para]

The client takes one mandatory argument [arg recipient] and a few option-value
pairs. The [arg recipient] can be either a JID ot send the messages or
literal "[const -]" in which case the messages will be sent to all roster
members of the connected JID.

[para]

The message body to send can be specified in three ways. First it can be a value
of "[option -body]" option. Second, if "[option -follow]" is specified, it points
to a file which contents will be sent line by line, and after that any apended
line will be sent also. And finally, if there's no "[option -body]"
or "[option -follow]" options then the message is taken from the standard input.

[para]

The full list of the command line options follows below:

[list_begin definitions]
[def "[option -from] [arg jid]"]
[para]
The sender JID. If there's no [option -host] option then the server part
of the specified JID is used to connect to.

[def "[option -password] [arg string]"]
[para]
The sender password.

[def "[option -type] [arg normal|chat]"]
[para]
The message type. Must be one of [const normal] or [const chat].
Defaults to [const chat].

[def "[option -subject] [arg string]"]
[para]
The message subject.

[def "[option -body] [arg string]"]
[para]
The message body.

[def "[option -xhtml] [arg string]"]
[para]
The XHTML message (see XEP-0071 for details).

[def "[option -url] [arg string]"]
[para]
The URL to attach (see XEP-0066 for details).

[def "[option -description] [arg string]"]
[para]
The description for the URL attached (see XEP-0066 for details).

[def "[option -follow] [arg file]"]
[para]
Follow the specified file for the messages stream.

[def "[option -pidfile] [arg file]"]
[para]
Create the specified file with the PID of the running process. This
option is useful together with [option -follow] option.

[def "[option -host] [arg hostname]"]
[para]
Explicit hostname to connect to.

[def "[option -port] [arg number]"]
[para]
Explicit port to connect to.

[def "[option -bosh] [arg string]"]
[para]
BOSH URL (see XEP-0124 and XEP-0206 for details).

[def "[option -tls] [arg boolean]"]
[para]
Whether the old legacy SSL encryption is to be used (defaults to [const false]).

[def "[option -starttls] [arg boolean]"]
[para]
Whether the STARTTLS and therefore the TLS encryption is to be used (defaults
to [const true]).

[def "[option -sasl] [arg boolean]"]
[para]
Whether the SASL authentication is to be used (defaults to [const true]).

[list_end]
[list_end]

[section "FILES"]

The file .jsendrc.tcl in the current directory or in the current user's home
directory is sourced if it's available and is not world readable. It can contain
any Tcl code and modify the jsend behavior in any way but its primary goal is to
define [var args] list of option-value pairs, e.g.

[example {
set args {-from fred@example.com/bedrock -password wilma}
}]

[section "AUTHORS"]

Marshall T. Rose,
Sergei Golovan

[keywords Tcl XMPP]
[comment { vim: set ft=tcl ts=8 sw=4 sts=4 et: }]
[manpage_end]
