/* rcode template file: rcd_scp.tmp.c */

#include "%rcd_bname%_rcd_scope.h"

__BEGIN_DECLS

// rcd_autogen: full/basic mode

typedef struct __tls_rcd_scope_s {
	const rcd_scope_t  *scope;
	// "volatile"/variable message:
	//  valid only right after the rcode is returned
	rcd_vmsg_t          vmsg;
} tls_rcd_scope_t;

static __thread tls_rcd_scope_t __tls_scope;


struct rcd_scope*
%rcd_bname%_rcdGetScopePtr() {
	__tls_scope.scope = &%rcd_bname%_scope;
	return (struct rcd_scope*) &__tls_scope;
}

//full mode (2) -> VMSG defines min buffer size, otherwise
//it's the max length of static message
//the rcd_autogen_md variable is injected by rcd_autogen
//RCD_MODE_BASIC comes from rcode.h
int
%rcd_bname%_rcdGetMinMsgBufSz(struct rcd_scope *scp) {
	tls_rcd_scope_t *p_scp = (tls_rcd_scope_t*) scp;
	__tls_scope.scope = &%rcd_bname%_scope;
	if (NULL == p_scp) {p_scp = &__tls_scope; }
	return (int) ( p_scp->scope->hdr.rcdgen_md > RCD_MODE_BASIC) ? RCD_VMSG_MAX_SZ : p_scp->scope->hdr.min_bufsz;
}

__END_DECLS
