// re2swift $INPUT -o $OUTPUT

struct SemVer: Equatable { var major: Int, minor: Int, patch: Int }

func lex(_ yyinput: UnsafePointer<UInt8>) -> SemVer? {
  let tagNone = -1

  var yycursor = 0, yymarker = 0

  // Final tag variables available in semantic action.
  /*!svars:re2c format = "var @@ = tagNone\n"; */

  // Intermediate tag variables used by the lexer (must be autogenerated).
  /*!stags:re2c format = 'var @@ = tagNone\n'; */

  /*!re2c
    re2c:yyfill:enable = 0;
    re2c:tags = 1;

    num = [0-9]+;

    @t1 num @t2 "." @t3 num @t4 ("." @t5 num)? [\x00] {
      let s2n = { (range: Range<Int>) in
        range.reduce(0) { accum, idx in
          accum * 10 + Int(yyinput[idx] - UInt8(ascii: "0"))
        }
      }

      return SemVer(
        major: s2n(t1..<t2),
        minor: s2n(t3..<t4),
        patch: t5 != tagNone ? s2n(t5..<(yycursor - 1)) : 0)
    }
    * { return nil }
  */
}

assert(lex("23.34") == SemVer(major: 23, minor: 34, patch: 0))
assert(lex("1.2.999") == SemVer(major: 1, minor: 2, patch: 999))
assert(lex("1.a") == nil)
