#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader import fenrirVersion
from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("Present the version of Fenrir currently in use.")

    def run(self):
        try:
            self.env["runtime"]["OutputManager"].present_text(
                f"Fenrir screen reader version {
                    fenrirVersion.version}-{
                    fenrirVersion.code_name}",
                interrupt=True,
            )
        except Exception as e:
            self.env["runtime"]["OutputManager"].present_text(
                _("Version information is unavailable."), interrupt=True
            )

    def set_callback(self, callback):
        pass
