# Contributing

We are open to, and grateful for, any contributions made by the community. By contributing to axios, you agree to abide by the [code of conduct](https://github.com/axios/axios/blob/master/CODE_OF_CONDUCT.md).

## Code Style

Please follow the [node style guide](https://github.com/felixge/node-style-guide).

## Commit Messages

Please follow [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/)

## Testing

Please update the tests to reflect your code changes. Pull requests will not be accepted if they are failing on GitHub actions.

## Documentation

Please update the [documentation](https://axios-http.com/docs/intro) accordingly so that there are no discrepancies between the API and the documentation.

## Developing

- `npm run test` run the jasmine and mocha tests
- `npm run build` run rollup and bundle the source
- `npm run version` prepare the code for release

Please don't include changes to `dist/` in your pull request. This should only be updated when releasing a new version.

## Running Examples

Examples are included in part to allow manual testing.

Running example

```bash
> npm run examples
# Open 127.0.0.1:3000
```

Running sandbox in browser

```bash
> npm start
# Open 127.0.0.1:3000
```

Running sandbox in terminal

```bash
> npm start
> node ./sandbox/client
```
