% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{jinjar_config}
\alias{jinjar_config}
\alias{default_config}
\title{Configure the templating engine}
\usage{
jinjar_config(
  loader = NULL,
  block_open = "{\%",
  block_close = "\%}",
  variable_open = "{{",
  variable_close = "}}",
  comment_open = "{#",
  comment_close = "#}",
  line_statement = NULL,
  trim_blocks = FALSE,
  lstrip_blocks = FALSE,
  ignore_missing_files = FALSE
)

default_config()
}
\arguments{
\item{loader}{How the engine discovers templates. Choices:
\itemize{
\item \code{NULL} (default), disables search for templates.
\item Path to template directory.
\item A \code{\link{loader}} object.
}}

\item{block_open, block_close}{The opening and closing delimiters
for control blocks. Default: \verb{"\{\%"} and \verb{"\%\}"}.}

\item{variable_open, variable_close}{The opening and closing delimiters
for print statements. Default: \code{"{{"} and \code{"}}"}.}

\item{comment_open, comment_close}{The opening and closing delimiters
for comments. Default: \code{"{#"} and \code{"#}"}.}

\item{line_statement}{The prefix for an inline statement. If \code{NULL} (the
default), inline statements are disabled.}

\item{trim_blocks}{Remove first newline after a block. Default: \code{FALSE}.}

\item{lstrip_blocks}{Remove inline whitespace before a block. Default: \code{FALSE}.}

\item{ignore_missing_files}{Ignore \code{include} or \code{extends} statements when
the auxiliary template cannot be found. If \code{FALSE} (default), then an error
is raised.}
}
\value{
A \code{"jinjar_config"} object.
}
\description{
Create an object to configure the templating engine behavior (e.g. customize
the syntax). The default values have been chosen to match the Jinja defaults.
}
\note{
The equivalent Jinja class is \code{Environment}, but this term has special
significance in R (see \code{\link[=environment]{environment()}}).
}
\examples{
jinjar_config()
}
