# Try pkg-config first
find_package(PkgConfig)
pkg_check_modules(PKGC_LIBFUSE QUIET fuse)
pkg_check_modules(PKGC_LIBFUSE3 QUIET fuse3)

if(PKGC_LIBFUSE_FOUND AND PKGC_LIBFUSE3_FOUND)
  message(STATUS "Found libfuse2 and libfuse3, preferring v3 over v2")
  set(PKGC_LIBFUSE_FOUND false)
endif(PKGC_LIBFUSE_FOUND AND PKGC_LIBFUSE3_FOUND)

if(PKGC_LIBFUSE_FOUND OR PKGC_LIBFUSE3_FOUND)
  # Found lib using pkg-config.
  if(PKGC_LIBFUSE_FOUND)
    # Found libfuse2
    if(CMAKE_DEBUG)
      message(STATUS "\${PKGC_LIBFUSE_LIBRARIES} = ${PKGC_LIBFUSE_LIBRARIES}")
      message(STATUS "\${PKGC_LIBFUSE_LIBRARY_DIRS} = ${PKGC_LIBFUSE_LIBRARY_DIRS}")
      message(STATUS "\${PKGC_LIBFUSE_LDFLAGS} = ${PKGC_LIBFUSE_LDFLAGS}")
      message(STATUS "\${PKGC_LIBFUSE_LDFLAGS_OTHER} = ${PKGC_LIBFUSE_LDFLAGS_OTHER}")
      message(STATUS "\${PKGC_LIBFUSE_INCLUDE_DIRS} = ${PKGC_LIBFUSE_INCLUDE_DIRS}")
      message(STATUS "\${PKGC_LIBFUSE_CFLAGS} = ${PKGC_LIBFUSE_CFLAGS}")
      message(STATUS "\${PKGC_LIBFUSE_CFLAGS_OTHER} = ${PKGC_LIBFUSE_CFLAGS_OTHER}")
    endif(CMAKE_DEBUG)

    set(LIBFUSE_LIBRARIES ${PKGC_LIBFUSE_LIBRARIES})
    set(LIBFUSE_INCLUDE_DIRS ${PKGC_LIBFUSE_INCLUDE_DIRS})
    #set(LIBFUSE_DEFINITIONS ${PKGC_LIBFUSE_CFLAGS_OTHER})
    set(LIBFUSE_VERSION 2)
  else(PKGC_LIBFUSE_FOUND)
    # Found libfuse3
    if(CMAKE_DEBUG)
      message(STATUS "\${PKGC_LIBFUSE3_LIBRARIES} = ${PKGC_LIBFUSE3_LIBRARIES}")
      message(STATUS "\${PKGC_LIBFUSE3_LIBRARY_DIRS} = ${PKGC_LIBFUSE3_LIBRARY_DIRS}")
      message(STATUS "\${PKGC_LIBFUSE3_LDFLAGS} = ${PKGC_LIBFUSE3_LDFLAGS}")
      message(STATUS "\${PKGC_LIBFUSE3_LDFLAGS_OTHER} = ${PKGC_LIBFUSE3_LDFLAGS_OTHER}")
      message(STATUS "\${PKGC_LIBFUSE3_INCLUDE_DIRS} = ${PKGC_LIBFUSE3_INCLUDE_DIRS}")
      message(STATUS "\${PKGC_LIBFUSE3_CFLAGS} = ${PKGC_LIBFUSE3_CFLAGS}")
      message(STATUS "\${PKGC_LIBFUSE3_CFLAGS_OTHER} = ${PKGC_LIBFUSE3_CFLAGS_OTHER}")
    endif(CMAKE_DEBUG)

    set(LIBFUSE_LIBRARIES ${PKGC_LIBFUSE3_LIBRARIES})
    set(LIBFUSE_INCLUDE_DIRS ${PKGC_LIBFUSE3_INCLUDE_DIRS})
    #set(LIBFUSE_DEFINITIONS ${PKGC_LIBFUSE3_CFLAGS_OTHER})
    set(LIBFUSE_VERSION 3)
  endif(PKGC_LIBFUSE_FOUND)
else(PKGC_LIBFUSE_FOUND OR PKGC_LIBFUSE3_FOUND)
  # Didn't find lib using pkg-config. Try to find it manually
  message(WARNING "Unable to find LibFUSE using pkg-config! If compilation fails, make sure pkg-config is installed and PKG_CONFIG_PATH is set correctly")

  find_path(LIBFUSE_INCLUDE_DIR fuse.h
            PATH_SUFFIXES fuse)
  find_library(LIBFUSE_LIBRARY NAMES fuse libfuse)
  find_library(LIBFUSE3_LIBRARY NAMES fuse3 libfuse3)

  if(LIBFUSE_LIBRARY AND LIBFUSE3_LIBRARY)
    message(STATUS "Found libfuse2 and libfuse3, preferring v3 over v2")
    set(LIBFUSE_LIBRARY false)
  endif(LIBFUSE_LIBRARY AND LIBFUSE3_LIBRARY)

  if(LIBFUSE_LIBRARY)
    if(CMAKE_DEBUG)
      message(STATUS "\${LIBFUSE_LIBRARY} = ${LIBFUSE_LIBRARY}")
      message(STATUS "\${LIBFUSE_INCLUDE_DIR} = ${LIBFUSE_INCLUDE_DIR}")
    endif(CMAKE_DEBUG)

    set(LIBFUSE_LIBRARIES ${LIBFUSE_LIBRARY})
    set(LIBFUSE_INCLUDE_DIRS ${LIBFUSE_INCLUDE_DIR})
    set(LIBFUSE_VERSION 2)
  endif(LIBFUSE_LIBRARY)

  if(LIBFUSE3_LIBRARY)
    if(CMAKE_DEBUG)
      message(STATUS "\${LIBFUSE3_LIBRARY} = ${LIBFUSE3_LIBRARY}")
      message(STATUS "\${LIBFUSE_INCLUDE_DIR} = ${LIBFUSE_INCLUDE_DIR}")
    endif(CMAKE_DEBUG)

    set(LIBFUSE_LIBRARIES ${LIBFUSE3_LIBRARY})
    set(LIBFUSE_INCLUDE_DIRS ${LIBFUSE_INCLUDE_DIR})
    set(LIBFUSE_VERSION 3)
  endif(LIBFUSE3_LIBRARY)
endif(PKGC_LIBFUSE_FOUND OR PKGC_LIBFUSE3_FOUND)

include(FindPackageHandleStandardArgs)
# Handle the QUIETLY and REQUIRED arguments and set <PREFIX>_FOUND to TRUE if
# all listed variables are TRUE
find_package_handle_standard_args(LibFUSE DEFAULT_MSG LIBFUSE_LIBRARIES)

