/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import org.apache.commons.lang3.util.FluentBitSet;

final class URIBitSets {
    static final FluentBitSet PERCENT = URIBitSets.bitSet(37);
    static final FluentBitSet DIGIT = URIBitSets.bitSet().setInclusive(48, 57);
    static final FluentBitSet ALPHA = URIBitSets.bitSet().setInclusive(97, 122).setInclusive(65, 90);
    static final FluentBitSet ALPHANUM = URIBitSets.bitSet().or(new FluentBitSet[]{ALPHA, DIGIT});
    static final FluentBitSet HEX = URIBitSets.bitSet().or(DIGIT).setInclusive(97, 102).setInclusive(65, 70);
    static final FluentBitSet ESCAPED = URIBitSets.bitSet().or(new FluentBitSet[]{PERCENT, HEX});
    static final FluentBitSet MARK = URIBitSets.bitSet(45, 95, 46, 33, 126, 42, 39, 40, 41);
    static final FluentBitSet UNRESERVED = URIBitSets.bitSet().or(new FluentBitSet[]{ALPHANUM, MARK});
    static final FluentBitSet RESERVED = URIBitSets.bitSet(59, 47, 63, 58, 64, 38, 61, 43, 36, 44);
    static final FluentBitSet URIC;
    static final FluentBitSet FRAGMENT;
    static final FluentBitSet QUERY;
    static final FluentBitSet PCHAR;
    static final FluentBitSet PARAM;
    static final FluentBitSet SEGMENT;
    static final FluentBitSet PATH_SEGMENTS;
    static final FluentBitSet ABS_PATH;
    static final FluentBitSet URIC_NO_SLASH;
    static final FluentBitSet OPAQUE_PART;
    static final FluentBitSet PATH;
    static final FluentBitSet PORT;
    static final FluentBitSet IPV4ADDRESS;
    static final FluentBitSet IPV6ADDRESS;
    static final FluentBitSet IPV6REFERENCE;
    static final FluentBitSet TOPLABEL;
    static final FluentBitSet DOMAINLABEL;
    static final FluentBitSet HOSTNAME;
    static final FluentBitSet HOST;
    static final FluentBitSet HOSTPORT;
    static final FluentBitSet USERINFO;
    static final FluentBitSet WITHIN_USERRINFO;
    static final FluentBitSet SERVER;
    static final FluentBitSet REG_NAME;
    static final FluentBitSet AUTHORITY;
    static final FluentBitSet SCHEME;
    static final FluentBitSet REL_SEGMENT;
    static final FluentBitSet REL_PATH;
    static final FluentBitSet NET_PATH;
    static final FluentBitSet HIER_PART;
    static final FluentBitSet RELATIVEURI;
    static final FluentBitSet ABSOLUTEURI;
    static final FluentBitSet URI_REFERENCE;
    static final FluentBitSet SPACE;
    static final FluentBitSet DELIMS;
    static final FluentBitSet UNWISE;
    static final FluentBitSet DISALLOWED_REL_PATH;
    static final FluentBitSet DISALLOWED_OPAQUE_PART;
    static final FluentBitSet ALLOWED_AUTHORITY;
    static final FluentBitSet ALLOWED_OPAQUE_PART;
    static final FluentBitSet ALLOWED_REG_NAME;
    static final FluentBitSet ALLOWED_USER_INFO;
    static final FluentBitSet ALLOWED_WITHIN_USERINFO;
    static final FluentBitSet ALLOWED_IPV6REFERENCE;
    static final FluentBitSet ALLOWED_HOST;
    static final FluentBitSet ALLOWED_WITHIN_AUTHORITY;
    static final FluentBitSet ALLOWED_ABS_PATH;
    static final FluentBitSet ALLOWED_REL_PATH;
    static final FluentBitSet ALLOWED_WITHIN_PATH;
    static final FluentBitSet ALLOWED_QUERY;
    static final FluentBitSet ALLOWED_WITHIN_QUERY;
    static final FluentBitSet ALLOWED_FRAGMENT;
    private static final int CHARACTER_DEL = 127;
    private static final int CHARACTER_US = 31;
    static final FluentBitSet CONTROL;
    private static final int NBITS = 256;

    static FluentBitSet bitSet() {
        return new FluentBitSet(256);
    }

    private static FluentBitSet bitSet(int ... bitIndexArray) {
        return URIBitSets.bitSet().set(bitIndexArray);
    }

    private URIBitSets() {
    }

    static {
        FRAGMENT = URIC = URIBitSets.bitSet().or(new FluentBitSet[]{RESERVED, UNRESERVED, ESCAPED});
        QUERY = URIC;
        PARAM = PCHAR = URIBitSets.bitSet(58, 64, 38, 61, 43, 36, 44).or(new FluentBitSet[]{UNRESERVED, ESCAPED});
        SEGMENT = URIBitSets.bitSet(59).or(new FluentBitSet[]{PCHAR, PARAM});
        PATH_SEGMENTS = URIBitSets.bitSet(47).or(SEGMENT);
        ABS_PATH = URIBitSets.bitSet(47).or(PATH_SEGMENTS);
        URIC_NO_SLASH = URIBitSets.bitSet(59, 63, 59, 64, 38, 61, 43, 36, 44).or(new FluentBitSet[]{UNRESERVED, ESCAPED});
        OPAQUE_PART = URIBitSets.bitSet().or(new FluentBitSet[]{URIC_NO_SLASH, URIC});
        PATH = URIBitSets.bitSet().or(new FluentBitSet[]{ABS_PATH, OPAQUE_PART});
        PORT = DIGIT;
        IPV4ADDRESS = URIBitSets.bitSet(46).or(DIGIT);
        IPV6ADDRESS = URIBitSets.bitSet(58).or(new FluentBitSet[]{HEX, IPV4ADDRESS});
        IPV6REFERENCE = URIBitSets.bitSet(91, 93).or(IPV6ADDRESS);
        DOMAINLABEL = TOPLABEL = URIBitSets.bitSet(45).or(ALPHANUM);
        HOSTNAME = URIBitSets.bitSet(46).or(TOPLABEL);
        HOST = URIBitSets.bitSet().or(new FluentBitSet[]{HOSTNAME, IPV6REFERENCE});
        HOSTPORT = URIBitSets.bitSet(58).or(new FluentBitSet[]{HOST, PORT});
        USERINFO = URIBitSets.bitSet(59, 58, 38, 61, 43, 36, 44).or(new FluentBitSet[]{UNRESERVED, ESCAPED});
        WITHIN_USERRINFO = URIBitSets.bitSet(59, 58, 64, 63, 47).or(USERINFO);
        SERVER = URIBitSets.bitSet(64).or(new FluentBitSet[]{USERINFO, HOSTPORT});
        REG_NAME = URIBitSets.bitSet(36, 44, 59, 58, 64, 38, 61, 43).or(new FluentBitSet[]{UNRESERVED, ESCAPED});
        AUTHORITY = URIBitSets.bitSet().or(new FluentBitSet[]{SERVER, REG_NAME});
        SCHEME = URIBitSets.bitSet(43, 45, 46).or(new FluentBitSet[]{ALPHA, DIGIT});
        REL_SEGMENT = URIBitSets.bitSet(59, 64, 38, 61, 43, 36, 44).or(new FluentBitSet[]{UNRESERVED, ESCAPED});
        REL_PATH = URIBitSets.bitSet().or(new FluentBitSet[]{REL_SEGMENT, ABS_PATH});
        NET_PATH = URIBitSets.bitSet(47).or(new FluentBitSet[]{AUTHORITY, ABS_PATH});
        HIER_PART = URIBitSets.bitSet().or(new FluentBitSet[]{NET_PATH, ABS_PATH, QUERY});
        RELATIVEURI = URIBitSets.bitSet().or(new FluentBitSet[]{NET_PATH, ABS_PATH, REL_PATH, QUERY});
        ABSOLUTEURI = URIBitSets.bitSet(58).or(new FluentBitSet[]{SCHEME, HIER_PART, OPAQUE_PART});
        URI_REFERENCE = URIBitSets.bitSet(35).or(new FluentBitSet[]{ABSOLUTEURI, RELATIVEURI, FRAGMENT});
        SPACE = URIBitSets.bitSet(32);
        DELIMS = URIBitSets.bitSet(60, 62, 35, 37, 34);
        UNWISE = URIBitSets.bitSet(123, 125, 124, 92, 94, 91, 93, 96);
        DISALLOWED_REL_PATH = URIBitSets.bitSet().or(URIC).andNot(REL_PATH);
        DISALLOWED_OPAQUE_PART = URIBitSets.bitSet().or(URIC).andNot(OPAQUE_PART);
        ALLOWED_AUTHORITY = URIBitSets.bitSet().or(AUTHORITY).clear(37);
        ALLOWED_OPAQUE_PART = URIBitSets.bitSet().or(OPAQUE_PART).clear(37);
        ALLOWED_REG_NAME = URIBitSets.bitSet().or(REG_NAME).clear(37);
        ALLOWED_USER_INFO = URIBitSets.bitSet().or(USERINFO).clear(37);
        ALLOWED_WITHIN_USERINFO = URIBitSets.bitSet().or(WITHIN_USERRINFO).clear(37);
        ALLOWED_IPV6REFERENCE = URIBitSets.bitSet().or(IPV6REFERENCE).clear(91, 93);
        ALLOWED_HOST = URIBitSets.bitSet().or(new FluentBitSet[]{HOSTNAME, ALLOWED_IPV6REFERENCE});
        ALLOWED_WITHIN_AUTHORITY = URIBitSets.bitSet().or(new FluentBitSet[]{SERVER, REG_NAME}).clear(new int[]{59, 58, 64, 63, 47});
        ALLOWED_ABS_PATH = URIBitSets.bitSet().or(ABS_PATH).andNot(PERCENT).clear(43);
        ALLOWED_REL_PATH = URIBitSets.bitSet().or(REL_PATH).clear(37, 43);
        ALLOWED_WITHIN_PATH = URIBitSets.bitSet().or(ABS_PATH).clear(new int[]{47, 59, 61, 63});
        ALLOWED_QUERY = URIBitSets.bitSet().or(URIC).clear(37);
        ALLOWED_WITHIN_QUERY = URIBitSets.bitSet().or(ALLOWED_QUERY).andNot(RESERVED);
        ALLOWED_FRAGMENT = URIBitSets.bitSet().or(URIC).clear(37);
        CONTROL = URIBitSets.bitSet().setInclusive(0, 31).set(127);
    }
}

