/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.SingletonIndexCursor;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.server.xdbm.search.cursor.ApproximateCursor;
import org.apache.directory.server.xdbm.search.cursor.ChildrenCursor;
import org.apache.directory.server.xdbm.search.cursor.DescendantCursor;
import org.apache.directory.server.xdbm.search.evaluator.ApproximateEvaluator;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;

public class CursorBuilder {
    private Store db = null;
    private EvaluatorBuilder evaluatorBuilder;

    public CursorBuilder(Store db, EvaluatorBuilder evaluatorBuilder) {
        this.db = db;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    public <T> long build(PartitionTxn partitionTxn, ExprNode node, PartitionSearchResult searchResult) throws LdapException {
        Object count = node.get("count");
        if (count != null && (Long)count == 0L) {
            return 0L;
        }
        try {
            switch (node.getAssertionType()) {
                case APPROXIMATE: {
                    return this.computeApproximate(partitionTxn, (ApproximateNode)node, searchResult);
                }
                case EQUALITY: {
                    return this.computeEquality(partitionTxn, (EqualityNode)node, searchResult);
                }
                case GREATEREQ: {
                    return this.computeGreaterEq(partitionTxn, (GreaterEqNode)node, searchResult);
                }
                case LESSEQ: {
                    return this.computeLessEq(partitionTxn, (LessEqNode)node, searchResult);
                }
                case PRESENCE: {
                    return this.computePresence(partitionTxn, (PresenceNode)node, searchResult);
                }
                case SCOPE: {
                    if (((ScopeNode)node).getScope() == SearchScope.ONELEVEL) {
                        return this.computeOneLevelScope(partitionTxn, (ScopeNode)node, searchResult);
                    }
                    return this.computeSubLevelScope(partitionTxn, (ScopeNode)node, searchResult);
                }
                case SUBSTRING: {
                    return this.computeSubstring(partitionTxn, (SubstringNode)node, searchResult);
                }
                case AND: {
                    return this.computeAnd(partitionTxn, (AndNode)node, searchResult);
                }
                case NOT: {
                    return this.computeNot((NotNode)node, searchResult);
                }
                case OR: {
                    return this.computeOr(partitionTxn, (OrNode)node, searchResult);
                }
                case UNDEFINED: {
                    return Long.MAX_VALUE;
                }
                case ASSERTION: 
                case EXTENSIBLE: {
                    throw new NotImplementedException();
                }
            }
            throw new IllegalStateException(I18n.err(I18n.ERR_260, new Object[]{node.getAssertionType()}));
        }
        catch (IOException | CursorException | IndexNotFoundException e) {
            throw new LdapOtherException(e.getMessage(), e);
        }
    }

    private <T> long computeApproximate(PartitionTxn partitionTxn, ApproximateNode<T> node, PartitionSearchResult searchResult) throws LdapException, IndexNotFoundException, CursorException, IOException {
        ApproximateCursor cursor = new ApproximateCursor(partitionTxn, this.db, (ApproximateEvaluator)this.evaluatorBuilder.build(partitionTxn, node));
        int nbResults = 0;
        Set<String> uuidSet = searchResult.getCandidateSet();
        while (cursor.next()) {
            Object indexEntry = cursor.get();
            String uuid = (String)((IndexEntry)indexEntry).getId();
            boolean added = uuidSet.add(uuid);
            if (!added) continue;
            ++nbResults;
        }
        cursor.close();
        return nbResults;
    }

    private <T> long computeEquality(PartitionTxn partitionTxn, EqualityNode<T> node, PartitionSearchResult searchResult) throws LdapException, IndexNotFoundException, CursorException, IOException {
        Cursor<IndexEntry<String, String>> userIdxCursor;
        Set thisCandidates = (Set)node.get("candidates");
        if (thisCandidates != null) {
            Set<String> candidates = searchResult.getCandidateSet();
            for (String candidate : thisCandidates) {
                candidates.add(candidate);
            }
            return thisCandidates.size();
        }
        AttributeType attributeType = node.getAttributeType();
        Value value = node.getValue();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            userIdxCursor = userIndex.forwardCursor(partitionTxn, value.getNormalized());
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (userIdxCursor.next()) {
                IndexEntry<String, String> indexEntry = userIdxCursor.get();
                String uuid = indexEntry.getId();
                boolean added = uuidSet.add(uuid);
                if (!added) continue;
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        userIdxCursor.close();
        return nbResults;
    }

    private <T> long computeGreaterEq(PartitionTxn partitionTxn, GreaterEqNode<T> node, PartitionSearchResult searchResult) throws LdapException, IndexNotFoundException, CursorException, IOException {
        Cursor<IndexEntry<?, String>> userIdxCursor;
        AttributeType attributeType = node.getAttributeType();
        Value value = node.getValue();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            userIdxCursor = userIndex.forwardCursor(partitionTxn);
            IndexEntry<String, Object> indexEntry = new IndexEntry();
            indexEntry.setKey(value.getString());
            userIdxCursor.before(indexEntry);
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (userIdxCursor.next()) {
                indexEntry = userIdxCursor.get();
                String uuid = (String)indexEntry.getId();
                boolean added = uuidSet.add(uuid);
                if (!added) continue;
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        userIdxCursor.close();
        return nbResults;
    }

    private <T> long computeLessEq(PartitionTxn partitionTxn, LessEqNode<T> node, PartitionSearchResult searchResult) throws LdapException, IndexNotFoundException, CursorException, IOException {
        Cursor<IndexEntry<?, String>> userIdxCursor;
        AttributeType attributeType = node.getAttributeType();
        Value value = node.getValue();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            userIdxCursor = userIndex.forwardCursor(partitionTxn);
            IndexEntry<String, Object> indexEntry = new IndexEntry();
            indexEntry.setKey(value.getString());
            userIdxCursor.after(indexEntry);
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (userIdxCursor.previous()) {
                indexEntry = userIdxCursor.get();
                String uuid = (String)indexEntry.getId();
                boolean added = uuidSet.add(uuid);
                if (!added) continue;
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        userIdxCursor.close();
        return nbResults;
    }

    private long computePresence(PartitionTxn partitionTxn, PresenceNode node, PartitionSearchResult searchResult) throws LdapException, CursorException, IOException {
        Cursor<IndexEntry<String, String>> presenceCursor;
        AttributeType attributeType = node.getAttributeType();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            presenceCursor = this.db.getPresenceIndex().forwardCursor(partitionTxn, attributeType.getOid());
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (presenceCursor.next()) {
                IndexEntry<String, String> indexEntry = presenceCursor.get();
                String uuid = indexEntry.getId();
                boolean added = uuidSet.add(uuid);
                if (!added) continue;
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        presenceCursor.close();
        return nbResults;
    }

    private long computeOneLevelScope(PartitionTxn partitionTxn, ScopeNode node, PartitionSearchResult searchResult) throws LdapException, CursorException, IOException {
        int nbResults = 0;
        Cursor<IndexEntry<ParentIdAndRdn, String>> rdnCursor = this.db.getRdnIndex().forwardCursor(partitionTxn);
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey(new ParentIdAndRdn(node.getBaseId(), (Rdn[])null));
        rdnCursor.before(startingPos);
        ChildrenCursor scopeCursor = new ChildrenCursor(partitionTxn, this.db, node.getBaseId(), rdnCursor);
        Set<String> candidateSet = searchResult.getCandidateSet();
        while (scopeCursor.next()) {
            IndexEntry indexEntry = (IndexEntry)scopeCursor.get();
            String uuid = (String)indexEntry.getId();
            if (searchResult.isDerefAlways() || searchResult.isDerefInSearching()) {
                Dn aliasedDn = this.db.getAliasIndex().reverseLookup(partitionTxn, uuid);
                if (aliasedDn != null) {
                    String aliasedId;
                    boolean added;
                    if (!aliasedDn.isSchemaAware()) {
                        aliasedDn = new Dn(this.evaluatorBuilder.getSchemaManager(), aliasedDn);
                    }
                    if (!(added = candidateSet.add(aliasedId = this.db.getEntryId(partitionTxn, aliasedDn)))) continue;
                    ++nbResults;
                    continue;
                }
                boolean added = candidateSet.add(uuid);
                if (!added) continue;
                ++nbResults;
                continue;
            }
            boolean added = candidateSet.add(uuid);
            if (!added) continue;
            ++nbResults;
        }
        scopeCursor.close();
        return nbResults;
    }

    private long computeSubLevelScope(PartitionTxn partitionTxn, ScopeNode node, PartitionSearchResult searchResult) throws LdapException, IOException, CursorException {
        String contextEntryId = this.db.getEntryId(partitionTxn, ((Partition)((Object)this.db)).getSuffixDn());
        if (node.getBaseId() == contextEntryId) {
            return Long.MAX_VALUE;
        }
        long nbResults = 0L;
        String baseId = node.getBaseId();
        ParentIdAndRdn parentIdAndRdn = this.db.getRdnIndex().reverseLookup(partitionTxn, baseId);
        IndexEntry<ParentIdAndRdn, String> startingPos = new IndexEntry<ParentIdAndRdn, String>();
        startingPos.setKey(parentIdAndRdn);
        startingPos.setId(baseId);
        SingletonIndexCursor<ParentIdAndRdn> rdnCursor = new SingletonIndexCursor<ParentIdAndRdn>(partitionTxn, startingPos);
        String parentId = parentIdAndRdn.getParentId();
        DescendantCursor scopeCursor = new DescendantCursor(partitionTxn, this.db, baseId, parentId, rdnCursor);
        Set<String> candidateSet = searchResult.getCandidateSet();
        while (scopeCursor.next()) {
            IndexEntry indexEntry = (IndexEntry)scopeCursor.get();
            String uuid = (String)indexEntry.getId();
            if (searchResult.isDerefAlways() || searchResult.isDerefInSearching()) {
                Dn aliasedDn = this.db.getAliasIndex().reverseLookup(partitionTxn, uuid);
                if (aliasedDn != null) {
                    String aliasedId;
                    boolean added;
                    if (!aliasedDn.isSchemaAware()) {
                        aliasedDn = new Dn(this.evaluatorBuilder.getSchemaManager(), aliasedDn);
                    }
                    if (!(added = candidateSet.add(aliasedId = this.db.getEntryId(partitionTxn, aliasedDn)))) continue;
                    ++nbResults;
                    ScopeNode newScopeNode = new ScopeNode(node.getDerefAliases(), aliasedDn, aliasedId, node.getScope());
                    nbResults += this.computeSubLevelScope(partitionTxn, newScopeNode, searchResult);
                    continue;
                }
                boolean added = candidateSet.add(uuid);
                if (!added) continue;
                ++nbResults;
                continue;
            }
            boolean added = candidateSet.add(uuid);
            if (!added) continue;
            ++nbResults;
        }
        scopeCursor.close();
        return nbResults;
    }

    private long computeSubstring(PartitionTxn partitionTxn, SubstringNode node, PartitionSearchResult searchResult) throws LdapException, IndexNotFoundException, CursorException, IOException {
        AttributeType attributeType = node.getAttributeType();
        if (attributeType.getSubstring() == null) {
            return 0L;
        }
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            Cursor<IndexEntry<?, String>> cursor = userIndex.forwardCursor(partitionTxn);
            IndexEntry<Object, Object> indexEntry = new IndexEntry();
            String initial = node.getInitial();
            boolean fullIndexScan = false;
            if (initial == null) {
                fullIndexScan = true;
                cursor.beforeFirst();
            } else {
                indexEntry.setKey(attributeType.getEquality().getNormalizer().normalize(initial, PrepareString.AssertionType.SUBSTRING_INITIAL));
                cursor.before(indexEntry);
            }
            int nbResults = 0;
            MatchingRule rule = attributeType.getSubstring();
            if (rule == null) {
                rule = attributeType.getEquality();
            }
            Normalizer normalizer = rule != null ? rule.getNormalizer() : new NoOpNormalizer(attributeType.getSyntaxOid());
            Pattern regexp = attributeType.getSyntax().isHumanReadable() ? node.getRegex(normalizer) : null;
            Set<String> uuidSet = searchResult.getCandidateSet();
            if (regexp == null) {
                return nbResults;
            }
            while (cursor.next()) {
                String uuid;
                boolean added;
                indexEntry = cursor.get();
                String key = (String)indexEntry.getKey();
                boolean matched = regexp.matcher(key).matches();
                if (!fullIndexScan && !matched) {
                    cursor.close();
                    return nbResults;
                }
                if (!matched || !(added = uuidSet.add(uuid = (String)indexEntry.getId()))) continue;
                ++nbResults;
            }
            cursor.close();
            return nbResults;
        }
        return Long.MAX_VALUE;
    }

    private long computeOr(PartitionTxn partitionTxn, OrNode node, PartitionSearchResult searchResult) throws LdapException {
        List<ExprNode> children = node.getChildren();
        long nbOrResults = 0L;
        for (ExprNode child : children) {
            long nbResults;
            Object count = child.get("count");
            if (count != null) {
                long countLong = (Long)count;
                if (countLong == 0L) continue;
                if (countLong == Long.MAX_VALUE) {
                    return countLong;
                }
            }
            if ((nbResults = this.build(partitionTxn, child, searchResult)) == Long.MAX_VALUE) {
                return nbResults;
            }
            nbOrResults += nbResults;
        }
        return nbOrResults;
    }

    private long computeAnd(PartitionTxn partitionTxn, AndNode node, PartitionSearchResult searchResult) throws LdapException {
        int minIndex = 0;
        long minValue = Long.MAX_VALUE;
        List<ExprNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ExprNode child = children.get(i);
            Object count = child.get("count");
            if (count == null) continue;
            long value = (Long)count;
            if (value == 0L) {
                return 0L;
            }
            if (value >= minValue) continue;
            minValue = value;
            minIndex = i;
        }
        ExprNode minChild = children.get(minIndex);
        return this.build(partitionTxn, minChild, searchResult);
    }

    private long computeNot(NotNode node, PartitionSearchResult searchResult) {
        List<ExprNode> children = node.getChildren();
        ExprNode child = children.get(0);
        Object count = child.get("count");
        if (count == null) {
            return Long.MAX_VALUE;
        }
        long value = (Long)count;
        if (value == Long.MAX_VALUE) {
            return 0L;
        }
        return Long.MAX_VALUE;
    }
}

