/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.pipeline.handler;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.GroupByTransform;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.pipeline.handler.BeamBaseTransformHandler;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByMeta;

public class BeamGroupByTransformHandler
extends BeamBaseTransformHandler
implements IBeamPipelineTransformHandler {
    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        this.loadTransformMetadata((ITransformMeta)meta, transformMeta, metadataProvider, pipelineMeta);
        String[] aggregates = new String[meta.getAggregateType().length];
        for (int i = 0; i < aggregates.length; ++i) {
            aggregates[i] = MemoryGroupByMeta.getTypeDesc((int)meta.getAggregateType()[i]);
        }
        GroupByTransform transformTransform = new GroupByTransform(transformMeta.getName(), JsonRowMeta.toJson((IRowMeta)rowMeta), transformPluginClasses, xpPluginClasses, meta.getGroupField(), meta.getSubjectField(), aggregates, meta.getAggregateField());
        PCollection transformPCollection = (PCollection)input.apply(transformMeta.getName(), (PTransform)transformTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)transformPCollection);
        log.logBasic("Handled Group By (TRANSFORM) : " + transformMeta.getName() + ", gets data from " + previousTransforms.size() + " previous transform(s)");
    }
}

