/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sns;

import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.services.sns.model.PublishResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.aws.coders.AwsCoders;

public final class PublishResultCoders {
    private static final Coder<String> MESSAGE_ID_CODER = StringUtf8Coder.of();
    private static final Coder<ResponseMetadata> RESPONSE_METADATA_CODER = NullableCoder.of(AwsCoders.responseMetadata());

    private PublishResultCoders() {
    }

    public static Coder<PublishResult> defaultPublishResult() {
        return new PublishResultCoder(null, null);
    }

    public static Coder<PublishResult> fullPublishResult() {
        return new PublishResultCoder(RESPONSE_METADATA_CODER, (Coder)NullableCoder.of(AwsCoders.sdkHttpMetadata()));
    }

    public static Coder<PublishResult> fullPublishResultWithoutHeaders() {
        return new PublishResultCoder(RESPONSE_METADATA_CODER, (Coder)NullableCoder.of(AwsCoders.sdkHttpMetadataWithoutHeaders()));
    }

    static class PublishResultCoder
    extends CustomCoder<PublishResult> {
        private final Coder<ResponseMetadata> responseMetadataEncoder;
        private final Coder<SdkHttpMetadata> sdkHttpMetadataCoder;

        private PublishResultCoder(Coder<ResponseMetadata> responseMetadataEncoder, Coder<SdkHttpMetadata> sdkHttpMetadataCoder) {
            this.responseMetadataEncoder = responseMetadataEncoder;
            this.sdkHttpMetadataCoder = sdkHttpMetadataCoder;
        }

        public void encode(PublishResult value, OutputStream outStream) throws CoderException, IOException {
            MESSAGE_ID_CODER.encode((Object)value.getMessageId(), outStream);
            if (this.responseMetadataEncoder != null) {
                this.responseMetadataEncoder.encode((Object)value.getSdkResponseMetadata(), outStream);
            }
            if (this.sdkHttpMetadataCoder != null) {
                this.sdkHttpMetadataCoder.encode((Object)value.getSdkHttpMetadata(), outStream);
            }
        }

        public PublishResult decode(InputStream inStream) throws CoderException, IOException {
            String messageId = (String)MESSAGE_ID_CODER.decode(inStream);
            PublishResult publishResult = new PublishResult().withMessageId(messageId);
            if (this.responseMetadataEncoder != null) {
                publishResult.setSdkResponseMetadata((ResponseMetadata)this.responseMetadataEncoder.decode(inStream));
            }
            if (this.sdkHttpMetadataCoder != null) {
                publishResult.setSdkHttpMetadata((SdkHttpMetadata)this.sdkHttpMetadataCoder.decode(inStream));
            }
            return publishResult;
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            MESSAGE_ID_CODER.verifyDeterministic();
            if (this.responseMetadataEncoder != null) {
                this.responseMetadataEncoder.verifyDeterministic();
            }
            if (this.sdkHttpMetadataCoder != null) {
                this.sdkHttpMetadataCoder.verifyDeterministic();
            }
        }
    }
}

