/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarItem;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class BaseGuiWidgets {
    protected String instanceId;

    public BaseGuiWidgets(String instanceId) {
        this.instanceId = instanceId;
    }

    public void registerGuiPluginObject(Object guiPluginObject) {
        GuiRegistry guiRegistry = GuiRegistry.getInstance();
        String guiPluginClassName = guiPluginObject.getClass().getName();
        guiRegistry.registerGuiPluginObject(HopGui.getInstance().getId(), guiPluginClassName, this.instanceId, guiPluginObject);
    }

    protected void addDeRegisterGuiPluginObjectListener(Control control) {
        control.addDisposeListener(e -> GuiRegistry.getInstance().removeGuiPluginObjects(HopGui.getInstance().getId(), this.instanceId));
    }

    public void dispose() {
        String hopGuiId = HopGui.getInstance().getId();
        GuiRegistry.getInstance().removeGuiPluginObjects(hopGuiId, this.instanceId);
    }

    protected Object findGuiPluginInstance(ClassLoader classLoader, String listenerClassName) throws Exception {
        try {
            String hopGuiId = HopGui.getInstance().getId();
            Object guiPluginObject = GuiRegistry.getInstance().findGuiPluginObject(hopGuiId, listenerClassName, this.instanceId);
            if (guiPluginObject == null) {
                guiPluginObject = classLoader.loadClass(listenerClassName).newInstance();
                GuiRegistry.getInstance().registerGuiPluginObject(hopGuiId, listenerClassName, this.instanceId, guiPluginObject);
            }
            return guiPluginObject;
        }
        catch (Exception e) {
            throw new HopException("Error finding GuiPlugin instance for class '" + listenerClassName + "' and instance ID : " + this.instanceId, (Throwable)e);
        }
    }

    protected String[] getComboItems(GuiToolbarItem toolbarItem) {
        try {
            Object[] arguments;
            Method method;
            Object singleton = this.findGuiPluginInstance(toolbarItem.getClassLoader(), toolbarItem.getListenerClass());
            if (singleton == null) {
                LogChannel.UI.logError("Could not get instance of class '" + toolbarItem.getListenerClass() + " for toolbar item " + toolbarItem + ", combo values method : " + toolbarItem.getGetComboValuesMethod());
                return new String[0];
            }
            try {
                method = singleton.getClass().getMethod(toolbarItem.getGetComboValuesMethod(), ILogChannel.class, IHopMetadataProvider.class);
                arguments = new Object[]{LogChannel.UI, HopGui.getInstance().getMetadataProvider()};
            }
            catch (NoSuchMethodException nsme) {
                try {
                    method = singleton.getClass().getMethod(toolbarItem.getGetComboValuesMethod(), ILogChannel.class, IHopMetadataProvider.class, String.class);
                    arguments = new Object[]{LogChannel.UI, HopGui.getInstance().getMetadataProvider(), this.instanceId};
                }
                catch (NoSuchMethodException nsme2) {
                    try {
                        method = singleton.getClass().getMethod(toolbarItem.getGetComboValuesMethod(), new Class[0]);
                        arguments = new Object[]{};
                    }
                    catch (NoSuchMethodException nsme3) {
                        throw new HopException("Unable to find method '" + toolbarItem.getGetComboValuesMethod() + "' without parameters or with parameters ILogChannel and IHopMetadataProvider in class '" + toolbarItem.getListenerClass() + "'", (Throwable)nsme2);
                    }
                }
            }
            List values = (List)method.invoke(singleton, arguments);
            return values.toArray(new String[0]);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting list of combo items for method '" + toolbarItem.getGetComboValuesMethod() + "' in class : " + toolbarItem.getListenerClass(), (Throwable)e);
            return new String[0];
        }
    }

    protected Listener getListener(ClassLoader classLoader, String listenerClassName, String listenerMethodName) {
        return e -> {
            try {
                Object singleton = this.findGuiPluginInstance(classLoader, listenerClassName);
                Method listenerMethod = singleton.getClass().getDeclaredMethod(listenerMethodName, new Class[0]);
                if (listenerMethod == null) {
                    throw new HopException("Unable to find method " + listenerMethodName + " in class " + listenerClassName);
                }
                try {
                    listenerMethod.invoke(singleton, new Object[0]);
                }
                catch (Exception ie) {
                    System.err.println("Unable to call method " + listenerMethodName + " in class " + listenerClassName + " : " + ie.getMessage());
                    throw ie;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        };
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }
}

