/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;
import scala.Tuple2;

public class MultiOutputCoder<T>
extends CustomCoder<Tuple2<TupleTag<T>, WindowedValue<T>>> {
    Coder<TupleTag> tupleTagCoder;
    Map<TupleTag<?>, Coder<?>> coderMap;
    Coder<? extends BoundedWindow> windowCoder;

    public static MultiOutputCoder of(Coder<TupleTag> tupleTagCoder, Map<TupleTag<?>, Coder<?>> coderMap, Coder<? extends BoundedWindow> windowCoder) {
        return new MultiOutputCoder(tupleTagCoder, coderMap, windowCoder);
    }

    private MultiOutputCoder(Coder<TupleTag> tupleTagCoder, Map<TupleTag<?>, Coder<?>> coderMap, Coder<? extends BoundedWindow> windowCoder) {
        this.tupleTagCoder = tupleTagCoder;
        this.coderMap = coderMap;
        this.windowCoder = windowCoder;
    }

    public void encode(Tuple2<TupleTag<T>, WindowedValue<T>> tuple2, OutputStream outStream) throws IOException {
        TupleTag tupleTag = (TupleTag)tuple2._1();
        this.tupleTagCoder.encode((Object)tupleTag, outStream);
        Coder<?> valueCoder = this.coderMap.get(tupleTag);
        WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of(valueCoder, this.windowCoder);
        wvCoder.encode((WindowedValue)tuple2._2(), outStream);
    }

    public Tuple2<TupleTag<T>, WindowedValue<T>> decode(InputStream inStream) throws CoderException, IOException {
        TupleTag tupleTag = (TupleTag)this.tupleTagCoder.decode(inStream);
        Coder<?> valueCoder = this.coderMap.get(tupleTag);
        WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of(valueCoder, this.windowCoder);
        WindowedValue wv = wvCoder.decode(inStream);
        return Tuple2.apply((Object)tupleTag, (Object)wv);
    }
}

