/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.google.api.services.clouddebugger.v2.model.Debuggee;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Description(value="[Experimental] Used to configure the Cloud Debugger")
@Hidden
@Experimental
public interface CloudDebuggerOptions
extends PipelineOptions {
    @Description(value="Whether to enable the Cloud Debugger snapshot agent for the current job.")
    public boolean getEnableCloudDebugger();

    public void setEnableCloudDebugger(boolean var1);

    @Description(value="The Cloud Debugger debuggee to associate with. This should not be set directly.")
    @Hidden
    public @Nullable Debuggee getDebuggee();

    public void setDebuggee(Debuggee var1);

    @Description(value="The maximum cost (as a ratio of CPU time) allowed for evaluating conditional snapshots. Should be a double between 0 and 1. Snapshots will be cancelled if evaluating conditions takes more than this ratio of time.")
    @Default.Double(value=0.01)
    public double getMaxConditionCost();

    public void setMaxConditionCost(double var1);
}

