/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.batching;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BlockingSemaphore;
import com.google.bigtable.repackaged.com.google.api.gax.batching.DynamicFlowControlSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowControlEventStats;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowControlSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.NonBlockingSemaphore;
import com.google.bigtable.repackaged.com.google.api.gax.batching.Semaphore64;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class FlowController {
    @Nullable
    private final Semaphore64 outstandingElementCount;
    @Nullable
    private final Semaphore64 outstandingByteCount;
    @Nullable
    private final Long maxElementCountLimit;
    @Nullable
    private final Long maxRequestBytesLimit;
    @Nullable
    private final Long minElementCountLimit;
    @Nullable
    private final Long minRequestBytesLimit;
    private final LimitExceededBehavior limitExceededBehavior;
    private final Object updateLimitLock;
    private static final long RESERVE_FLOW_CONTROL_THRESHOLD_MS = 1L;
    private final FlowControlEventStats flowControlEventStats;

    public FlowController(FlowControlSettings settings) {
        this(FlowController.convertFlowControlSettings(settings));
    }

    @InternalApi(value="For google-cloud-java client use only")
    public FlowController(DynamicFlowControlSettings settings) {
        this.limitExceededBehavior = settings.getLimitExceededBehavior();
        this.updateLimitLock = new Object();
        this.flowControlEventStats = new FlowControlEventStats();
        switch (settings.getLimitExceededBehavior()) {
            case ThrowException: 
            case Block: {
                break;
            }
            case Ignore: {
                this.maxElementCountLimit = null;
                this.maxRequestBytesLimit = null;
                this.minElementCountLimit = null;
                this.minRequestBytesLimit = null;
                this.outstandingElementCount = null;
                this.outstandingByteCount = null;
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown LimitBehaviour: " + (Object)((Object)settings.getLimitExceededBehavior()));
            }
        }
        this.maxElementCountLimit = settings.getMaxOutstandingElementCount();
        this.minElementCountLimit = settings.getMinOutstandingElementCount();
        Long initialElementCountLimit = settings.getInitialOutstandingElementCount();
        this.outstandingElementCount = initialElementCountLimit == null ? null : (settings.getLimitExceededBehavior() == LimitExceededBehavior.Block ? new BlockingSemaphore(initialElementCountLimit) : new NonBlockingSemaphore(initialElementCountLimit));
        this.maxRequestBytesLimit = settings.getMaxOutstandingRequestBytes();
        this.minRequestBytesLimit = settings.getMinOutstandingRequestBytes();
        Long initialRequestBytesLimit = settings.getInitialOutstandingRequestBytes();
        this.outstandingByteCount = initialRequestBytesLimit == null ? null : (settings.getLimitExceededBehavior() == LimitExceededBehavior.Block ? new BlockingSemaphore(initialRequestBytesLimit) : new NonBlockingSemaphore(initialRequestBytesLimit));
    }

    public void reserve(long elements, long bytes) throws FlowControlException {
        Preconditions.checkArgument(elements >= 0L);
        Preconditions.checkArgument(bytes >= 0L);
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.outstandingElementCount != null && !this.outstandingElementCount.acquire(elements)) {
            MaxOutstandingElementCountReachedException exception = new MaxOutstandingElementCountReachedException(this.outstandingElementCount.getPermitLimit());
            this.flowControlEventStats.recordFlowControlEvent(FlowControlEventStats.FlowControlEvent.createReserveDenied(exception));
            throw exception;
        }
        if (this.outstandingByteCount != null && !this.outstandingByteCount.acquirePartial(bytes)) {
            if (this.outstandingElementCount != null) {
                this.outstandingElementCount.release(elements);
            }
            MaxOutstandingRequestBytesReachedException exception = new MaxOutstandingRequestBytesReachedException(this.outstandingByteCount.getPermitLimit());
            this.flowControlEventStats.recordFlowControlEvent(FlowControlEventStats.FlowControlEvent.createReserveDenied(exception));
            throw exception;
        }
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (elapsed >= 1L) {
            this.flowControlEventStats.recordFlowControlEvent(FlowControlEventStats.FlowControlEvent.createReserveDelayed(elapsed));
        }
    }

    public void release(long elements, long bytes) {
        Preconditions.checkArgument(elements >= 0L);
        Preconditions.checkArgument(bytes >= 0L);
        if (this.outstandingElementCount != null) {
            this.outstandingElementCount.release(elements);
        }
        if (this.outstandingByteCount != null) {
            this.outstandingByteCount.release(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi(value="For google-cloud-java client use only")
    public void increaseThresholds(long elementSteps, long byteSteps) {
        Preconditions.checkArgument(elementSteps >= 0L);
        Preconditions.checkArgument(byteSteps >= 0L);
        Object object = this.updateLimitLock;
        synchronized (object) {
            long actualStep;
            if (this.outstandingElementCount != null) {
                actualStep = Math.min(elementSteps, this.maxElementCountLimit - this.outstandingElementCount.getPermitLimit());
                this.outstandingElementCount.increasePermitLimit(actualStep);
            }
            if (this.outstandingByteCount != null) {
                actualStep = Math.min(byteSteps, this.maxRequestBytesLimit - this.outstandingByteCount.getPermitLimit());
                this.outstandingByteCount.increasePermitLimit(actualStep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalApi(value="For google-cloud-java client use only")
    public void decreaseThresholds(long elementSteps, long byteSteps) {
        Preconditions.checkArgument(elementSteps >= 0L);
        Preconditions.checkArgument(byteSteps >= 0L);
        Object object = this.updateLimitLock;
        synchronized (object) {
            long actualStep;
            if (this.outstandingElementCount != null) {
                actualStep = Math.min(elementSteps, this.outstandingElementCount.getPermitLimit() - this.minElementCountLimit);
                this.outstandingElementCount.reducePermitLimit(actualStep);
            }
            if (this.outstandingByteCount != null) {
                actualStep = Math.min(byteSteps, this.outstandingByteCount.getPermitLimit() - this.minRequestBytesLimit);
                this.outstandingByteCount.reducePermitLimit(actualStep);
            }
        }
    }

    private static DynamicFlowControlSettings convertFlowControlSettings(FlowControlSettings settings) {
        return DynamicFlowControlSettings.newBuilder().setInitialOutstandingElementCount(settings.getMaxOutstandingElementCount()).setMinOutstandingElementCount(settings.getMaxOutstandingElementCount()).setMaxOutstandingElementCount(settings.getMaxOutstandingElementCount()).setInitialOutstandingRequestBytes(settings.getMaxOutstandingRequestBytes()).setMinOutstandingRequestBytes(settings.getMaxOutstandingRequestBytes()).setMaxOutstandingRequestBytes(settings.getMaxOutstandingRequestBytes()).setLimitExceededBehavior(settings.getLimitExceededBehavior()).build();
    }

    LimitExceededBehavior getLimitExceededBehavior() {
        return this.limitExceededBehavior;
    }

    @InternalApi(value="For internal use by google-cloud-java clients only")
    @Nullable
    public Long getMaxElementCountLimit() {
        return this.maxElementCountLimit;
    }

    @InternalApi(value="For internal use by google-cloud-java clients only")
    @Nullable
    public Long getMaxRequestBytesLimit() {
        return this.maxRequestBytesLimit;
    }

    @InternalApi(value="For google-cloud-java client use only")
    @Nullable
    public Long getMinElementCountLimit() {
        return this.minElementCountLimit;
    }

    @InternalApi(value="For google-cloud-java client use only")
    @Nullable
    public Long getMinRequestBytesLimit() {
        return this.minRequestBytesLimit;
    }

    @InternalApi(value="For google-cloud-java client use only")
    @Nullable
    public Long getCurrentElementCountLimit() {
        return this.outstandingElementCount == null ? null : Long.valueOf(this.outstandingElementCount.getPermitLimit());
    }

    @InternalApi(value="For google-cloud-java client use only")
    @Nullable
    public Long getCurrentRequestBytesLimit() {
        return this.outstandingByteCount == null ? null : Long.valueOf(this.outstandingByteCount.getPermitLimit());
    }

    @InternalApi(value="For google-cloud-java client use only")
    public FlowControlEventStats getFlowControlEventStats() {
        return this.flowControlEventStats;
    }

    public static enum LimitExceededBehavior {
        ThrowException,
        Block,
        Ignore;

    }

    public static final class MaxOutstandingRequestBytesReachedException
    extends FlowControlException {
        private final long currentMaxBytes;

        public MaxOutstandingRequestBytesReachedException(long currentMaxBytes) {
            this.currentMaxBytes = currentMaxBytes;
        }

        public long getCurrentMaxBatchBytes() {
            return this.currentMaxBytes;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of batch bytes: %d have been reached.", this.currentMaxBytes);
        }
    }

    public static final class MaxOutstandingElementCountReachedException
    extends FlowControlException {
        private final long currentMaxElementCount;

        public MaxOutstandingElementCountReachedException(long currentMaxElementCount) {
            this.currentMaxElementCount = currentMaxElementCount;
        }

        public long getCurrentMaxBatchElementCount() {
            return this.currentMaxElementCount;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of batch elements: %d have been reached.", this.currentMaxElementCount);
        }
    }

    public static class FlowControlRuntimeException
    extends RuntimeException {
        private FlowControlRuntimeException(FlowControlException e) {
            super(e);
        }

        public static FlowControlRuntimeException fromFlowControlException(FlowControlException e) {
            return new FlowControlRuntimeException(e);
        }
    }

    public static abstract class FlowControlException
    extends Exception {
        private FlowControlException() {
        }
    }
}

